/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.entity.VirusScanError;
import com.akelesconsulting.confluence.plugins.ao.service.VirusScanErrorService;
import com.akelesconsulting.confluence.plugins.rest.beans.AttachmentBean;
import com.akelesconsulting.confluence.plugins.rest.beans.PageBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceBean;
import com.akelesconsulting.confluence.plugins.rest.beans.UserBean;
import com.akelesconsulting.confluence.plugins.rest.beans.VirusScanErrorBean;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.AttachmentHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/report/virus-scan")
public class VirusScanErrorResource {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.rest.VirusScanErrorResource");
    private final AttachmentHelper b;
    private final DateHelper c;
    private final Gson d;
    private final I18nResolver e;
    private final PermissionManager f;
    private final SettingsManager g;
    private final VirusScanErrorService h;

    @Inject
    public VirusScanErrorResource(AttachmentHelper attachmentHelper, DateHelper dateHelper, @ComponentImport I18nResolver i18nResolver, @ComponentImport PermissionManager permissionManager, @ComponentImport SettingsManager settingsManager, VirusScanErrorService virusScanErrorService) {
        this.b = attachmentHelper;
        this.c = dateHelper;
        this.d = new Gson();
        this.e = i18nResolver;
        this.f = permissionManager;
        this.g = settingsManager;
        this.h = virusScanErrorService;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getVirusScanErrorList() {
        a.debug((Object)"Get virus scan error list");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.f.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to perform this action"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        HashMap<String, SpaceBean> hashMap = new HashMap<String, SpaceBean>();
        HashMap<Long, PageBean> hashMap2 = new HashMap<Long, PageBean>();
        HashMap<String, UserBean> hashMap3 = new HashMap<String, UserBean>();
        String string = this.g.getGlobalSettings().getBaseUrl();
        ArrayList<VirusScanErrorBean> arrayList = new ArrayList<VirusScanErrorBean>();
        List<VirusScanError> list = this.h.getVirusScanErrorList();
        for (VirusScanError virusScanError : list) {
            long l = virusScanError.getAttachmentId();
            a.debug((Object)("Attachment id [" + l + "]"));
            String string2 = this.c.a(virusScanError.getExecDate(), this.e.getText("com.akeles.acc.unknown"));
            VirusScanErrorBean virusScanErrorBean = new VirusScanErrorBean(virusScanError.getID(), virusScanError.getNodeId(), virusScanError.getExitCode(), virusScanError.getIsInfection(), virusScanError.getOutput(), virusScanError.getErrorOutput(), string2);
            int n = virusScanError.getVersion();
            Date date = virusScanError.getCreationDate();
            String string3 = virusScanError.getFileName();
            String string4 = AttachmentCheckerHelper.a(virusScanError.getFileSize(), 2);
            Space space = null;
            String string5 = null;
            ContentEntityObject contentEntityObject = null;
            Attachment attachment = this.b.a(l, n, date);
            AttachmentBean attachmentBean = new AttachmentBean(l, this.c.a(date, this.e.getText("com.akeles.acc.unknown")), n, string3, string4, "");
            long l2 = virusScanError.getAttachedToId();
            if (attachment != null) {
                string5 = attachment.getSpaceKey();
                space = attachment.getSpace();
                contentEntityObject = attachment.getContainer();
                attachmentBean.setFileLocation(this.b.a(attachment, l, n, l2));
                attachmentBean.setIsInTrash(attachment.isDeleted());
            } else {
                attachmentBean.setIsDeleted(true);
            }
            SpaceBean spaceBean = (SpaceBean)hashMap.get(string5);
            if (spaceBean == null) {
                spaceBean = this.b.a(string5, space, "", string);
                hashMap.put(string5, spaceBean);
            }
            attachmentBean.setSpace(spaceBean);
            PageBean pageBean = (PageBean)hashMap2.get(l2);
            if (pageBean == null) {
                pageBean = this.b.a(l2, contentEntityObject, "", string);
                hashMap2.put(l2, pageBean);
            }
            attachmentBean.setPage(pageBean);
            String string6 = virusScanError.getUserKey();
            UserBean userBean = (UserBean)hashMap3.get(string6);
            if (userBean == null) {
                userBean = this.b.a(string6, "", "", string);
                hashMap3.put(string6, userBean);
            }
            attachmentBean.setCreator(userBean);
            virusScanErrorBean.setAttachment(attachmentBean);
            a.debug((Object)("VirusScanError ID [" + virusScanErrorBean.getId() + "] exit code [" + virusScanErrorBean.getExitCode() + "] exec date [" + virusScanErrorBean.getExecDate() + "]"));
            arrayList.add(virusScanErrorBean);
        }
        a.debug((Object)("Error count [" + arrayList.size() + "]"));
        return Response.ok((Object)this.d.toJson(arrayList)).build();
    }
}

