/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.listener;

import com.akelesconsulting.confluence.plugins.ao.service.AttachmentToScanService;
import com.akelesconsulting.confluence.plugins.ao.service.LargeAttachmentService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceFilterModeService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.ao.service.SpacePermissionService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceScannedService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.listener.AnnotatedListener;
import com.akelesconsulting.confluence.plugins.task.PageMoveTask;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentUpdateEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentVersionRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnnotatedListenerImpl
implements AnnotatedListener,
DisposableBean,
InitializingBean {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.listener.AnnotatedListenerImpl");
    private final AttachmentCheckerConfig b;
    private final AttachmentManager c;
    private final AttachmentToScanService d;
    private final EventPublisher e;
    private final LargeAttachmentService f;
    private final ScheduledExecutorService g;
    private final SpaceFilterModeService h;
    private final SpaceInfoService i;
    private final SpacePermissionService j;
    private final SpaceScannedService k;

    @Autowired
    public AnnotatedListenerImpl(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport AttachmentManager attachmentManager, AttachmentToScanService attachmentToScanService, @ComponentImport EventPublisher eventPublisher, LargeAttachmentService largeAttachmentService, SpaceFilterModeService spaceFilterModeService, SpaceInfoService spaceInfoService, SpacePermissionService spacePermissionService, SpaceScannedService spaceScannedService) {
        this.c = attachmentManager;
        this.e = eventPublisher;
        this.b = attachmentCheckerConfig;
        this.d = attachmentToScanService;
        this.f = largeAttachmentService;
        this.g = Executors.newScheduledThreadPool(10);
        this.h = spaceFilterModeService;
        this.i = spaceInfoService;
        this.j = spacePermissionService;
        this.k = spaceScannedService;
    }

    public void afterPropertiesSet() {
        this.e.register((Object)this);
    }

    public void destroy() {
        this.e.unregister((Object)this);
    }

    @Override
    @EventListener
    public void a(GeneralAttachmentCreateEvent generalAttachmentCreateEvent) {
        a.debug((Object)"*** Attachment CREATE Event ***");
        Attachment attachment = generalAttachmentCreateEvent.getAttachment();
        String string = attachment.getFileName();
        a.debug((Object)("Created attachment [" + string + "]"));
        String string2 = attachment.getSpaceKey();
        a.debug((Object)("Attachment's space key [" + string2 + "]"));
        if (string2 != null) {
            this.a(attachment, false, false);
            this.a(attachment, generalAttachmentCreateEvent.getAttachedTo().getId(), string2);
        }
    }

    @Override
    @EventListener
    public void a(GeneralAttachmentUpdateEvent generalAttachmentUpdateEvent) {
        a.debug((Object)"*** Attachment UPDATE Event ***");
        Attachment attachment = generalAttachmentUpdateEvent.getAttachment();
        String string = attachment.getFileName();
        a.debug((Object)("Updated attachment [" + string + "]"));
        boolean bl = "This is a placeholder to replace the infected file".equals(attachment.getVersionComment());
        a.debug((Object)("Is placeholder? [" + bl + "]"));
        boolean bl2 = generalAttachmentUpdateEvent.getOld().getVersion() != generalAttachmentUpdateEvent.getNew().getVersion();
        a.debug((Object)("Is version changed? [" + bl2 + "]"));
        if (bl2) {
            this.a(attachment, false, false);
            if (!bl) {
                this.a(attachment, generalAttachmentUpdateEvent.getAttachedTo().getId(), attachment.getSpaceKey());
            }
        }
    }

    @Override
    @EventListener
    public void a(GeneralAttachmentRemoveEvent generalAttachmentRemoveEvent) {
        String string = Thread.currentThread().getName();
        if (!string.contains("Space removal long running task")) {
            a.debug((Object)"*** Attachment REMOVE Event ***");
            Attachment attachment = generalAttachmentRemoveEvent.getAttachment();
            String string2 = attachment.getFileName();
            a.debug((Object)("Removed all versions of attachment [" + string2 + "]"));
            this.a(attachment, true, true);
        }
    }

    @Override
    @EventListener
    public void a(GeneralAttachmentVersionRemoveEvent generalAttachmentVersionRemoveEvent) {
        a.debug((Object)"*** Attachment Version REMOVE Event ***");
        Attachment attachment = generalAttachmentVersionRemoveEvent.getAttachment();
        String string = attachment.getFileName();
        a.debug((Object)("Removed attachment [" + string + "] version [" + attachment.getVersion() + "]"));
        this.a(attachment, true, false);
    }

    private void a(Attachment attachment, boolean bl, boolean bl2) {
        a.debug((Object)"Updating SpaceInfo...");
        String string = attachment.getSpaceKey();
        if (this.i.a(string) != null) {
            long l = attachment.getFileSize();
            a.debug((Object)("File name [" + attachment.getFileName() + "] size [" + l + "] version [" + attachment.getVersion() + "] space key [" + string + "]"));
            if (bl2) {
                l = 0L;
                a.debug((Object)"Getting all versions of the attachment...");
                List list = this.c.getAllVersions(attachment);
                for (Attachment attachment2 : list) {
                    l += attachment2.getFileSize();
                    a.debug((Object)("(v." + attachment2.getVersion() + ") File size [" + attachment2.getFileSize() + "]"));
                }
            }
            this.i.a(string, l, bl);
        }
    }

    private void a(@NotNull Attachment attachment, long l, String string) {
        long l2 = attachment.getId();
        int n = attachment.getVersion();
        String string2 = attachment.getFileName();
        a.debug((Object)("Attachment id [" + l2 + "]"));
        a.debug((Object)("Attachment version [" + n + "]"));
        a.debug((Object)("File name [" + string2 + "]"));
        Date date = attachment.getCreationDate();
        a.debug((Object)("Creation date [" + date + "]"));
        date = DateHelper.a(date);
        if (this.b.d() || this.b.e()) {
            a.debug((Object)("Create AttachmentToScan for [" + string2 + "] id [" + l2 + "] version [" + n + "] creation date [" + date + "] attached to [" + l + "]"));
            this.d.a(l2, n, date, l);
        }
        long l3 = attachment.getFileSize();
        long l4 = this.b.getLargeAttachmentSize();
        boolean bl = this.b.r();
        a.debug((Object)("File size [" + l3 + "]"));
        a.debug((Object)("Large attachment size [" + l4 + "]"));
        a.debug((Object)("Track large attachment? [" + bl + "]"));
        if (bl && l3 >= l4) {
            a.debug((Object)("Add LargeAttachment for [" + string2 + "]"));
            this.f.a(attachment, l2, n, date, l, string);
        }
    }

    @EventListener
    public void a(@NotNull PageMoveEvent pageMoveEvent) {
        a.debug((Object)"*** Page Move Event ***");
        boolean bl = pageMoveEvent.isMovedSpace();
        a.debug((Object)("Is moved space? [" + bl + "]"));
        List list = pageMoveEvent.getMovedPageList();
        if (bl && list != null && !list.isEmpty()) {
            Space space = pageMoveEvent.getOldSpace();
            Space space2 = pageMoveEvent.getPage().getSpace();
            PageMoveTask pageMoveTask = new PageMoveTask(this.i, space, space2, list);
            a.debug((Object)"Scheduling PageMoveTask");
            this.g.schedule(pageMoveTask, 0L, TimeUnit.SECONDS);
        }
    }

    @Override
    @EventListener
    public void a(@NotNull SpaceCreateEvent spaceCreateEvent) {
        a.debug((Object)"*** Space CREATE Event ***");
        Space space = spaceCreateEvent.getSpace();
        a.debug((Object)("Space key [" + space.getKey() + "]"));
        if (this.b.q()) {
            this.i.a(space);
        }
    }

    @Override
    @EventListener
    public void a(@NotNull SpaceRemoveEvent spaceRemoveEvent) {
        String string = spaceRemoveEvent.getSpace().getKey();
        a.debug((Object)"*** Space REMOVE Event ***");
        a.debug((Object)("Space key [" + string + "]"));
        this.h.c(string);
        this.h.d(string);
        this.i.b(string);
        this.j.d(string);
        this.k.b(string);
    }
}

