/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.beans.OptionBean;
import com.akelesconsulting.confluence.plugins.rest.beans.QuotaConfigBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ResultBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ScheduledJobBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ScheduledTimeBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceQuotaBean;
import com.akelesconsulting.confluence.plugins.scheduler.JobScheduler;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.akelesconsulting.confluence.plugins.utils.QuotaHelper;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Path(value="/quota-summary")
public class QuotaSummaryResource {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.rest.QuotaSummaryResource");
    private static final String b = "com.akeles.acc.error.noViewPermission";
    private static final String c = "com.akeles.acc.config.error.update.permissionDenied";
    private static final String d = "com.akeles.acc.date.notRecorded";
    private final AttachmentCheckerConfig e;
    private final DateHelper f;
    private final Gson g;
    private final I18nResolver h;
    private final JobScheduler i;
    private final PermissionManager j;
    private final QuotaHelper k;
    private final SpaceInfoService l;

    @Inject
    public QuotaSummaryResource(AttachmentCheckerConfig attachmentCheckerConfig, DateHelper dateHelper, @ComponentImport I18nResolver i18nResolver, JobScheduler jobScheduler, @ComponentImport PermissionManager permissionManager, QuotaHelper quotaHelper, SpaceInfoService spaceInfoService) {
        this.e = attachmentCheckerConfig;
        this.f = dateHelper;
        this.g = new Gson();
        this.h = i18nResolver;
        this.i = jobScheduler;
        this.j = permissionManager;
        this.k = quotaHelper;
        this.l = spaceInfoService;
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig() {
        a.debug((Object)"Get quota summary config");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to get quota summary config"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.h.getText(b)).build();
        }
        long l = this.e.getDefaultQuotaAllocated();
        boolean bl = l == 0L;
        String string = this.e.getUnit();
        String string2 = bl ? this.h.getText("com.akeles.acc.config.common.unlimited") : AttachmentCheckerHelper.a(l, string, 2);
        long l2 = this.e.getDefaultPersonalQuotaAllocated();
        boolean bl2 = l2 == 0L;
        String string3 = this.e.getDefaultPersonalQuotaUnit();
        String string4 = bl2 ? this.h.getText("com.akeles.acc.config.common.unlimited") : AttachmentCheckerHelper.a(l2, string3, 2);
        ScheduledJobBean scheduledJobBean = this.getScheduledJobBean();
        QuotaConfigBean quotaConfigBean = new QuotaConfigBean(this.e.k(), bl, string2, string, scheduledJobBean);
        quotaConfigBean.setPersonalQuota(bl2, string4, string3);
        a.debug((Object)quotaConfigBean.toString());
        return Response.ok((Object)this.g.toJson((Object)quotaConfigBean)).build();
    }

    @NotNull
    private ScheduledJobBean getScheduledJobBean() {
        Object object;
        Object object2;
        boolean bl;
        ScheduledJobBean scheduledJobBean = new ScheduledJobBean();
        String string = this.e.getJobStartHour();
        String string2 = this.e.getJobStartMinute();
        String string3 = this.e.getJobStartAmPm();
        String string4 = this.e.getJobEndHour();
        String string5 = this.e.getJobEndMinute();
        String string6 = this.e.getJobEndAmPm();
        boolean bl2 = bl = !string.isEmpty();
        if (bl) {
            scheduledJobBean.setStartTime(string, string2, string3);
            scheduledJobBean.setEndTime(string4, string5, string6);
        }
        String string7 = this.f.a(string, string2, string3, string4, string5, string6, this.h.getText("com.akeles.acc.untilAllSpacesAreCalculated"));
        scheduledJobBean.setScheduledTime(string7);
        String string8 = this.e.getQuotaRecalculationInterval();
        scheduledJobBean.setInterval(new OptionBean(this.h.getText("com.akeles.acc.interval." + string8), string8));
        int n = this.l.getSpaceCount();
        int n2 = this.l.getSpaceInfoRecalculatedCount();
        boolean bl3 = this.e.p();
        boolean bl4 = this.e.q();
        boolean bl5 = this.l.getSpaceInfoCalculatedCount() == n;
        boolean bl6 = n2 > 0 || this.l.getSpaceInfoPendingRecalculationCount() > 0;
        a.debug((Object)("Is quota setup completed? [" + bl4 + "]"));
        a.debug((Object)("Is quota calculation completed? [" + bl5 + "]"));
        if (bl6) {
            object2 = this.h.getText("com.akeles.acc.recalculationStatus.spaceCount", new Serializable[]{Integer.valueOf(n2), Integer.valueOf(n)});
            scheduledJobBean.setStatus((String)object2, n2, n);
        } else {
            int n3 = this.l.getSpaceInfoNotPurgedCount();
            object = this.h.getText("com.akeles.acc.calculationStatus.spaceCount", new Serializable[]{Integer.valueOf(n3), Integer.valueOf(n)});
            scheduledJobBean.setStatus((String)object, n3, n);
        }
        object2 = this.e.getQuotaCalculationStartTime();
        object = this.e.getQuotaCalculationEndTime();
        String string9 = this.f.a((Long)object2, this.h.getText(d));
        String string10 = this.f.a((Long)object, this.h.getText(d));
        String string11 = this.f.a((Long)object2, (Long)object, this.h.getText(d));
        String string12 = "-";
        String string13 = "-";
        if (bl3 && this.e.getQuotaCalculationEndTime() == 0L) {
            String string14;
            string10 = string14 = bl6 ? this.h.getText("com.akeles.acc.recalculationInProgress") : this.h.getText("com.akeles.acc.calculationInProgress");
            string11 = string14;
            string12 = string14;
            string13 = string14;
        } else if (bl) {
            string13 = this.f.a(DateHelper.a(string, string2, string3), "-");
            Calendar calendar = DateHelper.a((Long)object, this.e.getMonthsInterval(), DateHelper.a(string, string3), DateHelper.a(string2));
            string12 = !bl4 || !bl5 || (Long)object == 0L || calendar.before(Calendar.getInstance()) ? string13 : this.f.a(calendar.getTime(), "-");
        }
        scheduledJobBean.setLastRunDetails(string9, string10, string11);
        scheduledJobBean.setNextRunDetails(string12, string13);
        scheduledJobBean.setJobStatus(bl, bl3);
        return scheduledJobBean;
    }

    @POST
    @Path(value="/config")
    @Produces(value={"application/json"})
    @ReadOnlyAccessBlocked
    public Response a(QuotaConfigBean quotaConfigBean) {
        a.debug((Object)"Update quota summary config");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to edit quota summary config"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.h.getText(c)).build();
        }
        String string = quotaConfigBean.getQuotaCheck();
        String string2 = quotaConfigBean.getQuotaAllocated();
        String string3 = quotaConfigBean.getPersonalQuotaAllocated();
        ScheduledJobBean scheduledJobBean = quotaConfigBean.getScheduledJob();
        String string4 = quotaConfigBean.getQuotaRecalculationInterval();
        if (string != null) {
            if (!this.e.q()) {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.h.getText("com.akeles.acc.error.quotaSetupIncomplete")).build();
            }
            a.debug((Object)("Update quotaCheck [" + string + "]"));
            this.e.setQuotaCheck(string);
        } else if (string2 != null) {
            String string5 = quotaConfigBean.getQuotaUnit();
            a.debug((Object)("Update quotaAllocated [" + string2 + "] unit [" + string5 + "]"));
            string2 = AttachmentCheckerHelper.d(string2);
            if (string2.isEmpty()) {
                string2 = "0";
            }
            string2 = AttachmentCheckerHelper.a(string2, string5);
            this.e.b(string2, string5);
        } else if (string3 != null) {
            String string6 = quotaConfigBean.getPersonalQuotaUnit();
            a.debug((Object)("Update personalQuotaAllocated [" + string3 + "] unit [" + string6 + "]"));
            string3 = AttachmentCheckerHelper.d(string3);
            if (string3.isEmpty()) {
                string3 = "0";
            }
            string3 = AttachmentCheckerHelper.a(string3, string6);
            this.e.c(string3, string6);
        } else if (scheduledJobBean != null) {
            if (this.e.p()) {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.h.getText("com.akeles.acc.error.quotaJobIsRunning")).build();
            }
            ScheduledTimeBean scheduledTimeBean = scheduledJobBean.getStartTime();
            ScheduledTimeBean scheduledTimeBean2 = scheduledJobBean.getEndTime();
            a.debug((Object)("Update quotaCalculationJobStartTime [" + scheduledTimeBean + "]"));
            a.debug((Object)("Update quotaCalculationJobEndTime [" + scheduledTimeBean2 + "]"));
            this.e.a(scheduledTimeBean.getHour(), scheduledTimeBean.getMinute(), scheduledTimeBean.getAmPm(), scheduledTimeBean2.getHour(), scheduledTimeBean2.getMinute(), scheduledTimeBean2.getAmPm());
            this.i.a(DateHelper.a(scheduledTimeBean.getHour(), scheduledTimeBean.getMinute(), scheduledTimeBean.getAmPm()));
        } else if (string4 != null) {
            a.debug((Object)("Update quotaRecalculationInterval [" + string4 + "]"));
            this.e.setQuotaRecalculationInterval(string4);
        }
        return this.getConfig();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="startIndex") int n, @QueryParam(value="query") @DefaultValue(value="") String string, @QueryParam(value="allocation") @DefaultValue(value="") String string2, @QueryParam(value="usage") @DefaultValue(value="") String string3, @QueryParam(value="spaceType") @DefaultValue(value="") String string4) {
        a.debug((Object)("Get space quota list, start index [" + n + "]"));
        a.debug((Object)("Query [" + string + "]"));
        a.debug((Object)("Allocation [" + string2 + "]"));
        a.debug((Object)("Usage [" + string3 + "]"));
        a.debug((Object)("Space type [" + string4 + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to get space quota list"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.h.getText(b)).build();
        }
        ResultBean resultBean = new ResultBean(50);
        List<SpaceQuotaBean> list = new ArrayList<SpaceQuotaBean>();
        boolean bl = !string.isEmpty() || !string2.isEmpty() || !string3.isEmpty() || !string4.isEmpty();
        int n2 = 0;
        if (n >= 0) {
            if (bl) {
                list = this.k.a(string, string2, string3, string4);
                n2 = list.size();
                if (n2 > 50) {
                    list = this.a(n, list);
                }
            } else {
                list = this.k.a(n);
                n2 = this.l.getSpaceInfoCount();
            }
        }
        resultBean.setPagination(n, n2);
        resultBean.addSpaceQuotaBeanList(list);
        a.debug((Object)resultBean.toString());
        return Response.ok((Object)this.g.toJson((Object)resultBean)).build();
    }

    private List<SpaceQuotaBean> a(int n, @NotNull List<SpaceQuotaBean> list) {
        int n2 = n + 50;
        if (n2 > list.size()) {
            n2 = list.size();
        }
        if (n <= list.size() - 1) {
            try {
                list = list.subList(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                a.error((Object)"Index out of bound when getting sublist of SpaceQuotaBean", (Throwable)indexOutOfBoundsException);
            }
        } else {
            list = new ArrayList<SpaceQuotaBean>();
        }
        return list;
    }

    @POST
    @Path(value="/recalculate")
    @Produces(value={"application/json"})
    @ReadOnlyAccessBlocked
    public Response a() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to trigger recalculation"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.h.getText(c)).build();
        }
        this.l.a();
        return this.getConfig();
    }
}

