/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirusScanningJobHelper {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.utils.VirusScanningJobHelper");
    private final AttachmentManager b;
    private final CommentManager c;
    private final I18nResolver d;
    private final LocaleManager e;
    private final PageManager f;
    private final TransactionTemplate g;

    @Autowired
    public VirusScanningJobHelper(@ComponentImport AttachmentManager attachmentManager, @ComponentImport CommentManager commentManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport LocaleManager localeManager, @ComponentImport PageManager pageManager, @ComponentImport TransactionTemplate transactionTemplate) {
        this.b = attachmentManager;
        this.c = commentManager;
        this.d = i18nResolver;
        this.e = localeManager;
        this.f = pageManager;
        this.g = transactionTemplate;
    }

    public File a(Attachment attachment) {
        File file = null;
        a.debug((Object)"Creating temp file...");
        try {
            file = File.createTempFile("AttachmentCheckerTempFile", ".tmp");
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            a.error((Object)"Error creating temp file", (Throwable)iOException);
        }
        if (file != null) {
            try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                 InputStream inputStream = this.b.getAttachmentData(attachment);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (IOException iOException) {
                a.error((Object)"Error copying content", (Throwable)iOException);
            }
        }
        return file;
    }

    public String a(String string, int n, ConfluenceUser confluenceUser) {
        a.debug((Object)"Get comment for null creation date");
        Locale locale = this.e.getLocaleInfo((User)confluenceUser).getSelectedLocale();
        a.debug((Object)("Creator [" + confluenceUser + "] locale [" + locale + "]"));
        String string2 = confluenceUser == null ? this.d.getText(locale, "com.akeles.acc.greeting.anonymous", new Serializable[]{this.d.getText(locale, "anonymous.name")}) : this.d.getText(locale, "com.akeles.acc.greeting.user", new Serializable[]{confluenceUser.getKey()});
        string2 = string2 + this.d.getText(locale, "com.akeles.acc.comment.nullCreationDate", new Serializable[]{string, Integer.valueOf(n)});
        return string2;
    }

    @NotNull
    public String a(String string, ConfluenceUser confluenceUser, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        String string2;
        a.debug((Object)"Get comment for infected/error");
        Locale locale = this.e.getLocaleInfo((User)confluenceUser).getSelectedLocale();
        a.debug((Object)("Creator [" + confluenceUser + "] locale [" + locale + "]"));
        String string3 = string2 = confluenceUser == null ? this.d.getText(locale, "com.akeles.acc.greeting.anonymous", new Serializable[]{this.d.getText(locale, "anonymous.name")}) : this.d.getText(locale, "com.akeles.acc.greeting.user", new Serializable[]{confluenceUser.getKey()});
        if (bl) {
            string2 = string2 + this.d.getText(locale, "com.akeles.acc.comment.infectedFile", new Serializable[]{string});
            string2 = bl2 ? string2 + this.a(locale, bl5) : string2 + this.d.getText(locale, "com.akeles.acc.comment.infectedFile.notDeleted");
        } else {
            string2 = string2 + this.d.getText(locale, "com.akeles.acc.comment.errorScanning", new Serializable[]{string});
            string2 = bl3 ? string2 + this.a(locale, bl5) : (bl4 ? string2 + this.d.getText(locale, "com.akeles.acc.comment.errorScanning.emailed") : string2 + this.d.getText(locale, "com.akeles.acc.comment.errorScanning.notDeleted"));
        }
        return string2;
    }

    @NotNull
    private String a(Locale locale, boolean bl) {
        if (!bl) {
            return this.d.getText(locale, "com.akeles.acc.comment.errorDeleting");
        }
        return this.d.getText(locale, "com.akeles.acc.comment.replacedWithPlaceholder");
    }

    public void a(String string, long l, ConfluenceUser confluenceUser) {
        this.g.execute(() -> {
            ContentEntityObject contentEntityObject = this.f.getById(l);
            if (contentEntityObject != null) {
                String string2 = contentEntityObject.getType();
                String string3 = contentEntityObject.getTitle();
                a.debug((Object)("Adding comment to [" + string2 + "] with title [" + string3 + "]"));
                ConfluenceUser confluenceUser2 = AuthenticatedUserThreadLocal.get();
                AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser);
                this.c.addCommentToObject(contentEntityObject, null, string);
                AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser2);
            } else {
                a.debug((Object)("ContentEntityObject with id [" + l + "] is null"));
            }
            return null;
        });
    }
}

