/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.entity.MissingAttachment;
import com.akelesconsulting.confluence.plugins.ao.service.MissingAttachmentService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceScannedService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.beans.AttachmentBean;
import com.akelesconsulting.confluence.plugins.rest.beans.PageBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ResultBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ScheduledJobBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ScheduledTimeBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceBean;
import com.akelesconsulting.confluence.plugins.scheduler.JobScheduler;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.AttachmentHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.akelesconsulting.confluence.plugins.utils.LicenseHelper;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Path(value="/missing-attachment")
public class MissingAttachmentScannerResource {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.rest.MissingAttachmentCheckerResource");
    private static final int b = 50;
    private final AttachmentCheckerConfig c;
    private final AttachmentHelper d;
    private final DateHelper e;
    private final Gson f;
    private final I18nResolver g;
    private final JobScheduler h;
    private final LicenseHelper i;
    private final MissingAttachmentService j;
    private final PermissionManager k;
    private final SettingsManager l;
    private final SpaceInfoService m;
    private final SpaceScannedService n;

    @Inject
    public MissingAttachmentScannerResource(AttachmentCheckerConfig attachmentCheckerConfig, AttachmentHelper attachmentHelper, DateHelper dateHelper, @ComponentImport I18nResolver i18nResolver, JobScheduler jobScheduler, LicenseHelper licenseHelper, MissingAttachmentService missingAttachmentService, @ComponentImport PermissionManager permissionManager, @ComponentImport SettingsManager settingsManager, SpaceInfoService spaceInfoService, SpaceScannedService spaceScannedService) {
        this.c = attachmentCheckerConfig;
        this.d = attachmentHelper;
        this.e = dateHelper;
        this.f = new Gson();
        this.g = i18nResolver;
        this.h = jobScheduler;
        this.i = licenseHelper;
        this.j = missingAttachmentService;
        this.k = permissionManager;
        this.l = settingsManager;
        this.m = spaceInfoService;
        this.n = spaceScannedService;
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig() {
        boolean bl;
        a.debug((Object)"Get missing attachment scanner config");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.k.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to get missing attachment scanner config"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ScheduledJobBean scheduledJobBean = new ScheduledJobBean();
        String string = this.c.getMissingAttachmentScannerStartHour();
        String string2 = this.c.getMissingAttachmentScannerStartMinute();
        String string3 = this.c.getMissingAttachmentScannerStartAmPm();
        String string4 = this.c.getMissingAttachmentScannerEndHour();
        String string5 = this.c.getMissingAttachmentScannerEndMinute();
        String string6 = this.c.getMissingAttachmentScannerEndAmPm();
        boolean bl2 = bl = !StringUtils.isEmpty((CharSequence)string);
        if (bl) {
            scheduledJobBean.setStartTime(string, string2, string3);
            scheduledJobBean.setEndTime(string4, string5, string6);
        }
        String string7 = this.e.a(string, string2, string3, string4, string5, string6, this.g.getText("com.akeles.acc.untilAllSpacesAreScanned"));
        scheduledJobBean.setScheduledTime(string7);
        int n = this.n.a("missing");
        int n2 = this.m.getSpaceList().size();
        String string8 = this.g.getText("com.akeles.acc.scanStatus.spaceCount", new Serializable[]{Integer.valueOf(n), Integer.valueOf(n2)});
        scheduledJobBean.setStatus(string8, n, n2);
        boolean bl3 = this.c.s();
        boolean bl4 = this.c.t();
        a.debug((Object)("Is missing attachment scan completed? [" + bl4 + "]"));
        Long l = this.c.getMissingAttachmentScannerLastRun();
        String string9 = this.e.a(l, this.g.getText("com.akeles.acc.date.never"));
        String string10 = "-";
        boolean bl5 = this.i.a();
        scheduledJobBean.setIsEvaluationLicense(bl5);
        if (bl3) {
            string10 = this.g.getText("com.akeles.acc.scanning");
        } else if (bl5 && this.j.getMissingAttachmentTotalCount() > 0) {
            string10 = this.g.getText("com.akeles.acc.missingAttachmentScanner.purchaseLicenseToScan");
            scheduledJobBean.setIsEvaluationMessage(true);
        } else if (!bl4 && bl) {
            string10 = this.e.a(DateHelper.a(string, string2, string3), "");
        }
        scheduledJobBean.setLastRunDetails(string9, "", "");
        scheduledJobBean.setNextRunDetails(string10, "");
        scheduledJobBean.setJobStatus(bl, bl3);
        a.debug((Object)scheduledJobBean.toString());
        return Response.ok((Object)this.f.toJson((Object)scheduledJobBean)).build();
    }

    @POST
    @Path(value="/config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response a(ScheduledJobBean scheduledJobBean) {
        a.debug((Object)"Update missing attachment scanner config");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.k.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to update missing attachment scanner config"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        boolean bl = this.c.s();
        if (bl) {
            a.debug((Object)"Missing attachment scanner is running, config is not updated!");
        } else {
            ScheduledTimeBean scheduledTimeBean = scheduledJobBean.getStartTime();
            String string = scheduledTimeBean.getHour();
            String string2 = scheduledTimeBean.getMinute();
            String string3 = scheduledTimeBean.getAmPm();
            ScheduledTimeBean scheduledTimeBean2 = scheduledJobBean.getEndTime();
            String string4 = scheduledTimeBean2.getHour();
            String string5 = scheduledTimeBean2.getMinute();
            String string6 = scheduledTimeBean2.getAmPm();
            this.c.b(string, string2, string3, string4, string5, string6);
            this.h.b(DateHelper.a(string, string2, string3));
        }
        return this.getConfig();
    }

    @POST
    @Path(value="/rescan")
    @Produces(value={"application/json"})
    public Response a() {
        a.debug((Object)"Trigger rescan for missing attachments");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.k.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to trigger rescan for missing attachments"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        boolean bl = this.c.s();
        if (bl) {
            a.debug((Object)"Missing attachment scanner is running, rescan is not triggered!");
        } else {
            this.j.a();
            this.n.b("missing");
            this.c.setIsMissingAttachmentScanCompleted(false);
        }
        return this.getConfig();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="startIndex") int n) {
        a.debug((Object)("Get list of MissingAttachment, start index [" + n + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.k.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to get missing attachment list"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ResultBean resultBean = new ResultBean(50);
        List<MissingAttachment> list = this.j.a(n, 50);
        String string = this.l.getGlobalSettings().getBaseUrl();
        for (MissingAttachment missingAttachment : list) {
            Object object;
            a.debug((Object)("Attachment id [" + missingAttachment.getAttachmentId() + "]"));
            long l = missingAttachment.getAttachmentId();
            int n2 = missingAttachment.getVersion();
            Date date = missingAttachment.getCreationDate();
            Attachment attachment = this.d.a(l, n2, date);
            if (attachment == null) {
                this.j.a(missingAttachment);
                continue;
            }
            String string2 = attachment.getFileName();
            String string3 = AttachmentCheckerHelper.a(attachment.getFileSize(), 2);
            ContentEntityObject contentEntityObject = attachment.getContainer();
            long l2 = contentEntityObject == null ? 0L : contentEntityObject.getId();
            String string4 = this.d.a(attachment, l, n2, l2);
            AttachmentBean attachmentBean = new AttachmentBean(missingAttachment.getID(), this.e.a(date, this.g.getText("com.akeles.acc.unknown")), missingAttachment.getVersion(), string2, string3, string4);
            attachmentBean.setIsInTrash(attachment.isDeleted());
            Space space = attachment.getSpace();
            if (space != null) {
                object = new SpaceBean(space.getKey());
                ((SpaceBean)object).setName(space.getName());
                ((SpaceBean)object).setUrl(string + space.getUrlPath());
                attachmentBean.setSpace((SpaceBean)object);
            }
            if ((object = attachment.getContainer()) != null) {
                PageBean pageBean = new PageBean();
                pageBean.setTitle(object.getTitle());
                pageBean.setUrl(string + object.getAttachmentsUrlPath());
                attachmentBean.setPage(pageBean);
            }
            resultBean.addAttachment(attachmentBean);
        }
        int n3 = this.j.getMissingAttachmentTotalCount();
        resultBean.setPagination(n, n3);
        resultBean.setIsEvaluationLicense(this.i.a());
        a.debug((Object)resultBean.toString());
        return Response.ok((Object)this.f.toJson((Object)resultBean)).build();
    }

    @DELETE
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response b() {
        a.debug((Object)"Delete all MissingAttachment");
        if (this.i.a()) {
            a.debug((Object)"Missing attachments cannot be purged with evaluation license!");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.k.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to purge missing attachments"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        List<MissingAttachment> list = this.j.getAllMissingAttachment();
        for (MissingAttachment missingAttachment : list) {
            long l = missingAttachment.getAttachmentId();
            int n = missingAttachment.getVersion();
            Date date = missingAttachment.getCreationDate();
            this.d.b(l, n, date);
            this.j.a(missingAttachment);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response b(@PathParam(value="id") int n) {
        a.debug((Object)("Delete MissingAttachment id [" + n + "]"));
        if (this.i.a()) {
            a.debug((Object)"Missing attachment cannot be deleted with evaluation license!");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.k.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to delete missing attachment"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        MissingAttachment missingAttachment = this.j.a(n);
        if (missingAttachment != null) {
            long l = missingAttachment.getAttachmentId();
            int n2 = missingAttachment.getVersion();
            Date date = missingAttachment.getCreationDate();
            this.d.b(l, n2, date);
            this.j.a(missingAttachment);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

