/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.config;

import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeGroup;
import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeLimit;
import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.akelesconsulting.confluence.plugins.ao.service.FileSizeLimitService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.apache.tika.Tika;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentCheckerConfig {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.config.AttachmentCheckerConfig");
    private static final String b = "whitelist";
    private static final String c = "blacklist";
    private static final String d = "enabled";
    private static final String e = "application/octet-stream";
    private static final String f = "application/x-msdownload";
    private static final String g = "application/x-dosexec";
    private static final String h = "text/plain";
    private static final String i = ".render";
    private static final String j = ".tfss";
    private static final String k = "jpg";
    private static final String l = "whitelist";
    private static final String m = "This file type is not allowed.";
    private static final String n = "The file size has exceeded the maximum size limit set for the file type.";
    private static final String o = "Insufficient quota available.";
    private static final String p = "MB";
    private static final int q = 90;
    private static final String r = "This space has exceeded 90% of the disk quota. Please housekeep the attachments or inform the Confluence admin to increase the quota.";
    private static final String s = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.";
    private static final String t = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions";
    private static final String u = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map";
    private static final String v = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set";
    private static final String w = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set";
    private static final String x = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.filterMode";
    private static final String y = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowProtected";
    private static final String z = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowEncrypted";
    private static final String A = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowDrawIo";
    private static final String B = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowTableSpreadsheetMacro";
    private static final String C = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.message";
    private static final String D = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeCheck";
    private static final String E = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeError";
    private static final String F = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.onAccessScanning";
    private static final String G = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerMode";
    private static final String H = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerPath";
    private static final String I = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerOption";
    private static final String J = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.autoDeleteMode";
    private static final String K = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfInfected";
    private static final String L = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.deleteIfError";
    private static final String M = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfError";
    private static final String N = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.groupToEmail";
    private static final String O = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusAlertActor";
    private static final String P = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanRunning";
    private static final String Q = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanNodeId";
    private static final String R = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isAttachmentAssignmentJobRunning";
    private static final String S = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.attachmentAssignmentJobNodeId";
    private static final String T = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCheck";
    private static final String U = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaError";
    private static final String V = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultStorage";
    private static final String W = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unit";
    private static final String X = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultPersonalQuotaAllocated";
    private static final String Y = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultPersonalQuotaUnit";
    private static final String Z = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaAlertThreshold";
    private static final String aa = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaAlertMessage";
    private static final String ab = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowUsersToViewSpaceQuota";
    private static final String ac = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.showSpaceQuotaTips";
    private static final String ad = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.spaceQuotaTipsText";
    private static final String ae = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.spaceQuotaTipsUrl";
    private static final String af = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndAmPm";
    private static final String ag = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndHour";
    private static final String ah = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndMinute";
    private static final String ai = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartAmPm";
    private static final String aj = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartHour";
    private static final String ak = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartMinute";
    private static final String al = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaRecalculationInterval";
    private static final String am = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCalculationStartTime";
    private static final String an = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCalculationEndTime";
    private static final String ao = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isJobRunning";
    private static final String ap = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isQuotaSetupCompleted";
    private static final String aq = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.enableQuotaCheckAfterSetup";
    private static final String ar = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.trackLargeAttachment";
    private static final String as = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.largeAttachmentSize";
    private static final long at = 0xFA00000L;
    private static final String au = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartHour";
    private static final String av = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartMinute";
    private static final String aw = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartAmPm";
    private static final String ax = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndHour";
    private static final String ay = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndMinute";
    private static final String az = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndAmPm";
    private static final String aA = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobLastRun";
    private static final String aB = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanRunning";
    private static final String aC = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanCompleted";
    private static final String aD = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobStartHour";
    private static final String aE = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobStartMinute";
    private static final String aF = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobStartAmPm";
    private static final String aG = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobEndHour";
    private static final String aH = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobEndMinute";
    private static final String aI = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobEndAmPm";
    private static final String aJ = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobLastRun";
    private static final String aK = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isViolationScanRunning";
    private static final String aL = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isViolationScanCompleted";
    private static final String aM = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.loggingMode";
    private static final String aN = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.attachmentLogGroup";
    private final Cache<String, Object> aO;
    private final FileSizeLimitService aP;
    private final GroupManager aQ;
    private final MimeTypes aR;
    private final PluginAccessor aS;
    private final PluginSettingsFactory aT;
    private final PermissionManager aU;
    private final SpaceInfoService aV;
    private final Tika aW;
    private final UserAccessor aX;

    @Autowired
    public AttachmentCheckerConfig(@ComponentImport @NotNull CacheManager cacheManager, FileSizeLimitService fileSizeLimitService, @ComponentImport GroupManager groupManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport PermissionManager permissionManager, SpaceInfoService spaceInfoService, @ComponentImport UserAccessor userAccessor) {
        String string = AttachmentCheckerConfig.class.getName() + ".cache";
        CacheSettings cacheSettings = new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(1000).flushable().build();
        this.aO = cacheManager.getCache(string, (CacheLoader)new AcConfigCacheLoader(), cacheSettings);
        this.aQ = groupManager;
        this.aP = fileSizeLimitService;
        this.aR = MimeTypes.getDefaultMimeTypes();
        this.aS = pluginAccessor;
        this.aT = pluginSettingsFactory;
        this.aU = permissionManager;
        this.aV = spaceInfoService;
        this.aW = new Tika();
        this.aX = userAccessor;
    }

    public List<String> a(String string) {
        List<String> list;
        String string2 = this.d(string);
        if (string2.equalsIgnoreCase(f) || string2.equalsIgnoreCase(g)) {
            list = this.d(string, f);
            list.addAll(this.d(string, g));
        } else {
            list = this.d(string, string2);
        }
        return list;
    }

    private List<String> d(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            MimeType mimeType = this.aR.forName(string2);
            List list = mimeType.getExtensions();
            for (String string3 : list) {
                if (string3.equalsIgnoreCase(string)) continue;
                arrayList.add(string3);
            }
        }
        catch (MimeTypeException mimeTypeException) {
            a.debug((Object)mimeTypeException.getMessage());
        }
        return arrayList;
    }

    public String getExtensions() {
        return (String)this.aO.get((Object)t);
    }

    public String getFilterMode() {
        return (String)this.aO.get((Object)x);
    }

    public String getFileTypeErrorMessage() {
        return (String)this.aO.get((Object)C);
    }

    public Map<String, List<String>> getExtensionsMap() {
        return (Map)this.aO.get((Object)u);
    }

    public Set<String> getExtensionSet() {
        TreeSet treeSet = (TreeSet)this.aO.get((Object)v);
        if (treeSet == null) {
            treeSet = new TreeSet();
        }
        return treeSet;
    }

    public Set<String> getMimeTypeSet() {
        TreeSet treeSet = (TreeSet)this.aO.get((Object)w);
        if (treeSet == null) {
            treeSet = new TreeSet();
        }
        return treeSet;
    }

    public void a(String string, String string2, String string3) {
        PluginSettings pluginSettings = this.aT.createGlobalSettings();
        pluginSettings.put(x, (Object)string);
        this.aO.remove((Object)x);
        a.debug((Object)("Updated filterMode [" + string + "]"));
        pluginSettings.put(t, (Object)string2);
        this.aO.remove((Object)t);
        this.aO.remove((Object)u);
        this.aO.remove((Object)v);
        this.aO.remove((Object)w);
        a.debug((Object)("Updated extensions [" + string2 + "]"));
        pluginSettings.put(C, (Object)string3);
        this.aO.remove((Object)C);
        a.debug((Object)("Updated fileTypeErrorMessage (message) [" + string3 + "]"));
    }

    public void a(String string, String string2, String string3, String string4) {
        PluginSettings pluginSettings = this.aT.createGlobalSettings();
        pluginSettings.put(y, (Object)string);
        this.aO.remove((Object)y);
        a.debug((Object)("Updated allowProtected [" + string + "]"));
        pluginSettings.put(z, (Object)string2);
        this.aO.remove((Object)z);
        a.debug((Object)("Updated allowEncrypted [" + string2 + "]"));
        pluginSettings.put(A, (Object)string3);
        this.aO.remove((Object)A);
        a.debug((Object)("Updated allowDrawIo [" + string3 + "]"));
        pluginSettings.put(B, (Object)string4);
        this.aO.remove((Object)B);
        a.debug((Object)("Updated allowTableSpreadsheetMacro [" + string4 + "]"));
    }

    public String getAllowProtected() {
        return (String)this.aO.get((Object)y);
    }

    public String getAllowEncrypted() {
        return (String)this.aO.get((Object)z);
    }

    public String getAllowDrawIo() {
        return (String)this.aO.get((Object)A);
    }

    public boolean a() {
        boolean bl = "on".equalsIgnoreCase(this.getAllowDrawIo());
        a.debug((Object)("Allow draw.io? [" + bl + "]"));
        return bl;
    }

    public String getAllowTableSpreadsheetMacro() {
        return (String)this.aO.get((Object)B);
    }

    public boolean b() {
        return "on".equalsIgnoreCase(this.getAllowTableSpreadsheetMacro());
    }

    public boolean c() {
        return "on".equalsIgnoreCase(this.getFileSizeCheck());
    }

    public String getFileSizeCheck() {
        String string = (String)this.aO.get((Object)D);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setFileSizeCheck(String string) {
        this.aT.createGlobalSettings().put(D, (Object)string);
        this.aO.remove((Object)D);
        a.debug((Object)("Updated file size check [" + string + "]"));
    }

    public String getFileSizeErrorMessage() {
        return (String)this.aO.get((Object)E);
    }

    public void setFileSizeErrorMessage(String string) {
        this.aT.createGlobalSettings().put(E, (Object)string);
        this.aO.remove((Object)E);
        a.debug((Object)("Updated file size error message [" + string + "]"));
    }

    public boolean d() {
        return this.getMissingFileCheck().equalsIgnoreCase("on");
    }

    public String getMissingFileCheck() {
        String string = (String)this.aO.get((Object)F);
        if (Boolean.TRUE.toString().equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setMissingFileCheck(String string) {
        this.aT.createGlobalSettings().put(F, (Object)string);
        this.aO.remove((Object)F);
        a.debug((Object)("Updated missing file check [" + string + "]"));
    }

    public boolean e() {
        return this.getVirusScanning().equalsIgnoreCase("on");
    }

    public String getVirusScanning() {
        String string = (String)this.aO.get((Object)G);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setVirusScanning(String string) {
        this.aT.createGlobalSettings().put(G, (Object)string);
        this.aO.remove((Object)G);
        a.debug((Object)("Updated virus scanning [" + string + "]"));
    }

    public boolean a(int n, @NotNull String string) {
        boolean bl = true;
        if (!this.getScannerDetected().equalsIgnoreCase("unknown")) {
            bl = n == 1 && (string.contains("clamscan") || string.contains("clamdscan") || string.contains("fpscan")) || n == 3 && string.contains("savscan") || n == 13 && (string.contains("uvscan") || string.contains("scan.exe")) || n == 50 && (string.contains("ecls.exe") || string.contains("eset")) || n == 72 && string.contains("kesl-control");
        }
        a.debug((Object)("Is infected? [" + bl + "]"));
        return bl;
    }

    public String getScannerDetected() {
        String string = this.getScannerPath().toLowerCase();
        String string2 = string.contains("clamscan") || string.contains("clamdscan") ? "ClamAV" : (string.contains("ecls.exe") || string.contains("eset") ? "ESET" : (string.contains("fpscan") ? "F-PROT Antivirus" : (string.contains("kesl-control") ? "Kaspersky Endpoint Security for Linux" : (string.contains("savscan") ? "Sophos Anti-Virus" : (string.contains("uvscan") || string.contains("scan.exe") ? "McAfee VirusScan" : "unknown")))));
        return string2;
    }

    public String getScannerPath() {
        return (String)this.aO.get((Object)H);
    }

    public void a(String string, String string2) {
        PluginSettings pluginSettings = this.aT.createGlobalSettings();
        pluginSettings.put(H, (Object)string);
        this.aO.remove((Object)H);
        a.debug((Object)("Updated scannerPath [" + string + "]"));
        pluginSettings.put(I, (Object)string2);
        this.aO.remove((Object)I);
        a.debug((Object)("Updated scannerOption [" + string2 + "]"));
    }

    public String getScannerOption() {
        return (String)this.aO.get((Object)I);
    }

    public boolean f() {
        return this.getDeleteIfInfected().equalsIgnoreCase("on");
    }

    public String getDeleteIfInfected() {
        String string = (String)this.aO.get((Object)J);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public boolean g() {
        return this.getEmailIfInfected().equalsIgnoreCase("on");
    }

    public String getEmailIfInfected() {
        return (String)this.aO.get((Object)K);
    }

    public boolean h() {
        return this.getDeleteIfError().equalsIgnoreCase("on");
    }

    public String getDeleteIfError() {
        return (String)this.aO.get((Object)L);
    }

    public boolean i() {
        return this.getEmailIfError().equalsIgnoreCase("on");
    }

    public String getEmailIfError() {
        return (String)this.aO.get((Object)M);
    }

    public void b(String string, String string2, String string3, String string4) {
        PluginSettings pluginSettings = this.aT.createGlobalSettings();
        pluginSettings.put(J, (Object)string);
        this.aO.remove((Object)J);
        a.debug((Object)("Updated deleteIfInfected (autoDeleteMode) [" + string + "]"));
        pluginSettings.put(K, (Object)string2);
        this.aO.remove((Object)K);
        a.debug((Object)("Updated emailIfInfected [" + string2 + "]"));
        pluginSettings.put(L, (Object)string3);
        this.aO.remove((Object)L);
        a.debug((Object)("Updated deleteIfError [" + string3 + "]"));
        pluginSettings.put(M, (Object)string4);
        this.aO.remove((Object)M);
        a.debug((Object)("Updated emailIfError [" + string4 + "]"));
    }

    public String getGroupToEmail() {
        return (String)this.aO.get((Object)N);
    }

    public void setGroupToEmail(String string) {
        this.aT.createGlobalSettings().put(N, (Object)string);
        this.aO.remove((Object)N);
        a.debug((Object)("Updated group to email (Confluence Sysadmin Group) [" + string + "]"));
    }

    private String getVirusAlertActor() {
        return (String)this.aO.get((Object)O);
    }

    public void setVirusAlertActor(String string) {
        this.aT.createGlobalSettings().put(O, (Object)string);
        this.aO.remove((Object)O);
        a.debug((Object)("Updated virus alert actor [" + string + "]"));
    }

    public ConfluenceUser getVirusAlertActorUser() {
        ConfluenceUser confluenceUser = null;
        String string = this.getVirusAlertActor();
        if (!string.isEmpty()) {
            confluenceUser = this.aX.getUserByKey(new UserKey(string));
        }
        return confluenceUser;
    }

    public boolean j() {
        return Boolean.parseBoolean((String)this.aO.get((Object)R));
    }

    public void setIsAttachmentAssignmentJobRunning(boolean bl) {
        this.aT.createGlobalSettings().put(R, (Object)Boolean.toString(bl));
        this.aO.remove((Object)R);
        a.debug((Object)("Updated isAttachmentAssignmentJobRunning [" + bl + "]"));
    }

    public String getAttachmentAssignmentJobNodeId() {
        return (String)this.aO.get((Object)S);
    }

    public void setAttachmentAssignmentJobNodeId(String string) {
        this.aT.createGlobalSettings().put(S, (Object)string);
        this.aO.remove((Object)S);
        a.debug((Object)("Updated attachmentAssignmentJobNodeId [" + string + "]"));
    }

    public String getVirusScanNodeId() {
        return (String)this.aO.get((Object)Q);
    }

    public void setVirusScanNodeId(String string) {
        this.aT.createGlobalSettings().put(Q, (Object)string);
        this.aO.remove((Object)Q);
        a.debug((Object)("Updated virus scan node id [" + string + "]"));
    }

    public boolean k() {
        boolean bl = this.getQuotaCheck().equalsIgnoreCase("on");
        a.debug((Object)("Is quota check enabled? [" + bl + "]"));
        return bl;
    }

    public String getQuotaCheck() {
        String string = (String)this.aO.get((Object)T);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setQuotaCheck(String string) {
        this.aT.createGlobalSettings().put(T, (Object)string);
        this.aO.remove((Object)T);
        a.debug((Object)("Updated quota check [" + string + "]"));
    }

    public String getQuotaErrorMessage() {
        return (String)this.aO.get((Object)U);
    }

    public String getUnit() {
        return (String)this.aO.get((Object)W);
    }

    public long getDefaultQuotaAllocated() {
        Long l = (Long)this.aO.get((Object)V);
        return l == null ? 0L : l;
    }

    public boolean l() {
        return this.getDefaultQuotaAllocated() == 0L;
    }

    public void setQuotaErrorMessage(String string) {
        this.aT.createGlobalSettings().put(U, (Object)string);
        this.aO.remove((Object)U);
        a.debug((Object)("Updated quota error message [" + string + "]"));
    }

    public void b(String string, String string2) {
        PluginSettings pluginSettings = this.aT.createGlobalSettings();
        pluginSettings.put(V, (Object)string);
        this.aO.remove((Object)V);
        a.debug((Object)("Updated defaultQuotaAllocated (defaultStorage) [" + string + "]"));
        pluginSettings.put(W, (Object)string2);
        this.aO.remove((Object)W);
        a.debug((Object)("Updated defaultQuotaAllocatedUnit (unit) [" + string2 + "]"));
    }

    public long getDefaultPersonalQuotaAllocated() {
        Long l = (Long)this.aO.get((Object)X);
        if (l == null || l == -1L) {
            l = this.getDefaultQuotaAllocated();
        }
        return l;
    }

    public String getDefaultPersonalQuotaUnit() {
        String string = (String)this.aO.get((Object)Y);
        if (string == null || string.trim().isEmpty()) {
            string = this.getUnit();
        }
        return string;
    }

    public void c(String string, String string2) {
        PluginSettings pluginSettings = this.aT.createGlobalSettings();
        pluginSettings.put(X, (Object)string);
        this.aO.remove((Object)X);
        a.debug((Object)("Updated defaultPersonalQuotaAllocated [" + string + "]"));
        pluginSettings.put(Y, (Object)string2);
        this.aO.remove((Object)Y);
        a.debug((Object)("Updated defaultPersonalQuotaUnit [" + string2 + "]"));
    }

    public int getQuotaAlertThreshold() {
        Integer n = (Integer)this.aO.get((Object)Z);
        return n == null ? 90 : n;
    }

    public String getQuotaAlertMessage() {
        return (String)this.aO.get((Object)aa);
    }

    public void b(int n, String string) {
        PluginSettings pluginSettings = this.aT.createGlobalSettings();
        pluginSettings.put(Z, (Object)Integer.toString(n));
        this.aO.remove((Object)Z);
        a.debug((Object)("Updated quotaAlertThreshold [" + n + "]"));
        pluginSettings.put(aa, (Object)string);
        this.aO.remove((Object)aa);
        a.debug((Object)("Updated quotaAlertMessage [" + string + "]"));
    }

    public boolean m() {
        int n = this.aV.getSpaceCount();
        int n2 = this.aV.getSpaceInfoCalculatedCount();
        a.debug((Object)("Num of Space [" + n + "]"));
        a.debug((Object)("Num of SpaceInfo [" + n2 + "]"));
        boolean bl = this.k() || this.q() || n == n2;
        a.debug((Object)("Is quota usage viewable? [" + bl + "]"));
        return bl;
    }

    public boolean b(String string) {
        int n = this.aV.getSpaceCount();
        int n2 = this.aV.getSpaceInfoCalculatedCount();
        a.debug((Object)("Num of Space [" + n + "]"));
        a.debug((Object)("Num of SpaceInfo [" + n2 + "]"));
        boolean bl = (this.k() || this.q() || n == n2) && this.c(string);
        a.debug((Object)("Is quota usage viewable for space [" + string + "]? [" + bl + "]"));
        return bl;
    }

    public boolean c(String string) {
        SpaceInfo spaceInfo = this.aV.a(string);
        boolean bl = spaceInfo != null && spaceInfo.getStorageUsed() != -1L;
        a.debug((Object)("Is quota usage calculated? [" + bl + "]"));
        return bl;
    }

    public boolean a(ConfluenceUser confluenceUser, Space space) {
        boolean bl = confluenceUser != null && (this.aU.isConfluenceAdministrator((User)confluenceUser) || this.aU.hasPermission((User)confluenceUser, Permission.ADMINISTER, (Object)space) || this.x() && this.aU.hasPermission((User)confluenceUser, Permission.VIEW, (Object)space));
        a.debug((Object)("User has permission to view space quota? [" + bl + "]"));
        return bl;
    }

    private boolean x() {
        return this.getAllowUsersToViewSpaceQuota().equalsIgnoreCase("on");
    }

    public String getAllowUsersToViewSpaceQuota() {
        return (String)this.aO.get((Object)ab);
    }

    public void setQuotaPermissions(String string) {
        this.aT.createGlobalSettings().put(ab, (Object)string);
        this.aO.remove((Object)ab);
        a.debug((Object)("Updated allowUsersToViewSpaceQuota [" + string + "]"));
    }

    public boolean n() {
        return this.getShowSpaceQuotaTips().equalsIgnoreCase("on");
    }

    public String getShowSpaceQuotaTips() {
        return (String)this.aO.get((Object)ac);
    }

    public String getSpaceQuotaTipsText() {
        return (String)this.aO.get((Object)ad);
    }

    public String getSpaceQuotaTipsUrl() {
        return (String)this.aO.get((Object)ae);
    }

    public void b(String string, String string2, String string3) {
        this.aT.createGlobalSettings().put(ac, (Object)string);
        this.aO.remove((Object)ac);
        a.debug((Object)("Updated showSpaceQuotaTips [" + string + "]"));
        this.aT.createGlobalSettings().put(ad, (Object)string2);
        this.aO.remove((Object)ad);
        a.debug((Object)("Updated spaceQuotaTipsText [" + string2 + "]"));
        this.aT.createGlobalSettings().put(ae, (Object)string3);
        this.aO.remove((Object)ae);
        a.debug((Object)("Updated spaceQuotaTipsUrl [" + string3 + "]"));
    }

    public Date getQuotaJobNextRunTime() {
        return DateHelper.a(this.getJobStartHour(), this.getJobStartMinute(), this.getJobStartAmPm());
    }

    public String getJobEndAmPm() {
        return (String)this.aO.get((Object)af);
    }

    public String getJobEndHour() {
        return (String)this.aO.get((Object)ag);
    }

    public String getJobEndMinute() {
        return (String)this.aO.get((Object)ah);
    }

    public String getJobStartAmPm() {
        return (String)this.aO.get((Object)ai);
    }

    public String getJobStartHour() {
        return (String)this.aO.get((Object)aj);
    }

    public String getJobStartMinute() {
        return (String)this.aO.get((Object)ak);
    }

    public String getQuotaRecalculationInterval() {
        return (String)this.aO.get((Object)al);
    }

    public void setQuotaRecalculationInterval(String string) {
        PluginSettings pluginSettings = this.aT.createGlobalSettings();
        pluginSettings.put(al, (Object)string);
        this.aO.remove((Object)al);
        a.debug((Object)("Updated calculateAttachmentJobInterval (quotaRecalculationInterval) [" + string + "]"));
    }

    public int getMonthsInterval() {
        int n;
        String string;
        switch (string = this.getQuotaRecalculationInterval()) {
            case "quarterly": {
                n = 3;
                break;
            }
            case "bimonthly": {
                n = 2;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    private String getEnableQuotaCheckAfterSetup() {
        return (String)this.aO.get((Object)aq);
    }

    private String getIsJobRunning() {
        return (String)this.aO.get((Object)ao);
    }

    public boolean o() {
        return Boolean.parseBoolean(this.getEnableQuotaCheckAfterSetup());
    }

    public boolean p() {
        return Boolean.parseBoolean(this.getIsJobRunning());
    }

    public void a(String string, String string2, String string3, String string4, String string5, String string6) {
        PluginSettings pluginSettings = this.aT.createGlobalSettings();
        pluginSettings.put(aj, (Object)string);
        this.aO.remove((Object)aj);
        a.debug((Object)("Updated calculateAttachmentJobStartHour (jobStartHour) [" + string + "]"));
        pluginSettings.put(ak, (Object)string2);
        this.aO.remove((Object)ak);
        a.debug((Object)("Updated calculateAttachmentJobStartMinute (jobStartMinute) [" + string2 + "]"));
        pluginSettings.put(ai, (Object)string3);
        this.aO.remove((Object)ai);
        a.debug((Object)("Updated calculateAttachmentJobStartAmPm (jobStartAmPm) [" + string3 + "]"));
        pluginSettings.put(ag, (Object)string4);
        this.aO.remove((Object)ag);
        a.debug((Object)("Updated calculateAttachmentJobEndHour (jobEndHour) [" + string4 + "]"));
        pluginSettings.put(ah, (Object)string5);
        this.aO.remove((Object)ah);
        a.debug((Object)("Updated calculateAttachmentJobEndMinute (jobEndMinute) [" + string5 + "]"));
        pluginSettings.put(af, (Object)string6);
        this.aO.remove((Object)af);
        a.debug((Object)("Updated calculateAttachmentJobEndAmPm (jobEndAmPm) [" + string6 + "]"));
    }

    public void setIsJobRunning(boolean bl) {
        this.aT.createGlobalSettings().put(ao, (Object)String.valueOf(bl));
        this.aO.remove((Object)ao);
        a.debug((Object)("Updated is job running [" + bl + "]"));
    }

    public boolean q() {
        boolean bl = Boolean.parseBoolean((String)this.aO.get((Object)ap));
        a.debug((Object)("Is quota setup completed? [" + bl + "]"));
        return bl;
    }

    public void setIsQuotaSetupCompleted(boolean bl) {
        this.aT.createGlobalSettings().put(ap, (Object)Boolean.toString(bl));
        this.aO.remove((Object)ap);
        a.debug((Object)("Updated isQuotaSetupCompleted [" + bl + "]"));
    }

    public Long getQuotaCalculationStartTime() {
        Long l = (Long)this.aO.get((Object)am);
        a.debug((Object)("Get quotaCalculationStartTime [" + l + "]"));
        return l;
    }

    public void setQuotaCalculationStartTime(long l) {
        this.aT.createGlobalSettings().put(am, (Object)Long.toString(l));
        this.aO.remove((Object)am);
        a.debug((Object)("Updated quotaCalculationStartTime [" + l + "]"));
    }

    public Long getQuotaCalculationEndTime() {
        Long l = (Long)this.aO.get((Object)an);
        a.debug((Object)("Get quotaCalculationEndTime [" + l + "]"));
        return l;
    }

    public void setQuotaCalculationEndTime(long l) {
        this.aT.createGlobalSettings().put(an, (Object)Long.toString(l));
        this.aO.remove((Object)an);
        a.debug((Object)("Updated quotaCalculationEndTime [" + l + "]"));
    }

    public boolean r() {
        return "on".equalsIgnoreCase(this.getTrackLargeAttachment());
    }

    public String getTrackLargeAttachment() {
        return (String)this.aO.get((Object)ar);
    }

    public void setTrackLargeAttachment(String string) {
        this.aT.createGlobalSettings().put(ar, (Object)string);
        this.aO.remove((Object)ar);
        a.debug((Object)("Updated track large attachment [" + string + "]"));
    }

    public long getLargeAttachmentSize() {
        Long l = (Long)this.aO.get((Object)as);
        return l == null ? 0xFA00000L : l;
    }

    public void setLargeAttachmentSize(String string) {
        this.aT.createGlobalSettings().put(as, (Object)string);
        this.aO.remove((Object)as);
        a.debug((Object)("Updated large attachment size [" + string + "]"));
    }

    public boolean s() {
        return Boolean.parseBoolean((String)this.aO.get((Object)aB));
    }

    public void setIsMissingAttachmentScanRunning(boolean bl) {
        this.aT.createGlobalSettings().put(aB, (Object)Boolean.toString(bl));
        this.aO.remove((Object)aB);
        a.debug((Object)("Updated isMissingAttachmentScanRunning [" + bl + "]"));
    }

    public boolean t() {
        return Boolean.parseBoolean((String)this.aO.get((Object)aC));
    }

    public void setIsMissingAttachmentScanCompleted(boolean bl) {
        this.aT.createGlobalSettings().put(aC, (Object)Boolean.toString(bl));
        this.aO.remove((Object)aC);
        a.debug((Object)("Updated isMissingAttachmentScanCompleted [" + bl + "]"));
    }

    public Long getMissingAttachmentScannerLastRun() {
        return (Long)this.aO.get((Object)aA);
    }

    public void setMissingAttachmentScannerLastRun(long l) {
        this.aT.createGlobalSettings().put(aA, (Object)String.valueOf(l));
        this.aO.remove((Object)aA);
        a.debug((Object)("Updated missingAttachmentJobLastRun [" + l + "]"));
    }

    public void b(String string, String string2, String string3, String string4, String string5, String string6) {
        PluginSettings pluginSettings = this.aT.createGlobalSettings();
        pluginSettings.put(au, (Object)string);
        this.aO.remove((Object)au);
        a.debug((Object)("Updated missingAttachmentJobStartHour [" + string + "]"));
        pluginSettings.put(av, (Object)string2);
        this.aO.remove((Object)av);
        a.debug((Object)("Updated missingAttachmentJobStartMinute [" + string2 + "]"));
        pluginSettings.put(aw, (Object)string3);
        this.aO.remove((Object)aw);
        a.debug((Object)("Updated missingAttachmentJobStartAmPm [" + string3 + "]"));
        pluginSettings.put(ax, (Object)string4);
        this.aO.remove((Object)ax);
        a.debug((Object)("Updated missingAttachmentJobEndHour [" + string4 + "]"));
        pluginSettings.put(ay, (Object)string5);
        this.aO.remove((Object)ay);
        a.debug((Object)("Updated missingAttachmentJobEndMinute [" + string5 + "]"));
        pluginSettings.put(az, (Object)string6);
        this.aO.remove((Object)az);
        a.debug((Object)("Updated missingAttachmentJobEndAmPm [" + string6 + "]"));
    }

    public String getMissingAttachmentScannerStartHour() {
        return (String)this.aO.get((Object)au);
    }

    public String getMissingAttachmentScannerStartMinute() {
        return (String)this.aO.get((Object)av);
    }

    public String getMissingAttachmentScannerStartAmPm() {
        return (String)this.aO.get((Object)aw);
    }

    public String getMissingAttachmentScannerEndHour() {
        return (String)this.aO.get((Object)ax);
    }

    public String getMissingAttachmentScannerEndMinute() {
        return (String)this.aO.get((Object)ay);
    }

    public String getMissingAttachmentScannerEndAmPm() {
        return (String)this.aO.get((Object)az);
    }

    public boolean u() {
        return Boolean.parseBoolean((String)this.aO.get((Object)aK));
    }

    public void setIsViolationScanRunning(boolean bl) {
        this.aT.createGlobalSettings().put(aK, (Object)Boolean.toString(bl));
        this.aO.remove((Object)aK);
        a.debug((Object)("Updated isViolationScanRunning [" + bl + "]"));
    }

    public boolean v() {
        return Boolean.parseBoolean((String)this.aO.get((Object)aL));
    }

    public void setIsViolationScanCompleted(boolean bl) {
        this.aT.createGlobalSettings().put(aL, (Object)Boolean.toString(bl));
        this.aO.remove((Object)aL);
        a.debug((Object)("Updated isViolationScanCompleted [" + bl + "]"));
    }

    public Long getViolationScannerLastRun() {
        return (Long)this.aO.get((Object)aJ);
    }

    public void setViolationScannerLastRun(long l) {
        this.aT.createGlobalSettings().put(aJ, (Object)String.valueOf(l));
        this.aO.remove((Object)aJ);
        a.debug((Object)("Updated violationScannerJobLastRun [" + l + "]"));
    }

    public void c(String string, String string2, String string3, String string4, String string5, String string6) {
        PluginSettings pluginSettings = this.aT.createGlobalSettings();
        pluginSettings.put(aD, (Object)string);
        this.aO.remove((Object)aD);
        a.debug((Object)("Updated violationScannerJobStartHour [" + string + "]"));
        pluginSettings.put(aE, (Object)string2);
        this.aO.remove((Object)aE);
        a.debug((Object)("Updated violationScannerJobStartMinute [" + string2 + "]"));
        pluginSettings.put(aF, (Object)string3);
        this.aO.remove((Object)aF);
        a.debug((Object)("Updated violationScannerJobStartAmPm [" + string3 + "]"));
        pluginSettings.put(aG, (Object)string4);
        this.aO.remove((Object)aG);
        a.debug((Object)("Updated violationScannerJobEndHour [" + string4 + "]"));
        pluginSettings.put(aH, (Object)string5);
        this.aO.remove((Object)aH);
        a.debug((Object)("Updated violationScannerJobEndMinute [" + string5 + "]"));
        pluginSettings.put(aI, (Object)string6);
        this.aO.remove((Object)aI);
        a.debug((Object)("Updated violationScannerJobEndAmPm [" + string6 + "]"));
    }

    public String getViolationScannerStartHour() {
        return (String)this.aO.get((Object)aD);
    }

    public String getViolationScannerStartMinute() {
        return (String)this.aO.get((Object)aE);
    }

    public String getViolationScannerStartAmPm() {
        return (String)this.aO.get((Object)aF);
    }

    public String getViolationScannerEndHour() {
        return (String)this.aO.get((Object)aG);
    }

    public String getViolationScannerEndMinute() {
        return (String)this.aO.get((Object)aH);
    }

    public String getViolationScannerEndAmPm() {
        return (String)this.aO.get((Object)aI);
    }

    public String d(String string) {
        String string2;
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        if ((string2 = this.aW.detect(string)).equalsIgnoreCase(e)) {
            if (string.equalsIgnoreCase(".dcm")) {
                string2 = "application/dicom";
            } else if (string.equalsIgnoreCase(".hwp")) {
                string2 = "application/x-hwp-v5";
            } else if (string.equalsIgnoreCase(".xd")) {
                string2 = "application/vnd.adobe.sparkler.project+dcxucf";
            } else if (string.equalsIgnoreCase(".qea")) {
                string2 = "application/x-sqlite3";
            }
        }
        return string2;
    }

    public String getAttachmentLog() {
        return (String)this.aO.get((Object)aM);
    }

    public void setAttachmentLog(String string) {
        this.aT.createGlobalSettings().put(aM, (Object)string);
        this.aO.remove((Object)aM);
        a.debug((Object)("Updated attachment log [" + string + "]"));
    }

    public String getAttachmentLogGroup() {
        return (String)this.aO.get((Object)aN);
    }

    public void setAttachmentLogGroup(String string) {
        this.aT.createGlobalSettings().put(aN, (Object)string);
        this.aO.remove((Object)aN);
        a.debug((Object)("Updated attachment log [" + string + "]"));
    }

    public String a(InputStream inputStream, String string) {
        String string2 = null;
        TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)inputStream);
        Metadata metadata = new Metadata();
        if (string != null && string.matches(".+\\.7z\\.\\d\\d\\d$")) {
            a.debug((Object)"File name matches 7z split files");
            metadata.add("resourceName", string + ".7z");
        } else {
            metadata.add("resourceName", string);
        }
        try {
            string2 = this.aW.detect((InputStream)tikaInputStream, metadata);
            a.debug((Object)("Detected MIME type [" + string2 + "]"));
            string2 = MediaType.parse((String)string2).getBaseType().toString();
            a.debug((Object)("Base MIME type [" + string2 + "]"));
            tikaInputStream.close();
        }
        catch (IOException iOException) {
            a.error((Object)"Error detecting MIME type", (Throwable)iOException);
        }
        return string2;
    }

    public boolean a(String string, boolean bl) {
        boolean bl2;
        a.debug((Object)"*** Checking Extension ***");
        if (string != null) {
            if (bl) {
                bl2 = this.a();
            } else {
                boolean bl3 = bl2 = (string.equals(j) || string.equals(i)) && this.b();
            }
            if (!bl2) {
                String string2 = this.getFilterMode();
                boolean bl4 = string2.equalsIgnoreCase("whitelist");
                Set<String> set = this.getExtensionSet();
                String string3 = string;
                if (string.startsWith(".kal_")) {
                    string3 = ".kal";
                }
                bl2 = this.a(bl4, string3, set);
            }
        } else {
            bl2 = true;
        }
        a.debug((Object)("Is extension [" + string + "] valid? [" + bl2 + "]"));
        return bl2;
    }

    public boolean a(String string, String string2, InputStream inputStream, boolean bl) {
        boolean bl2;
        a.debug((Object)"*** Checking MIME Type ***");
        String string3 = this.getFilterMode();
        a.debug((Object)("Filter mode [" + string3 + "]"));
        a.debug((Object)("MIME type [" + string2 + "]"));
        boolean bl3 = string3.equalsIgnoreCase("whitelist");
        boolean bl4 = AttachmentCheckerHelper.a(string, string2, inputStream);
        if (string2.equals("application/x-tika-ooxml-protected")) {
            String string4 = this.getAllowProtected();
            a.debug((Object)("Allow protected [" + string4 + "]"));
            bl2 = string4.equals("on");
        } else if (bl4) {
            String string5 = this.getAllowEncrypted();
            a.debug((Object)("Allow encrypted [" + string5 + "]"));
            bl2 = string5.equals("on");
        } else if (string2.equals("application/vnd.apple.keynote.13")) {
            a.debug((Object)"Apple keynote file detected");
            bl2 = this.a(bl3, string, ".key");
        } else if (string2.equals("application/vnd.apple.unknown.13")) {
            a.debug((Object)"Apple keynote/numbers/pages file detected");
            bl2 = this.a(bl3, string, ".key", ".numbers", ".pages");
        } else if (string2.equals("application/vnd.ms-spreadsheetml") || string2.equals("application/vnd.ms-wordml")) {
            a.debug((Object)"Office xml file detected");
            bl2 = this.a(bl3, string, ".xml");
        } else if (bl) {
            bl2 = this.a();
        } else if (string != null && string.startsWith(".kal_") && string2.equals(e)) {
            bl2 = true;
        } else {
            boolean bl5 = bl2 = this.e(string, string2) && this.b() || this.a(string, string2, inputStream);
            if (!bl2) {
                Set<String> set = this.getMimeTypeSet();
                bl2 = this.a(bl3, string2, set);
            }
        }
        a.debug((Object)("Is MIME type [" + string2 + "] valid? [" + bl2 + "]"));
        return bl2;
    }

    public boolean c(String string, String string2, String string3) {
        boolean bl = false;
        boolean bl2 = string2 == null;
        a.debug((Object)("Attachment comment [" + string3 + "]"));
        if (string3 != null) {
            if (string3.endsWith("exported to image")) {
                bl = string.equals(".png") && (bl2 || string2.equals("image/png"));
            } else if ("draw.io Draft".equalsIgnoreCase(string3)) {
                bl = string.equals(".tmp") && (bl2 || string2.equals(h));
            } else if ("draw.io diagram".equalsIgnoreCase(string3)) {
                bl = bl2 || string2.equals(h);
            }
        }
        a.debug((Object)("Is draw.io attachment? [" + bl + "]"));
        return bl;
    }

    private boolean a(boolean bl, String string, Set<String> set) {
        return bl && set.contains(string) || !bl && !set.contains(string);
    }

    private boolean a(boolean bl, String string, String ... stringArray) {
        boolean bl2 = false;
        for (String string2 : stringArray) {
            boolean bl3 = bl2 = bl && string2.equals(string) || !bl && !this.getExtensionSet().contains(string2);
            if (bl2) break;
        }
        return bl2;
    }

    private boolean a(String string, String string2, InputStream inputStream) {
        boolean bl = false;
        if (".ics".equals(string) && string2.equals("text/html")) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string3 = bufferedReader.readLine();
                a.debug((Object)("First line [" + string3 + "]"));
                bl = string3.equals("BEGIN:VCALENDAR");
            }
            catch (IOException iOException) {
                a.error((Object)"IOException while trying to read input stream", (Throwable)iOException);
            }
        }
        a.debug((Object)("Is calendar file with html? [" + bl + "]"));
        return bl;
    }

    private boolean e(String string, String string2) {
        boolean bl = false;
        if (string != null) {
            bl = string.equals(j) && string2.equals(h) || string.equals(i) && (string2.equals(e) || string2.equals("text/html"));
        }
        a.debug((Object)("Is Table Spreadsheet Macro attachments? [" + bl + "]"));
        return bl;
    }

    public boolean a(String string, long l, ConfluenceUser confluenceUser) {
        a.debug((Object)("User [" + confluenceUser + "]"));
        FileSizeLimit fileSizeLimit = null;
        if (confluenceUser != null) {
            List<FileSizeGroup> list = this.aP.getFileSizeGroups();
            for (FileSizeGroup fileSizeGroup : list) {
                try {
                    Group group = this.aQ.getGroup(fileSizeGroup.getGroup());
                    if (!this.aQ.hasMembership(group, (User)confluenceUser)) continue;
                    a.debug((Object)("Get file size limit for [" + fileSizeGroup.getGroup() + "]"));
                    fileSizeLimit = this.aP.b(fileSizeGroup.getID(), string);
                    break;
                }
                catch (EntityException entityException) {
                    a.error((Object)entityException.getMessage());
                }
            }
            if (fileSizeLimit == null) {
                a.debug((Object)"Get file size limit for any logged in user");
                fileSizeLimit = this.aP.b(0, string);
            }
        } else {
            a.debug((Object)"Get file size limit for anonymous ");
            fileSizeLimit = this.aP.b(-1, string);
        }
        if (fileSizeLimit != null) {
            long l2 = AttachmentCheckerHelper.a(fileSizeLimit.getSizeLimit(), fileSizeLimit.getSizeUnit());
            a.debug((Object)("Mime type [" + string + "] size limit [" + l2 + "] bytes"));
            a.debug((Object)("File size [" + l + "] bytes"));
            return l > l2;
        }
        return false;
    }

    public Map<String, String> a(@NotNull Space space, long l) {
        long l2;
        a.debug((Object)("Check quota for space [" + space.getKey() + "]"));
        a.debug((Object)("File size [" + l + "]"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SpaceInfo spaceInfo = this.aV.a(space.getKey());
        boolean bl = spaceInfo != null;
        a.debug((Object)("Has SpaceInfo? [" + bl + "]"));
        long l3 = l2 = !bl ? 0L : spaceInfo.getStorageAllocated();
        if (l2 == -1L) {
            long l4 = l2 = space.isPersonal() ? this.getDefaultPersonalQuotaAllocated() : this.getDefaultQuotaAllocated();
        }
        if (!bl || l2 == 0L) {
            a.debug((Object)"Quota allocated is unlimited");
            hashMap.put("isSufficient", Boolean.toString(true));
        } else {
            long l5 = spaceInfo.getStorageUsed();
            long l6 = l2 - l5;
            a.debug((Object)("Quota allocated (bytes) [" + l2 + "]"));
            a.debug((Object)("Quota available (bytes) [" + l6 + "]"));
            hashMap.put("allocated", AttachmentCheckerHelper.a(l2, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("available", AttachmentCheckerHelper.a(l6, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("used", AttachmentCheckerHelper.a(l5, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("isSufficient", String.valueOf(l <= l6));
        }
        return hashMap;
    }

    private class AcConfigCacheLoader
    implements CacheLoader<String, Object> {
        private AcConfigCacheLoader() {
        }

        @Nonnull
        public Object a(@Nonnull String string) {
            Object object;
            String string2 = null;
            try {
                string2 = this.b(string);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            a.debug((Object)("Get value for key [" + string + "]"));
            switch (string) {
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions": {
                    object = this.a(string2, AttachmentCheckerConfig.k);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map": {
                    object = this.d(AttachmentCheckerConfig.u);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set": {
                    object = this.d(AttachmentCheckerConfig.v);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set": {
                    object = this.d(AttachmentCheckerConfig.w);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.filterMode": {
                    object = this.e(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowUsersToViewSpaceQuota": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.showSpaceQuotaTips": {
                    object = this.a(string2, "on");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowDrawIo": {
                    object = this.a(string2, AttachmentCheckerConfig.this.aS.isPluginEnabled("com.mxgraph.confluence.plugins.diagramly") ? "on" : "off");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowEncrypted": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowProtected": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowTableSpreadsheetMacro": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeCheck": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.onAccessScanning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerMode": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.autoDeleteMode": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfInfected": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.deleteIfError": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfError": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCheck": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.trackLargeAttachment": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.loggingMode": {
                    object = this.a(string2, "off");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.largeAttachmentSize": {
                    object = this.a(string2, 0xFA00000L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobLastRun": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobLastRun": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCalculationStartTime": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCalculationEndTime": {
                    object = this.a(string2, 0L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.message": {
                    object = this.a(string2, AttachmentCheckerConfig.m);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeError": {
                    object = this.a(string2, AttachmentCheckerConfig.n);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.enableQuotaCheckAfterSetup": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isJobRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isAttachmentAssignmentJobRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isQuotaSetupCompleted": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanCompleted": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isViolationScanRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isViolationScanCompleted": {
                    object = this.a(string2, Boolean.FALSE.toString());
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.groupToEmail": {
                    object = this.a(string2, "confluence-administrators");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultPersonalQuotaUnit": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerPath": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerOption": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusAlertActor": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanNodeId": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.attachmentAssignmentJobNodeId": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobStartHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobStartMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobStartAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobEndHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobEndMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobEndAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.attachmentLogGroup": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.spaceQuotaTipsText": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.spaceQuotaTipsUrl": {
                    object = this.a(string2, "");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaError": {
                    object = this.a(string2, AttachmentCheckerConfig.o);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultStorage": {
                    object = this.a(string2, 0L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultPersonalQuotaAllocated": {
                    object = this.a(string2, -1L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unit": {
                    object = this.a(string2, AttachmentCheckerConfig.p);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaAlertThreshold": {
                    object = this.c(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaAlertMessage": {
                    object = this.a(string2, AttachmentCheckerConfig.r);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaRecalculationInterval": {
                    object = this.a(string2, "monthly");
                    break;
                }
                default: {
                    object = "This should not happen";
                }
            }
            return object;
        }

        private String b(@NotNull String string) {
            switch (string) {
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set": {
                    return null;
                }
            }
            return AttachmentCheckerConfig.this.aT.createGlobalSettings().get(string).toString();
        }

        @NotNull
        private String a(String string, String string2) {
            if (string == null || string.trim().isEmpty()) {
                string = string2;
            }
            a.debug((Object)("String value [" + string + "]"));
            return string;
        }

        private int c(String string) {
            int n;
            if (string == null || string.isEmpty()) {
                n = 90;
            } else {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 90;
                }
            }
            a.debug((Object)("int value [" + n + "]"));
            return n;
        }

        private Object d(String string) {
            String string2 = (String)AttachmentCheckerConfig.this.aO.get((Object)AttachmentCheckerConfig.t);
            HashMap<String, List> hashMap = new HashMap<String, List>();
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            if (string2 != null && string2.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                while (stringTokenizer.hasMoreElements()) {
                    List list;
                    String string3 = (String)stringTokenizer.nextElement();
                    if (!string3.startsWith(".")) {
                        string3 = ".".concat(string3);
                    }
                    a.debug((Object)("Adding extension [" + string3 + "]"));
                    treeSet.add(string3);
                    String string4 = AttachmentCheckerConfig.this.d(string3);
                    if (string4.equalsIgnoreCase(AttachmentCheckerConfig.f) || string4.equalsIgnoreCase(AttachmentCheckerConfig.g)) {
                        treeSet2.add(AttachmentCheckerConfig.f);
                        treeSet2.add(AttachmentCheckerConfig.g);
                        a.debug((Object)("Adding mime type [application/x-msdownload] for [" + string3 + "]"));
                        a.debug((Object)("Adding mime type [application/x-dosexec] for [" + string3 + "]"));
                        list = AttachmentCheckerConfig.this.d(string3, AttachmentCheckerConfig.g);
                        list.addAll(AttachmentCheckerConfig.this.d(string3, AttachmentCheckerConfig.f));
                    } else {
                        treeSet2.add(string4);
                        a.debug((Object)("Adding mime type [" + string4 + "] for [" + string3 + "]"));
                        list = AttachmentCheckerConfig.this.d(string3, string4);
                    }
                    treeSet.addAll(list);
                    hashMap.put(string3, list);
                }
            }
            if (string.equalsIgnoreCase(AttachmentCheckerConfig.u)) {
                return hashMap;
            }
            if (string.equalsIgnoreCase(AttachmentCheckerConfig.v)) {
                return treeSet;
            }
            return treeSet2;
        }

        private String e(String string) {
            if (string == null || !string.equalsIgnoreCase(AttachmentCheckerConfig.c) && !string.equalsIgnoreCase("whitelist")) {
                string = "whitelist";
            }
            a.debug((Object)("Filter mode [" + string + "]"));
            return string.toLowerCase();
        }

        private Long a(String string, long l) {
            long l2;
            if (string == null || string.isEmpty()) {
                string = String.valueOf(l);
            }
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = l;
            }
            a.debug((Object)("Long value [" + string + "]"));
            return l2;
        }

        @Nonnull
        public /* synthetic */ Object load(@Nonnull Object object) {
            return this.a((String)object);
        }
    }
}

