/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class DateHelper {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.utils.DateHelper");
    private static final int b = 2;
    private static final int c = 0;
    private final FormatSettingsManager d;
    private final I18nResolver e;
    private final LocaleManager f;
    private final TimeZoneManager g;

    public DateHelper(@ComponentImport FormatSettingsManager formatSettingsManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport LocaleManager localeManager, @ComponentImport TimeZoneManager timeZoneManager) {
        this.d = formatSettingsManager;
        this.e = i18nResolver;
        this.f = localeManager;
        this.g = timeZoneManager;
    }

    public static int a(String string, String string2) {
        int n = 2;
        try {
            n = Integer.parseInt(string);
            if ("PM".equalsIgnoreCase(string2) && n != 12 || "AM".equalsIgnoreCase(string2) && n == 12) {
                n += 12;
            }
        }
        catch (NumberFormatException numberFormatException) {
            a.error((Object)("NumberFormatException parsing as int [" + string + "]"), (Throwable)numberFormatException);
        }
        return n;
    }

    public static int a(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            a.error((Object)("NumberFormatException parsing as int [" + string + "]"), (Throwable)numberFormatException);
        }
        return n;
    }

    @NotNull
    public static Date a(String string, String string2, String string3) {
        int n = DateHelper.a(string, string3);
        int n2 = DateHelper.a(string2);
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (calendar.getTime().before(new Date())) {
            calendar.add(5, 1);
        }
        return calendar.getTime();
    }

    @NotNull
    public static Date a(Date date, String string, String string2, String string3) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(13, 0);
        calendar.set(14, 0);
        int n = DateHelper.a(string, string3);
        int n2 = DateHelper.a(string2);
        calendar.set(11, n);
        calendar.set(12, n2);
        if (!calendar.getTime().after(date)) {
            calendar.add(5, 1);
        }
        return calendar.getTime();
    }

    public String a(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8;
        if (!StringUtils.isEmpty((CharSequence)string)) {
            String string9 = string + ":" + ("0".equals(string2) ? "00" : string2) + " " + string3.toUpperCase();
            String string10 = "0".equals(string4) ? string7 : string4 + ":" + ("0".equals(string5) ? "00" : string5) + " " + string6.toUpperCase();
            string8 = this.e.getText("com.akeles.acc.scheduledTime.fromTimeToTime", new Serializable[]{string9, string10});
        } else {
            string8 = this.e.getText("com.akeles.acc.scheduledTime.notScheduled");
        }
        a.debug((Object)("Scheduled time [" + string8 + "]"));
        return string8;
    }

    public String a(Long l, String string) {
        String string2 = l == null || l == 0L ? string : this.a(new Date(l), string);
        a.debug((Object)("Formatted run time [" + string2 + "]"));
        return string2;
    }

    public String a(Date date, String string) {
        if (date == null) {
            return string;
        }
        DateFormatter dateFormatter = new DateFormatter(this.g.getUserTimeZone(), this.d, this.f);
        return dateFormatter.formatDateTime(date);
    }

    public static Date a(Date date) {
        if (date != null) {
            a.debug((Object)("Round date to nearest second [" + date.getTime() + "]"));
            date = DateUtils.round((Date)date, (int)13);
            a.debug((Object)("Updated date [" + date.getTime() + "]"));
        }
        return date;
    }

    @NotNull
    public static Calendar a(long l, int n, int n2, int n3) {
        Date date = new Date(l);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        a.debug((Object)("Last calculation end time [" + calendar.getTime() + "]"));
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        calendar2.add(2, n);
        calendar2.set(11, n2);
        calendar2.set(12, n3);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        a.debug((Object)("Next calculation date [" + calendar2.getTime() + "]"));
        return calendar2;
    }

    public String a(Long l, Long l2, String string) {
        if (l == null || l == 0L || l2 == null || l2 == 0L) {
            return string;
        }
        long l3 = l2 - l;
        if (l3 < 1000L) {
            return l3 + " " + this.e.getText("com.akeles.acc.milliseconds", new Serializable[]{Long.valueOf(l3)});
        }
        String string2 = l3 % 1000L + " " + this.e.getText("com.akeles.acc.milliseconds", new Serializable[]{Long.valueOf(l3)});
        long l4 = TimeUnit.MILLISECONDS.toSeconds(l3);
        if (l4 < 60L) {
            return l4 + " " + this.e.getText("com.akeles.acc.seconds", new Serializable[]{Long.valueOf(l4)}) + ", " + string2;
        }
        String string3 = l4 + " " + this.e.getText("com.akeles.acc.seconds", new Serializable[]{Long.valueOf(l4 %= 60L)}) + ", " + string2;
        l4 = TimeUnit.MILLISECONDS.toMinutes(l3);
        if (l4 < 60L) {
            return l4 + " " + this.e.getText("com.akeles.acc.minutes", new Serializable[]{Long.valueOf(l4)}) + ", " + string3;
        }
        String string4 = l4 + " " + this.e.getText("com.akeles.acc.minutes", new Serializable[]{Long.valueOf(l4 %= 60L)}) + ", " + string3;
        l4 = TimeUnit.MILLISECONDS.toHours(l3);
        if (l4 < 24L) {
            return l4 + " " + this.e.getText("com.akeles.acc.hours", new Serializable[]{Long.valueOf(l4)}) + ", " + string4;
        }
        String string5 = l4 + " " + this.e.getText("com.akeles.acc.hours", new Serializable[]{Long.valueOf(l4 %= 24L)}) + ", " + string4;
        l4 = TimeUnit.MILLISECONDS.toDays(l3);
        return l4 + " " + this.e.getText("com.akeles.acc.days", new Serializable[]{Long.valueOf(l4)}) + ", " + string5;
    }
}

