/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.notification;

import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import java.lang.invoke.SerializedLambda;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MailService {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.notification.MailService");
    private static final String b = "mail";
    private final AttachmentCheckerConfig c;
    private final GroupManager d;
    private final MultiQueueTaskManager e;
    private final PageManager f;
    private final SettingsManager g;
    private final UserAccessor h;

    @Autowired
    public MailService(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport GroupManager groupManager, @ComponentImport MultiQueueTaskManager multiQueueTaskManager, @ComponentImport PageManager pageManager, @ComponentImport SettingsManager settingsManager, @ComponentImport UserAccessor userAccessor) {
        this.c = attachmentCheckerConfig;
        this.d = groupManager;
        this.e = multiQueueTaskManager;
        this.f = pageManager;
        this.g = settingsManager;
        this.h = userAccessor;
    }

    public void a(boolean bl, boolean bl2, int n, String string, String string2, long l, @NotNull Attachment attachment) {
        boolean bl3;
        String string3;
        Group group;
        String string4 = this.c.getGroupToEmail();
        a.debug((Object)("Send email to group [" + string4 + "] regarding attachment [" + string + "]"));
        ConfluenceUser confluenceUser = attachment.getCreator();
        String string5 = confluenceUser == null ? "Anonymous" : confluenceUser.getName();
        String string6 = attachment.getCreationDate().toString();
        a.debug((Object)("Attachment creator [" + string5 + "]"));
        a.debug((Object)("Attachment creation date [" + string6 + "]"));
        try {
            group = this.d.getGroup(string4);
        }
        catch (EntityException entityException) {
            a.error((Object)("Error getting group with group name [" + string4 + "]"), (Throwable)entityException);
            return;
        }
        ContentEntityObject contentEntityObject = this.f.getById(l);
        String string7 = "page id " + l;
        String string8 = "Attachment Checker for Confluence alert";
        if (contentEntityObject != null) {
            string8 = string8 + " for " + contentEntityObject.getType().toLowerCase() + ": " + contentEntityObject.getDisplayTitle();
            string7 = contentEntityObject.getType().toLowerCase() + " <a href=\"" + this.g.getGlobalSettings().getBaseUrl() + contentEntityObject.getUrlPath() + "\">" + contentEntityObject.getDisplayTitle() + "</a>";
        } else {
            a.debug((Object)("ContentEntityObject with id [" + l + "] is null"));
        }
        a.debug((Object)("Email subject [" + string8 + "]"));
        if (bl) {
            string3 = "<p>Attachment Checker has detected an infected file <strong>" + string + "</strong> attached to " + string7 + ".</p>";
            bl3 = this.c.f();
        } else {
            string3 = "<p>Attachment Checker has encountered an error while scanning <strong>" + string + "</strong> attached to " + string7 + ".</p>";
            bl3 = this.c.h();
        }
        string3 = string3 + "<p>Attachment creator: " + string5 + "<br>Attachment creation date: " + string6 + "</p>";
        string3 = string3 + "<p>The error code is <strong>" + n + "</strong>.</p>";
        string3 = bl3 ? (bl2 ? string3 + "<p>The file has been deleted.</p>" : string3 + "<p>An unexpected error occurred while deleting the file.</p>") : string3 + "<p>To scan the file manually, please execute the command:</p><p>" + string2 + "</p>";
        a.debug((Object)("Email body [" + string3 + "]"));
        a.debug((Object)("Getting members of group [" + group + "]"));
        Iterable iterable = this.h.getMembers(group);
        for (ConfluenceUser confluenceUser2 : iterable) {
            a.debug((Object)("Group member [" + confluenceUser2 + "]"));
            String string9 = confluenceUser2.getEmail();
            ConfluenceMailQueueItem confluenceMailQueueItem = new ConfluenceMailQueueItem(string9, string8, string3, "text/html");
            this.e.addTask(b, () -> ((MailQueueItem)confluenceMailQueueItem).send());
            a.debug((Object)("Added mail to queue for user [" + confluenceUser2.getKey() + "] email [" + string9 + "]"));
        }
        a.debug((Object)"Done!");
    }

    private static /* synthetic */ Object a(SerializedLambda serializedLambda) {
        switch (serializedLambda.getImplMethodName()) {
            case "send": {
                if (serializedLambda.getImplMethodKind() != 9 || !serializedLambda.getFunctionalInterfaceClass().equals("com/atlassian/core/task/Task") || !serializedLambda.getFunctionalInterfaceMethodName().equals("execute") || !serializedLambda.getFunctionalInterfaceMethodSignature().equals("()V") || !serializedLambda.getImplClass().equals("com/atlassian/mail/queue/MailQueueItem") || !serializedLambda.getImplMethodSignature().equals("()V")) break;
                return () -> ((MailQueueItem)((MailQueueItem)serializedLambda.getCapturedArg(0))).send();
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

