/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.scheduler.job;

import com.akelesconsulting.confluence.plugins.ao.entity.AttachmentToScan;
import com.akelesconsulting.confluence.plugins.ao.service.AttachmentToScanService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.notification.MailService;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.AttachmentHelper;
import com.akelesconsulting.confluence.plugins.utils.StreamGobbler;
import com.akelesconsulting.confluence.plugins.utils.VirusScanningJobHelper;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class VirusScanningJobRunner
implements JobRunner {
    private static final Logger d = Logger.getLogger((String)"com.akeles.plugins.acc.scheduler.VirusScanningJobRunner");
    public static final JobRunnerKey a = JobRunnerKey.of((String)VirusScanningJobRunner.class.getName());
    public static final JobId b = JobId.of((String)VirusScanningJobRunner.class.getName());
    public static final long c = 60000L;
    private final AccessModeCompatService e;
    private final AttachmentCheckerConfig f;
    private final AttachmentHelper g;
    private final AttachmentToScanService h;
    private final ClusterManager i;
    private final MailService j;
    private final VirusScanningJobHelper k;

    @Inject
    public VirusScanningJobRunner(AccessModeCompatService accessModeCompatService, AttachmentCheckerConfig attachmentCheckerConfig, AttachmentHelper attachmentHelper, AttachmentToScanService attachmentToScanService, @ComponentImport ClusterManager clusterManager, MailService mailService, VirusScanningJobHelper virusScanningJobHelper) {
        this.e = accessModeCompatService;
        this.f = attachmentCheckerConfig;
        this.g = attachmentHelper;
        this.h = attachmentToScanService;
        this.i = clusterManager;
        this.j = mailService;
        this.k = virusScanningJobHelper;
        d.setLevel(Level.INFO);
    }

    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        long l;
        long l2;
        AttachmentToScan[] attachmentToScanArray;
        if (!this.f.d() && !this.f.e()) {
            d.debug((Object)"Missing File Check and Virus Scanning disabled!");
            return JobRunnerResponse.success();
        }
        d.info((Object)"Running scheduled job: VirusScanningJob");
        if (this.e.isReadOnlyAccessModeEnabled()) {
            d.info((Object)"Read-only access mode enabled! Abort virus scanning job!");
            return JobRunnerResponse.aborted((String)"Job aborted because read-only access mode is enabled!");
        }
        String string = null;
        if (this.i.isClustered() && (attachmentToScanArray = this.i.getThisNodeInformation()) != null) {
            string = attachmentToScanArray.getAnonymizedNodeIdentifier();
        }
        d.debug((Object)"Checking queue...");
        attachmentToScanArray = this.a(string);
        long l3 = System.nanoTime();
        if (attachmentToScanArray.length > 0) {
            this.a(attachmentToScanArray);
        }
        if ((l2 = TimeUnit.NANOSECONDS.toMillis(l = System.nanoTime()) - TimeUnit.NANOSECONDS.toMillis(l3)) < 30000L) {
            long l4 = 10000L - l2;
            if (l4 > 0L) {
                try {
                    Thread.sleep(l4);
                }
                catch (InterruptedException interruptedException) {
                    d.error((Object)"Interrupted", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
            }
            d.debug((Object)"Checking queue again...");
            attachmentToScanArray = this.a(string);
            if (attachmentToScanArray.length > 0) {
                this.a(attachmentToScanArray);
            }
        }
        d.info((Object)"End of scheduled job: VirusScanningJob");
        return JobRunnerResponse.success();
    }

    private AttachmentToScan[] a(String string) {
        AttachmentToScan[] attachmentToScanArray;
        if (string == null) {
            attachmentToScanArray = this.h.getAttachmentToScan();
            d.info((Object)("Total AttachmentToScan count [" + this.h.getAttachmentToScanCount() + "]"));
            d.info((Object)("Retrieved AttachmentToScan count [" + attachmentToScanArray.length + "]"));
        } else {
            attachmentToScanArray = this.h.b(string);
            d.info((Object)("[" + string + "] Total AttachmentToScan count [" + this.h.a(string) + "]"));
            d.info((Object)("[" + string + "] Retrieved AttachmentToScan count [" + attachmentToScanArray.length + "]"));
        }
        return attachmentToScanArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(AttachmentToScan[] attachmentToScanArray) {
        boolean bl = this.f.d();
        boolean bl2 = this.f.e();
        String string = this.f.getScannerPath();
        String string2 = this.f.getScannerOption();
        boolean bl3 = this.f.f();
        boolean bl4 = this.f.h();
        for (AttachmentToScan attachmentToScan : attachmentToScanArray) {
            long l = attachmentToScan.getAttachmentId();
            int n = attachmentToScan.getVersion();
            long l2 = attachmentToScan.getAttachedToId();
            Date date = attachmentToScan.getCreationDate();
            d.info((Object)("Attachment id [" + l + "] version [" + n + "] attached to id [" + l2 + "] with entity id [" + attachmentToScan.getID() + "]"));
            Attachment attachment = this.g.a(l, n, date);
            d.debug((Object)("Retrieved attachment [" + attachment + "]"));
            if (attachment != null) {
                File file;
                block6: {
                    d.debug((Object)"Retrieved attachment is not null!");
                    String string3 = attachment.getFileName();
                    file = null;
                    try {
                        file = this.k.a(attachment);
                        if (!bl2) break block6;
                        this.a(attachment, attachmentToScan, file, string, string2, bl3, bl4);
                    }
                    catch (NullPointerException nullPointerException) {
                        block7: {
                            try {
                                d.error((Object)"NPE while getting attachment data", (Throwable)nullPointerException);
                                if (!bl) break block7;
                                boolean bl5 = this.g.a(bl3, l, n, date);
                                String string4 = this.k.a(string3, attachment.getCreator(), true, bl3, bl4, this.f.i(), bl5);
                                this.k.a(string4, l2, this.f.getVirusAlertActorUser());
                            }
                            catch (Throwable throwable) {
                                AttachmentCheckerHelper.a(file);
                                throw throwable;
                            }
                        }
                        AttachmentCheckerHelper.a(file);
                    }
                }
                AttachmentCheckerHelper.a(file);
            }
            this.h.a(attachmentToScan);
            if (!this.e.isReadOnlyAccessModeEnabled()) continue;
            d.info((Object)"Read-only access mode enabled! Stopping job!");
            break;
        }
    }

    private void a(@NotNull Attachment attachment, AttachmentToScan attachmentToScan, File file, String string, String string2, boolean bl, boolean bl2) {
        String string3 = attachment.getFileName();
        if (file == null) {
            d.debug((Object)"Temp file is null!");
            return;
        }
        d.info((Object)("Scanning [" + string3 + "]"));
        ConfluenceUser confluenceUser = attachment.getCreator();
        long l = attachment.getId();
        try {
            String string4 = file.getCanonicalPath();
            Object[] objectArray = this.a(string, string2, string4, attachment);
            d.info((Object)("Executing [" + Arrays.toString(objectArray) + "]"));
            Process process = Runtime.getRuntime().exec((String[])objectArray);
            StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), "OUTPUT", true);
            StreamGobbler streamGobbler2 = new StreamGobbler(process.getErrorStream(), "ERROR", true);
            streamGobbler.start();
            streamGobbler2.start();
            int n = process.waitFor();
            d.info((Object)("Exit status code [" + n + "]"));
            if (attachment.getCreationDate() == null) {
                d.debug((Object)"Attachment creation date is null!");
                String string5 = this.k.a(string3, attachmentToScan.getVersion(), confluenceUser);
                this.k.a(string5, attachmentToScan.getAttachedToId(), this.f.getVirusAlertActorUser());
            }
            if (n != 0) {
                String string6;
                boolean bl3;
                boolean bl4;
                boolean bl5 = this.f.a(n, string);
                if (bl5) {
                    d.debug((Object)("Infected attachment [" + string3 + "] id [" + l + "] found"));
                    bl4 = this.f.f();
                    bl3 = this.f.g();
                    d.debug((Object)("Delete if infected? [" + bl4 + "]"));
                    d.debug((Object)("Email if infected? [" + bl3 + "]"));
                } else {
                    d.debug((Object)"Exit code is not virus code!");
                    bl4 = this.f.h();
                    bl3 = this.f.i();
                    d.debug((Object)("Delete if error? [" + bl4 + "]"));
                    d.debug((Object)("Email if error? [" + bl3 + "]"));
                }
                boolean bl6 = this.g.a(bl4, attachmentToScan.getAttachmentId(), attachmentToScan.getVersion(), attachmentToScan.getCreationDate());
                if (bl3) {
                    string6 = this.a(string, string2, attachment, attachmentToScan);
                    d.debug((Object)("Manual scan command [" + string6 + "]"));
                    this.j.a(bl5, bl6, n, string3, string6, attachmentToScan.getAttachedToId(), attachment);
                }
                string6 = this.k.a(string3, confluenceUser, bl5, bl, bl2, bl3, bl6);
                this.k.a(string6, attachmentToScan.getAttachedToId(), this.f.getVirusAlertActorUser());
            }
        }
        catch (IOException iOException) {
            d.error((Object)"Error executing process", (Throwable)iOException);
        }
        catch (InterruptedException interruptedException) {
            d.error((Object)"Process interrupted", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
    }

    private String[] a(String string, String string2, String string3, Attachment attachment) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        if (!string2.equals("")) {
            string2 = this.a(string2, attachment);
            String[] stringArray = string2.split(" ");
            arrayList.addAll(Arrays.asList(stringArray));
        }
        arrayList.add(string3);
        return arrayList.toArray(new String[0]);
    }

    @NotNull
    private String a(String string, @NotNull String string2, @NotNull Attachment attachment, @NotNull AttachmentToScan attachmentToScan) {
        d.debug((Object)"Get manual scan command");
        long l = attachmentToScan.getAttachedToId();
        long l2 = attachmentToScan.getAttachmentId();
        int n = attachment.getVersion();
        String string3 = this.g.a(attachment, l2, n, l);
        return string + " " + (string2.isEmpty() ? "" : this.a(string2, attachment) + " ") + string3;
    }

    @NotNull
    private String a(@NotNull String string, @NotNull Attachment attachment) {
        string = string.replace("${attachment.id}", attachment.getIdAsString());
        ConfluenceUser confluenceUser = attachment.getCreator();
        string = string.replace("${attachment.creator.name}", confluenceUser == null ? "Anonymous" : confluenceUser.getName());
        return string;
    }
}

