/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.config.xwork;

import com.akelesconsulting.confluence.plugins.ao.service.AttachmentToScanService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.scheduler.JobScheduler;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.LicenseHelper;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.xwork.ParameterSafe;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConfigManager
extends ConfluenceActionSupport {
    private static final Logger logger = Logger.getLogger((String)"com.akeles.plugins.acc.config.ConfigManager");
    private static final String ERROR_MESSAGE_I18N_KEY = "com.akeles.acc.config.common.errorMessage";
    private transient AccessModeCompatService accessModeCompatService;
    private transient AttachmentCheckerConfig attachmentCheckerConfig;
    private transient AttachmentToScanService attachmentToScanService;
    private transient JobScheduler jobScheduler;
    private transient LicenseHelper licenseHelper;
    private transient TransactionTemplate transactionTemplate;
    private String filterMode;
    private String extensions;
    private Map<String, List<String>> extensionsMap;
    private String allowProtected;
    private String allowEncrypted;
    private String allowDrawIo;
    private String allowTableSpreadsheetMacro;
    private String errorMessage;
    private String fileSizeCheck;
    private String fileSizeErrorMessage;
    private String missingFileCheck;
    private String virusScanning;
    private String scannerPath;
    private String scannerOption;
    private String scannerDetected;
    private String deleteIfInfected;
    private String emailIfInfected;
    private String deleteIfError;
    private String emailIfError;
    private String groupToEmail;
    private String virusAlertActor;
    private String quotaCheck;
    private String defaultQuotaAllocated;
    private String defaultQuotaUnit;
    private boolean isDefaultQuotaUnlimited;
    private String quotaCheckErrorMessage;
    private boolean isSetupComplete;
    private int quotaAlertThreshold;
    private String quotaAlertMessage;
    private String allowUsersToViewSpaceQuota;
    private String showSpaceQuotaTips;
    private String spaceQuotaTipsText;
    private String spaceQuotaTipsUrl;
    private String loggingMode;
    private String attachmentLogGroup;

    public void setAccessModeCompatService(AccessModeCompatService accessModeCompatService) {
        this.accessModeCompatService = accessModeCompatService;
    }

    public void setAttachmentCheckerConfig(AttachmentCheckerConfig attachmentCheckerConfig) {
        this.attachmentCheckerConfig = attachmentCheckerConfig;
    }

    public void setAttachmentToScanService(AttachmentToScanService attachmentToScanService) {
        this.attachmentToScanService = attachmentToScanService;
    }

    public void setLicenseHelper(LicenseHelper licenseHelper) {
        this.licenseHelper = licenseHelper;
    }

    public void setJobScheduler(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    public void setTransactionTemplate(@ComponentImport TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public String getFilterMode() {
        return this.filterMode;
    }

    @ParameterSafe
    public void setFilterMode(String string) {
        this.filterMode = string;
    }

    public String getExtensions() {
        return this.extensions;
    }

    @ParameterSafe
    public void setExtensions(String string) {
        this.extensions = string;
    }

    public Map<String, List<String>> getExtensionsMap() {
        return this.extensionsMap;
    }

    public String getAllowProtected() {
        return this.allowProtected;
    }

    @ParameterSafe
    public void setAllowProtected(String string) {
        this.allowProtected = string;
    }

    public String getAllowEncrypted() {
        return this.allowEncrypted;
    }

    @ParameterSafe
    public void setAllowEncrypted(String string) {
        this.allowEncrypted = string;
    }

    public String getAllowDrawIo() {
        return this.allowDrawIo;
    }

    @ParameterSafe
    public void setAllowDrawIo(String string) {
        this.allowDrawIo = string;
    }

    public String getAllowTableSpreadsheetMacro() {
        return this.allowTableSpreadsheetMacro;
    }

    @ParameterSafe
    public void setAllowTableSpreadsheetMacro(String string) {
        this.allowTableSpreadsheetMacro = string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @ParameterSafe
    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getFileSizeCheck() {
        return this.fileSizeCheck;
    }

    @ParameterSafe
    public void setFileSizeCheck(String string) {
        this.fileSizeCheck = string;
    }

    public String getFileSizeErrorMessage() {
        return this.fileSizeErrorMessage;
    }

    @ParameterSafe
    public void setFileSizeErrorMessage(String string) {
        this.fileSizeErrorMessage = string;
    }

    public String getMissingFileCheck() {
        return this.missingFileCheck;
    }

    @ParameterSafe
    public void setMissingFileCheck(String string) {
        this.missingFileCheck = string;
    }

    public String getVirusScanning() {
        return this.virusScanning;
    }

    @ParameterSafe
    public void setVirusScanning(String string) {
        this.virusScanning = string;
    }

    public String getScannerPath() {
        return this.scannerPath;
    }

    @ParameterSafe
    public void setScannerPath(String string) {
        this.scannerPath = string;
    }

    public String getScannerOption() {
        return this.scannerOption;
    }

    @ParameterSafe
    public void setScannerOption(String string) {
        this.scannerOption = string;
    }

    public String getScannerDetected() {
        return this.scannerDetected;
    }

    public String getDeleteIfInfected() {
        return this.deleteIfInfected;
    }

    @ParameterSafe
    public void setDeleteIfInfected(String string) {
        this.deleteIfInfected = string;
    }

    public String getEmailIfInfected() {
        return this.emailIfInfected;
    }

    @ParameterSafe
    public void setEmailIfInfected(String string) {
        this.emailIfInfected = string;
    }

    public String getDeleteIfError() {
        return this.deleteIfError;
    }

    @ParameterSafe
    public void setDeleteIfError(String string) {
        this.deleteIfError = string;
    }

    public String getEmailIfError() {
        return this.emailIfError;
    }

    @ParameterSafe
    public void setEmailIfError(String string) {
        this.emailIfError = string;
    }

    public String getGroupToEmail() {
        return this.groupToEmail;
    }

    @ParameterSafe
    public void setGroupToEmail(String string) {
        this.groupToEmail = string;
    }

    public String getVirusAlertActor() {
        return this.virusAlertActor;
    }

    @ParameterSafe
    public void setVirusAlertActor(String string) {
        this.virusAlertActor = string;
    }

    public String getQuotaCheck() {
        return this.quotaCheck;
    }

    @ParameterSafe
    public void setQuotaCheck(String string) {
        this.quotaCheck = string;
    }

    public String getDefaultQuotaAllocated() {
        return this.defaultQuotaAllocated;
    }

    @ParameterSafe
    public void setDefaultQuotaAllocated(String string) {
        this.defaultQuotaAllocated = string;
    }

    public String getDefaultQuotaUnit() {
        return this.defaultQuotaUnit;
    }

    @ParameterSafe
    public void setDefaultQuotaUnit(String string) {
        this.defaultQuotaUnit = string;
    }

    public boolean getIsDefaultQuotaUnlimited() {
        return this.isDefaultQuotaUnlimited;
    }

    public String getQuotaCheckErrorMessage() {
        return this.quotaCheckErrorMessage;
    }

    @ParameterSafe
    public void setQuotaCheckErrorMessage(String string) {
        this.quotaCheckErrorMessage = string;
    }

    public int getQuotaAlertThreshold() {
        return this.quotaAlertThreshold;
    }

    @ParameterSafe
    public void setQuotaAlertThreshold(int n) {
        this.quotaAlertThreshold = n;
    }

    public String getQuotaAlertMessage() {
        return this.quotaAlertMessage;
    }

    @ParameterSafe
    public void setQuotaAlertMessage(String string) {
        this.quotaAlertMessage = string;
    }

    public String getAllowUsersToViewSpaceQuota() {
        return this.allowUsersToViewSpaceQuota;
    }

    @ParameterSafe
    public void setAllowUsersToViewSpaceQuota(String string) {
        this.allowUsersToViewSpaceQuota = string;
    }

    public String getShowSpaceQuotaTips() {
        return this.showSpaceQuotaTips;
    }

    @ParameterSafe
    public void setShowSpaceQuotaTips(String string) {
        this.showSpaceQuotaTips = string;
    }

    public String getSpaceQuotaTipsText() {
        return this.spaceQuotaTipsText;
    }

    @ParameterSafe
    public void setSpaceQuotaTipsText(String string) {
        this.spaceQuotaTipsText = string;
    }

    public String getSpaceQuotaTipsUrl() {
        return this.spaceQuotaTipsUrl;
    }

    @ParameterSafe
    public void setSpaceQuotaTipsUrl(String string) {
        this.spaceQuotaTipsUrl = string;
    }

    public boolean getIsSetupComplete() {
        return this.isSetupComplete;
    }

    public boolean getIsReadOnlyAccessModeEnabled() {
        return this.accessModeCompatService.isReadOnlyAccessModeEnabled();
    }

    public String getLoggingMode() {
        return this.loggingMode;
    }

    @ParameterSafe
    public void setLoggingMode(String string) {
        this.loggingMode = string;
    }

    public String getAttachmentLogGroup() {
        return this.attachmentLogGroup;
    }

    @ParameterSafe
    public void setAttachmentLogGroup(String string) {
        this.attachmentLogGroup = string;
    }

    public String execute() {
        logger.debug((Object)"Accessing attachment checker configuration...");
        logger.debug((Object)"Validating license...");
        if (!this.licenseHelper.b()) {
            logger.debug((Object)"No valid license found for Attachment Checker for Confluence.");
            return "unlicensed";
        }
        logger.debug((Object)"Valid!");
        this.loadFileTypeBlockingSettings();
        this.loadFileSizeCheckingSettings();
        this.loadVirusScanningSettings();
        this.loadQuotaCheckingSettings();
        this.loadAttachmentLogSettings();
        return "success";
    }

    private void loadFileTypeBlockingSettings() {
        this.filterMode = this.attachmentCheckerConfig.getFilterMode();
        logger.debug((Object)("Filter mode [" + this.filterMode + "]"));
        this.extensions = this.attachmentCheckerConfig.getExtensions();
        logger.debug((Object)("Extensions [" + this.extensions + "]"));
        this.allowProtected = this.attachmentCheckerConfig.getAllowProtected();
        logger.debug((Object)("Allow protected [" + this.allowProtected + "]"));
        this.allowEncrypted = this.attachmentCheckerConfig.getAllowEncrypted();
        logger.debug((Object)("Allow encrypted [" + this.allowEncrypted + "]"));
        this.allowDrawIo = this.attachmentCheckerConfig.getAllowDrawIo();
        logger.debug((Object)("Allow draw.io? [" + this.allowDrawIo + "]"));
        this.allowTableSpreadsheetMacro = this.attachmentCheckerConfig.getAllowTableSpreadsheetMacro();
        logger.debug((Object)("Allow Table Spreadsheet Macro attachments? [" + this.allowTableSpreadsheetMacro + "]"));
        this.errorMessage = this.attachmentCheckerConfig.getFileTypeErrorMessage();
        logger.debug((Object)("Error message [" + this.errorMessage + "]"));
        this.extensionsMap = this.attachmentCheckerConfig.getExtensionsMap();
    }

    private void loadFileSizeCheckingSettings() {
        this.fileSizeCheck = this.attachmentCheckerConfig.getFileSizeCheck();
        logger.debug((Object)("File size check [" + this.fileSizeCheck + "]"));
        this.fileSizeErrorMessage = this.attachmentCheckerConfig.getFileSizeErrorMessage();
        logger.debug((Object)("File size error message [" + this.fileSizeErrorMessage + "]"));
    }

    private void loadVirusScanningSettings() {
        this.missingFileCheck = this.attachmentCheckerConfig.getMissingFileCheck();
        logger.debug((Object)("Missing file check [" + this.missingFileCheck + "]"));
        this.virusScanning = this.attachmentCheckerConfig.getVirusScanning();
        logger.debug((Object)("Virus scanning [" + this.virusScanning + "]"));
        this.scannerPath = this.attachmentCheckerConfig.getScannerPath();
        logger.debug((Object)("Scanner path [" + this.scannerPath + "]"));
        this.scannerOption = this.attachmentCheckerConfig.getScannerOption();
        logger.debug((Object)("Scanner option [" + this.scannerOption + "]"));
        this.scannerDetected = this.attachmentCheckerConfig.getScannerDetected();
        logger.debug((Object)("Scanner detected [" + this.scannerDetected + "]"));
        this.deleteIfInfected = this.attachmentCheckerConfig.getDeleteIfInfected();
        this.emailIfInfected = this.attachmentCheckerConfig.getEmailIfInfected();
        logger.debug((Object)("Delete if infected? [" + this.deleteIfInfected + "]"));
        logger.debug((Object)("Email if infected? [" + this.emailIfInfected + "]"));
        this.deleteIfError = this.attachmentCheckerConfig.getDeleteIfError();
        this.emailIfError = this.attachmentCheckerConfig.getEmailIfError();
        logger.debug((Object)("Delete if error? [" + this.deleteIfError + "]"));
        logger.debug((Object)("Email if error? [" + this.emailIfError + "]"));
        this.groupToEmail = this.attachmentCheckerConfig.getGroupToEmail();
        logger.debug((Object)("Group to email (Confluence Sysadmin Group) [" + this.groupToEmail + "]"));
        ConfluenceUser confluenceUser = this.attachmentCheckerConfig.getVirusAlertActorUser();
        logger.debug((Object)("Virus alert actor [" + confluenceUser + "]"));
        if (confluenceUser != null) {
            this.virusAlertActor = confluenceUser.getName();
        }
    }

    private void loadQuotaCheckingSettings() {
        this.quotaCheck = this.attachmentCheckerConfig.getQuotaCheck();
        logger.debug((Object)("Quota check [" + this.quotaCheck + "]"));
        this.defaultQuotaUnit = this.attachmentCheckerConfig.getUnit();
        this.isDefaultQuotaUnlimited = this.attachmentCheckerConfig.l();
        if (this.isDefaultQuotaUnlimited) {
            this.defaultQuotaAllocated = "Unlimited";
        } else {
            long l = this.attachmentCheckerConfig.getDefaultQuotaAllocated();
            this.defaultQuotaAllocated = AttachmentCheckerHelper.a(l, this.defaultQuotaUnit, 2);
        }
        logger.debug((Object)("Default quota allocated [" + this.defaultQuotaAllocated + "] " + this.defaultQuotaUnit));
        this.quotaCheckErrorMessage = this.attachmentCheckerConfig.getQuotaErrorMessage();
        logger.debug((Object)("Quota check error message [" + this.quotaCheckErrorMessage + "]"));
        this.quotaAlertThreshold = this.attachmentCheckerConfig.getQuotaAlertThreshold();
        logger.debug((Object)("Quota alert threshold [" + this.quotaAlertThreshold + "]"));
        this.quotaAlertMessage = this.attachmentCheckerConfig.getQuotaAlertMessage();
        logger.debug((Object)("Quota alert message [" + this.quotaAlertMessage + "]"));
        this.allowUsersToViewSpaceQuota = this.attachmentCheckerConfig.getAllowUsersToViewSpaceQuota();
        logger.debug((Object)("Allow users to view space quota? [" + this.allowUsersToViewSpaceQuota + "]"));
        this.showSpaceQuotaTips = this.attachmentCheckerConfig.getShowSpaceQuotaTips();
        logger.debug((Object)("Show space quota tips? [" + this.showSpaceQuotaTips + "]"));
        this.spaceQuotaTipsText = this.attachmentCheckerConfig.getSpaceQuotaTipsText();
        logger.debug((Object)("Space quota tips text [" + this.spaceQuotaTipsText + "]"));
        this.spaceQuotaTipsUrl = this.attachmentCheckerConfig.getSpaceQuotaTipsUrl();
        logger.debug((Object)("Space quota tips URL [" + this.spaceQuotaTipsUrl + "]"));
        this.isSetupComplete = this.attachmentCheckerConfig.q();
    }

    private void loadAttachmentLogSettings() {
        this.loggingMode = this.attachmentCheckerConfig.getAttachmentLog();
        logger.debug((Object)("Attachment logging mode [" + this.loggingMode + "]"));
        this.attachmentLogGroup = this.attachmentCheckerConfig.getAttachmentLogGroup();
        logger.debug((Object)("Attachment logging group [ " + this.attachmentLogGroup + " ]"));
    }

    public void validate() {
        super.validate();
        if (this.filterMode != null) {
            this.validateFileTypeBlockingSettings();
        } else if (this.fileSizeErrorMessage != null) {
            this.validateFileSizeCheckingSettings();
        } else if (this.scannerPath != null) {
            this.validateVirusCheckingSettings();
        } else if (this.defaultQuotaAllocated != null) {
            this.validateQuotaCheckingSettings();
        }
        this.validateAttachmentLogSettings();
    }

    private void validateFileTypeBlockingSettings() {
        logger.debug((Object)"Validating file type blocking settings...");
        if (!AttachmentCheckerHelper.b(this.extensions)) {
            this.extensions = AttachmentCheckerHelper.c(this.extensions);
        }
        if (this.allowProtected == null) {
            this.allowProtected = "off";
        }
        if (this.allowEncrypted == null) {
            this.allowEncrypted = "off";
        }
        if (this.allowDrawIo == null) {
            this.allowDrawIo = "off";
        }
        if (this.allowTableSpreadsheetMacro == null) {
            this.allowTableSpreadsheetMacro = "off";
        }
        if (AttachmentCheckerHelper.b(this.errorMessage)) {
            this.addFieldError("errorMessageError", this.getText("com.akeles.acc.config.error.isRequired", new String[]{this.getText(ERROR_MESSAGE_I18N_KEY)}));
        }
    }

    private void validateFileSizeCheckingSettings() {
        logger.debug((Object)"Validating file size checking settings...");
        if (this.fileSizeCheck == null) {
            this.fileSizeCheck = "off";
        }
        if (AttachmentCheckerHelper.b(this.fileSizeErrorMessage)) {
            this.addFieldError("fileSizeErrorMessageError", this.getText("com.akeles.acc.config.error.isRequired", new String[]{this.getText(ERROR_MESSAGE_I18N_KEY)}));
        }
    }

    private void validateVirusCheckingSettings() {
        logger.debug((Object)"Validating virus scanning settings...");
        if (this.missingFileCheck == null) {
            this.missingFileCheck = "off";
        }
        if (this.virusScanning == null) {
            this.virusScanning = "off";
        } else {
            String string = "scannerPathError";
            if (AttachmentCheckerHelper.b(this.scannerPath)) {
                this.addFieldError("scannerPathError", this.getText("com.akeles.acc.config.virusScanning.scannerFullPath.error.empty"));
            } else {
                File file = new File(this.scannerPath);
                if (!file.exists()) {
                    logger.debug((Object)("Unable to find file at " + this.scannerPath));
                    this.addFieldError("scannerPathError", this.getText("com.akeles.acc.config.virusScanning.scannerFullPath.error.notFound", new String[]{this.scannerPath}));
                } else if (!file.canExecute()) {
                    logger.debug((Object)("Unable to execute file at " + this.scannerPath));
                    this.addFieldError("scannerPathError", this.getText("com.akeles.acc.config.virusScanning.scannerFullPath.error.notExecutable", new String[]{this.scannerPath}));
                }
            }
        }
        if (this.deleteIfInfected == null) {
            this.deleteIfInfected = "off";
        }
        if (this.emailIfInfected == null) {
            this.emailIfInfected = "off";
        }
        if (this.deleteIfError == null) {
            this.deleteIfError = "off";
        }
        if (this.emailIfError == null) {
            this.emailIfError = "off";
        }
    }

    private void validateQuotaCheckingSettings() {
        logger.debug((Object)"Validating quota checking settings...");
        if (!AttachmentCheckerHelper.b(this.defaultQuotaAllocated)) {
            this.defaultQuotaAllocated = AttachmentCheckerHelper.d(this.defaultQuotaAllocated);
            if (this.defaultQuotaUnit == null) {
                this.defaultQuotaUnit = this.attachmentCheckerConfig.getUnit();
            }
            this.defaultQuotaAllocated = AttachmentCheckerHelper.a(this.defaultQuotaAllocated, this.defaultQuotaUnit);
        }
        this.isSetupComplete = this.attachmentCheckerConfig.q();
        if (!this.attachmentCheckerConfig.k() && !this.isSetupComplete && "on".equalsIgnoreCase(this.quotaCheck)) {
            this.addFieldError("quotaCheckError", this.getText("com.akeles.acc.config.quotaChecking.quotaCheck.error.incompleteSetup"));
        } else if (this.quotaCheck == null) {
            this.quotaCheck = "off";
        }
        if (AttachmentCheckerHelper.b(this.quotaCheckErrorMessage)) {
            this.addFieldError("quotaCheckErrorMessageError", this.getText("com.akeles.acc.config.error.isRequired", new String[]{this.getText(ERROR_MESSAGE_I18N_KEY)}));
        }
        if (this.quotaAlertThreshold < 0) {
            this.addFieldError("quotaAlertThresholdError", this.getText("com.akeles.acc.quota.error.invalid"));
        }
        if (this.quotaAlertThreshold > 0 && AttachmentCheckerHelper.b(this.quotaAlertMessage)) {
            this.addFieldError("quotaAlertMessageError", this.getText("com.akeles.acc.config.error.isRequired", new String[]{this.getText("com.akeles.acc.config.quotaChecking.alertMessage")}));
        }
        if (this.allowUsersToViewSpaceQuota == null) {
            this.allowUsersToViewSpaceQuota = "off";
        }
        if (this.showSpaceQuotaTips == null) {
            this.showSpaceQuotaTips = "off";
        }
        this.spaceQuotaTipsText = this.spaceQuotaTipsText.trim();
        this.spaceQuotaTipsUrl = this.spaceQuotaTipsUrl.trim();
        if (this.spaceQuotaTipsUrl.length() > 0) {
            try {
                new URL(this.spaceQuotaTipsUrl).toURI();
            }
            catch (MalformedURLException | URISyntaxException exception) {
                this.addFieldError("spaceQuotaTipsUrlError", this.getText("com.akeles.acc.config.error.invalidUrl"));
            }
        }
    }

    private void validateAttachmentLogSettings() {
        logger.debug((Object)"Validating attachment log settings...");
        logger.debug((Object)("loggingMode: " + this.loggingMode));
        if (this.loggingMode == null) {
            this.loggingMode = "off";
        }
    }

    @ReadOnlyAccessBlocked
    public String doUpdate() {
        if (this.filterMode != null) {
            this.saveFileTypeBlockingSettings();
        } else if (this.fileSizeCheck != null) {
            this.saveFileSizeCheckingSettings();
        } else if (this.scannerPath != null) {
            this.saveVirusScanningSettings();
        } else if (this.defaultQuotaAllocated != null) {
            this.saveQuotaCheckingSettings();
        } else if (this.loggingMode != null) {
            this.saveAttachmentLogSettings();
        }
        return "success";
    }

    private void saveFileTypeBlockingSettings() {
        logger.debug((Object)("Filter mode [" + this.filterMode + "]"));
        logger.debug((Object)("Extensions [" + this.extensions + "]"));
        logger.debug((Object)("Allow protected [" + this.allowProtected + "]"));
        logger.debug((Object)("Allow encrypted [" + this.allowEncrypted + "]"));
        logger.debug((Object)("Allow draw.io? [" + this.allowDrawIo + "]"));
        logger.debug((Object)("Allow Table Spreadsheet Macro attachments? [" + this.allowTableSpreadsheetMacro + "]"));
        logger.debug((Object)("Error message [" + this.errorMessage + "]"));
        logger.debug((Object)"Saving file type blocking settings...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.a(this.filterMode, this.extensions, this.errorMessage);
            this.attachmentCheckerConfig.a(this.allowProtected, this.allowEncrypted, this.allowDrawIo, this.allowTableSpreadsheetMacro);
            return null;
        });
    }

    private void saveFileSizeCheckingSettings() {
        logger.debug((Object)("File size check [" + this.fileSizeCheck + "]"));
        logger.debug((Object)("File size error message [" + this.fileSizeErrorMessage + "]"));
        logger.debug((Object)"Saving file size checking settings...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.setFileSizeCheck(this.fileSizeCheck);
            this.attachmentCheckerConfig.setFileSizeErrorMessage(this.fileSizeErrorMessage);
            return null;
        });
    }

    private void saveVirusScanningSettings() {
        logger.debug((Object)("Missing file check [" + this.missingFileCheck + "]"));
        logger.debug((Object)("Virus scanning [" + this.virusScanning + "]"));
        logger.debug((Object)("Scanner path [" + this.scannerPath + "]"));
        logger.debug((Object)("Scanner option [" + this.scannerOption + "]"));
        logger.debug((Object)("Delete if infected? [" + this.deleteIfInfected + "]"));
        logger.debug((Object)("Email if infected? [" + this.emailIfInfected + "]"));
        logger.debug((Object)("Delete if error? [" + this.deleteIfError + "]"));
        logger.debug((Object)("Email if error? [" + this.emailIfError + "]"));
        logger.debug((Object)("Group to email (Confluence Sysadmin Group) [" + this.groupToEmail + "]"));
        String string = this.getUserKey(this.virusAlertActor);
        logger.debug((Object)("Virus alert actor user key [" + string + "]"));
        logger.debug((Object)"Saving virus scanning settings...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.setMissingFileCheck(this.missingFileCheck);
            this.attachmentCheckerConfig.setVirusScanning(this.virusScanning);
            this.attachmentCheckerConfig.a(this.scannerPath, this.scannerOption);
            this.attachmentCheckerConfig.b(this.deleteIfInfected, this.emailIfInfected, this.deleteIfError, this.emailIfError);
            this.attachmentCheckerConfig.setGroupToEmail(this.groupToEmail);
            this.attachmentCheckerConfig.setVirusAlertActor(string);
            return null;
        });
        if (this.virusScanning.equalsIgnoreCase("off") && this.missingFileCheck.equalsIgnoreCase("off")) {
            this.jobScheduler.c();
            this.attachmentToScanService.a();
        } else {
            this.jobScheduler.a();
        }
    }

    private void saveQuotaCheckingSettings() {
        logger.debug((Object)("Quota check [" + this.quotaCheck + "]"));
        logger.debug((Object)("Quota check error message [" + this.quotaCheckErrorMessage + "]"));
        logger.debug((Object)("Default quota allocated [" + this.defaultQuotaAllocated + "] bytes"));
        logger.debug((Object)("Default quota unit [" + this.defaultQuotaUnit + "]"));
        logger.debug((Object)("Quota alert threshold [" + this.quotaAlertThreshold + "]"));
        logger.debug((Object)("Quota alert message [" + this.quotaAlertMessage + "]"));
        logger.debug((Object)("Allow users to view space quota? [" + this.allowUsersToViewSpaceQuota + "]"));
        logger.debug((Object)("Show space quota tips? [" + this.showSpaceQuotaTips + "]"));
        logger.debug((Object)("Space quota tips text [" + this.spaceQuotaTipsText + "]"));
        logger.debug((Object)("Space quota tips URL [" + this.spaceQuotaTipsUrl + "]"));
        logger.debug((Object)"Saving quota checking settings...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.setQuotaCheck(this.quotaCheck);
            this.attachmentCheckerConfig.b(this.defaultQuotaAllocated, this.defaultQuotaUnit);
            this.attachmentCheckerConfig.setQuotaErrorMessage(this.quotaCheckErrorMessage);
            this.attachmentCheckerConfig.b(this.quotaAlertThreshold, this.quotaAlertMessage);
            this.attachmentCheckerConfig.setQuotaPermissions(this.allowUsersToViewSpaceQuota);
            this.attachmentCheckerConfig.b(this.showSpaceQuotaTips, this.spaceQuotaTipsText, this.spaceQuotaTipsUrl);
            return null;
        });
    }

    private void saveAttachmentLogSettings() {
        logger.debug((Object)("Logging Mode [" + this.loggingMode + "]"));
        logger.debug((Object)("Attachment Log Group [ " + this.attachmentLogGroup + " ]"));
        logger.debug((Object)"Saving attachment logging mode settings...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.setAttachmentLogGroup(this.attachmentLogGroup);
            this.attachmentCheckerConfig.setAttachmentLog(this.loggingMode);
            return null;
        });
    }

    private String getUserKey(String string) {
        ConfluenceUser confluenceUser;
        String string2 = "";
        if (!string.isEmpty() && (confluenceUser = this.userAccessor.getUserByName(string)) != null) {
            string2 = confluenceUser.getKey().getStringValue();
        }
        logger.debug((Object)("Username [" + string + "] user key [" + string2 + "]"));
        return string2;
    }
}

