/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.config.xwork;

import com.akelesconsulting.confluence.plugins.ao.service.SpaceFilterModeService;
import com.akelesconsulting.confluence.plugins.ao.service.SpacePermissionService;
import com.atlassian.confluence.spaces.actions.SpaceAdminAction;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.xwork.ParameterSafe;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class EditAttachmentPermissions
extends SpaceAdminAction {
    private final transient Logger logger = Logger.getLogger((String)"com.akeles.plugins.acc.config.EditAttachmentPermissions");
    private transient SpacePermissionService spacePermissionService;
    private transient SpaceFilterModeService spaceFilterModeService;
    private String spaceKey;
    private String permissionFilterMode;
    private String filterMode;
    private String groupPermissions;
    private String userPermissions;
    private String attachmentLogMode;

    public void setAttachmentCheckerSpacePermissionService(SpacePermissionService spacePermissionService) {
        this.spacePermissionService = spacePermissionService;
    }

    public void setSpaceFilterModeService(SpaceFilterModeService spaceFilterModeService) {
        this.spaceFilterModeService = spaceFilterModeService;
    }

    public String getPermissionFilterMode() {
        return this.permissionFilterMode;
    }

    @ParameterSafe
    public void setPermissionFilterMode(String string) {
        this.permissionFilterMode = string;
    }

    @ParameterSafe
    public void setGroupPermissions(String string) {
        this.groupPermissions = string;
    }

    public String getGroupPermissions() {
        return this.groupPermissions;
    }

    @ParameterSafe
    public void setUserPermissions(String string) {
        this.userPermissions = string;
    }

    public String getUserPermissions() {
        return this.userPermissions;
    }

    public JSONObject getUserList() {
        this.spaceKey = this.getSpaceKey();
        JSONObject jSONObject = new JSONObject();
        Map<String, String> map = this.spacePermissionService.a(this.spaceKey, "user");
        if (!map.isEmpty()) {
            jSONObject = new JSONObject(map);
        }
        return jSONObject;
    }

    public JSONObject getGroupList() {
        this.spaceKey = this.getSpaceKey();
        JSONObject jSONObject = new JSONObject();
        Map<String, String> map = this.spacePermissionService.a(this.spaceKey, "group");
        if (!map.isEmpty()) {
            jSONObject = new JSONObject(map);
        }
        return jSONObject;
    }

    public String getFilterMode() {
        this.spaceKey = this.getSpaceKey();
        this.filterMode = this.spaceFilterModeService.a(this.spaceKey);
        this.logger.debug((Object)("Filter Mode: " + this.filterMode));
        return this.filterMode;
    }

    @ParameterSafe
    public void setFilterMode(String string) {
        this.filterMode = string;
    }

    @ParameterSafe
    public void setAttachmentLogMode(String string) {
        this.attachmentLogMode = string;
    }

    public String getAttachmentLogMode() {
        this.spaceKey = this.getSpaceKey();
        this.attachmentLogMode = this.spaceFilterModeService.b(this.spaceKey);
        return this.attachmentLogMode;
    }

    public String execute() {
        this.filterMode = this.getFilterMode();
        this.logger.debug((Object)("Filter Mode: " + this.filterMode));
        return "input";
    }

    public String doUpdate() {
        String[] stringArray;
        this.spaceKey = this.getSpaceKey();
        this.spacePermissionService.a(this.spaceKey);
        this.logger.debug((Object)"Updating Attachment Space Permissions... ");
        this.spaceFilterModeService.b(this.spaceKey, this.attachmentLogMode);
        this.logger.debug((Object)("Setting Attachment Log: " + this.attachmentLogMode));
        this.spaceFilterModeService.a(this.spaceKey, this.permissionFilterMode);
        this.logger.debug((Object)("Setting Filter Mode: " + this.permissionFilterMode));
        if (!this.groupPermissions.isEmpty()) {
            for (String string : stringArray = this.groupPermissions.split(",")) {
                this.spacePermissionService.a(this.spaceKey, string, "group");
                this.logger.debug((Object)("Setting Group: " + string));
            }
        }
        if (!this.userPermissions.isEmpty()) {
            for (String string : stringArray = this.userPermissions.split(",")) {
                ConfluenceUser confluenceUser;
                if (string.isEmpty() || (confluenceUser = this.userAccessor.getUserByName(string)) == null) continue;
                String string2 = confluenceUser.getKey().getStringValue();
                this.spacePermissionService.a(this.spaceKey, string2, "user");
                this.logger.debug((Object)("Setting User: " + confluenceUser));
            }
        }
        return "success";
    }
}

