/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.scheduler;

import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.scheduler.job.CalculateAttachmentJobRunner;
import com.akelesconsulting.confluence.plugins.scheduler.job.MissingAttachmentScannerJobRunner;
import com.akelesconsulting.confluence.plugins.scheduler.job.ViolationScannerJobRunner;
import com.akelesconsulting.confluence.plugins.scheduler.job.VirusScanningJobRunner;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class JobScheduler
implements LifecycleAware,
DisposableBean,
InitializingBean {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.scheduler.JobScheduler");
    private static final String b = "com.akelesconsulting.confluence.plugins.AttachmentChecker4CONF";
    private final AttachmentCheckerConfig c;
    private final ClusterLockService d;
    private final ClusterManager e;
    private final EventPublisher f;
    private final SchedulerService g;
    private final CalculateAttachmentJobRunner h;
    private final MissingAttachmentScannerJobRunner i;
    private final ViolationScannerJobRunner j;
    private final VirusScanningJobRunner k;
    @GuardedBy(value="this")
    private final Set<LifecycleEvent> l = EnumSet.noneOf(LifecycleEvent.class);

    @Autowired
    public JobScheduler(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport ClusterLockService clusterLockService, @ComponentImport ClusterManager clusterManager, @ComponentImport EventPublisher eventPublisher, @ComponentImport SchedulerService schedulerService, CalculateAttachmentJobRunner calculateAttachmentJobRunner, MissingAttachmentScannerJobRunner missingAttachmentScannerJobRunner, ViolationScannerJobRunner violationScannerJobRunner, VirusScanningJobRunner virusScanningJobRunner) {
        this.c = attachmentCheckerConfig;
        this.d = clusterLockService;
        this.e = clusterManager;
        this.f = eventPublisher;
        this.g = schedulerService;
        this.h = calculateAttachmentJobRunner;
        this.i = missingAttachmentScannerJobRunner;
        this.j = violationScannerJobRunner;
        this.k = virusScanningJobRunner;
    }

    public void afterPropertiesSet() {
        this.f.register((Object)this);
        this.a(LifecycleEvent.AFTER_PROPERTIES_SET);
    }

    @EventListener
    public void a(@NotNull PluginEnabledEvent pluginEnabledEvent) {
        if (b.equals(pluginEnabledEvent.getPlugin().getKey())) {
            this.a(LifecycleEvent.PLUGIN_ENABLED);
        }
    }

    public void onStart() {
        this.a(LifecycleEvent.LIFECYCLE_AWARE_ON_START);
    }

    public void onStop() {
        a.debug((Object)"*** onStop ***");
    }

    public void destroy() {
        a.debug((Object)("Unschedule CalculateAttachmentJobRunner [" + CalculateAttachmentJobRunner.b + "]"));
        this.g.unscheduleJob(CalculateAttachmentJobRunner.b);
        a.debug((Object)("Unschedule MissingAttachmentScannerJobRunner [" + MissingAttachmentScannerJobRunner.c + "]"));
        this.g.unscheduleJob(MissingAttachmentScannerJobRunner.c);
        a.debug((Object)("Unschedule ViolationScannerJobRunner [" + ViolationScannerJobRunner.c + "]"));
        this.g.unscheduleJob(ViolationScannerJobRunner.c);
        a.debug((Object)("Unschedule VirusScanningJobRunner [" + VirusScanningJobRunner.b + "]"));
        this.g.unscheduleJob(VirusScanningJobRunner.b);
        a.debug((Object)("Unregister CalculateAttachmentJobRunner [" + CalculateAttachmentJobRunner.a + "]"));
        this.g.unregisterJobRunner(CalculateAttachmentJobRunner.a);
        a.debug((Object)("Unregister MissingAttachmentScannerJobRunner [" + MissingAttachmentScannerJobRunner.b + "]"));
        this.g.unregisterJobRunner(MissingAttachmentScannerJobRunner.b);
        a.debug((Object)("Unregister ViolationScannerJobRunner [" + ViolationScannerJobRunner.b + "]"));
        this.g.unregisterJobRunner(ViolationScannerJobRunner.b);
        a.debug((Object)("Unregister VirusScanningJobRunner [" + VirusScanningJobRunner.a + "]"));
        this.g.unregisterJobRunner(VirusScanningJobRunner.a);
        this.f.unregister((Object)this);
    }

    private void a(LifecycleEvent lifecycleEvent) {
        a.debug((Object)("onLifecycleEvent [" + (Object)((Object)lifecycleEvent) + "]"));
        if (this.b(lifecycleEvent)) {
            a.debug((Object)"Got the last lifecycle event... Time to get started!");
            this.f.unregister((Object)this);
            try {
                this.a();
            }
            catch (Exception exception) {
                a.error((Object)"Unexpected error during launch", (Throwable)exception);
            }
        }
    }

    private synchronized boolean b(LifecycleEvent lifecycleEvent) {
        return this.l.add(lifecycleEvent) && this.l.size() == LifecycleEvent.values().length;
    }

    private void a() {
        Object object;
        this.g.registerJobRunner(CalculateAttachmentJobRunner.a, (JobRunner)this.h);
        this.g.registerJobRunner(MissingAttachmentScannerJobRunner.b, (JobRunner)this.i);
        this.g.registerJobRunner(VirusScanningJobRunner.a, (JobRunner)this.k);
        String string = this.c.getJobStartHour();
        String string2 = this.c.getJobStartMinute();
        String string3 = this.c.getJobStartAmPm();
        if (!(string.isEmpty() || string2.isEmpty() || string3.isEmpty() || this.g.getJobDetails(CalculateAttachmentJobRunner.b) != null)) {
            this.a(DateHelper.a(string, string2, string3));
        }
        if (!this.e.isClustered()) {
            this.c.setIsMissingAttachmentScanRunning(false);
        } else {
            object = this.d.getLockForName(MissingAttachmentScannerJobRunner.a);
            try {
                if (object.tryLock(3L, TimeUnit.SECONDS)) {
                    this.c.setIsMissingAttachmentScanRunning(false);
                    object.unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                a.error((Object)"Interrupted while acquiring MissingAttachmentScannerJob lock", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
        object = this.c.getMissingAttachmentScannerStartHour();
        String string4 = this.c.getMissingAttachmentScannerStartMinute();
        String string5 = this.c.getMissingAttachmentScannerStartAmPm();
        if (!StringUtils.isEmpty((CharSequence)object) && this.g.getJobDetails(MissingAttachmentScannerJobRunner.c) == null) {
            this.b(DateHelper.a((String)object, string4, string5));
        }
        this.b();
        if ((this.c.d() || this.c.e()) && this.g.getJobDetails(VirusScanningJobRunner.b) == null) {
            this.c();
        }
    }

    private void b() {
        Object object;
        this.g.registerJobRunner(ViolationScannerJobRunner.b, (JobRunner)this.j);
        if (!this.e.isClustered()) {
            this.c.setIsViolationScanRunning(false);
        } else {
            object = this.d.getLockForName(ViolationScannerJobRunner.a);
            try {
                if (object.tryLock(3L, TimeUnit.SECONDS)) {
                    this.c.setIsViolationScanRunning(false);
                    object.unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                a.error((Object)"Interrupted while acquiring ViolationScannerJob lock", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
        object = this.c.getViolationScannerStartHour();
        String string = this.c.getViolationScannerStartMinute();
        String string2 = this.c.getViolationScannerStartAmPm();
        if (!StringUtils.isEmpty((CharSequence)object) && this.g.getJobDetails(ViolationScannerJobRunner.c) == null) {
            this.c(DateHelper.a((String)object, string, string2));
        }
    }

    public void a(Date date) {
        a.debug((Object)"Scheduling CalculateAttachmentJob...");
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)CalculateAttachmentJobRunner.a).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)86400000L, (Date)date));
        try {
            this.g.scheduleJob(CalculateAttachmentJobRunner.b, jobConfig);
            a.debug((Object)"Scheduled CalculateAttachmentJob!");
        }
        catch (SchedulerServiceException schedulerServiceException) {
            a.error((Object)"Error scheduling CalculateAttachmentJob", (Throwable)schedulerServiceException);
        }
    }

    public void b(Date date) {
        a.debug((Object)"Scheduling MissingAttachmentScannerJob...");
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)MissingAttachmentScannerJobRunner.b).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)86400000L, (Date)date));
        try {
            this.g.scheduleJob(MissingAttachmentScannerJobRunner.c, jobConfig);
            a.debug((Object)("Next run time [" + date + "]"));
            a.debug((Object)"Scheduled MissingAttachmentScannerJob!");
        }
        catch (SchedulerServiceException schedulerServiceException) {
            a.error((Object)"Error scheduling MissingAttachmentScannerJob", (Throwable)schedulerServiceException);
        }
    }

    public void c(Date date) {
        a.debug((Object)"Scheduling ViolationScannerJob...");
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)ViolationScannerJobRunner.b).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)86400000L, (Date)date));
        try {
            this.g.scheduleJob(ViolationScannerJobRunner.c, jobConfig);
            JobDetails jobDetails = this.g.getJobDetails(ViolationScannerJobRunner.c);
            if (jobDetails != null) {
                a.debug((Object)"Scheduled ViolationScannerJob!");
                a.debug((Object)("ViolationScannerJob next run time [" + date + "]"));
            }
        }
        catch (SchedulerServiceException schedulerServiceException) {
            a.error((Object)"Error scheduling ViolationScannerJob", (Throwable)schedulerServiceException);
        }
    }

    private void c() {
        a.debug((Object)"Scheduling VirusScanningJob...");
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)VirusScanningJobRunner.a).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)60000L, (Date)new Date(System.currentTimeMillis() + 15000L)));
        try {
            this.g.scheduleJob(VirusScanningJobRunner.b, jobConfig);
            a.debug((Object)"Scheduled VirusScanningJob!");
        }
        catch (SchedulerServiceException schedulerServiceException) {
            a.error((Object)"Error scheduling VirusScanningJob", (Throwable)schedulerServiceException);
        }
    }

    static enum LifecycleEvent {
        AFTER_PROPERTIES_SET,
        PLUGIN_ENABLED,
        LIFECYCLE_AWARE_ON_START;

    }
}

