/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.config.xwork;

import com.akelesconsulting.confluence.plugins.ao.entity.AttachmentLogs;
import com.akelesconsulting.confluence.plugins.ao.service.AttachmentLogsService;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.actions.SpaceAdminAction;
import com.atlassian.sal.api.user.UserKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AttachmentLogsManager
extends SpaceAdminAction {
    private static final Logger logger = Logger.getLogger((String)"com.akeles.plugins.acc.config.AttachmentLogsManager");
    private transient AttachmentLogsService attachmentLogsService;
    private transient PageManager pageManager;
    private transient AttachmentManager attachmentManager;
    String spaceKey;

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setAttachmentLogsService(AttachmentLogsService attachmentLogsService) {
        this.attachmentLogsService = attachmentLogsService;
    }

    public List<Map<String, String>> retrieveLogs(String string) {
        AttachmentLogs[] attachmentLogsArray;
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        for (AttachmentLogs attachmentLogs : attachmentLogsArray = this.attachmentLogsService.a(string)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Page page = this.pageManager.getPage(Long.parseLong(attachmentLogs.getPageId()));
            if (page == null) continue;
            hashMap.put("page", page.getTitle());
            hashMap.put("pageId", attachmentLogs.getPageId());
            hashMap.put("attachment", this.getAttachmentName(attachmentLogs.getAttachmentId()));
            hashMap.put("user", this.userKeyToName(attachmentLogs.getUserKey()));
            hashMap.put("userName", this.userKeyToUserName(attachmentLogs.getUserKey()));
            hashMap.put("dateTime", this.convertDateTime(attachmentLogs.getDownloadTime().toString()));
            hashMap.put("version", attachmentLogs.getAttachmentVersion());
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public List<Map<String, String>> getLogEntries() {
        this.spaceKey = this.getSpaceKey();
        logger.debug((Object)("Retrieved logs: " + this.retrieveLogs(this.spaceKey)));
        return this.retrieveLogs(this.spaceKey);
    }

    public String execute() {
        logger.debug((Object)"Executing AttachmentLogsManager....");
        return "success";
    }

    private String userKeyToName(String string) {
        UserKey userKey = new UserKey(string);
        return this.userAccessor.getUserByKey(userKey).getFullName();
    }

    private String userKeyToUserName(String string) {
        UserKey userKey = new UserKey(string);
        return this.userAccessor.getUserByKey(userKey).getName();
    }

    private String convertDateTime(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string2 = null;
        try {
            Date date = simpleDateFormat.parse(string);
            string2 = simpleDateFormat2.format(date);
        }
        catch (ParseException parseException) {
            logger.error((Object)"Error parsing Date Time");
        }
        return string2;
    }

    private String getAttachmentName(String string) {
        if (string.equals("-1")) {
            return "Download All";
        }
        Attachment attachment = this.attachmentManager.getAttachment(Long.parseLong(string));
        if (attachment != null) {
            return attachment.getFileName();
        }
        return "Attachment not found";
    }
}

