/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class AttachmentHelper {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.utils.AttachmentHelper");
    private final AttachmentManager b;
    private final BootstrapManager c;
    private final ClusterManager d;
    private final TransactionTemplate e;

    public AttachmentHelper(@ComponentImport AttachmentManager attachmentManager, @ComponentImport BootstrapManager bootstrapManager, @ComponentImport ClusterManager clusterManager, @ComponentImport TransactionTemplate transactionTemplate) {
        this.b = attachmentManager;
        this.c = bootstrapManager;
        this.d = clusterManager;
        this.e = transactionTemplate;
    }

    public Attachment a(long l, int n, Date date) {
        a.debug((Object)("Get attachment id [" + l + "] version [" + n + "] creation date [" + date + "]"));
        Attachment attachment = this.b.getAttachment(l);
        if (attachment == null) {
            a.debug((Object)"Attachment is null");
            return null;
        }
        Date date2 = DateHelper.a(attachment.getCreationDate());
        a.debug((Object)("Retrieved attachment version [" + attachment.getVersion() + "]"));
        a.debug((Object)("Retrieved attachment creation date [" + date2 + "]"));
        boolean bl = attachment.getVersion() != n;
        boolean bl2 = date2 != null && date != null && date2.getTime() != date.getTime();
        a.debug((Object)("Is version diff? [" + bl + "]"));
        a.debug((Object)("Is creation date diff? [" + bl2 + "]"));
        if (bl || bl2) {
            a.debug((Object)"Checking all versions");
            List list = this.b.getAllVersions(attachment);
            attachment = null;
            for (Attachment attachment2 : list) {
                int n2 = attachment2.getVersion();
                Date date3 = DateHelper.a(attachment2.getCreationDate());
                a.debug((Object)("Current version [" + n2 + "]"));
                a.debug((Object)("Current creation date [" + date3 + "]"));
                if (n2 != n || date != null && (date3 == null || date3.getTime() != date.getTime())) continue;
                a.debug((Object)"Found attachment!");
                attachment = attachment2;
                break;
            }
        }
        a.debug((Object)("Attachment [" + attachment + "]"));
        return attachment;
    }

    public void b(long l, int n, Date date) {
        a.debug((Object)("Delete attachment id [" + l + "]"));
        this.e.execute(() -> {
            Attachment attachment = this.a(l, n, date);
            if (attachment != null) {
                try {
                    this.b.removeAttachmentVersionFromServer(attachment);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    a.debug((Object)"IllegalArgumentException deleting attachment", (Throwable)illegalArgumentException);
                }
            }
            return null;
        });
    }

    public String a(@NotNull Attachment attachment, long l, int n, long l2) {
        String string;
        long l3 = attachment.getSpace().getId();
        String string2 = (String)this.c.getApplicationConfig().getProperty((Object)"attachments.dir");
        string2 = string2.replace("${confluenceHome}", this.d.isClustered() ? this.c.getSharedHome().getPath() : this.c.getLocalHome().getPath());
        boolean bl = new File(string2 + File.separator + "v4").exists();
        a.debug((Object)("Is attachment storage v4? [" + bl + "]"));
        if (bl) {
            long l4 = l % 65535L;
            string = string2 + File.separator + "v4" + File.separator + l4 % 256L + File.separator + l4 / 256L + File.separator + l + File.separator + l + "." + n;
        } else {
            string = string2 + File.separator + "ver003" + File.separator + l3 % 250L + File.separator + l3 / 1000L % 250L + File.separator + l3 + File.separator + l2 % 250L + File.separator + l2 / 1000L % 250L + File.separator + l2 + File.separator + l + File.separator + n;
        }
        return string;
    }

    public boolean a(boolean bl, long l, int n, Date date) {
        boolean bl2 = false;
        if (bl) {
            try {
                bl2 = (Boolean)this.e.execute(() -> this.c(l, n, date));
            }
            catch (Exception exception) {
                a.error((Object)"Error with addPlaceholderAndDeleteAttachmentVersion transaction", (Throwable)exception);
            }
        }
        return bl2;
    }

    public boolean c(long l, int n, Date date) {
        boolean bl = false;
        try {
            Attachment attachment = this.a(l, n, date);
            if (attachment != null) {
                Attachment attachment2 = this.b.getAttachment(l);
                Attachment attachment3 = attachment2.copy();
                ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
                AuthenticatedUserThreadLocal.set((ConfluenceUser)attachment.getCreator());
                a.debug((Object)"Saving placeholder... ");
                attachment2.setFileSize(136628L);
                attachment2.setMediaType("image/png");
                attachment2.setVersionComment("This is a placeholder to replace the infected file");
                InputStream inputStream = this.getClass().getResourceAsStream("/images/imageplaceholder.png");
                this.b.saveAttachment(attachment2, attachment3, inputStream);
                a.debug((Object)"Placeholder saved!");
                a.debug((Object)("Removing attachment version [" + n + "]"));
                this.b.removeAttachmentVersionFromServer(this.a(l, n, date));
                a.debug((Object)"Attachment version removed!");
                AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser);
                bl = true;
            }
        }
        catch (Exception exception) {
            a.error((Object)"Error adding placeholder version and deleting old version", (Throwable)exception);
        }
        return bl;
    }
}

