/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.entity.AttachmentLogs;
import com.akelesconsulting.confluence.plugins.ao.service.AttachmentLogsService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceFilterModeService;
import com.akelesconsulting.confluence.plugins.ao.service.SpacePermissionService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/config")
public class AttachmentCheckerConfigRestResource {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.rest.AttachmentCheckerConfigRestResource");
    private final AttachmentCheckerConfig b;
    private final PermissionManager c;
    private final SpaceFilterModeService d;
    private final SpacePermissionService e;
    private final AttachmentLogsService f;
    private final SpacePermissionManager g;
    private final PageManager h;
    private final SpaceManager i;

    @Inject
    public AttachmentCheckerConfigRestResource(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport PermissionManager permissionManager, SpacePermissionService spacePermissionService, SpaceFilterModeService spaceFilterModeService, AttachmentLogsService attachmentLogsService, PageManager pageManager, @ComponentImport SpacePermissionManager spacePermissionManager, @ComponentImport SpaceManager spaceManager) {
        this.b = attachmentCheckerConfig;
        this.c = permissionManager;
        this.e = spacePermissionService;
        this.d = spaceFilterModeService;
        this.f = attachmentLogsService;
        this.h = pageManager;
        this.g = spacePermissionManager;
        this.i = spaceManager;
    }

    @GET
    @Path(value="/extensions")
    @Produces(value={"application/json"})
    public Response getExtensionsMapJson() {
        a.debug((Object)"Get extensions map json...");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        a.debug((Object)("Logged in user [" + confluenceUser + "]"));
        if (this.c.isConfluenceAdministrator((User)confluenceUser)) {
            Map<String, List<String>> map = this.b.getExtensionsMap();
            JSONObject jSONObject = new JSONObject();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                try {
                    jSONObject.put(entry.getKey(), (Collection)entry.getValue());
                }
                catch (JSONException jSONException) {
                    a.error((Object)"JSONException while putting (extension, associated) into JSONObject", (Throwable)jSONException);
                }
            }
            return Response.ok((Object)jSONObject.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"You are not authorised to view this.").build();
    }

    @GET
    @Path(value="/scanner")
    @Produces(value={"text/plain"})
    public Response getScannerDetected() {
        String string = this.b.getScannerDetected();
        a.debug((Object)("Scanner detected [" + string + "]"));
        return Response.ok((Object)string).build();
    }

    @GET
    @Path(value="/attachmentLogs/{spaceKey}")
    public Response a(@PathParam(value="spaceKey") String string) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        Space space = this.i.getSpace(string);
        if (this.c.isConfluenceAdministrator((User)confluenceUser) || this.g.hasPermission("SETSPACEPERMISSIONS", space, (User)confluenceUser)) {
            JSONArray jSONArray = new JSONArray();
            AttachmentLogs[] attachmentLogsArray = this.f.a(string);
            try {
                for (AttachmentLogs attachmentLogs : attachmentLogsArray) {
                    JSONObject jSONObject = new JSONObject();
                    String string2 = "Page not found";
                    Page page = this.h.getPage(Long.parseLong(attachmentLogs.getPageId()));
                    if (page != null) {
                        string2 = page.getTitle();
                    }
                    jSONObject.put("Page", (Object)string2);
                    jSONObject.put("Attachment", (Object)attachmentLogs.getAttachmentId());
                    jSONObject.put("User", (Object)this.e.b(attachmentLogs.getUserKey()));
                    jSONObject.put("Date Time", (Object)attachmentLogs.getDownloadTime());
                    jSONArray.put((Object)jSONObject);
                }
            }
            catch (JSONException jSONException) {
                a.error((Object)"JSON Error", (Throwable)jSONException);
            }
            return Response.ok((Object)jSONArray.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"You are not authorised to view this").build();
    }

    @POST
    @Path(value="/attachmentLogs/purge/{spaceKey}")
    public Response b(@PathParam(value="spaceKey") String string) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        Space space = this.i.getSpace(string);
        if (this.c.isConfluenceAdministrator((User)confluenceUser) || this.g.hasPermission("SETSPACEPERMISSIONS", space, (User)confluenceUser)) {
            this.f.b(string);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"You are not authorised to perform this action").build();
    }

    @GET
    @Path(value="/isValid/{spaceKey}")
    @Produces(value={"application/json"})
    public Response c(@PathParam(value="spaceKey") String string) {
        boolean bl = true;
        JSONObject jSONObject = new JSONObject();
        try {
            String string2 = this.d.a(string);
            if (string2.equals("denylist") && this.e.c(string) || string2.equals("allowlist") && !this.e.c(string)) {
                bl = false;
            }
            jSONObject.put("isValid", bl);
            a.debug((Object)("User has permission [" + bl + "]"));
        }
        catch (JSONException jSONException) {
            a.error((Object)"Error putting values to JSON Object", (Throwable)jSONException);
        }
        return Response.ok((Object)jSONObject.toString()).build();
    }
}

