/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceToUpdateService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceQuotaBean;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class QuotaHelper {
    private static final Logger g = Logger.getLogger((String)"com.akeles.plugins.acc.utils.QuotaHelper");
    private static final int h = 50;
    public static final long a = -1L;
    public static final long b = 0L;
    public static final long c = -1L;
    public static final String d = "green";
    public static final String e = "orange";
    public static final String f = "red";
    private final AttachmentCheckerConfig i;
    private final DateHelper j;
    private final I18nResolver k;
    private final SpaceInfoService l;
    private final SpaceManager m;
    private final SpaceToUpdateService n;

    public QuotaHelper(AttachmentCheckerConfig attachmentCheckerConfig, DateHelper dateHelper, @ComponentImport I18nResolver i18nResolver, SpaceInfoService spaceInfoService, @ComponentImport SpaceManager spaceManager, SpaceToUpdateService spaceToUpdateService) {
        this.i = attachmentCheckerConfig;
        this.j = dateHelper;
        this.k = i18nResolver;
        this.l = spaceInfoService;
        this.m = spaceManager;
        this.n = spaceToUpdateService;
    }

    public List<SpaceQuotaBean> a(int n) {
        g.debug((Object)"Get SpaceQuotaBean list");
        ArrayList<SpaceQuotaBean> arrayList = new ArrayList<SpaceQuotaBean>();
        ListBuilder listBuilder = this.m.getSpaces(SpacesQuery.newQuery().sortBy("key").build());
        while (arrayList.size() < 50) {
            g.debug((Object)("Start index [" + n + "]"));
            List list = listBuilder.getPage(n, 50 - arrayList.size());
            if (list.isEmpty()) {
                g.debug((Object)("No space found for start index [" + n + "]"));
                break;
            }
            for (Space space : list) {
                SpaceQuotaBean spaceQuotaBean = this.a(space.getKey());
                if (spaceQuotaBean == null) continue;
                arrayList.add(spaceQuotaBean);
                g.debug((Object)("Adding space [" + space.getKey() + "]"));
            }
            g.debug((Object)("SpaceQuotaBean count [" + arrayList.size() + "]"));
            n += 50;
        }
        return arrayList;
    }

    public SpaceQuotaBean a(String string) {
        boolean bl;
        boolean bl2;
        g.debug((Object)("Get SpaceQuotaBean for space [" + string + "]"));
        SpaceInfo spaceInfo = this.l.a(string);
        if (spaceInfo == null) {
            return null;
        }
        String string2 = this.i.getUnit();
        long l = spaceInfo.getStorageAllocated();
        long l2 = spaceInfo.getStorageUsed();
        boolean bl3 = l2 == -1L;
        String string3 = "";
        String string4 = bl3 ? "" : AttachmentCheckerHelper.a(l2, string2, 2);
        String string5 = "";
        boolean bl4 = bl2 = l == -1L;
        if (bl2) {
            l = this.i.getDefaultQuotaAllocated();
        }
        boolean bl5 = bl = l == 0L;
        if (bl) {
            string5 = string3 = this.k.getText("com.akeles.acc.config.common.unlimited");
        } else if (!bl3) {
            string3 = AttachmentCheckerHelper.a(l, string2, 2);
            string5 = this.a(string3, string4, l, l2);
            if (string3.equals("0.00") && l > 0L) {
                string3 = string3 + " (" + AttachmentCheckerHelper.a(l, 2) + ")";
            }
        }
        if (string4.equals("0.00") && l2 > 0L) {
            string4 = string4 + " (" + AttachmentCheckerHelper.a(l2, 2) + ")";
        }
        SpaceQuotaBean spaceQuotaBean = new SpaceQuotaBean(string, string2, string3, string4, string5, bl2, bl);
        if (!bl && !bl3) {
            spaceQuotaBean.setQuotaUsage(l, l2, this.i.getQuotaAlertThreshold());
        }
        spaceQuotaBean.setAttachmentsCount(spaceInfo.getAllVersionsCount(), spaceInfo.getCurrentVersionsCount());
        boolean bl6 = this.n.a(string);
        String string6 = this.j.a(spaceInfo.getLastUpdated(), "-");
        String string7 = this.j.a(this.i.getQuotaJobNextRunTime(), "-");
        spaceQuotaBean.setSchedule(string6, string7, bl6);
        g.debug((Object)spaceQuotaBean.toString());
        return spaceQuotaBean;
    }

    @NotNull
    private String a(String string, String string2, long l, long l2) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        try {
            double d = Double.parseDouble(string);
            double d2 = Double.parseDouble(string2);
            bigDecimal = new BigDecimal(String.valueOf(d - d2));
        }
        catch (NumberFormatException numberFormatException) {
            g.debug((Object)"Error converting String to double", (Throwable)numberFormatException);
        }
        String string3 = bigDecimal.setScale(2, RoundingMode.HALF_UP).toPlainString();
        long l3 = l - l2;
        if (string3.equals("0.00") && l3 > 0L) {
            string3 = string3 + " (" + AttachmentCheckerHelper.a(l3, 2) + ")";
        }
        return string3;
    }
}

