/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.entity.LargeAttachment;
import com.akelesconsulting.confluence.plugins.ao.service.LargeAttachmentService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.beans.AttachmentBean;
import com.akelesconsulting.confluence.plugins.rest.beans.LargeAttachmentTrackerConfigBean;
import com.akelesconsulting.confluence.plugins.rest.beans.PageBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ResultBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceBean;
import com.akelesconsulting.confluence.plugins.rest.beans.UserBean;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.AttachmentHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.google.gson.Gson;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Path(value="/large-attachment")
public class LargeAttachmentTrackerResource {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.rest.LargeAttachmentTrackerResource");
    private static final int b = 50;
    private final AttachmentCheckerConfig c;
    private final AttachmentHelper d;
    private final DateHelper e;
    private final Gson f;
    private final I18nResolver g;
    private final LargeAttachmentService h;
    private final PageManager i;
    private final PermissionManager j;
    private final SettingsManager k;
    private final SpaceManager l;
    private final UserAccessor m;

    @Inject
    public LargeAttachmentTrackerResource(AttachmentCheckerConfig attachmentCheckerConfig, AttachmentHelper attachmentHelper, DateHelper dateHelper, @ComponentImport I18nResolver i18nResolver, LargeAttachmentService largeAttachmentService, @ComponentImport PageManager pageManager, PermissionManager permissionManager, @ComponentImport SettingsManager settingsManager, @ComponentImport SpaceManager spaceManager, @ComponentImport UserAccessor userAccessor) {
        this.c = attachmentCheckerConfig;
        this.d = attachmentHelper;
        this.e = dateHelper;
        this.f = new Gson();
        this.g = i18nResolver;
        this.h = largeAttachmentService;
        this.i = pageManager;
        this.j = permissionManager;
        this.k = settingsManager;
        this.l = spaceManager;
        this.m = userAccessor;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="startIndex") int n) {
        a.debug((Object)("Get list of LargeAttachment, start index [" + n + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to get large attachment list"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        HashMap<String, SpaceBean> hashMap = new HashMap<String, SpaceBean>();
        HashMap<Long, PageBean> hashMap2 = new HashMap<Long, PageBean>();
        HashMap<String, UserBean> hashMap3 = new HashMap<String, UserBean>();
        ResultBean resultBean = new ResultBean(50);
        List<LargeAttachment> list = this.h.a(n, 50);
        String string = this.k.getGlobalSettings().getBaseUrl();
        for (LargeAttachment largeAttachment : list) {
            int n2;
            Date date = largeAttachment.getCreationDate();
            String string2 = largeAttachment.getFileName();
            String string3 = AttachmentCheckerHelper.a(largeAttachment.getFileSize(), "MB", 2);
            AttachmentBean attachmentBean = new AttachmentBean(largeAttachment.getID(), this.e.a(date, this.g.getText("com.akeles.acc.unknown")), largeAttachment.getVersion(), string2, string3, "");
            Space space = null;
            String string4 = largeAttachment.getSpaceKey();
            ContentEntityObject contentEntityObject = null;
            long l = largeAttachment.getContentId();
            long l2 = largeAttachment.getAttachmentId();
            Attachment attachment = this.d.a(l2, n2 = largeAttachment.getVersion(), date);
            if (attachment != null) {
                string4 = attachment.getSpaceKey();
                space = attachment.getSpace();
                contentEntityObject = attachment.getContainer();
                attachmentBean.setIsInTrash(attachment.isDeleted());
            } else {
                attachmentBean.setIsDeleted(true);
            }
            SpaceBean spaceBean = (SpaceBean)hashMap.get(string4);
            if (spaceBean == null) {
                spaceBean = this.a(string4, space, largeAttachment, string);
                hashMap.put(string4, spaceBean);
            }
            attachmentBean.setSpace(spaceBean);
            PageBean pageBean = (PageBean)hashMap2.get(l);
            if (pageBean == null) {
                pageBean = this.a(l, contentEntityObject, largeAttachment, string);
                hashMap2.put(l, pageBean);
            }
            attachmentBean.setPage(pageBean);
            String string5 = largeAttachment.getUserKey();
            UserBean userBean = (UserBean)hashMap3.get(string5);
            if (userBean == null) {
                userBean = this.a(string5, largeAttachment, string);
                hashMap3.put(string5, userBean);
            }
            attachmentBean.setCreator(userBean);
            a.debug((Object)attachmentBean.toString());
            resultBean.addAttachment(attachmentBean);
        }
        int n3 = this.h.getLargeAttachmentTotalCount();
        resultBean.setPagination(n, n3);
        a.debug((Object)resultBean.toString());
        return Response.ok((Object)this.f.toJson((Object)resultBean)).build();
    }

    @NotNull
    private SpaceBean a(String string, Space space, LargeAttachment largeAttachment, String string2) {
        SpaceBean spaceBean = new SpaceBean(string);
        if (space == null) {
            space = this.l.getSpace(string);
        }
        if (space != null) {
            spaceBean.setName(space.getName());
            spaceBean.setUrl(string2 + space.getUrlPath());
        } else {
            spaceBean.setName(largeAttachment.getSpaceName());
        }
        return spaceBean;
    }

    @NotNull
    private PageBean a(long l, ContentEntityObject contentEntityObject, LargeAttachment largeAttachment, String string) {
        PageBean pageBean = new PageBean();
        if (contentEntityObject == null) {
            contentEntityObject = this.i.getPage(l);
        }
        if (contentEntityObject != null) {
            pageBean.setTitle(contentEntityObject.getTitle());
            pageBean.setUrl(string + contentEntityObject.getAttachmentsUrlPath());
        } else {
            pageBean.setTitle(largeAttachment.getPageTitle());
        }
        return pageBean;
    }

    @NotNull
    private UserBean a(String string, LargeAttachment largeAttachment, String string2) {
        UserBean userBean = new UserBean(string);
        ConfluenceUser confluenceUser = this.m.getExistingUserByKey(new UserKey(string));
        if (confluenceUser != null) {
            userBean.setDisplayName(confluenceUser.getFullName());
            userBean.setUsername(confluenceUser.getName());
            userBean.setUrl(string2 + "/display/~" + confluenceUser.getName());
        } else {
            userBean.setDisplayName(largeAttachment.getUserDisplayName());
            userBean.setUsername(largeAttachment.getUsername());
        }
        return userBean;
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig() {
        a.debug((Object)"Get large attachment tracker config");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to get large attachment tracker config"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        boolean bl = this.c.r();
        long l = this.c.getLargeAttachmentSize();
        String string = AttachmentCheckerHelper.a(l, "MB", 2);
        LargeAttachmentTrackerConfigBean largeAttachmentTrackerConfigBean = new LargeAttachmentTrackerConfigBean(bl, string);
        a.debug((Object)("Track large attachment? [" + bl + "]"));
        a.debug((Object)("Large attachment size (MB) [" + string + "]"));
        return Response.ok((Object)this.f.toJson((Object)largeAttachmentTrackerConfigBean)).build();
    }

    @POST
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="track") String string, @QueryParam(value="size") String string2) {
        a.debug((Object)"Update large attachment tracker config");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to update large attachment tracker config"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        LargeAttachmentTrackerConfigBean largeAttachmentTrackerConfigBean = new LargeAttachmentTrackerConfigBean();
        if (string2 != null) {
            string2 = AttachmentCheckerHelper.d(string2);
            String string3 = AttachmentCheckerHelper.a(string2, "MB");
            a.debug((Object)("Large attachment size (bytes) [" + string3 + "]"));
            this.c.setLargeAttachmentSize(string3);
            string2 = AttachmentCheckerHelper.a(this.c.getLargeAttachmentSize(), "MB", 2);
            largeAttachmentTrackerConfigBean.setSize(string2);
        } else {
            if (string == null) {
                string = "off";
            }
            a.debug((Object)("Track large attachment [" + string + "]"));
            this.c.setTrackLargeAttachment(string);
            largeAttachmentTrackerConfigBean.setTrackLargeAttachment(this.c.r());
        }
        return Response.ok((Object)this.f.toJson((Object)largeAttachmentTrackerConfigBean)).build();
    }
}

