/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class DateHelper {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.utils.DateHelper");
    private static final int b = 2;
    private static final int c = 0;
    private final FormatSettingsManager d;
    private final I18nResolver e;
    private final LocaleManager f;
    private final UserAccessor g;

    public DateHelper(@ComponentImport FormatSettingsManager formatSettingsManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport LocaleManager localeManager, @ComponentImport UserAccessor userAccessor) {
        this.d = formatSettingsManager;
        this.e = i18nResolver;
        this.f = localeManager;
        this.g = userAccessor;
    }

    @NotNull
    public static Date a(String string, String string2, String string3) {
        int n = 2;
        int n2 = 0;
        try {
            n = Integer.parseInt(string);
            if ("PM".equalsIgnoreCase(string3) && n != 12 || "AM".equalsIgnoreCase(string3) && n == 12) {
                n += 12;
            }
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            a.error((Object)"NumberFormatException parsing int", (Throwable)numberFormatException);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (calendar.getTime().before(new Date())) {
            calendar.add(5, 1);
        }
        return calendar.getTime();
    }

    @NotNull
    public static Date a(Date date, String string, String string2, String string3) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(13, 0);
        calendar.set(14, 0);
        try {
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            if ("PM".equalsIgnoreCase(string3) && n != 12 || "AM".equalsIgnoreCase(string3) && n == 12) {
                n += 12;
            }
            calendar.set(11, n);
            calendar.set(12, n2);
            if (!calendar.getTime().after(date)) {
                calendar.add(5, 1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            a.error((Object)"NumberFormatException parsing int", (Throwable)numberFormatException);
        }
        return calendar.getTime();
    }

    public String a(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7;
        if (!StringUtils.isEmpty((CharSequence)string)) {
            String string8 = string + ":" + ("0".equals(string2) ? "00" : string2) + " " + string3.toUpperCase();
            String string9 = "0".equals(string4) ? this.e.getText("com.akeles.acc.untilAllSpacesAreScanned") : string4 + ":" + ("0".equals(string5) ? "00" : string5) + " " + string6.toUpperCase();
            string7 = this.e.getText("com.akeles.acc.scheduledTime.fromTimeToTime", new Serializable[]{string8, string9});
        } else {
            string7 = this.e.getText("com.akeles.acc.scheduledTime.notScheduled");
        }
        a.debug((Object)("Scheduled time [" + string7 + "]"));
        return string7;
    }

    public String a(Long l) {
        String string = l == null || l == 0L ? this.e.getText("com.akeles.acc.date.never") : this.a(new Date(l), "");
        a.debug((Object)("Last run time [" + string + "]"));
        return string;
    }

    public String a(Date date, String string) {
        if (date == null) {
            return string;
        }
        ConfluenceUserPreferences confluenceUserPreferences = this.g.getConfluenceUserPreferences((User)AuthenticatedUserThreadLocal.get());
        DateFormatter dateFormatter = confluenceUserPreferences.getDateFormatter(this.d, this.f);
        return dateFormatter.formatDateTime(date);
    }

    public static Date a(Date date) {
        if (date != null) {
            a.debug((Object)("Round date to nearest second [" + date.getTime() + "]"));
            date = DateUtils.round((Date)date, (int)13);
            a.debug((Object)("Updated date [" + date.getTime() + "]"));
        }
        return date;
    }
}

