/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.servlet;

import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class QuotaSummaryServlet
extends HttpServlet {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.servlet.QuotaSummaryServlet");
    private final AttachmentCheckerConfig b;
    private final I18nResolver c;
    private final LoginUriProvider d;
    private final PermissionManager e;
    private final SpaceInfoService f;
    private final SpaceManager g;
    private final VelocityHelperService h;

    public QuotaSummaryServlet(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport I18nResolver i18nResolver, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport PermissionManager permissionManager, SpaceInfoService spaceInfoService, @ComponentImport SpaceManager spaceManager, @ComponentImport VelocityHelperService velocityHelperService) {
        this.b = attachmentCheckerConfig;
        this.c = i18nResolver;
        this.d = loginUriProvider;
        this.e = permissionManager;
        this.f = spaceInfoService;
        this.g = spaceManager;
        this.h = velocityHelperService;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        a.debug((Object)"Download quota summary");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser == null) {
            a.debug((Object)"User is not logged in");
            this.a(httpServletRequest, httpServletResponse);
            return;
        }
        if (!this.e.isSystemAdministrator((User)confluenceUser)) {
            a.debug((Object)("User does not have sysadmin permission to download quota summary [" + confluenceUser + "]"));
            this.a(httpServletResponse);
            return;
        }
        try (XSSFWorkbook xSSFWorkbook = new XSSFWorkbook();
             ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();){
            String string = this.a(httpServletRequest, "query").toLowerCase();
            String string2 = this.a(httpServletRequest, "allocation");
            String string3 = this.a(httpServletRequest, "usage");
            a.debug((Object)("Query [" + string + "] allocation [" + string2 + "] usage [" + string3 + "]"));
            this.a(xSSFWorkbook, string, string2, string3);
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String string4 = new SimpleDateFormat("yyyyMMdd-HHmmss").format(timestamp);
            a.debug((Object)("Quota summary generated on [" + string4 + "]"));
            a.debug((Object)"Writing to response output stream");
            httpServletResponse.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            httpServletResponse.setHeader("Pragma", "private");
            httpServletResponse.setHeader("Cache-Control", "cache, must-revalidate");
            httpServletResponse.setHeader("Content-Disposition", "attachment; filename=quotasummary-" + string4 + ".xlsx");
            xSSFWorkbook.write((OutputStream)servletOutputStream);
            servletOutputStream.flush();
        }
        catch (IOException iOException) {
            a.error((Object)"Error downloading quota summary", (Throwable)iOException);
        }
    }

    private void a(@NotNull HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            StringBuilder stringBuilder = new StringBuilder(httpServletRequest.getRequestURL().toString());
            if (httpServletRequest.getQueryString() != null) {
                stringBuilder.append("?");
                stringBuilder.append(httpServletRequest.getQueryString());
            }
            URI uRI = URI.create(stringBuilder.toString());
            httpServletResponse.sendRedirect(this.d.getLoginUri(uRI).toString());
        }
        catch (IOException iOException) {
            a.error((Object)"Error redirecting to login", (Throwable)iOException);
        }
    }

    private void a(@NotNull HttpServletResponse httpServletResponse) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("pageTitle", this.c.getText("com.akeles.acc.quota.summary.title"));
            hashMap.put("errorTitle", this.c.getText("errors.occurred"));
            hashMap.put("errorMessage", this.c.getText("com.akeles.acc.quota.summary.export.sysadmin.required"));
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.write(this.h.getRenderedTemplate("templates/QuotaExportError.vm", hashMap));
            printWriter.close();
        }
        catch (IOException iOException) {
            a.error((Object)"Error writing response", (Throwable)iOException);
        }
    }

    @NotNull
    private String a(@NotNull HttpServletRequest httpServletRequest, String string) {
        String string2 = httpServletRequest.getParameter(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public void a(@NotNull XSSFWorkbook xSSFWorkbook, String string, String string2, String string3) {
        a.debug((Object)"Adding data");
        String string4 = this.b.getUnit();
        long l = this.b.getDefaultQuotaAllocated();
        XSSFSheet xSSFSheet = xSSFWorkbook.createSheet(this.c.getText("com.akeles.acc.quota.summary.title"));
        XSSFRow xSSFRow = xSSFSheet.createRow(0);
        xSSFRow.createCell(0).setCellValue(this.c.getText("space-key"));
        xSSFRow.createCell(1).setCellValue(this.c.getText("space-name"));
        xSSFRow.createCell(2).setCellValue(this.c.getText("com.akeles.acc.quota.allocated") + " (" + string4 + ")");
        xSSFRow.createCell(3).setCellValue(this.c.getText("com.akeles.acc.quota.used") + " (" + string4 + ")");
        xSSFRow.createCell(4).setCellValue(this.c.getText("com.akeles.acc.quota.available") + " (" + string4 + ")");
        XSSFDataFormat xSSFDataFormat = xSSFWorkbook.createDataFormat();
        XSSFCellStyle xSSFCellStyle = xSSFWorkbook.createCellStyle();
        xSSFCellStyle.setDataFormat(xSSFDataFormat.getFormat("0.00"));
        ListBuilder listBuilder = this.g.getSpaces(SpacesQuery.newQuery().sortBy("key").build());
        List list = listBuilder.getRange(0, listBuilder.getAvailableSize() - 1);
        int n = 0;
        for (Space space : list) {
            boolean bl;
            boolean bl2;
            String string5 = space.getKey();
            String string6 = space.getName();
            SpaceInfo spaceInfo = this.f.a(string5);
            if (spaceInfo == null) continue;
            long l2 = spaceInfo.getStorageAllocated();
            long l3 = spaceInfo.getStorageUsed();
            boolean bl3 = bl2 = l2 == -1L;
            if (bl2) {
                l2 = l;
            }
            boolean bl4 = bl = l2 == 0L;
            if (this.a(string, string5, string6) || this.a(string2, string3, bl2, bl, l2, l3)) continue;
            a.debug((Object)("Creating row for space key [" + string5 + "]"));
            XSSFRow xSSFRow2 = xSSFSheet.createRow(++n);
            xSSFRow2.createCell(0).setCellValue(string5);
            xSSFRow2.createCell(1).setCellValue(string6);
            XSSFCell xSSFCell = xSSFRow2.createCell(2);
            XSSFCell xSSFCell2 = xSSFRow2.createCell(3);
            XSSFCell xSSFCell3 = xSSFRow2.createCell(4);
            double d = Double.parseDouble(AttachmentCheckerHelper.a(l3, string4, 2));
            xSSFCell2.setCellValue(d);
            xSSFCell2.setCellStyle((CellStyle)xSSFCellStyle);
            if (bl) {
                String string7 = this.c.getText("com.akeles.acc.config.common.unlimited");
                xSSFCell.setCellValue(string7);
                xSSFCell3.setCellValue(string7);
                continue;
            }
            double d2 = Double.parseDouble(AttachmentCheckerHelper.a(l2, string4, 2));
            double d3 = BigDecimal.valueOf(d2 - d).setScale(2, RoundingMode.HALF_UP).doubleValue();
            xSSFCell.setCellValue(d2);
            xSSFCell.setCellStyle((CellStyle)xSSFCellStyle);
            xSSFCell3.setCellValue(d3);
            xSSFCell3.setCellStyle((CellStyle)xSSFCellStyle);
        }
        a.debug((Object)("Added [" + n + "] data row(s)"));
    }

    private boolean a(@NotNull String string, String string2, String string3) {
        return !string.isEmpty() && !string2.toLowerCase().contains(string) && !string3.toLowerCase().contains(string);
    }

    private boolean a(@NotNull String string, @NotNull String string2, boolean bl, boolean bl2, long l, long l2) {
        return string.equals("default") && !bl || string.equals("custom") && bl || string2.equals("0") && l2 > 0L || string2.equals("101") && (bl2 || l2 <= l);
    }
}

