/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.ao.service;

import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceInfoService {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.service.SpaceInfoService");
    private final ActiveObjects b;
    private final AttachmentManager c;
    private final PageManager d;
    private final SpaceManager e;
    private final TransactionTemplate f;

    @Autowired
    public SpaceInfoService(@ComponentImport ActiveObjects activeObjects, @ComponentImport AttachmentManager attachmentManager, @ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager, @ComponentImport TransactionTemplate transactionTemplate) {
        this.b = activeObjects;
        this.c = attachmentManager;
        this.d = pageManager;
        this.e = spaceManager;
        this.f = transactionTemplate;
    }

    public SpaceInfo a(String string) {
        a.debug((Object)("Get SpaceInfo for space [" + string + "]"));
        return (SpaceInfo)this.b.get(SpaceInfo.class, (Object)string);
    }

    public SpaceInfo a(@NotNull Space space) {
        String string = space.getKey();
        a.debug((Object)("Get SpaceInfo for space [" + string + "]"));
        SpaceInfo spaceInfo = this.a(string);
        if (spaceInfo == null || spaceInfo.getStorageUsed() == -1L) {
            long l = 0L;
            int n = 0;
            int n2 = 0;
            for (Long l2 : this.d.getPageIds(space)) {
                ContentEntityObject contentEntityObject = this.d.getById(l2.longValue());
                if (contentEntityObject == null) continue;
                n += this.c.getAllVersionsOfAttachments(contentEntityObject).size();
                n2 += this.c.countLatestVersionsOfAttachments(contentEntityObject);
                List list = contentEntityObject.getAttachments();
                for (Attachment attachment : list) {
                    l += attachment.getFileSize();
                }
            }
            a.debug((Object)("Quota used (bytes) [" + l + "]"));
            a.debug((Object)("All versions count [" + n + "]"));
            a.debug((Object)("Current versions count [" + n2 + "]"));
            if (spaceInfo == null) {
                a.debug((Object)("SpaceInfo not found for space [" + string + "]"));
                spaceInfo = this.a(string, l, n, n2);
            } else {
                a.debug((Object)("SpaceInfo quota used is purged for space [" + string + "]"));
                this.a(spaceInfo, l, n, n2);
            }
        }
        return spaceInfo;
    }

    private SpaceInfo a(String string, long l, int n, int n2) {
        a.debug((Object)("Create SpaceInfo for space [" + string + "]"));
        SpaceInfo spaceInfo = (SpaceInfo)this.f.execute(() -> (SpaceInfo)this.b.create(SpaceInfo.class, new DBParam[]{new DBParam("SPACE_KEY", (Object)string), new DBParam("STORAGE_ALLOCATED", (Object)-1L), new DBParam("STORAGE_USED", (Object)l), new DBParam("ALL_VERSIONS_COUNT", (Object)n), new DBParam("CURRENT_VERSIONS_COUNT", (Object)n2), new DBParam("LAST_UPDATED", (Object)new Date())}));
        a.debug((Object)("Created SpaceInfo for space [" + string + "]"));
        return spaceInfo;
    }

    public List<Space> getSpaceList() {
        SpacesQuery spacesQuery = SpacesQuery.newQuery().sortBy("key").build();
        ListBuilder listBuilder = this.e.getSpaces(spacesQuery);
        return listBuilder.getRange(0, listBuilder.getAvailableSize() - 1);
    }

    public int getSpaceInfoListSize() {
        return this.b.count(SpaceInfo.class, Query.select().where("STORAGE_USED != ?", new Object[]{-1L}));
    }

    public int getSpaceListSize() {
        SpacesQuery spacesQuery = SpacesQuery.newQuery().build();
        return this.e.getSpaces(spacesQuery).getAvailableSize();
    }

    public void a(String string, long l) {
        a.debug((Object)("Update quota allocated for space [" + string + "]"));
        Space space = this.e.getSpace(string);
        if (space != null) {
            SpaceInfo spaceInfo = this.a(space);
            this.f.execute(() -> {
                spaceInfo.setStorageAllocated(l);
                spaceInfo.save();
                return null;
            });
            a.debug((Object)("Updated quota allocated (bytes) [" + spaceInfo.getStorageAllocated() + "]"));
        } else {
            a.debug((Object)("Space not found [" + string + "]"));
        }
    }

    public void a(String string, long l, boolean bl) {
        a.debug((Object)"*** Update quota used ***");
        a.debug((Object)("Space key [" + string + "]"));
        SpaceInfo spaceInfo = this.a(string);
        if (spaceInfo != null) {
            long l2 = spaceInfo.getStorageUsed();
            a.debug((Object)("Current [" + l2 + "] bytes"));
            if (l2 == -1L) {
                a.debug((Object)("Quota used for space [" + string + "] has been purged, skip update"));
                return;
            }
            long l3 = bl ? l2 - l : l2 + l;
            this.f.execute(() -> {
                spaceInfo.setStorageUsed(l3);
                spaceInfo.save();
                return null;
            });
            a.debug((Object)("Updated to [" + spaceInfo.getStorageUsed() + "] bytes used"));
        }
    }

    public void a() {
        SpaceInfo[] spaceInfoArray;
        a.debug((Object)"*** Purge usage ***");
        for (SpaceInfo spaceInfo : spaceInfoArray = (SpaceInfo[])this.b.find(SpaceInfo.class)) {
            this.f.execute(() -> {
                spaceInfo.setStorageUsed(-1L);
                spaceInfo.save();
                return null;
            });
        }
        a.debug((Object)"All SpaceInfo's storage used purged");
    }

    public void b(String string) {
        a.debug((Object)("*** Delete SpaceInfo [" + string + "] ***"));
        SpaceInfo spaceInfo = this.a(string);
        if (spaceInfo != null) {
            this.f.execute(() -> {
                this.b.delete(new RawEntity[]{spaceInfo});
                return null;
            });
            a.debug((Object)"SpaceInfo deleted");
        }
    }

    public void b() {
        SpaceInfo[] spaceInfoArray;
        a.debug((Object)"Delete SpaceInfo if Space not found...");
        for (SpaceInfo spaceInfo : spaceInfoArray = (SpaceInfo[])this.b.find(SpaceInfo.class)) {
            String string = spaceInfo.getSpaceKey();
            a.debug((Object)("Checking space key [" + string + "]"));
            if (this.e.getSpace(string) != null) continue;
            a.debug((Object)("Space [" + string + "] not found, deleting SpaceInfo."));
            this.f.execute(() -> {
                this.b.delete(new RawEntity[]{spaceInfo});
                return null;
            });
        }
    }

    public void c(String string) {
        a.debug((Object)("Update attachments count for space [" + string + "]"));
        Space space = this.e.getSpace(string);
        if (space == null) {
            a.debug((Object)("Space not found [" + string + "]"));
            return;
        }
        SpaceInfo spaceInfo = this.a(string);
        if (spaceInfo == null) {
            a.debug((Object)("SpaceInfo not found [" + string + "]"));
            return;
        }
        int n = 0;
        int n2 = 0;
        for (Long l : this.d.getPageIds(space)) {
            ContentEntityObject contentEntityObject = this.d.getById(l.longValue());
            if (contentEntityObject == null) continue;
            n += this.c.getAllVersionsOfAttachments(contentEntityObject).size();
            n2 += this.c.countLatestVersionsOfAttachments(contentEntityObject);
        }
        a.debug((Object)("All versions count [" + n + "]"));
        a.debug((Object)("Current versions count [" + n2 + "]"));
        this.a(spaceInfo, n, n2);
    }

    private void a(SpaceInfo spaceInfo, long l, int n, int n2) {
        a.debug((Object)"Update SpaceInfo quota used and attachments count");
        this.f.execute(() -> {
            spaceInfo.setStorageUsed(l);
            spaceInfo.setAllVersionsCount(n);
            spaceInfo.setCurrentVersionsCount(n2);
            spaceInfo.setLastUpdated(new Date());
            spaceInfo.save();
            return null;
        });
        a.debug((Object)"Updated quota used and attachments count!");
    }

    private void a(SpaceInfo spaceInfo, int n, int n2) {
        a.debug((Object)"Update SpaceInfo attachments count");
        this.f.execute(() -> {
            spaceInfo.setAllVersionsCount(n);
            spaceInfo.setCurrentVersionsCount(n2);
            spaceInfo.setLastUpdated(new Date());
            spaceInfo.save();
            return null;
        });
        a.debug((Object)"Updated attachments count!");
    }
}

