/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.scheduler.job;

import com.akelesconsulting.confluence.plugins.ao.entity.AttachmentToScan;
import com.akelesconsulting.confluence.plugins.ao.service.AttachmentToScanService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.notification.MailService;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.AttachmentHelper;
import com.akelesconsulting.confluence.plugins.utils.StreamGobbler;
import com.akelesconsulting.confluence.plugins.utils.VirusScanningJobHelper;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirusScanningJobRunner
implements JobRunner {
    private static final Logger d = Logger.getLogger((String)"com.akeles.plugins.acc.scheduler.VirusScanningJobRunner");
    private static final String e = VirusScanningJobRunner.class.getName() + ".lock";
    public static final JobRunnerKey a = JobRunnerKey.of((String)VirusScanningJobRunner.class.getName());
    public static final JobId b = JobId.of((String)VirusScanningJobRunner.class.getName());
    public static final long c = 60000L;
    private final AccessModeCompatService f;
    private final AttachmentCheckerConfig g;
    private final AttachmentHelper h;
    private final AttachmentToScanService i;
    private final ClusterLockService j;
    private final ClusterManager k;
    private final MailService l;
    private final SettingsManager m;
    private final VirusScanningJobHelper n;

    @Autowired
    public VirusScanningJobRunner(AccessModeCompatService accessModeCompatService, AttachmentCheckerConfig attachmentCheckerConfig, AttachmentHelper attachmentHelper, AttachmentToScanService attachmentToScanService, @ComponentImport ClusterLockService clusterLockService, @ComponentImport ClusterManager clusterManager, MailService mailService, @ComponentImport SettingsManager settingsManager, VirusScanningJobHelper virusScanningJobHelper) {
        this.f = accessModeCompatService;
        this.g = attachmentCheckerConfig;
        this.h = attachmentHelper;
        this.i = attachmentToScanService;
        this.j = clusterLockService;
        this.k = clusterManager;
        this.l = mailService;
        this.m = settingsManager;
        this.n = virusScanningJobHelper;
        d.setLevel(Level.INFO);
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        if (this.f.isReadOnlyAccessModeEnabled()) {
            d.info((Object)"Read-only access mode enabled! Abort virus scanning job!");
            return JobRunnerResponse.aborted((String)"Job aborted because read-only access mode is enabled!");
        }
        if (this.a()) {
            try {
                d.info((Object)"--- Running VirusScanningJob...");
                AttachmentToScan[] attachmentToScanArray = this.i.getAllAttachmentToScan();
                d.info((Object)("Num of attachments to scan [" + attachmentToScanArray.length + "]"));
                if (attachmentToScanArray.length > 0) {
                    this.a(attachmentToScanArray);
                }
                d.info((Object)"--- VirusScanningJob completed!");
            }
            finally {
                d.debug((Object)"Updating isVirusScanRunning to false...");
                this.g.setIsVirusScanRunning(false);
                this.g.setVirusScanNodeId("");
            }
        }
        return JobRunnerResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a() {
        boolean bl;
        block11: {
            bl = false;
            if (this.k.isClustered()) {
                d.debug((Object)"Instance is clustered!");
                ClusterLock clusterLock = this.j.getLockForName(e);
                try {
                    d.debug((Object)"Getting cluster lock...");
                    if (clusterLock.tryLock(3L, TimeUnit.SECONDS)) {
                        d.debug((Object)"Lock acquired!");
                        try {
                            String string = null;
                            ClusterNodeInformation clusterNodeInformation = this.k.getThisNodeInformation();
                            if (clusterNodeInformation != null) {
                                string = clusterNodeInformation.getAnonymizedNodeIdentifier();
                            }
                            String string2 = this.g.getVirusScanNodeId();
                            d.debug((Object)("Current node id [" + string + "]"));
                            d.debug((Object)("Runner node id [" + string2 + "]"));
                            if (!this.g.getIsVirusScanRunning() || !this.a(string2) || string2.equals(string)) {
                                d.debug((Object)"Updating isVirusScanRunning to true...");
                                this.g.setIsVirusScanRunning(true);
                                this.g.setVirusScanNodeId(string);
                                bl = true;
                            } else {
                                d.debug((Object)"VirusScanningJob is running on another node!");
                            }
                            break block11;
                        }
                        finally {
                            clusterLock.unlock();
                            d.debug((Object)"Lock released!");
                        }
                    }
                    d.debug((Object)"Unable to acquire lock!");
                }
                catch (InterruptedException interruptedException) {
                    d.error((Object)"Interrupted while acquiring lock", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
            } else {
                d.debug((Object)"Instance is not clustered!");
                this.g.setIsVirusScanRunning(true);
                bl = true;
            }
        }
        d.info((Object)("Run on current node? [" + bl + "]"));
        return bl;
    }

    private boolean a(String string) {
        boolean bl = false;
        for (ClusterNodeInformation clusterNodeInformation : this.k.getAllNodesInformation()) {
            if (!clusterNodeInformation.getAnonymizedNodeIdentifier().equals(string)) continue;
            bl = true;
            break;
        }
        d.debug((Object)("Is node id [" + string + "] alive? [" + bl + "]"));
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(AttachmentToScan[] attachmentToScanArray) {
        boolean bl = this.g.c();
        boolean bl2 = this.g.d();
        String string = this.g.getScannerPath();
        String string2 = this.g.getScannerOption();
        boolean bl3 = this.g.e();
        boolean bl4 = this.g.g();
        for (AttachmentToScan attachmentToScan : attachmentToScanArray) {
            long l = attachmentToScan.getAttachmentId();
            int n = attachmentToScan.getVersion();
            long l2 = attachmentToScan.getAttachedToId();
            Date date = attachmentToScan.getCreationDate();
            d.info((Object)("Attachment id [" + l + "] version [" + n + "] attached to id [" + l2 + "] with entity id [" + attachmentToScan.getID() + "]"));
            Attachment attachment = this.h.a(l, n, date);
            d.debug((Object)("Retrieved attachment [" + attachment + "]"));
            if (attachment != null) {
                File file;
                block6: {
                    d.debug((Object)"Retrieved attachment is not null!");
                    String string3 = attachment.getFileName();
                    file = null;
                    try {
                        file = this.n.a(attachment);
                        if (!bl2) break block6;
                        this.a(attachment, attachmentToScan, file, string, string2, bl3, bl4);
                    }
                    catch (NullPointerException nullPointerException) {
                        block7: {
                            try {
                                d.error((Object)"NPE while getting attachment data", (Throwable)nullPointerException);
                                if (!bl) break block7;
                                String string4 = this.n.a(string3, attachment.getCreator(), true, bl3, bl4, this.g.h());
                                this.n.a(string4, l2, this.g.getVirusAlertActorUser());
                                this.h.a(bl3, l, n, date);
                            }
                            catch (Throwable throwable) {
                                AttachmentCheckerHelper.a(file);
                                throw throwable;
                            }
                        }
                        AttachmentCheckerHelper.a(file);
                    }
                }
                AttachmentCheckerHelper.a(file);
            }
            this.i.a(attachmentToScan);
            if (!this.f.isReadOnlyAccessModeEnabled()) continue;
            d.info((Object)"Read-only access mode enabled! Stopping job!");
            break;
        }
    }

    private void a(@NotNull Attachment attachment, AttachmentToScan attachmentToScan, File file, String string, String string2, boolean bl, boolean bl2) {
        String string3 = attachment.getFileName();
        if (file == null) {
            d.debug((Object)"Temp file is null!");
            return;
        }
        d.info((Object)("Scanning [" + string3 + "]"));
        ConfluenceUser confluenceUser = attachment.getCreator();
        long l = attachment.getId();
        try {
            String string4 = file.getCanonicalPath();
            Object[] objectArray = this.a(string, string2, string4, attachment);
            d.info((Object)("Executing [" + Arrays.toString(objectArray) + "]"));
            Process process = Runtime.getRuntime().exec((String[])objectArray);
            StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), "OUTPUT", true);
            StreamGobbler streamGobbler2 = new StreamGobbler(process.getErrorStream(), "ERROR", true);
            streamGobbler.start();
            streamGobbler2.start();
            int n = process.waitFor();
            d.info((Object)("Exit status code [" + n + "]"));
            if (attachment.getCreationDate() == null) {
                d.debug((Object)"Attachment creation date is null!");
                String string5 = this.n.a(string3, attachmentToScan.getVersion(), confluenceUser);
                this.n.a(string5, attachmentToScan.getAttachedToId(), this.g.getVirusAlertActorUser());
            }
            if (n != 0) {
                String string6;
                boolean bl3;
                boolean bl4;
                boolean bl5 = this.g.a(n, string);
                if (bl5) {
                    d.debug((Object)("Infected attachment [" + string3 + "] id [" + l + "] found"));
                    bl4 = this.g.e();
                    bl3 = this.g.f();
                    d.debug((Object)("Delete if infected? [" + bl4 + "]"));
                    d.debug((Object)("Email if infected? [" + bl3 + "]"));
                } else {
                    d.debug((Object)"Exit code is not virus code!");
                    bl4 = this.g.g();
                    bl3 = this.g.h();
                    d.debug((Object)("Delete if error? [" + bl4 + "]"));
                    d.debug((Object)("Email if error? [" + bl3 + "]"));
                }
                this.h.a(bl4, l, attachmentToScan.getVersion(), attachmentToScan.getCreationDate());
                if (bl3) {
                    string6 = this.a(string, string2, attachment, attachmentToScan);
                    d.debug((Object)("Manual scan command [" + string6 + "]"));
                    this.l.a(bl5, n, string3, string6, attachmentToScan.getAttachedToId(), attachment, this.m.getGlobalSettings().getBaseUrl());
                }
                string6 = this.n.a(string3, confluenceUser, bl5, bl, bl2, bl3);
                this.n.a(string6, attachmentToScan.getAttachedToId(), this.g.getVirusAlertActorUser());
            }
        }
        catch (IOException iOException) {
            d.error((Object)"Error executing process", (Throwable)iOException);
        }
        catch (InterruptedException interruptedException) {
            d.error((Object)"Process interrupted", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
    }

    private String[] a(String string, String string2, String string3, Attachment attachment) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        if (!string2.equals("")) {
            string2 = this.a(string2, attachment);
            String[] stringArray = string2.split(" ");
            arrayList.addAll(Arrays.asList(stringArray));
        }
        arrayList.add(string3);
        return arrayList.toArray(new String[0]);
    }

    @NotNull
    private String a(String string, @NotNull String string2, @NotNull Attachment attachment, @NotNull AttachmentToScan attachmentToScan) {
        d.debug((Object)"Get manual scan command");
        long l = attachmentToScan.getAttachedToId();
        long l2 = attachmentToScan.getAttachmentId();
        int n = attachment.getVersion();
        String string3 = this.h.a(attachment, l2, n, l);
        return string + " " + (string2.isEmpty() ? "" : this.a(string2, attachment) + " ") + string3;
    }

    @NotNull
    private String a(@NotNull String string, @NotNull Attachment attachment) {
        string = string.replace("${attachment.id}", attachment.getIdAsString());
        ConfluenceUser confluenceUser = attachment.getCreator();
        string = string.replace("${attachment.creator.name}", confluenceUser == null ? "Anonymous" : confluenceUser.getName());
        return string;
    }
}

