/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.config.xwork;

import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.utils.LicenseHelper;
import com.atlassian.confluence.pages.actions.SpaceToolsAction;
import com.atlassian.confluence.user.ConfluenceUser;
import org.apache.log4j.Logger;

public class SpaceQuotaManager
extends SpaceToolsAction {
    private static final Logger logger = Logger.getLogger((String)"com.akeles.plugins.acc.config.SpaceQuotaManager");
    private transient AttachmentCheckerConfig attachmentCheckerConfig;
    private transient LicenseHelper licenseHelper;
    private boolean isQuotaUsageViewable;
    private boolean hasViewPermission;

    public void setAttachmentCheckerConfig(AttachmentCheckerConfig attachmentCheckerConfig) {
        this.attachmentCheckerConfig = attachmentCheckerConfig;
    }

    public void setLicenseHelper(LicenseHelper licenseHelper) {
        this.licenseHelper = licenseHelper;
    }

    public String getQuotaUnit() {
        return this.attachmentCheckerConfig.getUnit();
    }

    public boolean getIsQuotaUsageViewable() {
        return this.isQuotaUsageViewable;
    }

    public boolean getHasViewPermission() {
        return this.hasViewPermission;
    }

    public String execute() {
        logger.debug((Object)("Loading Space Quota for space key [" + this.key + "]"));
        if (this.space == null) {
            logger.debug((Object)("Space not found [" + this.key + "]"));
            return "notfound";
        }
        if (this.licenseHelper.b()) {
            logger.debug((Object)"License is valid!");
            ConfluenceUser confluenceUser = this.getAuthenticatedUser();
            this.isQuotaUsageViewable = this.attachmentCheckerConfig.b(this.key);
            logger.debug((Object)("Is quota usage viewable? [" + this.isQuotaUsageViewable + "]"));
            this.hasViewPermission = this.attachmentCheckerConfig.a(confluenceUser, this.space);
            logger.debug((Object)("User [" + confluenceUser + "] has permission to view space quota? [" + this.hasViewPermission + "]"));
            return "success";
        }
        logger.debug((Object)"License is invalid!");
        return "unlicensed";
    }
}

