/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.config;

import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeGroup;
import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeLimit;
import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.akelesconsulting.confluence.plugins.ao.service.FileSizeLimitService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentCheckerConfig {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.config.AttachmentCheckerConfig");
    private static final String b = "whitelist";
    private static final String c = "blacklist";
    private static final String d = "enabled";
    private static final String e = "application/octet-stream";
    private static final String f = "application/x-msdownload";
    private static final String g = "application/x-dosexec";
    private static final String h = ".render";
    private static final String i = ".tfss";
    private static final String j = "jpg";
    private static final String k = "whitelist";
    private static final String l = "This file type is not allowed.";
    private static final String m = "The file size has exceeded the maximum size limit set for the file type.";
    private static final String n = "Insufficient quota available.";
    private static final String o = "MB";
    private static final int p = 90;
    private static final String q = "This space has exceeded 90% of the disk quota. Please housekeep the attachments or inform the Confluence admin to increase the quota.";
    private static final String r = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.";
    private static final String s = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions";
    private static final String t = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map";
    private static final String u = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set";
    private static final String v = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set";
    private static final String w = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.filterMode";
    private static final String x = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowProtected";
    private static final String y = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowEncrypted";
    private static final String z = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowTableSpreadsheetMacro";
    private static final String A = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.message";
    private static final String B = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeCheck";
    private static final String C = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeError";
    private static final String D = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.onAccessScanning";
    private static final String E = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerMode";
    private static final String F = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerPath";
    private static final String G = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerOption";
    private static final String H = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.autoDeleteMode";
    private static final String I = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfInfected";
    private static final String J = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.deleteIfError";
    private static final String K = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfError";
    private static final String L = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.groupToEmail";
    private static final String M = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusAlertActor";
    private static final String N = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanRunning";
    private static final String O = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanNodeId";
    private static final String P = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCheck";
    private static final String Q = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaError";
    private static final String R = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unit";
    private static final String S = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultStorage";
    private static final String T = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaAlertThreshold";
    private static final String U = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaAlertMessage";
    private static final String V = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowUsersToViewSpaceQuota";
    private static final String W = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndAmPm";
    private static final String X = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndHour";
    private static final String Y = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndMinute";
    private static final String Z = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartAmPm";
    private static final String aa = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartHour";
    private static final String ab = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartMinute";
    private static final String ac = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isJobRunning";
    private static final String ad = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isQuotaSetupCompleted";
    private static final String ae = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.enableQuotaCheckAfterSetup";
    private static final String af = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.trackLargeAttachment";
    private static final String ag = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.largeAttachmentSize";
    private static final long ah = 0xFA00000L;
    private static final String ai = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartHour";
    private static final String aj = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartMinute";
    private static final String ak = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartAmPm";
    private static final String al = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndHour";
    private static final String am = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndMinute";
    private static final String an = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndAmPm";
    private static final String ao = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobLastRun";
    private static final String ap = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanRunning";
    private static final String aq = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanCompleted";
    private static final String ar = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.loggingMode";
    private static final String as = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.attachmentLogGroup";
    private final Cache<String, Object> at;
    private final FileSizeLimitService au;
    private final GroupManager av;
    private final MimeTypes aw;
    private final PluginSettingsFactory ax;
    private final PermissionManager ay;
    private final SpaceInfoService az;
    private final Tika aA;
    private final UserAccessor aB;

    @Autowired
    public AttachmentCheckerConfig(@ComponentImport @NotNull CacheManager cacheManager, FileSizeLimitService fileSizeLimitService, @ComponentImport GroupManager groupManager, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport PermissionManager permissionManager, SpaceInfoService spaceInfoService, @ComponentImport UserAccessor userAccessor) {
        String string = AttachmentCheckerConfig.class.getName() + ".cache";
        CacheSettings cacheSettings = new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(1000).flushable().build();
        this.at = cacheManager.getCache(string, (CacheLoader)new AcConfigCacheLoader(), cacheSettings);
        this.av = groupManager;
        this.au = fileSizeLimitService;
        this.aw = MimeTypes.getDefaultMimeTypes();
        this.ax = pluginSettingsFactory;
        this.ay = permissionManager;
        this.az = (SpaceInfoService)Preconditions.checkNotNull((Object)spaceInfoService);
        this.aA = new Tika();
        this.aB = userAccessor;
    }

    public List<String> a(String string) {
        List<String> list;
        String string2 = this.c(string);
        if (string2.equalsIgnoreCase(f) || string2.equalsIgnoreCase(g)) {
            list = this.c(string, f);
            list.addAll(this.c(string, g));
        } else {
            list = this.c(string, string2);
        }
        return list;
    }

    private List<String> c(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            MimeType mimeType = this.aw.forName(string2);
            List list = mimeType.getExtensions();
            for (String string3 : list) {
                if (string3.equalsIgnoreCase(string)) continue;
                arrayList.add(string3);
            }
        }
        catch (MimeTypeException mimeTypeException) {
            a.debug((Object)mimeTypeException.getMessage());
        }
        return arrayList;
    }

    public String getExtensions() {
        return (String)this.at.get((Object)s);
    }

    public String getFilterMode() {
        return (String)this.at.get((Object)w);
    }

    public String getFileTypeErrorMessage() {
        return (String)this.at.get((Object)A);
    }

    public Map<String, List<String>> getExtensionsMap() {
        return (Map)this.at.get((Object)t);
    }

    public Set<String> getExtensionSet() {
        TreeSet treeSet = (TreeSet)this.at.get((Object)u);
        if (treeSet == null) {
            treeSet = new TreeSet();
        }
        return treeSet;
    }

    public Set<String> getMimeTypeSet() {
        TreeSet treeSet = (TreeSet)this.at.get((Object)v);
        if (treeSet == null) {
            treeSet = new TreeSet();
        }
        return treeSet;
    }

    public void a(String string, String string2, String string3) {
        PluginSettings pluginSettings = this.ax.createGlobalSettings();
        pluginSettings.put(w, (Object)string);
        this.at.remove((Object)w);
        a.debug((Object)("Updated filterMode [" + string + "]"));
        pluginSettings.put(s, (Object)string2);
        this.at.remove((Object)s);
        this.at.remove((Object)t);
        this.at.remove((Object)u);
        this.at.remove((Object)v);
        a.debug((Object)("Updated extensions [" + string2 + "]"));
        pluginSettings.put(A, (Object)string3);
        this.at.remove((Object)A);
        a.debug((Object)("Updated fileTypeErrorMessage (message) [" + string3 + "]"));
    }

    public void b(String string, String string2, String string3) {
        PluginSettings pluginSettings = this.ax.createGlobalSettings();
        pluginSettings.put(x, (Object)string);
        this.at.remove((Object)x);
        a.debug((Object)("Updated allowProtected [" + string + "]"));
        pluginSettings.put(y, (Object)string2);
        this.at.remove((Object)y);
        a.debug((Object)("Updated allowEncrypted [" + string2 + "]"));
        pluginSettings.put(z, (Object)string3);
        this.at.remove((Object)z);
        a.debug((Object)("Updated allowTableSpreadsheetMacro [" + string3 + "]"));
    }

    public String getAllowProtected() {
        return (String)this.at.get((Object)x);
    }

    public String getAllowEncrypted() {
        return (String)this.at.get((Object)y);
    }

    public String getAllowTableSpreadsheetMacro() {
        return (String)this.at.get((Object)z);
    }

    public boolean a() {
        return "on".equalsIgnoreCase(this.getAllowTableSpreadsheetMacro());
    }

    public boolean b() {
        return "on".equalsIgnoreCase(this.getFileSizeCheck());
    }

    public String getFileSizeCheck() {
        String string = (String)this.at.get((Object)B);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setFileSizeCheck(String string) {
        this.ax.createGlobalSettings().put(B, (Object)string);
        this.at.remove((Object)B);
        a.debug((Object)("Updated file size check [" + string + "]"));
    }

    public String getFileSizeErrorMessage() {
        return (String)this.at.get((Object)C);
    }

    public void setFileSizeErrorMessage(String string) {
        this.ax.createGlobalSettings().put(C, (Object)string);
        this.at.remove((Object)C);
        a.debug((Object)("Updated file size error message [" + string + "]"));
    }

    public boolean c() {
        return this.getMissingFileCheck().equalsIgnoreCase("on");
    }

    public String getMissingFileCheck() {
        String string = (String)this.at.get((Object)D);
        if (Boolean.TRUE.toString().equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setMissingFileCheck(String string) {
        this.ax.createGlobalSettings().put(D, (Object)string);
        this.at.remove((Object)D);
        a.debug((Object)("Updated missing file check [" + string + "]"));
    }

    public boolean d() {
        return this.getVirusScanning().equalsIgnoreCase("on");
    }

    public String getVirusScanning() {
        String string = (String)this.at.get((Object)E);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setVirusScanning(String string) {
        this.ax.createGlobalSettings().put(E, (Object)string);
        this.at.remove((Object)E);
        a.debug((Object)("Updated virus scanning [" + string + "]"));
    }

    public boolean a(int n, @NotNull String string) {
        boolean bl = true;
        if (!this.getScannerDetected().equalsIgnoreCase("unknown")) {
            bl = n == 1 && (string.contains("clamscan") || string.contains("clamdscan") || string.contains("fpscan")) || n == 3 && string.contains("savscan") || n == 13 && (string.contains("uvscan") || string.contains("scan.exe")) || n == 50 && (string.contains("ecls.exe") || string.contains("eset")) || n == 72 && string.contains("kesl-control");
        }
        a.debug((Object)("Is infected? [" + bl + "]"));
        return bl;
    }

    public String getScannerDetected() {
        String string = this.getScannerPath().toLowerCase();
        String string2 = string.contains("clamscan") || string.contains("clamdscan") ? "ClamAV" : (string.contains("ecls.exe") || string.contains("eset") ? "ESET" : (string.contains("fpscan") ? "F-PROT Antivirus" : (string.contains("kesl-control") ? "Kaspersky Endpoint Security for Linux" : (string.contains("savscan") ? "Sophos Anti-Virus" : (string.contains("uvscan") || string.contains("scan.exe") ? "McAfee VirusScan" : "unknown")))));
        return string2;
    }

    public String getScannerPath() {
        return (String)this.at.get((Object)F);
    }

    public void a(String string, String string2) {
        PluginSettings pluginSettings = this.ax.createGlobalSettings();
        pluginSettings.put(F, (Object)string);
        this.at.remove((Object)F);
        a.debug((Object)("Updated scannerPath [" + string + "]"));
        pluginSettings.put(G, (Object)string2);
        this.at.remove((Object)G);
        a.debug((Object)("Updated scannerOption [" + string2 + "]"));
    }

    public String getScannerOption() {
        return (String)this.at.get((Object)G);
    }

    public boolean e() {
        return this.getDeleteIfInfected().equalsIgnoreCase("on");
    }

    public String getDeleteIfInfected() {
        String string = (String)this.at.get((Object)H);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public boolean f() {
        return this.getEmailIfInfected().equalsIgnoreCase("on");
    }

    public String getEmailIfInfected() {
        return (String)this.at.get((Object)I);
    }

    public boolean g() {
        return this.getDeleteIfError().equalsIgnoreCase("on");
    }

    public String getDeleteIfError() {
        return (String)this.at.get((Object)J);
    }

    public boolean h() {
        return this.getEmailIfError().equalsIgnoreCase("on");
    }

    public String getEmailIfError() {
        return (String)this.at.get((Object)K);
    }

    public void a(String string, String string2, String string3, String string4) {
        PluginSettings pluginSettings = this.ax.createGlobalSettings();
        pluginSettings.put(H, (Object)string);
        this.at.remove((Object)H);
        a.debug((Object)("Updated deleteIfInfected (autoDeleteMode) [" + string + "]"));
        pluginSettings.put(I, (Object)string2);
        this.at.remove((Object)I);
        a.debug((Object)("Updated emailIfInfected [" + string2 + "]"));
        pluginSettings.put(J, (Object)string3);
        this.at.remove((Object)J);
        a.debug((Object)("Updated deleteIfError [" + string3 + "]"));
        pluginSettings.put(K, (Object)string4);
        this.at.remove((Object)K);
        a.debug((Object)("Updated emailIfError [" + string4 + "]"));
    }

    public String getGroupToEmail() {
        return (String)this.at.get((Object)L);
    }

    public void setGroupToEmail(String string) {
        this.ax.createGlobalSettings().put(L, (Object)string);
        this.at.remove((Object)L);
        a.debug((Object)("Updated group to email (Confluence Sysadmin Group) [" + string + "]"));
    }

    private String getVirusAlertActor() {
        return (String)this.at.get((Object)M);
    }

    public void setVirusAlertActor(String string) {
        this.ax.createGlobalSettings().put(M, (Object)string);
        this.at.remove((Object)M);
        a.debug((Object)("Updated virus alert actor [" + string + "]"));
    }

    public ConfluenceUser getVirusAlertActorUser() {
        ConfluenceUser confluenceUser = null;
        String string = this.getVirusAlertActor();
        if (!string.isEmpty()) {
            confluenceUser = this.aB.getUserByKey(new UserKey(string));
        }
        return confluenceUser;
    }

    public boolean getIsVirusScanRunning() {
        return Boolean.parseBoolean((String)this.at.get((Object)N));
    }

    public void setIsVirusScanRunning(boolean bl) {
        this.ax.createGlobalSettings().put(N, (Object)Boolean.toString(bl));
        this.at.remove((Object)N);
        a.debug((Object)("Updated is virus scan running? [" + bl + "]"));
    }

    public String getVirusScanNodeId() {
        return (String)this.at.get((Object)O);
    }

    public void setVirusScanNodeId(String string) {
        this.ax.createGlobalSettings().put(O, (Object)string);
        this.at.remove((Object)O);
        a.debug((Object)("Updated virus scan node id [" + string + "]"));
    }

    public boolean i() {
        boolean bl = this.getQuotaCheck().equalsIgnoreCase("on");
        a.debug((Object)("Is quota check enabled? [" + bl + "]"));
        return bl;
    }

    public String getQuotaCheck() {
        String string = (String)this.at.get((Object)P);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setQuotaCheck(String string) {
        this.ax.createGlobalSettings().put(P, (Object)string);
        this.at.remove((Object)P);
        a.debug((Object)("Updated quota check [" + string + "]"));
    }

    public String getQuotaErrorMessage() {
        return (String)this.at.get((Object)Q);
    }

    public String getUnit() {
        return (String)this.at.get((Object)R);
    }

    public long getDefaultQuotaAllocated() {
        Long l = (Long)this.at.get((Object)S);
        return l == null ? 0L : l;
    }

    public boolean j() {
        return this.getDefaultQuotaAllocated() == 0L;
    }

    public void setQuotaErrorMessage(String string) {
        this.ax.createGlobalSettings().put(Q, (Object)string);
        this.at.remove((Object)Q);
        a.debug((Object)("Updated quota error message [" + string + "]"));
    }

    public void b(String string, String string2) {
        PluginSettings pluginSettings = this.ax.createGlobalSettings();
        pluginSettings.put(S, (Object)string);
        this.at.remove((Object)S);
        a.debug((Object)("Updated defaultQuotaAllocated (defaultStorage) [" + string + "]"));
        pluginSettings.put(R, (Object)string2);
        this.at.remove((Object)R);
        a.debug((Object)("Updated defaultQuotaAllocatedUnit (unit) [" + string2 + "]"));
    }

    public int getQuotaAlertThreshold() {
        Integer n = (Integer)this.at.get((Object)T);
        return n == null ? 90 : n;
    }

    public String getQuotaAlertMessage() {
        return (String)this.at.get((Object)U);
    }

    public void b(int n, String string) {
        PluginSettings pluginSettings = this.ax.createGlobalSettings();
        pluginSettings.put(T, (Object)Integer.toString(n));
        this.at.remove((Object)T);
        a.debug((Object)("Updated quotaAlertThreshold [" + n + "]"));
        pluginSettings.put(U, (Object)string);
        this.at.remove((Object)U);
        a.debug((Object)("Updated quotaAlertMessage [" + string + "]"));
    }

    public boolean b(String string) {
        int n = this.az.getSpaceListSize();
        int n2 = this.az.getSpaceInfoListSize();
        a.debug((Object)("Num of Space [" + n + "]"));
        a.debug((Object)("Num of SpaceInfo [" + n2 + "]"));
        boolean bl = (this.i() || this.n() || n == n2) && this.az.a(string) != null;
        a.debug((Object)("Is quota usage viewable? [" + bl + "]"));
        return bl;
    }

    public boolean a(ConfluenceUser confluenceUser, Space space) {
        boolean bl = this.ay.isConfluenceAdministrator((User)confluenceUser) || this.ay.hasPermission((User)confluenceUser, Permission.ADMINISTER, (Object)space) || this.s() && this.ay.hasPermission((User)confluenceUser, Permission.VIEW, (Object)space);
        a.debug((Object)("User has permission to view space quota? [" + bl + "]"));
        return bl;
    }

    private boolean s() {
        return this.getAllowUsersToViewSpaceQuota().equalsIgnoreCase("on");
    }

    public String getAllowUsersToViewSpaceQuota() {
        return (String)this.at.get((Object)V);
    }

    public void setQuotaPermissions(String string) {
        this.ax.createGlobalSettings().put(V, (Object)string);
        this.at.remove((Object)V);
        a.debug((Object)("Updated allowUsersToViewSpaceQuota [" + string + "]"));
    }

    public Date getQuotaJobNextRunTime() {
        return DateHelper.a(this.getJobStartHour(), this.getJobStartMinute(), this.getJobStartAmPm());
    }

    public String getJobEndAmPm() {
        return (String)this.at.get((Object)W);
    }

    public String getJobEndHour() {
        return (String)this.at.get((Object)X);
    }

    public String getJobEndMinute() {
        return (String)this.at.get((Object)Y);
    }

    public String getJobStartAmPm() {
        return (String)this.at.get((Object)Z);
    }

    public String getJobStartHour() {
        return (String)this.at.get((Object)aa);
    }

    public String getJobStartMinute() {
        return (String)this.at.get((Object)ab);
    }

    private String getEnableQuotaCheckAfterSetup() {
        return (String)this.at.get((Object)ae);
    }

    private String getIsJobRunning() {
        return (String)this.at.get((Object)ac);
    }

    public boolean k() {
        return Boolean.parseBoolean(this.getEnableQuotaCheckAfterSetup());
    }

    public boolean l() {
        return Boolean.parseBoolean(this.getIsJobRunning());
    }

    public void a(String string, String string2, String string3, String string4, String string5, String string6) {
        PluginSettings pluginSettings = this.ax.createGlobalSettings();
        pluginSettings.put(aa, (Object)string);
        this.at.remove((Object)aa);
        a.debug((Object)("Updated calculateAttachmentJobStartHour (jobStartHour) [" + string + "]"));
        pluginSettings.put(ab, (Object)string2);
        this.at.remove((Object)ab);
        a.debug((Object)("Updated calculateAttachmentJobStartMinute (jobStartMinute) [" + string2 + "]"));
        pluginSettings.put(Z, (Object)string3);
        this.at.remove((Object)Z);
        a.debug((Object)("Updated calculateAttachmentJobStartAmPm (jobStartAmPm) [" + string3 + "]"));
        pluginSettings.put(X, (Object)string4);
        this.at.remove((Object)X);
        a.debug((Object)("Updated calculateAttachmentJobEndHour (jobEndHour) [" + string4 + "]"));
        pluginSettings.put(Y, (Object)string5);
        this.at.remove((Object)Y);
        a.debug((Object)("Updated calculateAttachmentJobEndMinute (jobEndMinute) [" + string5 + "]"));
        pluginSettings.put(W, (Object)string6);
        this.at.remove((Object)W);
        a.debug((Object)("Updated calculateAttachmentJobEndAmPm (jobEndAmPm) [" + string6 + "]"));
    }

    public void m() {
        this.ax.createGlobalSettings().put(ae, (Object)String.valueOf(this.i()));
        this.at.remove((Object)ae);
        a.debug((Object)("Updated enable quota check after setup [" + this.i() + "]"));
    }

    public void setIsJobRunning(boolean bl) {
        this.ax.createGlobalSettings().put(ac, (Object)String.valueOf(bl));
        this.at.remove((Object)ac);
        a.debug((Object)("Updated is job running [" + bl + "]"));
    }

    public boolean n() {
        boolean bl = Boolean.parseBoolean((String)this.at.get((Object)ad));
        a.debug((Object)("Is quota setup completed? [" + bl + "]"));
        return bl;
    }

    public void setIsQuotaSetupCompleted(boolean bl) {
        this.ax.createGlobalSettings().put(ad, (Object)Boolean.toString(bl));
        this.at.remove((Object)ad);
        a.debug((Object)("Updated isQuotaSetupCompleted [" + bl + "]"));
    }

    public boolean o() {
        return "on".equalsIgnoreCase(this.getTrackLargeAttachment());
    }

    public String getTrackLargeAttachment() {
        return (String)this.at.get((Object)af);
    }

    public void setTrackLargeAttachment(String string) {
        this.ax.createGlobalSettings().put(af, (Object)string);
        this.at.remove((Object)af);
        a.debug((Object)("Updated track large attachment [" + string + "]"));
    }

    public long getLargeAttachmentSize() {
        Long l = (Long)this.at.get((Object)ag);
        return l == null ? 0xFA00000L : l;
    }

    public void setLargeAttachmentSize(String string) {
        this.ax.createGlobalSettings().put(ag, (Object)string);
        this.at.remove((Object)ag);
        a.debug((Object)("Updated large attachment size [" + string + "]"));
    }

    public boolean p() {
        return Boolean.parseBoolean((String)this.at.get((Object)ap));
    }

    public void setIsMissingAttachmentScanRunning(boolean bl) {
        this.ax.createGlobalSettings().put(ap, (Object)Boolean.toString(bl));
        this.at.remove((Object)ap);
        a.debug((Object)("Updated isMissingAttachmentScanRunning [" + bl + "]"));
    }

    public boolean q() {
        return Boolean.parseBoolean((String)this.at.get((Object)aq));
    }

    public void setIsMissingAttachmentScanCompleted(boolean bl) {
        this.ax.createGlobalSettings().put(aq, (Object)Boolean.toString(bl));
        this.at.remove((Object)aq);
        a.debug((Object)("Updated isMissingAttachmentScanCompleted [" + bl + "]"));
    }

    public Long getMissingAttachmentScannerLastRun() {
        return (Long)this.at.get((Object)ao);
    }

    public void setMissingAttachmentScannerLastRun(long l) {
        this.ax.createGlobalSettings().put(ao, (Object)String.valueOf(l));
        this.at.remove((Object)ao);
        a.debug((Object)("Updated missingAttachmentJobLastRun [" + l + "]"));
    }

    public void b(String string, String string2, String string3, String string4, String string5, String string6) {
        PluginSettings pluginSettings = this.ax.createGlobalSettings();
        pluginSettings.put(ai, (Object)string);
        this.at.remove((Object)ai);
        a.debug((Object)("Updated missingAttachmentJobStartHour [" + string + "]"));
        pluginSettings.put(aj, (Object)string2);
        this.at.remove((Object)aj);
        a.debug((Object)("Updated missingAttachmentJobStartMinute [" + string2 + "]"));
        pluginSettings.put(ak, (Object)string3);
        this.at.remove((Object)ak);
        a.debug((Object)("Updated missingAttachmentJobStartAmPm [" + string3 + "]"));
        pluginSettings.put(al, (Object)string4);
        this.at.remove((Object)al);
        a.debug((Object)("Updated missingAttachmentJobEndHour [" + string4 + "]"));
        pluginSettings.put(am, (Object)string5);
        this.at.remove((Object)am);
        a.debug((Object)("Updated missingAttachmentJobEndMinute [" + string5 + "]"));
        pluginSettings.put(an, (Object)string6);
        this.at.remove((Object)an);
        a.debug((Object)("Updated missingAttachmentJobEndAmPm [" + string6 + "]"));
    }

    public String getMissingAttachmentScannerStartHour() {
        return (String)this.at.get((Object)ai);
    }

    public String getMissingAttachmentScannerStartMinute() {
        return (String)this.at.get((Object)aj);
    }

    public String getMissingAttachmentScannerStartAmPm() {
        return (String)this.at.get((Object)ak);
    }

    public String getMissingAttachmentScannerEndHour() {
        return (String)this.at.get((Object)al);
    }

    public String getMissingAttachmentScannerEndMinute() {
        return (String)this.at.get((Object)am);
    }

    public String getMissingAttachmentScannerEndAmPm() {
        return (String)this.at.get((Object)an);
    }

    public String c(@NotNull String string) {
        String string2;
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        if ((string2 = this.aA.detect(string)).equalsIgnoreCase(e)) {
            if (string.equalsIgnoreCase(".dcm")) {
                string2 = "application/dicom";
            } else if (string.equalsIgnoreCase(".hwp")) {
                string2 = "application/x-hwp-v5";
            } else if (string.equalsIgnoreCase(".xd")) {
                string2 = "application/vnd.adobe.sparkler.project+dcxucf";
            }
        }
        return string2;
    }

    public String getAttachmentLog() {
        return (String)this.at.get((Object)ar);
    }

    public void setAttachmentLog(String string) {
        this.ax.createGlobalSettings().put(ar, (Object)string);
        this.at.remove((Object)ar);
        a.debug((Object)("Updated attachment log [" + string + "]"));
    }

    public String getAttachmentLogGroup() {
        return (String)this.at.get((Object)as);
    }

    public void setAttachmentLogGroup(String string) {
        this.ax.createGlobalSettings().put(as, (Object)string);
        this.at.remove((Object)as);
        a.debug((Object)("Updated attachment log [" + string + "]"));
    }

    public boolean d(String string) {
        boolean bl;
        a.debug((Object)"*** Checking Extension ***");
        if (string != null) {
            boolean bl2 = bl = (string.equals(i) || string.equals(h)) && this.a();
            if (!bl) {
                String string2 = this.getFilterMode();
                boolean bl3 = string2.equalsIgnoreCase("whitelist");
                Set<String> set = this.getExtensionSet();
                bl = bl3 && set.contains(string) || !bl3 && !set.contains(string);
            }
        } else {
            bl = true;
        }
        a.debug((Object)("Is extension [" + string + "] valid? [" + bl + "]"));
        return bl;
    }

    public boolean a(String string, String string2, InputStream inputStream) {
        boolean bl;
        a.debug((Object)"*** Checking Mime Type ***");
        String string3 = this.getFilterMode();
        a.debug((Object)("Filter mode [" + string3 + "]"));
        a.debug((Object)("Mime type [" + string2 + "]"));
        String string4 = MediaType.parse((String)string2).getBaseType().toString();
        a.debug((Object)("Base mime type [" + string4 + "]"));
        boolean bl2 = string3.equalsIgnoreCase("whitelist");
        boolean bl3 = AttachmentCheckerHelper.a(string, string4, inputStream);
        if (string4.equals("application/x-tika-ooxml-protected")) {
            String string5 = this.getAllowProtected();
            a.debug((Object)("Allow protected [" + string5 + "]"));
            bl = string5.equals("on");
        } else if (bl3) {
            String string6 = this.getAllowEncrypted();
            a.debug((Object)("Allow encrypted [" + string6 + "]"));
            bl = string6.equals("on");
        } else if (string4.equals("application/vnd.apple.unknown.13")) {
            a.debug((Object)"Apple keynote/numbers/pages file detected");
            bl = this.a(bl2, string, ".key", ".numbers", ".pages");
        } else if (string4.equals("application/vnd.ms-spreadsheetml") || string4.equals("application/vnd.ms-wordml")) {
            a.debug((Object)"Office xml file detected");
            bl = this.a(bl2, string, ".xml");
        } else {
            boolean bl4 = bl = this.d(string, string4) && this.a() || this.b(string, string4, inputStream);
            if (!bl) {
                Set<String> set = this.getMimeTypeSet();
                bl = bl2 && set.contains(string4) || !bl2 && !set.contains(string4);
            }
        }
        a.debug((Object)("Is mime type [" + string4 + "] valid? [" + bl + "]"));
        return bl;
    }

    private boolean a(boolean bl, String string, String ... stringArray) {
        boolean bl2 = false;
        for (String string2 : stringArray) {
            boolean bl3 = bl2 = bl && string2.equals(string) || !bl && !this.getExtensionSet().contains(string2);
            if (bl2) break;
        }
        return bl2;
    }

    private boolean b(@NotNull String string, String string2, InputStream inputStream) {
        boolean bl = false;
        if (".ics".equals(string) && string2.equals("text/html")) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string3 = bufferedReader.readLine();
                a.debug((Object)("First line [" + string3 + "]"));
                bl = string3.equals("BEGIN:VCALENDAR");
            }
            catch (IOException iOException) {
                a.error((Object)"IOException while trying to read input stream", (Throwable)iOException);
            }
        }
        a.debug((Object)("Is calendar file with html? [" + bl + "]"));
        return bl;
    }

    private boolean d(String string, String string2) {
        boolean bl = false;
        if (string != null) {
            bl = (string.equals(i) || string.equals(h)) && string2.equals("text/plain") || string.equals(h) && string2.equals(e);
        }
        a.debug((Object)("Is Table Spreadsheet Macro attachments? [" + bl + "]"));
        return bl;
    }

    public boolean a(String string, long l, ConfluenceUser confluenceUser) {
        a.debug((Object)("User [" + confluenceUser + "]"));
        FileSizeLimit fileSizeLimit = null;
        if (confluenceUser != null) {
            List<FileSizeGroup> list = this.au.getFileSizeGroups();
            for (FileSizeGroup fileSizeGroup : list) {
                try {
                    Group group = this.av.getGroup(fileSizeGroup.getGroup());
                    if (!this.av.hasMembership(group, (User)confluenceUser)) continue;
                    a.debug((Object)("Get file size limit for [" + fileSizeGroup.getGroup() + "]"));
                    fileSizeLimit = this.au.b(fileSizeGroup.getID(), string);
                    break;
                }
                catch (EntityException entityException) {
                    a.error((Object)entityException.getMessage());
                }
            }
            if (fileSizeLimit == null) {
                a.debug((Object)"Get file size limit for any logged in user");
                fileSizeLimit = this.au.b(0, string);
            }
        } else {
            a.debug((Object)"Get file size limit for anonymous ");
            fileSizeLimit = this.au.b(-1, string);
        }
        if (fileSizeLimit != null) {
            long l2 = AttachmentCheckerHelper.a(fileSizeLimit.getSizeLimit(), fileSizeLimit.getSizeUnit());
            a.debug((Object)("Mime type [" + string + "] size limit [" + l2 + "] bytes"));
            a.debug((Object)("File size [" + l + "] bytes"));
            return l > l2;
        }
        return false;
    }

    public Map<String, String> a(@NotNull Space space, long l) {
        a.debug((Object)("Check quota for space [" + space.getKey() + "]"));
        a.debug((Object)("File size [" + l + "]"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SpaceInfo spaceInfo = this.az.a(space);
        long l2 = spaceInfo.getStorageAllocated();
        if (l2 == -1L) {
            l2 = this.getDefaultQuotaAllocated();
        }
        if (l2 == 0L) {
            a.debug((Object)"Quota allocated is unlimited");
            hashMap.put("storageInfo", "(Unlimited Storage)");
            hashMap.put("isSufficient", Boolean.toString(true));
        } else {
            long l3 = spaceInfo.getStorageUsed();
            long l4 = l2 - l3;
            a.debug((Object)("Quota allocated (bytes) [" + l2 + "]"));
            a.debug((Object)("Quota available (bytes) [" + l4 + "]"));
            hashMap.put("allocated", AttachmentCheckerHelper.a(l2, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("available", AttachmentCheckerHelper.a(l4, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("used", AttachmentCheckerHelper.a(l3, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("isSufficient", String.valueOf(l <= l4));
        }
        return hashMap;
    }

    private class AcConfigCacheLoader
    implements CacheLoader<String, Object> {
        private AcConfigCacheLoader() {
        }

        @Nonnull
        public Object a(@Nonnull String string) {
            Object object;
            String string2 = null;
            try {
                string2 = this.b(string);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            a.debug((Object)("Get value for key [" + string + "]"));
            switch (string) {
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions": {
                    object = this.a(string2, AttachmentCheckerConfig.j);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map": {
                    object = this.d(AttachmentCheckerConfig.t);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set": {
                    object = this.d(AttachmentCheckerConfig.u);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set": {
                    object = this.d(AttachmentCheckerConfig.v);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.filterMode": {
                    object = this.e(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowUsersToViewSpaceQuota": {
                    object = this.a(string2, "on");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowEncrypted": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowProtected": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowTableSpreadsheetMacro": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeCheck": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.onAccessScanning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerMode": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.autoDeleteMode": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfInfected": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.deleteIfError": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfError": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCheck": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.trackLargeAttachment": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.loggingMode": {
                    object = this.a(string2, "off");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.largeAttachmentSize": {
                    object = this.a(string2, 0xFA00000L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobLastRun": {
                    object = this.a(string2, 0L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.message": {
                    object = this.a(string2, AttachmentCheckerConfig.l);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeError": {
                    object = this.a(string2, AttachmentCheckerConfig.m);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.enableQuotaCheckAfterSetup": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isJobRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isQuotaSetupCompleted": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanCompleted": {
                    object = this.a(string2, Boolean.FALSE.toString());
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.groupToEmail": {
                    object = this.a(string2, "confluence-administrators");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerPath": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerOption": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusAlertActor": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanNodeId": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.attachmentLogGroup": {
                    object = this.a(string2, "");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaError": {
                    object = this.a(string2, AttachmentCheckerConfig.n);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultStorage": {
                    object = this.a(string2, 0L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unit": {
                    object = this.a(string2, AttachmentCheckerConfig.o);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaAlertThreshold": {
                    object = this.c(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaAlertMessage": {
                    object = this.a(string2, AttachmentCheckerConfig.q);
                    break;
                }
                default: {
                    object = "This should not happen";
                }
            }
            return object;
        }

        private String b(@NotNull String string) {
            switch (string) {
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set": {
                    return null;
                }
            }
            return AttachmentCheckerConfig.this.ax.createGlobalSettings().get(string).toString();
        }

        @NotNull
        private String a(String string, String string2) {
            if (string == null || string.trim().isEmpty()) {
                string = string2;
            }
            a.debug((Object)("String value [" + string + "]"));
            return string;
        }

        private int c(String string) {
            int n;
            if (string == null || string.isEmpty()) {
                n = 90;
            } else {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 90;
                }
            }
            a.debug((Object)("int value [" + n + "]"));
            return n;
        }

        private Object d(String string) {
            String string2 = (String)AttachmentCheckerConfig.this.at.get((Object)AttachmentCheckerConfig.s);
            HashMap<String, List> hashMap = new HashMap<String, List>();
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            if (string2 != null && string2.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                while (stringTokenizer.hasMoreElements()) {
                    List list;
                    String string3 = (String)stringTokenizer.nextElement();
                    if (!string3.startsWith(".")) {
                        string3 = ".".concat(string3);
                    }
                    a.debug((Object)("Adding extension [" + string3 + "]"));
                    treeSet.add(string3);
                    String string4 = AttachmentCheckerConfig.this.c(string3);
                    if (string4.equalsIgnoreCase(AttachmentCheckerConfig.f) || string4.equalsIgnoreCase(AttachmentCheckerConfig.g)) {
                        treeSet2.add(AttachmentCheckerConfig.f);
                        treeSet2.add(AttachmentCheckerConfig.g);
                        a.debug((Object)("Adding mime type [application/x-msdownload] for [" + string3 + "]"));
                        a.debug((Object)("Adding mime type [application/x-dosexec] for [" + string3 + "]"));
                        list = AttachmentCheckerConfig.this.c(string3, AttachmentCheckerConfig.g);
                        list.addAll(AttachmentCheckerConfig.this.c(string3, AttachmentCheckerConfig.f));
                    } else {
                        treeSet2.add(string4);
                        a.debug((Object)("Adding mime type [" + string4 + "] for [" + string3 + "]"));
                        list = AttachmentCheckerConfig.this.c(string3, string4);
                    }
                    treeSet.addAll(list);
                    hashMap.put(string3, list);
                }
            }
            if (string.equalsIgnoreCase(AttachmentCheckerConfig.t)) {
                return hashMap;
            }
            if (string.equalsIgnoreCase(AttachmentCheckerConfig.u)) {
                return treeSet;
            }
            return treeSet2;
        }

        private String e(String string) {
            if (string == null || !string.equalsIgnoreCase(AttachmentCheckerConfig.c) && !string.equalsIgnoreCase("whitelist")) {
                string = "whitelist";
            }
            a.debug((Object)("Filter mode [" + string + "]"));
            return string.toLowerCase();
        }

        private Long a(String string, long l) {
            long l2;
            if (string == null || string.isEmpty()) {
                string = String.valueOf(l);
            }
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = l;
            }
            a.debug((Object)("Long value [" + string + "]"));
            return l2;
        }

        @Nonnull
        public /* synthetic */ Object load(@Nonnull Object object) {
            return this.a((String)object);
        }
    }
}

