/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest.beans;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;

@XmlRootElement
public class SpaceQuotaBean
implements Serializable {
    private static final Logger logger = Logger.getLogger((String)"com.akeles.plugins.acc.rest.SpaceQuotaBean");
    @XmlElement
    private final String spaceKey;
    @XmlElement
    private final String quotaUnit;
    @XmlElement
    private final String quotaAllocated;
    @XmlElement
    private final String quotaUsed;
    @XmlElement
    private final String quotaAvailable;
    @XmlElement
    private String quotaUsage;
    @XmlElement
    private String quotaUsageColour;
    @XmlElement
    private final boolean isQuotaDefault;
    @XmlElement
    private final boolean isQuotaUnlimited;

    public SpaceQuotaBean(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) {
        this.spaceKey = string;
        this.quotaUnit = string2;
        this.quotaAllocated = string3;
        this.quotaUsed = string4;
        this.quotaAvailable = string5;
        this.isQuotaDefault = bl;
        this.isQuotaUnlimited = bl2;
        this.quotaUsageColour = "green";
    }

    public void setQuotaUsage(long l, long l2, int n) {
        logger.debug((Object)"Calculating quota usage");
        BigDecimal bigDecimal = BigDecimal.valueOf(100L);
        try {
            logger.debug((Object)("Bytes allocated [" + l + "]"));
            logger.debug((Object)("Bytes used [" + l2 + "]"));
            BigDecimal bigDecimal2 = new BigDecimal(l2).multiply(bigDecimal).divide(new BigDecimal(l), 1, RoundingMode.HALF_UP);
            this.quotaUsage = bigDecimal2.toPlainString();
            logger.debug((Object)("Quota usage (%) [" + this.quotaUsage + "]"));
            if (bigDecimal2.compareTo(bigDecimal) >= 0) {
                this.quotaUsageColour = "red";
            } else if (n > 0 && bigDecimal2.compareTo(BigDecimal.valueOf(n)) >= 0) {
                this.quotaUsageColour = "orange";
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.debug((Object)"Error calculating percentage", (Throwable)numberFormatException);
        }
    }

    public String getQuotaUsageColour() {
        return this.quotaUsageColour;
    }

    public boolean getIsQuotaUnlimited() {
        return this.isQuotaUnlimited;
    }

    public String toString() {
        return "SpaceQuotaBean {spaceKey='" + this.spaceKey + '\'' + ", quotaUnit='" + this.quotaUnit + '\'' + ", quotaAllocated='" + this.quotaAllocated + '\'' + ", quotaUsed='" + this.quotaUsed + '\'' + ", quotaAvailable='" + this.quotaAvailable + '\'' + ", quotaUsage='" + this.quotaUsage + '\'' + ", quotaUsageColour='" + this.quotaUsageColour + '\'' + ", isQuotaDefault=" + this.isQuotaDefault + ", isQuotaUnlimited=" + this.isQuotaUnlimited + '}';
    }
}

