/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceAttachmentCountBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceQuotaAlertBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceQuotaBean;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.QuotaHelper;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Path(value="/space")
public class SpaceQuotaResource {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.rest.SpaceQuotaResource");
    private static final String b = "com.akeles.acc.error.noViewPermission";
    private static final String c = "com.akeles.acc.spaceQuota.noEditPermission";
    private static final String d = "com.akeles.acc.spaceQuota.notViewable";
    private final AttachmentCheckerConfig e;
    private final AttachmentManager f;
    private final I18nResolver g;
    private final PageManager h;
    private final PermissionManager i;
    private final QuotaHelper j;
    private final SpaceInfoService k;
    private final SpaceManager l;

    public SpaceQuotaResource(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport AttachmentManager attachmentManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport PageManager pageManager, @ComponentImport PermissionManager permissionManager, QuotaHelper quotaHelper, SpaceInfoService spaceInfoService, @ComponentImport SpaceManager spaceManager) {
        this.e = attachmentCheckerConfig;
        this.f = attachmentManager;
        this.g = i18nResolver;
        this.h = pageManager;
        this.i = permissionManager;
        this.j = quotaHelper;
        this.k = spaceInfoService;
        this.l = spaceManager;
    }

    @GET
    @AnonymousAllowed
    @Path(value="/{spaceKey}/status")
    @Produces(value={"application/json"})
    public Response a(@PathParam(value="spaceKey") String string) {
        String string2;
        String string3;
        a.debug((Object)("Get quota status for space [" + string + "]"));
        if (!this.e.k()) {
            a.debug((Object)"Space quota not viewable, no alert required");
            return Response.noContent().build();
        }
        SpaceQuotaBean spaceQuotaBean = this.j.a(string);
        if (spaceQuotaBean.getIsQuotaUnlimited() || spaceQuotaBean.getQuotaUsageColour().equals("green")) {
            a.debug((Object)"Space quota threshold not reached, no alert required");
            return Response.noContent().build();
        }
        if (spaceQuotaBean.getQuotaUsageColour().equals("orange")) {
            string3 = "warning";
            string2 = this.e.getQuotaAlertMessage();
        } else {
            string3 = "error";
            string2 = this.e.getQuotaErrorMessage();
        }
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        boolean bl = this.e.a(confluenceUser, this.l.getSpace(string));
        a.debug((Object)("User [" + confluenceUser + "] has permission to view space quota? [" + bl + "]"));
        SpaceQuotaAlertBean spaceQuotaAlertBean = new SpaceQuotaAlertBean(string3, string2, bl);
        a.debug((Object)spaceQuotaAlertBean.toString());
        return Response.ok((Object)spaceQuotaAlertBean).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="/{spaceKey}/quota")
    @Produces(value={"application/json"})
    public Response b(@PathParam(value="spaceKey") String string) {
        a.debug((Object)("Get quota for space [" + string + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.e.a(confluenceUser, this.l.getSpace(string))) {
            a.debug((Object)("[" + confluenceUser + "] does not have permission to get quota for space [" + string + "]"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.g.getText(b)).build();
        }
        if (!this.e.k()) {
            a.debug((Object)"Space quota not viewable, unable to get space quota");
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.g.getText(d)).build();
        }
        SpaceQuotaBean spaceQuotaBean = this.j.a(string);
        return Response.ok((Object)spaceQuotaBean).build();
    }

    @POST
    @Path(value="/{spaceKey}/quota")
    @Produces(value={"application/json"})
    public Response a(@PathParam(value="spaceKey") String string, @QueryParam(value="quotaAllocated") String string2) {
        a.debug((Object)("Set quota for space [" + string + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.i.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to set quota for space [" + string + "]"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.g.getText(c)).build();
        }
        if (!this.e.k()) {
            a.debug((Object)"Space quota not viewable, unable to set space quota");
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.g.getText(d)).build();
        }
        a.debug((Object)("New quota allocated [" + string2 + "]"));
        String string3 = this.e.getUnit();
        long l = -1L;
        if (!StringUtils.isEmpty((CharSequence)string2)) {
            string2 = AttachmentCheckerHelper.c(string2);
            l = Long.parseLong(AttachmentCheckerHelper.a(string2, string3));
        }
        this.k.a(string, l);
        SpaceQuotaBean spaceQuotaBean = this.j.a(string);
        return Response.ok((Object)spaceQuotaBean).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="/{spaceKey}/attachments")
    @Produces(value={"application/json"})
    public Response c(@PathParam(value="spaceKey") String string) {
        a.debug((Object)("Get attachments count for space [" + string + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.e.a(confluenceUser, this.l.getSpace(string))) {
            a.debug((Object)("[" + confluenceUser + "] does not have permission to get attachments count for space [" + string + "]"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.g.getText(b)).build();
        }
        int n = 0;
        int n2 = 0;
        Space space = this.l.getSpace(string);
        if (space != null) {
            for (Long l : this.h.getPageIds(space)) {
                ContentEntityObject contentEntityObject = this.h.getById(l.longValue());
                if (contentEntityObject == null) continue;
                n += this.f.getAllVersionsOfAttachments(contentEntityObject).size();
                n2 += this.f.countLatestVersionsOfAttachments(contentEntityObject);
            }
        }
        SpaceAttachmentCountBean spaceAttachmentCountBean = new SpaceAttachmentCountBean(n, n2);
        a.debug((Object)spaceAttachmentCountBean.toString());
        return Response.ok((Object)spaceAttachmentCountBean).build();
    }
}

