/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.entity.AttachmentLogs;
import com.akelesconsulting.confluence.plugins.ao.service.AttachmentLogsService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceFilterModeService;
import com.akelesconsulting.confluence.plugins.ao.service.SpacePermissionService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/config")
public class AttachmentCheckerConfigRestResource {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.rest.AttachmentCheckerConfigRestResource");
    private final AttachmentCheckerConfig b;
    private final PermissionManager c;
    private final UserAccessor d;
    private final SpaceFilterModeService e;
    private final SpacePermissionService f;
    private final AttachmentLogsService g;
    private final SpacePermissionManager h;
    private final PageManager i;
    private final SpaceManager j;

    public AttachmentCheckerConfigRestResource(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport PermissionManager permissionManager, @ComponentImport UserAccessor userAccessor, SpacePermissionService spacePermissionService, SpaceFilterModeService spaceFilterModeService, AttachmentLogsService attachmentLogsService, PageManager pageManager, @ComponentImport SpacePermissionManager spacePermissionManager, @ComponentImport SpaceManager spaceManager) {
        this.b = attachmentCheckerConfig;
        this.c = permissionManager;
        this.d = userAccessor;
        this.f = spacePermissionService;
        this.e = spaceFilterModeService;
        this.g = attachmentLogsService;
        this.i = pageManager;
        this.h = spacePermissionManager;
        this.j = spaceManager;
    }

    @GET
    @Path(value="/extensions")
    @Produces(value={"application/json"})
    public Response getExtensionsMapJson() {
        a.debug((Object)"Get extensions map json...");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        a.debug((Object)("Logged in user [" + confluenceUser + "]"));
        if (this.c.isConfluenceAdministrator((User)confluenceUser)) {
            Map<String, List<String>> map = this.b.getExtensionsMap();
            JSONObject jSONObject = new JSONObject();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                try {
                    jSONObject.put(entry.getKey(), (Collection)entry.getValue());
                }
                catch (JSONException jSONException) {
                    a.error((Object)"JSONException while putting (extension, associated) into JSONObject", (Throwable)jSONException);
                }
            }
            return Response.ok((Object)jSONObject.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"You are not authorised to view this.").build();
    }

    @GET
    @Path(value="/scanner")
    @Produces(value={"text/plain"})
    public Response getScannerDetected() {
        String string = this.b.getScannerDetected();
        a.debug((Object)("Scanner detected [" + string + "]"));
        return Response.ok((Object)string).build();
    }

    @GET
    @Path(value="/getUsers")
    @Produces(value={"application/json"})
    public Response getUserPicker() {
        JSONArray jSONArray = new JSONArray();
        try {
            Pager pager = this.d.getUserNames();
            for (String string : pager.getCurrentPage()) {
                ConfluenceUser confluenceUser = this.d.getUserByName(string);
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("value", (Object)confluenceUser.getKey());
                jSONObject.put("label", (Object)StringEscapeUtils.escapeHtml((String)confluenceUser.getFullName()));
                jSONArray.put((Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            a.error((Object)"Error putting values to JSON Object", (Throwable)jSONException);
        }
        return Response.ok((Object)jSONArray.toString()).build();
    }

    @GET
    @Path(value="/getGroups")
    @Produces(value={"application/json"})
    public Response getGroupPicker() {
        JSONArray jSONArray = new JSONArray();
        try {
            List list = this.d.getGroupsAsList();
            for (Group group : list) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("value", (Object)StringEscapeUtils.escapeHtml((String)group.getName()));
                jSONObject.put("label", (Object)StringEscapeUtils.escapeHtml((String)group.getName()));
                jSONArray.put((Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            a.error((Object)"Error putting values to JSON Object", (Throwable)jSONException);
        }
        return Response.ok((Object)jSONArray.toString()).build();
    }

    @GET
    @Path(value="/attachmentLogs/{spaceKey}")
    public Response a(@PathParam(value="spaceKey") String string) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        Space space = this.j.getSpace(string);
        this.h.hasPermission("ADMINISTER_SPACE_PERMISSION", space, (User)confluenceUser);
        if (this.c.isConfluenceAdministrator((User)confluenceUser) || this.h.hasPermission("ADMINISTER_SPACE_PERMISSION", space, (User)confluenceUser)) {
            JSONArray jSONArray = new JSONArray();
            AttachmentLogs[] attachmentLogsArray = this.g.a(string);
            try {
                for (AttachmentLogs attachmentLogs : attachmentLogsArray) {
                    JSONObject jSONObject = new JSONObject();
                    String string2 = "Page not found";
                    Page page = this.i.getPage(Long.parseLong(attachmentLogs.getPageId()));
                    if (page != null) {
                        string2 = page.getTitle();
                    }
                    jSONObject.put("Page", (Object)string2);
                    jSONObject.put("Attachment", (Object)attachmentLogs.getAttachmentId());
                    jSONObject.put("User", (Object)this.f.b(attachmentLogs.getUserKey()));
                    jSONObject.put("Date Time", (Object)attachmentLogs.getDownloadTime());
                    jSONArray.put((Object)jSONObject);
                }
            }
            catch (JSONException jSONException) {
                a.error((Object)"JSON Error", (Throwable)jSONException);
            }
            return Response.ok((Object)jSONArray.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"You are not authorised to view this").build();
    }

    @POST
    @Path(value="/attachmentLogs/purge/{spaceKey}")
    public Response b(@PathParam(value="spaceKey") String string) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        Space space = this.j.getSpace(string);
        if (this.c.isConfluenceAdministrator((User)confluenceUser) || this.h.hasPermission("ADMINISTER_SPACE_PERMISSION", space, (User)confluenceUser)) {
            this.g.b(string);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"You are not authorised to perform this action").build();
    }

    @GET
    @Path(value="/isValid/{spaceKey}")
    @Produces(value={"application/json"})
    public Response c(@PathParam(value="spaceKey") String string) {
        boolean bl = true;
        JSONObject jSONObject = new JSONObject();
        try {
            String string2 = this.e.a(string);
            if (string2.equals("denylist") && this.f.c(string) || string2.equals("allowlist") && !this.f.c(string)) {
                bl = false;
            }
            jSONObject.put("isValid", bl);
            a.debug((Object)("User has permission [" + bl + "]"));
        }
        catch (JSONException jSONException) {
            a.error((Object)"Error putting values to JSON Object", (Throwable)jSONException);
        }
        return Response.ok((Object)jSONObject.toString()).build();
    }
}

