/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.ao.service;

import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceInfoService {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.service.SpaceInfoService");
    private final ActiveObjects b;
    private final PageManager c;
    private final SpaceManager d;
    private final TransactionTemplate e;

    @Autowired
    public SpaceInfoService(@ComponentImport ActiveObjects activeObjects, @ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager, @ComponentImport TransactionTemplate transactionTemplate) {
        this.b = (ActiveObjects)Preconditions.checkNotNull((Object)activeObjects);
        this.c = pageManager;
        this.d = spaceManager;
        this.e = transactionTemplate;
    }

    public SpaceInfo a(String string) {
        return (SpaceInfo)this.b.get(SpaceInfo.class, (Object)string);
    }

    public SpaceInfo b(String string) {
        Space space;
        SpaceInfo spaceInfo = this.a(string);
        if (spaceInfo == null && (space = this.d.getSpace(string)) != null) {
            long l = this.b(space);
            spaceInfo = this.b(string, l);
        }
        return spaceInfo;
    }

    public SpaceInfo a(Space space) {
        String string = space.getKey();
        SpaceInfo spaceInfo = this.a(string);
        if (spaceInfo == null) {
            long l = this.b(space);
            spaceInfo = this.b(string, l);
        }
        return spaceInfo;
    }

    private SpaceInfo b(String string, long l) {
        a.debug((Object)("*** Create SpaceInfo [" + string + "] ***"));
        SpaceInfo spaceInfo = (SpaceInfo)this.e.execute(() -> (SpaceInfo)this.b.create(SpaceInfo.class, new DBParam[]{new DBParam("SPACE_KEY", (Object)string), new DBParam("STORAGE_ALLOCATED", (Object)-1L), new DBParam("STORAGE_USED", (Object)l)}));
        a.debug((Object)"SpaceInfo created");
        return spaceInfo;
    }

    public List<Space> getSpaceList() {
        SpacesQuery spacesQuery = SpacesQuery.newQuery().sortBy("key").build();
        ListBuilder listBuilder = this.d.getSpaces(spacesQuery);
        return listBuilder.getRange(0, listBuilder.getAvailableSize() - 1);
    }

    public int getSpaceInfoListSize() {
        return this.b.count(SpaceInfo.class, Query.select().where("STORAGE_USED != ?", new Object[]{-1L}));
    }

    public int getSpaceListSize() {
        SpacesQuery spacesQuery = SpacesQuery.newQuery().build();
        return this.d.getSpaces(spacesQuery).getAvailableSize();
    }

    public void a(String string, long l) {
        a.debug((Object)"*** Update quota allocated ***");
        a.debug((Object)("Space key [" + string + "]"));
        SpaceInfo spaceInfo = this.b(string);
        this.e.execute(() -> {
            spaceInfo.setStorageAllocated(l);
            spaceInfo.save();
            return null;
        });
        a.debug((Object)("Updated to [" + spaceInfo.getStorageAllocated() + "] bytes allocated"));
    }

    public void a(String string, long l, boolean bl) {
        a.debug((Object)"*** Update quota used ***");
        a.debug((Object)("Space key [" + string + "]"));
        SpaceInfo spaceInfo = this.a(string);
        if (spaceInfo != null) {
            long l2 = spaceInfo.getStorageUsed();
            a.debug((Object)("Current [" + l2 + "] bytes"));
            if (l2 == -1L) {
                a.debug((Object)("Quota used for space [" + string + "] has been purged, skip update"));
                return;
            }
            long l3 = bl ? l2 - l : l2 + l;
            this.e.execute(() -> {
                spaceInfo.setStorageUsed(l3);
                spaceInfo.save();
                return null;
            });
            a.debug((Object)("Updated to [" + spaceInfo.getStorageUsed() + "] bytes used"));
        }
    }

    public void a() {
        SpaceInfo[] spaceInfoArray;
        a.debug((Object)"*** Purge usage ***");
        for (SpaceInfo spaceInfo : spaceInfoArray = (SpaceInfo[])this.b.find(SpaceInfo.class)) {
            this.e.execute(() -> {
                spaceInfo.setStorageUsed(-1L);
                spaceInfo.save();
                return null;
            });
        }
        a.debug((Object)"All SpaceInfo's storage used purged");
    }

    public void c(String string) {
        a.debug((Object)("*** Delete SpaceInfo [" + string + "] ***"));
        SpaceInfo spaceInfo = this.a(string);
        if (spaceInfo != null) {
            this.e.execute(() -> {
                this.b.delete(new RawEntity[]{spaceInfo});
                return null;
            });
            a.debug((Object)"SpaceInfo deleted");
        }
    }

    public void b() {
        SpaceInfo[] spaceInfoArray;
        for (SpaceInfo spaceInfo : spaceInfoArray = (SpaceInfo[])this.b.find(SpaceInfo.class)) {
            String string = spaceInfo.getSpaceKey();
            if (this.d.getSpace(string) != null) continue;
            a.debug((Object)("Space [" + string + "] not found, deleting SpaceInfo."));
            this.e.execute(() -> {
                this.b.delete(new RawEntity[]{spaceInfo});
                return null;
            });
        }
    }

    public void a(SpaceInfo spaceInfo) {
        Space space = this.d.getSpace(spaceInfo.getSpaceKey());
        if (space != null) {
            long l = this.b(space);
            this.e.execute(() -> {
                spaceInfo.setStorageUsed(l);
                spaceInfo.save();
                return null;
            });
        }
    }

    private long b(Space space) {
        a.debug((Object)("*** Calculate Space [" + space.getKey() + "]'s attachments ***"));
        Collection collection = this.c.getPageIds(space);
        long l = 0L;
        for (Long l2 : collection) {
            ContentEntityObject contentEntityObject = this.c.getById(l2.longValue());
            if (contentEntityObject == null) continue;
            List list = contentEntityObject.getAttachments();
            for (Attachment attachment : list) {
                l += attachment.getFileSize();
            }
        }
        a.debug((Object)("Total bytes [" + l + "]"));
        return l;
    }
}

