/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.config.xwork;

import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.config.beans.SpaceInfoBean;
import com.akelesconsulting.confluence.plugins.scheduler.JobScheduler;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.akelesconsulting.confluence.plugins.utils.LicenseHelper;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class QuotaSummaryManager
extends ConfluenceActionSupport {
    private static final Logger logger = Logger.getLogger((String)"com.akeles.plugins.acc.config.QuotaSummaryManager");
    private static final int NUM_OF_SPACE_PER_PAGE = 50;
    private static final String JOB_NO_END_TIME = "0";
    private transient AccessModeCompatService accessModeCompatService;
    private transient AttachmentCheckerConfig attachmentCheckerConfig;
    private transient DateHelper dateHelper;
    private transient JobScheduler jobScheduler;
    private transient LicenseHelper licenseHelper;
    private transient SpaceInfoService spaceInfoService;
    private transient SpaceManager spaceManager;
    private transient TransactionTemplate transactionTemplate;
    private boolean isReadOnlyAccessModeEnabled;
    private String quotaCheck;
    private String quotaAllocated;
    private String quotaUnit;
    private long defaultQuotaAllocated;
    private String queryString;
    private String filterAllocation;
    private String filterUsage;
    private List<String> filterList;
    private int currentPage;
    private int numOfPage;
    private int numOfSpace;
    private int numOfSpaceInfo;
    private List<SpaceInfoBean> spaceInfoList;
    private String spaceKey;
    private String jobStartHour;
    private String jobStartMinute;
    private String jobStartAmPm;
    private String jobEndHour;
    private String jobEndMinute;
    private String jobEndAmPm;
    private String upcomingJobRun;

    public void setAccessModeCompatService(AccessModeCompatService accessModeCompatService) {
        this.accessModeCompatService = accessModeCompatService;
    }

    public void setAttachmentCheckerConfig(AttachmentCheckerConfig attachmentCheckerConfig) {
        this.attachmentCheckerConfig = attachmentCheckerConfig;
    }

    public void setDateHelper(DateHelper dateHelper) {
        this.dateHelper = dateHelper;
    }

    public void setJobScheduler(@ComponentImport JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    public void setSpaceInfoService(SpaceInfoService spaceInfoService) {
        this.spaceInfoService = spaceInfoService;
    }

    public void setLicenseHelper(LicenseHelper licenseHelper) {
        this.licenseHelper = licenseHelper;
    }

    public void setSpaceManager(@ComponentImport SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setTransactionTemplate(@ComponentImport TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public String getBaseUrl() {
        return this.getGlobalSettings().getBaseUrl();
    }

    public String getQuotaCheck() {
        return this.quotaCheck;
    }

    @ParameterSafe
    public void setQuotaCheck(String string) {
        this.quotaCheck = string;
    }

    public String getQuotaAllocated() {
        return this.quotaAllocated;
    }

    @ParameterSafe
    public void setQuotaAllocated(String string) {
        this.quotaAllocated = string;
    }

    public long getQuotaDefaultCode() {
        return -1L;
    }

    public long getQuotaUnlimitedCode() {
        return 0L;
    }

    public String getQuotaUnit() {
        return this.quotaUnit;
    }

    @ParameterSafe
    public void setQuotaUnit(String string) {
        this.quotaUnit = string;
    }

    public boolean getIsDefaultQuotaUnlimited() {
        return this.attachmentCheckerConfig.j();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getFilterAllocation() {
        return this.filterAllocation;
    }

    public String getFilterAllocationDisplayName() {
        String string = this.filterList.contains("custom") ? this.getText("com.akeles.acc.quota.summary.allocation.custom") : (this.filterList.contains("default") ? this.getText("default.name") : this.getText("com.akeles.acc.config.common.all"));
        return string;
    }

    public boolean getIsFilterAllocationCustom() {
        return this.filterList.contains("custom");
    }

    public boolean getIsFilterAllocationDefault() {
        return this.filterList.contains("default");
    }

    public String getFilterUsage() {
        return this.filterUsage;
    }

    public String getFilterUsageDisplayName() {
        String string = this.filterList.contains(JOB_NO_END_TIME) ? this.getText("com.akeles.acc.quota.summary.usage.empty") : (this.filterList.contains("101") ? this.getText("com.akeles.acc.quota.summary.usage.exceeded") : this.getText("com.akeles.acc.config.common.all"));
        return string;
    }

    public boolean getIsFilterUsageEmpty() {
        return this.filterList.contains(JOB_NO_END_TIME);
    }

    public boolean getIsFilterUsageExceeded() {
        return this.filterList.contains("101");
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getNumOfPage() {
        return this.numOfPage;
    }

    public int getNumOfSpace() {
        return this.numOfSpace;
    }

    public int getNumOfSpaceInfo() {
        return this.numOfSpaceInfo;
    }

    public int getNumOfSpacePerPage() {
        return 50;
    }

    public List<SpaceInfoBean> getSpaceInfoList() {
        return this.spaceInfoList;
    }

    @ParameterSafe
    public void setSpaceKey(String string) {
        this.spaceKey = string;
    }

    public String getSpaceName(String string) {
        String string2 = "";
        Space space = this.spaceManager.getSpace(string);
        if (space != null) {
            string2 = space.getName();
        }
        return string2;
    }

    public String formatSpaceKey(String string) {
        return string == null ? "" : string.replace("~", "-");
    }

    public boolean isQuotaDefault(long l) {
        return l == -1L;
    }

    public boolean isQuotaUnlimited(long l) {
        if (l == -1L) {
            l = this.defaultQuotaAllocated;
        }
        return l == 0L;
    }

    public String bytesToUnit(long l, boolean bl) {
        if (this.isQuotaDefault(l) && !bl) {
            l = this.defaultQuotaAllocated;
        }
        String string = this.isQuotaUnlimited(l) && !bl ? this.getText("com.akeles.acc.config.common.unlimited") : AttachmentCheckerHelper.a(l, this.quotaUnit, 2);
        return string;
    }

    public String getQuotaAvailable(String string, String string2) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        try {
            double d = Double.parseDouble(string);
            double d2 = Double.parseDouble(string2);
            bigDecimal = new BigDecimal(String.valueOf(d - d2));
        }
        catch (NumberFormatException numberFormatException) {
            logger.debug((Object)("Error converting string to double [" + string + "], [" + string2 + "]"));
        }
        return bigDecimal.setScale(2, RoundingMode.HALF_UP).toString();
    }

    public String getJobStartHour() {
        return this.jobStartHour;
    }

    @ParameterSafe
    public void setJobStartHour(String string) {
        this.jobStartHour = string;
    }

    public String getJobStartMinute() {
        return this.jobStartMinute;
    }

    @ParameterSafe
    public void setJobStartMinute(String string) {
        this.jobStartMinute = string;
    }

    public String getJobStartAmPm() {
        return this.jobStartAmPm;
    }

    @ParameterSafe
    public void setJobStartAmPm(String string) {
        this.jobStartAmPm = string;
    }

    public String getJobEndHour() {
        return this.jobEndHour;
    }

    @ParameterSafe
    public void setJobEndHour(String string) {
        this.jobEndHour = string;
    }

    public String getJobEndMinute() {
        return this.jobEndMinute;
    }

    @ParameterSafe
    public void setJobEndMinute(String string) {
        this.jobEndMinute = string;
    }

    public String getJobEndAmPm() {
        return this.jobEndAmPm;
    }

    @ParameterSafe
    public void setJobEndAmPm(String string) {
        this.jobEndAmPm = string;
    }

    public String getUpcomingJobRun() {
        return this.upcomingJobRun;
    }

    public boolean getIsJobRunning() {
        return this.attachmentCheckerConfig.l();
    }

    public boolean getIsSystemAdmin() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.isSystemAdministrator((User)confluenceUser);
    }

    public boolean getIsReadOnlyAccessModeEnabled() {
        return this.isReadOnlyAccessModeEnabled;
    }

    public String execute() {
        logger.debug((Object)"Accessing quota summary...");
        logger.debug((Object)"Validating license...");
        if (this.licenseHelper.b()) {
            logger.debug((Object)"License is valid!");
            this.isReadOnlyAccessModeEnabled = this.accessModeCompatService.isReadOnlyAccessModeEnabled();
            this.numOfSpaceInfo = this.spaceInfoService.getSpaceInfoListSize();
            this.numOfSpace = this.spaceInfoService.getSpaceListSize();
            logger.debug((Object)("Num of SpaceInfo [" + this.numOfSpaceInfo + "]"));
            logger.debug((Object)("Num of Space [" + this.numOfSpace + "]"));
            if (this.attachmentCheckerConfig.i() || this.attachmentCheckerConfig.n() || this.numOfSpace == this.numOfSpaceInfo) {
                logger.debug((Object)"Load Quota Summary");
                this.loadSettings();
                return "success";
            }
            logger.debug((Object)"Load Quota Summary initial setup");
            this.loadSetup();
            return "setup";
        }
        logger.debug((Object)"License is invalid!");
        return "unlicensed";
    }

    private void loadSetup() {
        this.jobStartHour = this.attachmentCheckerConfig.getJobStartHour();
        this.jobStartMinute = this.attachmentCheckerConfig.getJobStartMinute();
        this.jobStartAmPm = this.attachmentCheckerConfig.getJobStartAmPm();
        this.jobEndHour = this.attachmentCheckerConfig.getJobEndHour();
        this.jobEndMinute = this.attachmentCheckerConfig.getJobEndMinute();
        this.jobEndAmPm = this.attachmentCheckerConfig.getJobEndAmPm();
        if (!(this.jobStartHour.isEmpty() || this.jobStartMinute.isEmpty() || this.jobStartAmPm.isEmpty())) {
            this.upcomingJobRun = this.dateHelper.a(DateHelper.a(this.jobStartHour, this.jobStartMinute, this.jobStartAmPm));
            if (this.jobStartMinute.equals(JOB_NO_END_TIME)) {
                this.jobStartMinute = "00";
            }
            if (this.jobEndMinute.equals(JOB_NO_END_TIME)) {
                this.jobEndMinute = "00";
            }
            if (this.jobEndHour.equals(JOB_NO_END_TIME)) {
                logger.debug((Object)("Scheduled job [From " + this.jobStartHour + ":" + this.jobStartMinute + " " + this.jobStartAmPm + " to until all Spaces are calculated]"));
            } else {
                logger.debug((Object)("Scheduled job [From " + this.jobStartHour + ":" + this.jobStartMinute + " " + this.jobStartAmPm + " to " + this.jobEndHour + ":" + this.jobEndMinute + " " + this.jobEndAmPm + "]"));
            }
            logger.debug((Object)("Upcoming job run at [" + this.upcomingJobRun + "]"));
        } else {
            logger.debug((Object)"Scheduled time not set");
        }
    }

    private void loadSettings() {
        this.quotaCheck = this.attachmentCheckerConfig.getQuotaCheck();
        logger.debug((Object)("Quota check [" + this.quotaCheck + "]"));
        this.quotaUnit = this.attachmentCheckerConfig.getUnit();
        this.defaultQuotaAllocated = this.attachmentCheckerConfig.getDefaultStorageAllocated();
        this.quotaAllocated = this.defaultQuotaAllocated == 0L ? this.getText("com.akeles.acc.config.common.unlimited") : AttachmentCheckerHelper.a(this.defaultQuotaAllocated, this.quotaUnit, 2);
        logger.debug((Object)("Default quota allocated [" + this.quotaAllocated + "] " + this.quotaUnit));
        HttpServletRequest httpServletRequest = ServletContextThreadLocal.getRequest();
        this.filterAllocation = httpServletRequest.getParameter("filterAllocation");
        this.filterUsage = httpServletRequest.getParameter("filterUsage");
        this.queryString = httpServletRequest.getParameter("queryString");
        String string = httpServletRequest.getParameter("page");
        logger.debug((Object)("Request page [" + string + "] query string [" + this.queryString + "] allocation [" + this.filterAllocation + "] usage [" + this.filterUsage + "]"));
        this.currentPage = 1;
        if (string != null) {
            try {
                this.currentPage = Integer.parseInt(string);
                if (this.currentPage < 1) {
                    this.currentPage = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.debug((Object)"NFE while trying to parse page number");
            }
        }
        if (this.queryString == null) {
            this.queryString = "";
        }
        this.filterList = new ArrayList<String>();
        if (!AttachmentCheckerHelper.a(this.filterAllocation)) {
            this.filterList.add(this.filterAllocation);
        }
        if (!AttachmentCheckerHelper.a(this.filterUsage)) {
            this.filterList.add(this.filterUsage);
        }
        this.spaceInfoList = new ArrayList<SpaceInfoBean>();
        if (this.queryString.isEmpty() && this.filterList.isEmpty()) {
            this.getSpaceInfoListForCurrentPage();
        } else {
            this.getSpaceInfoListForQueryAndFilter(this.queryString.trim().toLowerCase());
            this.getSpaceInfoListToDisplay();
        }
        logger.debug((Object)("Num of SpaceInfo [" + this.numOfSpaceInfo + "]"));
        logger.debug((Object)("Num of page [" + this.numOfPage + "]"));
    }

    private void getSpaceInfoListForCurrentPage() {
        logger.debug((Object)("Getting SpaceInfo for current page [" + this.currentPage + "]"));
        ListBuilder listBuilder = this.spaceManager.getSpaces(SpacesQuery.newQuery().sortBy("key").build());
        int n = (this.currentPage - 1) * 50;
        List list = listBuilder.getPage(n, 50);
        this.addSpaceInfo(list);
        while (this.spaceInfoList.size() < 50 && !(list = listBuilder.getPage(n += 50, 50 - this.spaceInfoList.size())).isEmpty()) {
            this.addSpaceInfo(list);
        }
        this.numOfPage = (this.numOfSpaceInfo + 50 - 1) / 50;
    }

    private void addSpaceInfo(List<Space> list) {
        for (Space space : list) {
            String string = space.getKey();
            SpaceInfo spaceInfo = this.isReadOnlyAccessModeEnabled ? this.spaceInfoService.a(string) : this.spaceInfoService.a(space);
            logger.debug((Object)("SpaceInfo [" + spaceInfo + "]"));
            if (spaceInfo == null) continue;
            logger.debug((Object)("SpaceInfo for key [" + string + "] added"));
            this.spaceInfoList.add(new SpaceInfoBean(string, spaceInfo.getStorageAllocated(), spaceInfo.getStorageUsed(), this.isQuotaDefault(spaceInfo.getStorageAllocated()), this.isQuotaUnlimited(spaceInfo.getStorageAllocated())));
        }
    }

    private void getSpaceInfoListForQueryAndFilter(String string) {
        logger.debug((Object)("Getting SpaceInfo for query [" + string + "] filter [" + this.filterList + "]"));
        ListBuilder listBuilder = this.spaceManager.getSpaces(SpacesQuery.newQuery().sortBy("key").build());
        List list = listBuilder.getRange(0, listBuilder.getAvailableSize() - 1);
        for (Space space : list) {
            String string2 = space.getKey();
            if (!this.spaceNameOrKeyMatchesQuery(space.getName(), string2, string)) continue;
            SpaceInfo spaceInfo = this.isReadOnlyAccessModeEnabled ? this.spaceInfoService.a(string2) : this.spaceInfoService.a(space);
            logger.debug((Object)("SpaceInfo [" + spaceInfo + "]"));
            if (spaceInfo == null) continue;
            long l = spaceInfo.getStorageAllocated();
            if (!this.filterList.isEmpty() && (this.isNotInAllocationFilter(l) || this.isNotInUsageFilter(l, spaceInfo.getStorageUsed()))) continue;
            logger.debug((Object)("SpaceInfo for key [" + string2 + "] added"));
            this.spaceInfoList.add(new SpaceInfoBean(string2, spaceInfo.getStorageAllocated(), spaceInfo.getStorageUsed(), this.isQuotaDefault(spaceInfo.getStorageAllocated()), this.isQuotaUnlimited(spaceInfo.getStorageAllocated())));
        }
        this.numOfSpaceInfo = this.spaceInfoList.size();
        this.numOfPage = (this.numOfSpaceInfo + 50 - 1) / 50;
    }

    private boolean spaceNameOrKeyMatchesQuery(String string, String string2, String string3) {
        return string.toLowerCase().contains(string3) || string2.toLowerCase().contains(string3);
    }

    private boolean isNotInAllocationFilter(long l) {
        return this.filterList.contains("default") && l != -1L || this.filterList.contains("custom") && l == -1L;
    }

    private boolean isNotInUsageFilter(long l, long l2) {
        if (l == -1L) {
            l = this.defaultQuotaAllocated;
        }
        return this.filterList.contains("101") && (l == 0L || l2 <= l) || this.filterList.contains(JOB_NO_END_TIME) && l2 > 0L;
    }

    private void getSpaceInfoListToDisplay() {
        if (this.currentPage > this.numOfPage) {
            this.spaceInfoList = new ArrayList<SpaceInfoBean>();
        } else if (this.numOfSpaceInfo > 50) {
            int n = (this.currentPage - 1) * 50;
            int n2 = n + 50;
            if (n2 > this.spaceInfoList.size()) {
                n2 = this.spaceInfoList.size();
            }
            if (n <= this.spaceInfoList.size() - 1) {
                try {
                    this.spaceInfoList = this.spaceInfoList.subList(n, n2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    logger.error((Object)arrayIndexOutOfBoundsException.getMessage());
                }
            } else {
                this.spaceInfoList = new ArrayList<SpaceInfoBean>();
            }
        }
    }

    public void validate() {
        super.validate();
        if (this.quotaAllocated != null) {
            if (!this.quotaAllocated.isEmpty()) {
                this.quotaAllocated = AttachmentCheckerHelper.c(this.quotaAllocated);
                if (this.quotaUnit == null) {
                    this.quotaUnit = this.attachmentCheckerConfig.getUnit();
                }
                this.quotaAllocated = AttachmentCheckerHelper.a(this.quotaAllocated, this.quotaUnit);
            }
        } else if (this.quotaCheck == null) {
            this.quotaCheck = "off";
        }
        if (!this.attachmentCheckerConfig.i() && "on".equalsIgnoreCase(this.quotaCheck) && this.spaceInfoService.getSpaceInfoListSize() != this.spaceInfoService.getSpaceListSize()) {
            this.addActionError(this.getText("com.akeles.acc.config.quotaChecking.quotaCheck.error.incompleteSetup"));
        }
    }

    @ReadOnlyAccessBlocked
    public String doUpdate() {
        if (this.spaceKey != null && this.quotaAllocated != null) {
            long l = -1L;
            if (!this.quotaAllocated.isEmpty()) {
                try {
                    l = Long.parseLong(this.quotaAllocated);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.error((Object)numberFormatException.getMessage());
                }
            }
            logger.debug((Object)("Space [" + this.spaceKey + "] quota allocated [" + l + "] bytes"));
            this.spaceInfoService.a(this.spaceKey, l);
        } else if (this.quotaAllocated != null) {
            this.saveDefaultQuota();
        } else if (this.jobStartHour != null) {
            this.saveQuotaSetup();
        } else {
            this.saveQuotaCheck();
        }
        return "success";
    }

    private void saveQuotaCheck() {
        logger.debug((Object)("Quota check [" + this.quotaCheck + "]"));
        logger.debug((Object)"Saving quota check...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.setQuotaCheck(this.quotaCheck);
            return null;
        });
    }

    private void saveDefaultQuota() {
        logger.debug((Object)("Default quota allocated [" + this.quotaAllocated + "] bytes"));
        logger.debug((Object)("Default quota unit [" + this.quotaUnit + "]"));
        logger.debug((Object)"Saving default quota...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.b(this.quotaAllocated, this.quotaUnit);
            return null;
        });
    }

    private void saveQuotaSetup() {
        logger.debug((Object)("Job start hour [" + this.jobStartHour + "]"));
        logger.debug((Object)("Job start minute [" + this.jobStartMinute + "]"));
        logger.debug((Object)("Job start am/pm [" + this.jobStartAmPm + "]"));
        logger.debug((Object)("Job end hour [" + this.jobEndHour + "]"));
        logger.debug((Object)("Job end minute [" + this.jobEndMinute + "]"));
        logger.debug((Object)("Job end am/pm [" + this.jobEndAmPm + "]"));
        logger.debug((Object)"Saving quota setup job...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.a(this.jobStartHour, this.jobStartMinute, this.jobStartAmPm, this.jobEndHour, this.jobEndMinute, this.jobEndAmPm);
            this.jobScheduler.a(DateHelper.a(this.jobStartHour, this.jobStartMinute, this.jobStartAmPm));
            return null;
        });
    }

    @ReadOnlyAccessBlocked
    public String doPurge() {
        logger.debug((Object)"Purging all SpaceInfo's quota used...");
        this.spaceInfoService.a();
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.m();
            this.attachmentCheckerConfig.setQuotaCheck("off");
            this.attachmentCheckerConfig.setIsQuotaSetupCompleted(false);
            logger.debug((Object)"Disabled quota check!");
            return null;
        });
        return "success";
    }
}

