/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class AttachmentHelper {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.utils.AttachmentHelper");
    private final AttachmentManager b;
    private final BootstrapManager c;
    private final ClusterManager d;
    private final SpaceInfoService e;
    private final TransactionTemplate f;

    public AttachmentHelper(@ComponentImport AttachmentManager attachmentManager, @ComponentImport BootstrapManager bootstrapManager, @ComponentImport ClusterManager clusterManager, SpaceInfoService spaceInfoService, @ComponentImport TransactionTemplate transactionTemplate) {
        this.b = attachmentManager;
        this.c = bootstrapManager;
        this.d = clusterManager;
        this.e = spaceInfoService;
        this.f = transactionTemplate;
    }

    public Attachment a(long l, int n, Date date) {
        a.debug((Object)("Get attachment id [" + l + "] version [" + n + "] creation date [" + date + "]"));
        Attachment attachment = this.b.getAttachment(l);
        if (attachment == null) {
            a.debug((Object)"Attachment is null");
            return null;
        }
        boolean bl = attachment.getVersion() != n;
        boolean bl2 = date != null && DateUtils.round((Date)attachment.getCreationDate(), (int)13).getTime() != date.getTime();
        a.debug((Object)("Is version diff? [" + bl + "]"));
        a.debug((Object)("Is creation date diff? [" + bl2 + "]"));
        if (bl || bl2) {
            List list = this.b.getAllVersions(attachment);
            attachment = null;
            for (Attachment attachment2 : list) {
                int n2 = attachment2.getVersion();
                Date date2 = DateUtils.round((Date)attachment2.getCreationDate(), (int)13);
                a.debug((Object)("Version [" + n2 + "] creation date [" + date2.getTime() + "]"));
                if (n2 != n || date != null && date2.getTime() != date.getTime()) continue;
                a.debug((Object)"Found attachment!");
                attachment = attachment2;
                break;
            }
        }
        a.debug((Object)("Attachment [" + attachment + "]"));
        return attachment;
    }

    public void b(long l, int n, Date date) {
        a.debug((Object)("Delete attachment id [" + l + "]"));
        this.f.execute(() -> {
            Attachment attachment = this.a(l, n, date);
            if (attachment != null) {
                try {
                    this.b.getAttachmentDao().removeAttachmentVersionFromServer(attachment);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    a.debug((Object)"IllegalArgumentException deleting attachment", (Throwable)illegalArgumentException);
                }
            }
            return null;
        });
    }

    public String a(@NotNull Attachment attachment, long l, int n, long l2) {
        String string;
        long l3 = attachment.getSpace().getId();
        String string2 = (String)this.c.getApplicationConfig().getProperty((Object)"attachments.dir");
        string2 = string2.replace("${confluenceHome}", this.d.isClustered() ? this.c.getSharedHome().getPath() : this.c.getLocalHome().getPath());
        boolean bl = new File(string2 + File.separator + "v4").exists();
        a.debug((Object)("Is attachment storage v4? [" + bl + "]"));
        if (bl) {
            long l4 = l % 65535L;
            string = string2 + File.separator + "v4" + File.separator + l4 % 256L + File.separator + l4 / 256L + File.separator + l + File.separator + l + "." + n;
        } else {
            string = string2 + File.separator + "ver003" + File.separator + l3 % 250L + File.separator + l3 / 1000L % 250L + File.separator + l3 + File.separator + l2 % 250L + File.separator + l2 / 1000L % 250L + File.separator + l2 + File.separator + l + File.separator + n;
        }
        return string;
    }

    public void a(boolean bl, long l, int n, Date date) {
        if (bl) {
            try {
                this.f.execute(() -> {
                    Attachment attachment = this.a(l, n, date);
                    if (attachment != null) {
                        long l2 = 136628L;
                        long l3 = attachment.getFileSize();
                        long l4 = Math.abs(l2 - l3);
                        String string = attachment.getSpaceKey();
                        a.debug((Object)"Saving placeholder... ");
                        attachment.setFileSize(l2);
                        attachment.setMediaType("image/png");
                        attachment.setVersionComment("This is a placeholder to replace the infected file");
                        AttachmentDao attachmentDao = this.b.getAttachmentDao();
                        InputStream inputStream = this.getClass().getResourceAsStream("/images/imageplaceholder.png");
                        attachmentDao.replaceAttachmentData(attachment, inputStream);
                        a.debug((Object)"Placeholder saved!");
                        a.debug((Object)("Placeholder file size [" + l2 + "]"));
                        a.debug((Object)("Original file size [" + l3 + "]"));
                        a.debug((Object)("Offset file size [" + l4 + "]"));
                        this.e.a(string, l4, l3 > l2);
                    }
                    return null;
                });
            }
            catch (Exception exception) {
                a.error((Object)"Exception replacing attachment data with placeholder", (Throwable)exception);
            }
        }
    }
}

