/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.scheduler.job;

import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalculateAttachmentJobRunner
implements JobRunner {
    private static final Logger d = Logger.getLogger((String)"com.akeles.plugins.acc.scheduler.CalculateAttachmentJobRunner");
    private static final String e = CalculateAttachmentJobRunner.class.getName() + ".lock";
    public static final JobRunnerKey a = JobRunnerKey.of((String)CalculateAttachmentJobRunner.class.getName());
    public static final JobId b = JobId.of((String)CalculateAttachmentJobRunner.class.getName());
    public static final long c = 86400000L;
    private final AccessModeCompatService f;
    private final AttachmentCheckerConfig g;
    private final ClusterLockService h;
    private final SpaceInfoService i;
    private final TransactionTemplate j;

    @Autowired
    public CalculateAttachmentJobRunner(AccessModeCompatService accessModeCompatService, AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport ClusterLockService clusterLockService, SpaceInfoService spaceInfoService, @ComponentImport TransactionTemplate transactionTemplate) {
        this.f = accessModeCompatService;
        this.g = attachmentCheckerConfig;
        this.h = clusterLockService;
        this.i = spaceInfoService;
        this.j = transactionTemplate;
        d.setLevel(Level.INFO);
    }

    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        block7: {
            if (this.f.isReadOnlyAccessModeEnabled()) {
                d.info((Object)"Read-only access mode enabled! Abort calculate attachment job!");
                return JobRunnerResponse.aborted((String)"Job aborted because read-only access mode is enabled!");
            }
            ClusterLock clusterLock = this.h.getLockForName(e);
            try {
                if (clusterLock.tryLock(3L, TimeUnit.SECONDS)) {
                    try {
                        d.info((Object)"--- Running CalculateAttachmentJob...");
                        this.a();
                        d.info((Object)"--- CalculateAttachmentJob completed!");
                        break block7;
                    }
                    finally {
                        clusterLock.unlock();
                    }
                }
                d.info((Object)"CalculateAttachmentJob is running on another instance!");
            }
            catch (InterruptedException interruptedException) {
                d.error((Object)"Interrupted while acquiring lock", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
        return JobRunnerResponse.success();
    }

    private void a() {
        this.j.execute(() -> {
            this.g.setIsJobRunning(true);
            return null;
        });
        int n = (Integer)this.j.execute(this.i::getSpaceInfoListSize);
        int n2 = (Integer)this.j.execute(this.i::getSpaceListSize);
        d.info((Object)("Num of SpaceInfo [" + n + "]"));
        d.info((Object)("Num of Spaces [" + n2 + "]"));
        Calendar calendar = Calendar.getInstance();
        try {
            if (n > 0) {
                d.info((Object)"Deleting SpaceInfo if corresponding Space not found...");
                this.j.execute(() -> {
                    this.i.b();
                    return null;
                });
                n = (Integer)this.j.execute(this.i::getSpaceInfoListSize);
                d.info((Object)("Num of SpaceInfo after delete [" + n + "]"));
            }
            if (n != n2) {
                boolean bl = !this.g.getJobEndHour().equals("0");
                d.debug((Object)("Job end time set? [" + bl + "]"));
                Date date = this.a(bl, calendar);
                d.info((Object)"Calculating Space...");
                List list = (List)this.j.execute(this.i::getSpaceList);
                for (Space space : list) {
                    this.a(space);
                    if ((!bl || new Date().before(date)) && !this.f.isReadOnlyAccessModeEnabled()) continue;
                    break;
                }
                n = (Integer)this.j.execute(this.i::getSpaceInfoListSize);
                n2 = (Integer)this.j.execute(this.i::getSpaceListSize);
                d.debug((Object)("Num of SpaceInfo after calculate [" + n + "]"));
                d.debug((Object)("Num of Spaces [" + n2 + "]"));
            }
        }
        catch (Exception exception) {
            d.error((Object)"Exception while calculating attachments", (Throwable)exception);
        }
        if (n == n2 && this.g.k()) {
            d.info((Object)"Enabling quota check...");
            this.j.execute(() -> {
                this.g.setQuotaCheck("Enabled");
                return null;
            });
        }
        this.j.execute(() -> {
            this.g.setIsJobRunning(false);
            return null;
        });
    }

    private Date a(boolean bl, Calendar calendar) {
        Date date = null;
        if (bl) {
            date = DateHelper.a(calendar.getTime(), this.g.getJobEndHour(), this.g.getJobEndMinute(), this.g.getJobEndAmPm());
            d.debug((Object)("Job will stop by [" + date + "] (approx.)"));
        }
        return date;
    }

    private void a(Space space) {
        this.j.execute(() -> {
            String string = space.getKey();
            d.debug((Object)("Retrieving SpaceInfo [" + string + "]"));
            SpaceInfo spaceInfo = this.i.a(space);
            d.debug((Object)("Retrieved SpaceInfo [" + string + "]"));
            if (spaceInfo.getStorageUsed() == -1L) {
                d.debug((Object)("Recalculating attachments in [" + string + "]"));
                this.i.a(spaceInfo);
            }
            return null;
        });
    }
}

