/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.scheduler.job;

import com.akelesconsulting.confluence.plugins.ao.service.MissingAttachmentService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceScannedService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class MissingAttachmentScannerJobRunner
implements JobRunner {
    private static final Logger e = Logger.getLogger((String)"com.akeles.plugins.acc.scheduler.MissingAttachmentScannerJobRunner");
    public static final String a = MissingAttachmentScannerJobRunner.class.getName() + ".lock";
    public static final JobRunnerKey b = JobRunnerKey.of((String)MissingAttachmentScannerJobRunner.class.getName());
    public static final JobId c = JobId.of((String)MissingAttachmentScannerJobRunner.class.getName());
    public static final long d = 86400000L;
    private final AccessModeCompatService f;
    private final AttachmentCheckerConfig g;
    private final AttachmentManager h;
    private final ClusterLockService i;
    private final MissingAttachmentService j;
    private final PageManager k;
    private final SpaceInfoService l;
    private final SpaceScannedService m;
    private final TransactionTemplate n;

    public MissingAttachmentScannerJobRunner(AccessModeCompatService accessModeCompatService, AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport AttachmentManager attachmentManager, @ComponentImport ClusterLockService clusterLockService, MissingAttachmentService missingAttachmentService, @ComponentImport PageManager pageManager, SpaceInfoService spaceInfoService, SpaceScannedService spaceScannedService, @ComponentImport TransactionTemplate transactionTemplate) {
        this.f = accessModeCompatService;
        this.g = attachmentCheckerConfig;
        this.h = attachmentManager;
        this.i = clusterLockService;
        this.j = missingAttachmentService;
        this.k = pageManager;
        this.l = spaceInfoService;
        this.m = spaceScannedService;
        this.n = transactionTemplate;
    }

    public JobRunnerResponse runJob(@NotNull JobRunnerRequest jobRunnerRequest) {
        block7: {
            if (this.f.isReadOnlyAccessModeEnabled()) {
                e.info((Object)"Read-only access mode enabled, aborting job.");
                return JobRunnerResponse.aborted((String)"Job aborted because read-only access mode is enabled.");
            }
            ClusterLock clusterLock = this.i.getLockForName(a);
            try {
                if (clusterLock.tryLock(3L, TimeUnit.SECONDS)) {
                    e.debug((Object)"MissingAttachmentScannerJob lock acquired!");
                    this.g.setIsMissingAttachmentScanRunning(true);
                    try {
                        e.debug((Object)"--- Running MissingAttachmentScannerJob...");
                        this.a();
                        e.debug((Object)"--- MissingAttachmentScannerJob completed!");
                        break block7;
                    }
                    finally {
                        this.g.setIsMissingAttachmentScanRunning(false);
                        clusterLock.unlock();
                    }
                }
                e.debug((Object)"MissingAttachmentScannerJob is running on another instance!");
            }
            catch (InterruptedException interruptedException) {
                e.error((Object)"Interrupted while acquiring MissingAttachmentScannerJob lock", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
        return JobRunnerResponse.success();
    }

    private void a() {
        try {
            int n = (Integer)this.n.execute(() -> this.l.getSpaceList().size());
            e.debug((Object)("Space count [" + n + "]"));
            int n2 = (Integer)this.n.execute(this.m::getSpaceScannedTotalCount);
            e.debug((Object)("SpaceScanned count [" + n2 + "]"));
            if (n2 > 0) {
                e.info((Object)"Deleting SpaceScanned if corresponding Space not found");
                n2 = (Integer)this.n.execute(() -> {
                    this.m.b();
                    return this.m.getSpaceScannedTotalCount();
                });
                e.debug((Object)("SpaceScanned count after delete [" + n2 + "]"));
            }
            if (!this.g.p()) {
                this.g.setMissingAttachmentScannerLastRun(new Date().getTime());
                boolean bl = !this.g.getMissingAttachmentScannerEndHour().equals("0");
                e.debug((Object)("Job end time set? [" + bl + "]"));
                Calendar calendar = Calendar.getInstance();
                Date date = DateHelper.a(calendar.getTime(), this.g.getMissingAttachmentScannerEndHour(), this.g.getMissingAttachmentScannerEndMinute(), this.g.getMissingAttachmentScannerEndAmPm());
                List list = (List)this.n.execute(this.l::getSpaceList);
                for (Space space : list) {
                    boolean bl2 = (Boolean)this.n.execute(() -> {
                        e.debug((Object)("Space key [" + space.getKey() + "]"));
                        return this.m.a(space.getKey());
                    });
                    e.debug((Object)("Is space scanned? [" + bl2 + "]"));
                    if (!bl2) {
                        this.a(space);
                    }
                    Date date2 = new Date();
                    if (!bl || date2.before(date)) continue;
                    e.debug((Object)("Current time [" + date2 + "] is after configured end time [" + date + "]"));
                    e.debug((Object)"Stopping job");
                    break;
                }
                n2 = (Integer)this.n.execute(this.m::getSpaceScannedTotalCount);
                if (n2 == n) {
                    this.n.execute(() -> {
                        this.g.setIsMissingAttachmentScanCompleted(true);
                        return null;
                    });
                }
            }
        }
        catch (Exception exception) {
            e.error((Object)"Exception scanning for missing attachments", (Throwable)exception);
        }
    }

    private void a(Space space) {
        this.n.execute(() -> {
            String string = space.getKey();
            e.debug((Object)("Checking space [" + string + "]"));
            this.j.a(string);
            Collection collection = this.k.getPageIds(space);
            e.debug((Object)("Total page count [" + collection.size() + "]"));
            for (Long l : collection) {
                e.debug((Object)("Checking page id [" + l + "]"));
                ContentEntityObject contentEntityObject = this.k.getById(l.longValue());
                if (contentEntityObject == null) continue;
                List list = contentEntityObject.getAttachments();
                e.debug((Object)("Total attachments count [" + list.size() + "]"));
                for (Attachment attachment : list) {
                    if (this.h.getAttachmentData(attachment) != null) continue;
                    e.debug((Object)("Found missing attachment id [" + attachment.getId() + "]"));
                    this.j.a(attachment);
                }
            }
            this.m.b(string);
            return null;
        });
    }
}

