/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.config;

import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeGroup;
import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeLimit;
import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.akelesconsulting.confluence.plugins.ao.service.FileSizeLimitService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentCheckerConfig {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.config.AttachmentCheckerConfig");
    private static final String b = "whitelist";
    private static final String c = "blacklist";
    private static final String d = "enabled";
    private static final String e = "disabled";
    private static final String f = "application/octet-stream";
    private static final String g = "application/x-msdownload";
    private static final String h = "application/x-dosexec";
    private static final String i = ".render";
    private static final String j = ".tfss";
    private static final String k = "jpg";
    private static final String l = "whitelist";
    private static final String m = "This file type is not allowed.";
    private static final String n = "disabled";
    private static final String o = "The file size has exceeded the maximum size limit set for the file type.";
    private static final String p = "disabled";
    private static final String q = "Insufficient storage available.";
    private static final String r = "MB";
    private static final String s = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.";
    private static final String t = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions";
    private static final String u = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map";
    private static final String v = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set";
    private static final String w = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set";
    private static final String x = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.filterMode";
    private static final String y = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowProtected";
    private static final String z = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowEncrypted";
    private static final String A = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowTableSpreadsheetMacro";
    private static final String B = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.message";
    private static final String C = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeCheck";
    private static final String D = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeError";
    private static final String E = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.onAccessScanning";
    private static final String F = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerMode";
    private static final String G = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerPath";
    private static final String H = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerOption";
    private static final String I = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.autoDeleteMode";
    private static final String J = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfInfected";
    private static final String K = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.deleteIfError";
    private static final String L = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfError";
    private static final String M = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.groupToEmail";
    private static final String N = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusAlertActor";
    private static final String O = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanRunning";
    private static final String P = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanNodeId";
    private static final String Q = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCheck";
    private static final String R = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaError";
    private static final String S = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unit";
    private static final String T = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultStorage";
    private static final String U = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndAmPm";
    private static final String V = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndHour";
    private static final String W = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndMinute";
    private static final String X = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartAmPm";
    private static final String Y = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartHour";
    private static final String Z = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartMinute";
    private static final String aa = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isJobRunning";
    private static final String ab = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.enableQuotaCheckAfterSetup";
    private static final String ac = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.trackLargeAttachment";
    private static final String ad = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.largeAttachmentSize";
    private static final long ae = 0xFA00000L;
    private static final String af = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartHour";
    private static final String ag = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartMinute";
    private static final String ah = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartAmPm";
    private static final String ai = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndHour";
    private static final String aj = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndMinute";
    private static final String ak = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndAmPm";
    private static final String al = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobLastRun";
    private static final String am = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanRunning";
    private static final String an = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanCompleted";
    private final Cache<String, Object> ao;
    private final FileSizeLimitService ap;
    private final GroupManager aq;
    private final MimeTypes ar;
    private final PluginSettingsFactory as;
    private final SpaceInfoService at;
    private final Tika au;
    private final UserAccessor av;

    @Autowired
    public AttachmentCheckerConfig(FileSizeLimitService fileSizeLimitService, @ComponentImport GroupManager groupManager, @ComponentImport PluginSettingsFactory pluginSettingsFactory, SpaceInfoService spaceInfoService, @ComponentImport @NotNull CacheManager cacheManager, @ComponentImport UserAccessor userAccessor) {
        String string = AttachmentCheckerConfig.class.getName() + ".cache";
        CacheSettings cacheSettings = new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(1000).flushable().build();
        this.ao = cacheManager.getCache(string, (CacheLoader)new AcConfigCacheLoader(), cacheSettings);
        this.aq = groupManager;
        this.ap = fileSizeLimitService;
        this.ar = MimeTypes.getDefaultMimeTypes();
        this.as = pluginSettingsFactory;
        this.at = (SpaceInfoService)Preconditions.checkNotNull((Object)spaceInfoService);
        this.au = new Tika();
        this.av = userAccessor;
    }

    public List<String> a(String string) {
        List<String> list;
        String string2 = this.b(string);
        if (string2.equalsIgnoreCase(g) || string2.equalsIgnoreCase(h)) {
            list = this.c(string, g);
            list.addAll(this.c(string, h));
        } else {
            list = this.c(string, string2);
        }
        return list;
    }

    private List<String> c(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            MimeType mimeType = this.ar.forName(string2);
            List list = mimeType.getExtensions();
            for (String string3 : list) {
                if (string3.equalsIgnoreCase(string)) continue;
                arrayList.add(string3);
            }
        }
        catch (MimeTypeException mimeTypeException) {
            a.debug((Object)mimeTypeException.getMessage());
        }
        return arrayList;
    }

    public String getExtensions() {
        return (String)this.ao.get((Object)t);
    }

    public String getFilterMode() {
        return (String)this.ao.get((Object)x);
    }

    public String getFileTypeErrorMessage() {
        return (String)this.ao.get((Object)B);
    }

    public Map<String, List<String>> getExtensionsMap() {
        return (Map)this.ao.get((Object)u);
    }

    public Set<String> getExtensionSet() {
        TreeSet treeSet = (TreeSet)this.ao.get((Object)v);
        if (treeSet == null) {
            treeSet = new TreeSet();
        }
        return treeSet;
    }

    public Set<String> getMimeTypeSet() {
        TreeSet treeSet = (TreeSet)this.ao.get((Object)w);
        if (treeSet == null) {
            treeSet = new TreeSet();
        }
        return treeSet;
    }

    public void a(String string, String string2, String string3) {
        PluginSettings pluginSettings = this.as.createGlobalSettings();
        pluginSettings.put(x, (Object)string);
        this.ao.remove((Object)x);
        a.debug((Object)("Updated filterMode [" + string + "]"));
        pluginSettings.put(t, (Object)string2);
        this.ao.remove((Object)t);
        this.ao.remove((Object)u);
        this.ao.remove((Object)v);
        this.ao.remove((Object)w);
        a.debug((Object)("Updated extensions [" + string2 + "]"));
        pluginSettings.put(B, (Object)string3);
        this.ao.remove((Object)B);
        a.debug((Object)("Updated fileTypeErrorMessage (message) [" + string3 + "]"));
    }

    public void b(String string, String string2, String string3) {
        PluginSettings pluginSettings = this.as.createGlobalSettings();
        pluginSettings.put(y, (Object)string);
        this.ao.remove((Object)y);
        a.debug((Object)("Updated allowProtected [" + string + "]"));
        pluginSettings.put(z, (Object)string2);
        this.ao.remove((Object)z);
        a.debug((Object)("Updated allowEncrypted [" + string2 + "]"));
        pluginSettings.put(A, (Object)string3);
        this.ao.remove((Object)A);
        a.debug((Object)("Updated allowTableSpreadsheetMacro [" + string3 + "]"));
    }

    public String getAllowProtected() {
        return (String)this.ao.get((Object)y);
    }

    public String getAllowEncrypted() {
        return (String)this.ao.get((Object)z);
    }

    public String getAllowTableSpreadsheetMacro() {
        return (String)this.ao.get((Object)A);
    }

    public boolean a() {
        return "on".equalsIgnoreCase(this.getAllowTableSpreadsheetMacro());
    }

    public String getFileSizeCheck() {
        return (String)this.ao.get((Object)C);
    }

    public String getFileSizeErrMsg() {
        return (String)this.ao.get((Object)D);
    }

    public boolean b() {
        return this.getFileSizeCheck().equalsIgnoreCase(d);
    }

    public void setFileSizeCheck(String string) {
        this.as.createGlobalSettings().put(C, (Object)string);
        this.ao.remove((Object)C);
        a.debug((Object)("Updated file size check [" + string + "]"));
    }

    public void setFileSizeErrMsg(String string) {
        this.as.createGlobalSettings().put(D, (Object)string);
        this.ao.remove((Object)D);
        a.debug((Object)("Updated file size error message [" + string + "]"));
    }

    public boolean c() {
        return this.getMissingFileCheck().equalsIgnoreCase("on");
    }

    public String getMissingFileCheck() {
        String string = (String)this.ao.get((Object)E);
        if (Boolean.TRUE.toString().equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setMissingFileCheck(String string) {
        this.as.createGlobalSettings().put(E, (Object)string);
        this.ao.remove((Object)E);
        a.debug((Object)("Updated missing file check [" + string + "]"));
    }

    public boolean d() {
        return this.getVirusScanning().equalsIgnoreCase("on");
    }

    public String getVirusScanning() {
        String string = (String)this.ao.get((Object)F);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setVirusScanning(String string) {
        this.as.createGlobalSettings().put(F, (Object)string);
        this.ao.remove((Object)F);
        a.debug((Object)("Updated virus scanning [" + string + "]"));
    }

    public boolean a(int n, @NotNull String string) {
        boolean bl = true;
        if (!this.getScannerDetected().equalsIgnoreCase("unknown")) {
            bl = n == 1 && (string.contains("clamscan") || string.contains("clamdscan") || string.contains("fpscan")) || n == 3 && string.contains("savscan") || n == 13 && (string.contains("uvscan") || string.contains("scan.exe")) || n == 50 && (string.contains("ecls.exe") || string.contains("eset")) || n == 72 && string.contains("kesl-control");
        }
        a.debug((Object)("Is infected? [" + bl + "]"));
        return bl;
    }

    public String getScannerDetected() {
        String string = this.getScannerPath().toLowerCase();
        String string2 = string.contains("clamscan") || string.contains("clamdscan") ? "ClamAV" : (string.contains("ecls.exe") || string.contains("eset") ? "ESET" : (string.contains("fpscan") ? "F-PROT Antivirus" : (string.contains("kesl-control") ? "Kaspersky Endpoint Security for Linux" : (string.contains("savscan") ? "Sophos Anti-Virus" : (string.contains("uvscan") || string.contains("scan.exe") ? "McAfee VirusScan" : "unknown")))));
        return string2;
    }

    public String getScannerPath() {
        return (String)this.ao.get((Object)G);
    }

    public void a(String string, String string2) {
        PluginSettings pluginSettings = this.as.createGlobalSettings();
        pluginSettings.put(G, (Object)string);
        this.ao.remove((Object)G);
        a.debug((Object)("Updated scannerPath [" + string + "]"));
        pluginSettings.put(H, (Object)string2);
        this.ao.remove((Object)H);
        a.debug((Object)("Updated scannerOption [" + string2 + "]"));
    }

    public String getScannerOption() {
        return (String)this.ao.get((Object)H);
    }

    public boolean e() {
        return this.getDeleteIfInfected().equalsIgnoreCase("on");
    }

    public String getDeleteIfInfected() {
        String string = (String)this.ao.get((Object)I);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public boolean f() {
        return this.getEmailIfInfected().equalsIgnoreCase("on");
    }

    public String getEmailIfInfected() {
        return (String)this.ao.get((Object)J);
    }

    public boolean g() {
        return this.getDeleteIfError().equalsIgnoreCase("on");
    }

    public String getDeleteIfError() {
        return (String)this.ao.get((Object)K);
    }

    public boolean h() {
        return this.getEmailIfError().equalsIgnoreCase("on");
    }

    public String getEmailIfError() {
        return (String)this.ao.get((Object)L);
    }

    public void a(String string, String string2, String string3, String string4) {
        PluginSettings pluginSettings = this.as.createGlobalSettings();
        pluginSettings.put(I, (Object)string);
        this.ao.remove((Object)I);
        a.debug((Object)("Updated deleteIfInfected (autoDeleteMode) [" + string + "]"));
        pluginSettings.put(J, (Object)string2);
        this.ao.remove((Object)J);
        a.debug((Object)("Updated emailIfInfected [" + string2 + "]"));
        pluginSettings.put(K, (Object)string3);
        this.ao.remove((Object)K);
        a.debug((Object)("Updated deleteIfError [" + string3 + "]"));
        pluginSettings.put(L, (Object)string4);
        this.ao.remove((Object)L);
        a.debug((Object)("Updated emailIfError [" + string4 + "]"));
    }

    public String getGroupToEmail() {
        return (String)this.ao.get((Object)M);
    }

    public void setGroupToEmail(String string) {
        this.as.createGlobalSettings().put(M, (Object)string);
        this.ao.remove((Object)M);
        a.debug((Object)("Updated group to email (Confluence Sysadmin Group) [" + string + "]"));
    }

    private String getVirusAlertActor() {
        return (String)this.ao.get((Object)N);
    }

    public void setVirusAlertActor(String string) {
        this.as.createGlobalSettings().put(N, (Object)string);
        this.ao.remove((Object)N);
        a.debug((Object)("Updated virus alert actor [" + string + "]"));
    }

    public ConfluenceUser getVirusAlertActorUser() {
        ConfluenceUser confluenceUser = null;
        String string = this.getVirusAlertActor();
        if (!string.isEmpty()) {
            confluenceUser = this.av.getUserByKey(new UserKey(string));
        }
        return confluenceUser;
    }

    public boolean getIsVirusScanRunning() {
        return Boolean.parseBoolean((String)this.ao.get((Object)O));
    }

    public void setIsVirusScanRunning(boolean bl) {
        this.as.createGlobalSettings().put(O, (Object)Boolean.toString(bl));
        this.ao.remove((Object)O);
        a.debug((Object)("Updated is virus scan running? [" + bl + "]"));
    }

    public String getVirusScanNodeId() {
        return (String)this.ao.get((Object)P);
    }

    public void setVirusScanNodeId(String string) {
        this.as.createGlobalSettings().put(P, (Object)string);
        this.ao.remove((Object)P);
        a.debug((Object)("Updated virus scan node id [" + string + "]"));
    }

    public String getQuotaCheck() {
        return (String)this.ao.get((Object)Q);
    }

    public String getQuotaErrorMessage() {
        return (String)this.ao.get((Object)R);
    }

    public String getUnit() {
        return (String)this.ao.get((Object)S);
    }

    public long getDefaultStorageAllocated() {
        Long l = (Long)this.ao.get((Object)T);
        return l == null ? 0L : l;
    }

    public boolean i() {
        return this.getQuotaCheck().equalsIgnoreCase(d);
    }

    public boolean j() {
        return this.getDefaultStorageAllocated() == 0L;
    }

    public void setQuotaCheck(String string) {
        this.as.createGlobalSettings().put(Q, (Object)string);
        this.ao.remove((Object)Q);
        a.debug((Object)("Updated quota check [" + string + "]"));
    }

    public void setQuotaErrorMessage(String string) {
        this.as.createGlobalSettings().put(R, (Object)string);
        this.ao.remove((Object)R);
        a.debug((Object)("Updated quota error message [" + string + "]"));
    }

    public void b(String string, String string2) {
        PluginSettings pluginSettings = this.as.createGlobalSettings();
        pluginSettings.put(T, (Object)string);
        this.ao.remove((Object)T);
        a.debug((Object)("Updated defaultQuotaAllocated (defaultStorage) [" + string + "]"));
        pluginSettings.put(S, (Object)string2);
        this.ao.remove((Object)S);
        a.debug((Object)("Updated defaultQuotaAllocatedUnit (unit) [" + string2 + "]"));
    }

    public String getJobEndAmPm() {
        return (String)this.ao.get((Object)U);
    }

    public String getJobEndHour() {
        return (String)this.ao.get((Object)V);
    }

    public String getJobEndMinute() {
        return (String)this.ao.get((Object)W);
    }

    public String getJobStartAmPm() {
        return (String)this.ao.get((Object)X);
    }

    public String getJobStartHour() {
        return (String)this.ao.get((Object)Y);
    }

    public String getJobStartMinute() {
        return (String)this.ao.get((Object)Z);
    }

    private String getEnableQuotaCheckAfterSetup() {
        return (String)this.ao.get((Object)ab);
    }

    private String getIsJobRunning() {
        return (String)this.ao.get((Object)aa);
    }

    public boolean k() {
        return Boolean.parseBoolean(this.getEnableQuotaCheckAfterSetup());
    }

    public boolean l() {
        return Boolean.parseBoolean(this.getIsJobRunning());
    }

    public void a(String string, String string2, String string3, String string4, String string5, String string6) {
        PluginSettings pluginSettings = this.as.createGlobalSettings();
        pluginSettings.put(Y, (Object)string);
        this.ao.remove((Object)Y);
        a.debug((Object)("Updated calculateAttachmentJobStartHour (jobStartHour) [" + string + "]"));
        pluginSettings.put(Z, (Object)string2);
        this.ao.remove((Object)Z);
        a.debug((Object)("Updated calculateAttachmentJobStartMinute (jobStartMinute) [" + string2 + "]"));
        pluginSettings.put(X, (Object)string3);
        this.ao.remove((Object)X);
        a.debug((Object)("Updated calculateAttachmentJobStartAmPm (jobStartAmPm) [" + string3 + "]"));
        pluginSettings.put(V, (Object)string4);
        this.ao.remove((Object)V);
        a.debug((Object)("Updated calculateAttachmentJobEndHour (jobEndHour) [" + string4 + "]"));
        pluginSettings.put(W, (Object)string5);
        this.ao.remove((Object)W);
        a.debug((Object)("Updated calculateAttachmentJobEndMinute (jobEndMinute) [" + string5 + "]"));
        pluginSettings.put(U, (Object)string6);
        this.ao.remove((Object)U);
        a.debug((Object)("Updated calculateAttachmentJobEndAmPm (jobEndAmPm) [" + string6 + "]"));
    }

    public void m() {
        this.as.createGlobalSettings().put(ab, (Object)String.valueOf(this.i()));
        this.ao.remove((Object)ab);
        a.debug((Object)("Updated enable quota check after setup [" + this.i() + "]"));
    }

    public void setIsJobRunning(boolean bl) {
        this.as.createGlobalSettings().put(aa, (Object)String.valueOf(bl));
        this.ao.remove((Object)aa);
        a.debug((Object)("Updated is job running [" + bl + "]"));
    }

    public boolean n() {
        return "on".equalsIgnoreCase(this.getTrackLargeAttachment());
    }

    public String getTrackLargeAttachment() {
        return (String)this.ao.get((Object)ac);
    }

    public void setTrackLargeAttachment(String string) {
        this.as.createGlobalSettings().put(ac, (Object)string);
        this.ao.remove((Object)ac);
        a.debug((Object)("Updated track large attachment [" + string + "]"));
    }

    public long getLargeAttachmentSize() {
        Long l = (Long)this.ao.get((Object)ad);
        return l == null ? 0xFA00000L : l;
    }

    public void setLargeAttachmentSize(String string) {
        this.as.createGlobalSettings().put(ad, (Object)string);
        this.ao.remove((Object)ad);
        a.debug((Object)("Updated large attachment size [" + string + "]"));
    }

    public boolean o() {
        return Boolean.parseBoolean((String)this.ao.get((Object)am));
    }

    public void setIsMissingAttachmentScanRunning(boolean bl) {
        this.as.createGlobalSettings().put(am, (Object)Boolean.toString(bl));
        this.ao.remove((Object)am);
        a.debug((Object)("Updated isMissingAttachmentScanRunning [" + bl + "]"));
    }

    public boolean p() {
        return Boolean.parseBoolean((String)this.ao.get((Object)an));
    }

    public void setIsMissingAttachmentScanCompleted(boolean bl) {
        this.as.createGlobalSettings().put(an, (Object)Boolean.toString(bl));
        this.ao.remove((Object)an);
        a.debug((Object)("Updated isMissingAttachmentScanCompleted [" + bl + "]"));
    }

    public Long getMissingAttachmentScannerLastRun() {
        return (Long)this.ao.get((Object)al);
    }

    public void setMissingAttachmentScannerLastRun(long l) {
        this.as.createGlobalSettings().put(al, (Object)String.valueOf(l));
        this.ao.remove((Object)al);
        a.debug((Object)("Updated missingAttachmentJobLastRun [" + l + "]"));
    }

    public void b(String string, String string2, String string3, String string4, String string5, String string6) {
        PluginSettings pluginSettings = this.as.createGlobalSettings();
        pluginSettings.put(af, (Object)string);
        this.ao.remove((Object)af);
        a.debug((Object)("Updated missingAttachmentJobStartHour [" + string + "]"));
        pluginSettings.put(ag, (Object)string2);
        this.ao.remove((Object)ag);
        a.debug((Object)("Updated missingAttachmentJobStartMinute [" + string2 + "]"));
        pluginSettings.put(ah, (Object)string3);
        this.ao.remove((Object)ah);
        a.debug((Object)("Updated missingAttachmentJobStartAmPm [" + string3 + "]"));
        pluginSettings.put(ai, (Object)string4);
        this.ao.remove((Object)ai);
        a.debug((Object)("Updated missingAttachmentJobEndHour [" + string4 + "]"));
        pluginSettings.put(aj, (Object)string5);
        this.ao.remove((Object)aj);
        a.debug((Object)("Updated missingAttachmentJobEndMinute [" + string5 + "]"));
        pluginSettings.put(ak, (Object)string6);
        this.ao.remove((Object)ak);
        a.debug((Object)("Updated missingAttachmentJobEndAmPm [" + string6 + "]"));
    }

    public String getMissingAttachmentScannerStartHour() {
        return (String)this.ao.get((Object)af);
    }

    public String getMissingAttachmentScannerStartMinute() {
        return (String)this.ao.get((Object)ag);
    }

    public String getMissingAttachmentScannerStartAmPm() {
        return (String)this.ao.get((Object)ah);
    }

    public String getMissingAttachmentScannerEndHour() {
        return (String)this.ao.get((Object)ai);
    }

    public String getMissingAttachmentScannerEndMinute() {
        return (String)this.ao.get((Object)aj);
    }

    public String getMissingAttachmentScannerEndAmPm() {
        return (String)this.ao.get((Object)ak);
    }

    public String b(@NotNull String string) {
        String string2;
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        if ((string2 = this.au.detect(string)).equalsIgnoreCase(f)) {
            if (string.equalsIgnoreCase(".dcm")) {
                string2 = "application/dicom";
            } else if (string.equalsIgnoreCase(".hwp")) {
                string2 = "application/x-hwp-v5";
            } else if (string.equalsIgnoreCase(".xd")) {
                string2 = "application/vnd.adobe.sparkler.project+dcxucf";
            }
        }
        return string2;
    }

    public boolean c(String string) {
        boolean bl;
        a.debug((Object)"*** Checking Extension ***");
        if (string != null) {
            boolean bl2 = bl = (string.equals(j) || string.equals(i)) && this.a();
            if (!bl) {
                String string2 = this.getFilterMode();
                boolean bl3 = string2.equalsIgnoreCase("whitelist");
                Set<String> set = this.getExtensionSet();
                bl = bl3 && set.contains(string) || !bl3 && !set.contains(string);
            }
        } else {
            bl = true;
        }
        a.debug((Object)("Is extension [" + string + "] valid? [" + bl + "]"));
        return bl;
    }

    public boolean a(String string, String string2, InputStream inputStream) {
        boolean bl;
        a.debug((Object)"*** Checking Mime Type ***");
        String string3 = this.getFilterMode();
        a.debug((Object)("Filter mode [" + string3 + "]"));
        a.debug((Object)("Mime type [" + string2 + "]"));
        String string4 = MediaType.parse((String)string2).getBaseType().toString();
        a.debug((Object)("Base mime type [" + string4 + "]"));
        boolean bl2 = string3.equalsIgnoreCase("whitelist");
        boolean bl3 = AttachmentCheckerHelper.a(string, string4, inputStream);
        if (string4.equals("application/x-tika-ooxml-protected")) {
            String string5 = this.getAllowProtected();
            a.debug((Object)("Allow protected [" + string5 + "]"));
            bl = string5.equals("on");
        } else if (bl3) {
            String string6 = this.getAllowEncrypted();
            a.debug((Object)("Allow encrypted [" + string6 + "]"));
            bl = string6.equals("on");
        } else if (string4.equals("application/vnd.apple.unknown.13")) {
            a.debug((Object)"Apple keynote/numbers/pages file detected");
            bl = this.a(bl2, string, ".key", ".numbers", ".pages");
        } else if (string4.equals("application/vnd.ms-spreadsheetml") || string4.equals("application/vnd.ms-wordml")) {
            a.debug((Object)"Office xml file detected");
            bl = this.a(bl2, string, ".xml");
        } else {
            boolean bl4 = bl = this.d(string, string4) && this.a() || this.b(string, string4, inputStream);
            if (!bl) {
                Set<String> set = this.getMimeTypeSet();
                bl = bl2 && set.contains(string4) || !bl2 && !set.contains(string4);
            }
        }
        a.debug((Object)("Is mime type [" + string4 + "] valid? [" + bl + "]"));
        return bl;
    }

    private boolean a(boolean bl, String string, String ... stringArray) {
        boolean bl2 = false;
        for (String string2 : stringArray) {
            boolean bl3 = bl2 = bl && string2.equals(string) || !bl && !this.getExtensionSet().contains(string2);
            if (bl2) break;
        }
        return bl2;
    }

    private boolean b(@NotNull String string, String string2, InputStream inputStream) {
        boolean bl = false;
        if (".ics".equals(string) && string2.equals("text/html")) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string3 = bufferedReader.readLine();
                a.debug((Object)("First line [" + string3 + "]"));
                bl = string3.equals("BEGIN:VCALENDAR");
            }
            catch (IOException iOException) {
                a.error((Object)"IOException while trying to read input stream", (Throwable)iOException);
            }
        }
        a.debug((Object)("Is calendar file with html? [" + bl + "]"));
        return bl;
    }

    private boolean d(String string, String string2) {
        boolean bl = false;
        if (string != null) {
            bl = (string.equals(j) || string.equals(i)) && string2.equals("text/plain") || string.equals(i) && string2.equals(f);
        }
        a.debug((Object)("Is Table Spreadsheet Macro attachments? [" + bl + "]"));
        return bl;
    }

    public boolean a(String string, long l, ConfluenceUser confluenceUser) {
        a.debug((Object)("User [" + confluenceUser + "]"));
        FileSizeLimit fileSizeLimit = null;
        if (confluenceUser != null) {
            List<FileSizeGroup> list = this.ap.getFileSizeGroups();
            for (FileSizeGroup fileSizeGroup : list) {
                try {
                    Group group = this.aq.getGroup(fileSizeGroup.getGroup());
                    if (!this.aq.hasMembership(group, (User)confluenceUser)) continue;
                    a.debug((Object)("Get file size limit for [" + fileSizeGroup.getGroup() + "]"));
                    fileSizeLimit = this.ap.b(fileSizeGroup.getID(), string);
                    break;
                }
                catch (EntityException entityException) {
                    a.error((Object)entityException.getMessage());
                }
            }
            if (fileSizeLimit == null) {
                a.debug((Object)"Get file size limit for any logged in user");
                fileSizeLimit = this.ap.b(0, string);
            }
        } else {
            a.debug((Object)"Get file size limit for anonymous ");
            fileSizeLimit = this.ap.b(-1, string);
        }
        if (fileSizeLimit != null) {
            long l2 = AttachmentCheckerHelper.a(fileSizeLimit.getSizeLimit(), fileSizeLimit.getSizeUnit());
            a.debug((Object)("Mime type [" + string + "] size limit [" + l2 + "] bytes"));
            a.debug((Object)("File size [" + l + "] bytes"));
            return l > l2;
        }
        return false;
    }

    public Map<String, String> a(String string, long l) {
        a.debug((Object)"*** Checking Storage ***");
        a.debug((Object)("Space key [" + string + "]"));
        a.debug((Object)("File size [" + l + "]"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SpaceInfo spaceInfo = this.at.b(string);
        long l2 = spaceInfo.getStorageAllocated();
        if (l2 == -1L) {
            l2 = this.getDefaultStorageAllocated();
        }
        if (l2 == 0L) {
            a.debug((Object)"Storage allocated [Unlimited]");
            hashMap.put("storageInfo", "(Unlimited Storage)");
            hashMap.put("isSufficient", Boolean.toString(true));
        } else {
            long l3 = spaceInfo.getStorageUsed();
            long l4 = l2 - l3;
            a.debug((Object)("Storage allocated [" + l2 + "]"));
            a.debug((Object)("Storage available [" + l4 + "]"));
            hashMap.put("allocated", AttachmentCheckerHelper.a(l2, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("available", AttachmentCheckerHelper.a(l4, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("used", AttachmentCheckerHelper.a(l3, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("isSufficient", String.valueOf(l <= l4));
        }
        return hashMap;
    }

    private class AcConfigCacheLoader
    implements CacheLoader<String, Object> {
        private AcConfigCacheLoader() {
        }

        @Nonnull
        public Object a(@Nonnull String string) {
            Object object;
            String string2 = null;
            try {
                string2 = this.b(string);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            a.debug((Object)("Get value for key [" + string + "]"));
            switch (string) {
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions": {
                    object = this.a(string2, AttachmentCheckerConfig.k);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map": {
                    object = this.c(AttachmentCheckerConfig.u);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set": {
                    object = this.c(AttachmentCheckerConfig.v);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set": {
                    object = this.c(AttachmentCheckerConfig.w);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.filterMode": {
                    object = this.d(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowEncrypted": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowProtected": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowTableSpreadsheetMacro": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.onAccessScanning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerMode": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.autoDeleteMode": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfInfected": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.deleteIfError": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfError": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.trackLargeAttachment": {
                    object = this.a(string2, "off");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.largeAttachmentSize": {
                    object = this.a(string2, 0xFA00000L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobLastRun": {
                    object = this.a(string2, 0L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.message": {
                    object = this.a(string2, AttachmentCheckerConfig.m);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeCheck": {
                    object = this.a(string2, "disabled");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeError": {
                    object = this.a(string2, AttachmentCheckerConfig.o);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.enableQuotaCheckAfterSetup": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isJobRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanCompleted": {
                    object = this.a(string2, Boolean.FALSE.toString());
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.groupToEmail": {
                    object = this.a(string2, "confluence-administrators");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerPath": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerOption": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusAlertActor": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanNodeId": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndAmPm": {
                    object = this.a(string2, "");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCheck": {
                    object = this.a(string2, "disabled");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaError": {
                    object = this.a(string2, AttachmentCheckerConfig.q);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultStorage": {
                    object = this.a(string2, 0L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unit": {
                    object = this.a(string2, AttachmentCheckerConfig.r);
                    break;
                }
                default: {
                    object = "This should not happen";
                }
            }
            return object;
        }

        private String b(@NotNull String string) {
            switch (string) {
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set": {
                    return null;
                }
            }
            return AttachmentCheckerConfig.this.as.createGlobalSettings().get(string).toString();
        }

        @NotNull
        private String a(String string, String string2) {
            if (string == null || string.trim().isEmpty()) {
                string = string2;
            }
            a.debug((Object)("String value [" + string + "]"));
            return string;
        }

        private Object c(String string) {
            String string2 = (String)AttachmentCheckerConfig.this.ao.get((Object)AttachmentCheckerConfig.t);
            HashMap<String, List> hashMap = new HashMap<String, List>();
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            if (string2 != null && string2.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                while (stringTokenizer.hasMoreElements()) {
                    List list;
                    String string3 = (String)stringTokenizer.nextElement();
                    if (!string3.startsWith(".")) {
                        string3 = ".".concat(string3);
                    }
                    a.debug((Object)("Adding extension [" + string3 + "]"));
                    treeSet.add(string3);
                    String string4 = AttachmentCheckerConfig.this.b(string3);
                    if (string4.equalsIgnoreCase(AttachmentCheckerConfig.g) || string4.equalsIgnoreCase(AttachmentCheckerConfig.h)) {
                        treeSet2.add(AttachmentCheckerConfig.g);
                        treeSet2.add(AttachmentCheckerConfig.h);
                        a.debug((Object)("Adding mime type [application/x-msdownload] for [" + string3 + "]"));
                        a.debug((Object)("Adding mime type [application/x-dosexec] for [" + string3 + "]"));
                        list = AttachmentCheckerConfig.this.c(string3, AttachmentCheckerConfig.h);
                        list.addAll(AttachmentCheckerConfig.this.c(string3, AttachmentCheckerConfig.g));
                    } else {
                        treeSet2.add(string4);
                        a.debug((Object)("Adding mime type [" + string4 + "] for [" + string3 + "]"));
                        list = AttachmentCheckerConfig.this.c(string3, string4);
                    }
                    treeSet.addAll(list);
                    hashMap.put(string3, list);
                }
            }
            if (string.equalsIgnoreCase(AttachmentCheckerConfig.u)) {
                return hashMap;
            }
            if (string.equalsIgnoreCase(AttachmentCheckerConfig.v)) {
                return treeSet;
            }
            return treeSet2;
        }

        private String d(String string) {
            if (string == null || !string.equalsIgnoreCase(AttachmentCheckerConfig.c) && !string.equalsIgnoreCase("whitelist")) {
                string = "whitelist";
            }
            a.debug((Object)("Filter mode [" + string + "]"));
            return string.toLowerCase();
        }

        private Long a(String string, long l) {
            long l2;
            if (string == null || string.isEmpty()) {
                string = String.valueOf(l);
            }
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = l;
            }
            a.debug((Object)("Long value [" + string + "]"));
            return l2;
        }

        @Nonnull
        public /* synthetic */ Object load(@Nonnull Object object) {
            return this.a((String)object);
        }
    }
}

