/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirusScanningJobHelper {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.utils.VirusScanningJobHelper");
    private final AttachmentManager b;
    private final CommentManager c;
    private final PageManager d;
    private final TransactionTemplate e;

    @Autowired
    public VirusScanningJobHelper(@ComponentImport AttachmentManager attachmentManager, @ComponentImport CommentManager commentManager, @ComponentImport PageManager pageManager, @ComponentImport TransactionTemplate transactionTemplate) {
        this.b = attachmentManager;
        this.c = commentManager;
        this.d = pageManager;
        this.e = transactionTemplate;
    }

    public File a(Attachment attachment) {
        File file = null;
        a.debug((Object)"Creating temp file...");
        try {
            file = File.createTempFile("AttachmentCheckerTempFile", ".tmp");
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            a.error((Object)"Error creating temp file", (Throwable)iOException);
        }
        if (file != null) {
            try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                 InputStream inputStream = this.b.getAttachmentData(attachment);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (IOException iOException) {
                a.error((Object)"Error copying content", (Throwable)iOException);
            }
        }
        return file;
    }

    @NotNull
    public static String a(String string, UserKey userKey, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string2 = "<p>Hi <ac:link><ri:user ri:userkey=\"" + userKey + "\"/></ac:link>, </p>";
        if (bl) {
            string2 = string2 + "<p>Attachment Checker has detected an infected file <strong>" + string + "</strong>.</p>";
            string2 = bl2 ? string2 + "<p>It has been deleted and replaced with a placeholder.</p><p>You may delete the placeholder version.</p>" : string2 + "<p>Please delete it. Thank you.</p>";
        } else {
            string2 = string2 + "<p>There is an issue with scanning the attachment <strong>" + string + "</strong>.</p>";
            string2 = bl3 ? string2 + "<p>It has been deleted and replaced with a placeholder.</p><p>You may delete the placeholder version.</p>" : (bl4 ? string2 + "<p>The admins have been alerted and it will be deleted if found to be infected.</p><p>Please be careful with the attachment in the meantime.</p>" : string2 + "<p>Please be careful with the attachment.</p>");
        }
        return string2;
    }

    public void a(String string, long l, ConfluenceUser confluenceUser) {
        this.e.execute(() -> {
            ContentEntityObject contentEntityObject = this.d.getById(l);
            if (contentEntityObject != null) {
                String string2 = contentEntityObject.getType();
                String string3 = contentEntityObject.getTitle();
                a.debug((Object)("Adding comment to [" + string2 + "] with title [" + string3 + "]"));
                ConfluenceUser confluenceUser2 = AuthenticatedUserThreadLocal.get();
                AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser);
                this.c.addCommentToObject(contentEntityObject, null, string);
                AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser2);
            } else {
                a.debug((Object)("ContentEntityObject with id [" + l + "] is null"));
            }
            return null;
        });
    }
}

