/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.notification;

import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import java.lang.invoke.SerializedLambda;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MailService {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.notification.MailService");
    private static final String b = "mail";
    private final AttachmentCheckerConfig c;
    private final GroupManager d;
    private final MultiQueueTaskManager e;
    private final PageManager f;
    private final UserAccessor g;

    @Autowired
    public MailService(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport GroupManager groupManager, @ComponentImport MultiQueueTaskManager multiQueueTaskManager, @ComponentImport PageManager pageManager, @ComponentImport UserAccessor userAccessor) {
        this.c = attachmentCheckerConfig;
        this.d = groupManager;
        this.e = multiQueueTaskManager;
        this.f = pageManager;
        this.g = userAccessor;
    }

    public void a(boolean bl, int n, String string, String string2, long l, @NotNull Attachment attachment, String string3) {
        boolean bl2;
        String string4;
        Group group;
        String string5 = this.c.getGroupToEmail();
        a.debug((Object)("Send email to group [" + string5 + "] regarding attachment [" + string + "]"));
        ConfluenceUser confluenceUser = attachment.getCreator();
        String string6 = confluenceUser == null ? "Anonymous" : confluenceUser.getName();
        String string7 = attachment.getCreationDate().toString();
        a.debug((Object)("Attachment creator [" + string6 + "]"));
        a.debug((Object)("Attachment creation date [" + string7 + "]"));
        try {
            group = this.d.getGroup(string5);
        }
        catch (EntityException entityException) {
            a.error((Object)("Error getting group with group name [" + string5 + "]"), (Throwable)entityException);
            return;
        }
        ContentEntityObject contentEntityObject = this.f.getById(l);
        String string8 = "page id " + l;
        String string9 = "Attachment Checker for Confluence alert";
        if (contentEntityObject != null) {
            string9 = string9 + " for " + contentEntityObject.getType().toLowerCase() + ": " + contentEntityObject.getDisplayTitle();
            string8 = contentEntityObject.getType().toLowerCase() + " <a href=\"" + string3 + contentEntityObject.getUrlPath() + "\">" + contentEntityObject.getDisplayTitle() + "</a>";
        } else {
            a.debug((Object)("ContentEntityObject with id [" + l + "] is null"));
        }
        a.debug((Object)("Email subject [" + string9 + "]"));
        if (bl) {
            string4 = "<p>Attachment Checker has detected an infected file <strong>" + string + "</strong> attached to " + string8 + ".</p>";
            bl2 = this.c.e();
        } else {
            string4 = "<p>Attachment Checker has encountered an error while scanning <strong>" + string + "</strong> attached to " + string8 + ".</p>";
            bl2 = this.c.g();
        }
        string4 = string4 + "<p>Attachment creator: " + string6 + "<br>Attachment creation date: " + string7 + "</p>";
        string4 = string4 + "<p>The error code is <strong>" + n + "</strong>.</p>";
        string4 = string4 + (bl2 ? "<p>The file has been deleted.</p>" : "<p>To scan the file manually, please execute the command:</p><p>" + string2 + "</p>");
        a.debug((Object)("Email body [" + string4 + "]"));
        a.debug((Object)("Getting members of group [" + group + "]"));
        Iterable iterable = this.g.getMembers(group);
        for (ConfluenceUser confluenceUser2 : iterable) {
            a.debug((Object)("Group member [" + confluenceUser2 + "]"));
            String string10 = confluenceUser2.getEmail();
            ConfluenceMailQueueItem confluenceMailQueueItem = new ConfluenceMailQueueItem(string10, string9, string4, "text/html");
            this.e.addTask(b, () -> ((MailQueueItem)confluenceMailQueueItem).send());
            a.debug((Object)("Added mail to queue for user [" + confluenceUser2.getKey() + "] email [" + string10 + "]"));
        }
        a.debug((Object)"Done!");
    }

    private static /* synthetic */ Object a(SerializedLambda serializedLambda) {
        switch (serializedLambda.getImplMethodName()) {
            case "send": {
                if (serializedLambda.getImplMethodKind() != 9 || !serializedLambda.getFunctionalInterfaceClass().equals("com/atlassian/core/task/Task") || !serializedLambda.getFunctionalInterfaceMethodName().equals("execute") || !serializedLambda.getFunctionalInterfaceMethodSignature().equals("()V") || !serializedLambda.getImplClass().equals("com/atlassian/mail/queue/MailQueueItem") || !serializedLambda.getImplMethodSignature().equals("()V")) break;
                return () -> ((MailQueueItem)((MailQueueItem)serializedLambda.getCapturedArg(0))).send();
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

