/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.config;

import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeGroup;
import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeLimit;
import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.akelesconsulting.confluence.plugins.ao.service.FileSizeLimitService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentCheckerConfig {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.config.AttachmentCheckerConfig");
    private static final String b = "whitelist";
    private static final String c = "blacklist";
    private static final String d = "enabled";
    private static final String e = "disabled";
    private static final String f = "application/octet-stream";
    private static final String g = "application/x-msdownload";
    private static final String h = "application/x-dosexec";
    private static final String i = ".render";
    private static final String j = ".tfss";
    private static final String k = "jpg";
    private static final String l = "whitelist";
    private static final String m = "This file type is not allowed.";
    private static final String n = "disabled";
    private static final String o = "The file size has exceeded the maximum size limit set for the file type.";
    private static final String p = "disabled";
    private static final String q = "Insufficient storage available.";
    private static final String r = "MB";
    private static final String s = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.";
    private static final String t = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions";
    private static final String u = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map";
    private static final String v = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set";
    private static final String w = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set";
    private static final String x = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.filterMode";
    private static final String y = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowProtected";
    private static final String z = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowEncrypted";
    private static final String A = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowTableSpreadsheetMacro";
    private static final String B = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.message";
    private static final String C = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeCheck";
    private static final String D = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeError";
    private static final String E = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.onAccessScanning";
    private static final String F = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerMode";
    private static final String G = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerPath";
    private static final String H = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerOption";
    private static final String I = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.autoDeleteMode";
    private static final String J = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfInfected";
    private static final String K = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.deleteIfError";
    private static final String L = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfError";
    private static final String M = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.groupToEmail";
    private static final String N = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusAlertActor";
    private static final String O = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanRunning";
    private static final String P = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanNodeId";
    private static final String Q = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCheck";
    private static final String R = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaError";
    private static final String S = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unit";
    private static final String T = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultStorage";
    private static final String U = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndAmPm";
    private static final String V = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndHour";
    private static final String W = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndMinute";
    private static final String X = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartAmPm";
    private static final String Y = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartHour";
    private static final String Z = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartMinute";
    private static final String aa = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isJobRunning";
    private static final String ab = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.enableQuotaCheckAfterSetup";
    private static final String ac = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.trackLargeAttachment";
    private static final String ad = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.largeAttachmentSize";
    private static final long ae = 0xFA00000L;
    private final Cache<String, Object> af;
    private final FileSizeLimitService ag;
    private final GroupManager ah;
    private final MimeTypes ai;
    private final PluginSettingsFactory aj;
    private final SpaceInfoService ak;
    private final Tika al;
    private final UserAccessor am;

    @Autowired
    public AttachmentCheckerConfig(FileSizeLimitService fileSizeLimitService, @ComponentImport GroupManager groupManager, @ComponentImport PluginSettingsFactory pluginSettingsFactory, SpaceInfoService spaceInfoService, @ComponentImport @NotNull CacheManager cacheManager, @ComponentImport UserAccessor userAccessor) {
        String string = AttachmentCheckerConfig.class.getName() + ".cache";
        CacheSettings cacheSettings = new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(1000).flushable().build();
        this.af = cacheManager.getCache(string, (CacheLoader)new AcConfigCacheLoader(), cacheSettings);
        this.ah = groupManager;
        this.ag = fileSizeLimitService;
        this.ai = MimeTypes.getDefaultMimeTypes();
        this.aj = pluginSettingsFactory;
        this.ak = (SpaceInfoService)Preconditions.checkNotNull((Object)spaceInfoService);
        this.al = new Tika();
        this.am = userAccessor;
    }

    public List<String> a(String string) {
        List<String> list;
        String string2;
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        if ((string2 = this.al.detect(string)).equalsIgnoreCase(g) || string2.equalsIgnoreCase(h)) {
            list = this.a(string, g);
            list.addAll(this.a(string, h));
        } else {
            list = this.a(string, string2);
        }
        return list;
    }

    private List<String> a(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            MimeType mimeType = this.ai.forName(string2);
            List list = mimeType.getExtensions();
            for (String string3 : list) {
                if (string3.equalsIgnoreCase(string)) continue;
                arrayList.add(string3);
            }
        }
        catch (MimeTypeException mimeTypeException) {
            a.debug((Object)mimeTypeException.getMessage());
        }
        return arrayList;
    }

    public String getExtensions() {
        return (String)this.af.get((Object)t);
    }

    public String getFilterMode() {
        return (String)this.af.get((Object)x);
    }

    public String getFileTypeErrorMessage() {
        return (String)this.af.get((Object)B);
    }

    public Map<String, List<String>> getExtensionsMap() {
        return (Map)this.af.get((Object)u);
    }

    public Set<String> getExtensionSet() {
        TreeSet treeSet = (TreeSet)this.af.get((Object)v);
        if (treeSet == null) {
            treeSet = new TreeSet();
        }
        return treeSet;
    }

    public Set<String> getMimeTypeSet() {
        TreeSet treeSet = (TreeSet)this.af.get((Object)w);
        if (treeSet == null) {
            treeSet = new TreeSet();
        }
        return treeSet;
    }

    public void setExtensions(String string) {
        this.aj.createGlobalSettings().put(t, (Object)string);
        this.af.remove((Object)t);
        this.af.remove((Object)u);
        this.af.remove((Object)v);
        this.af.remove((Object)w);
        a.debug((Object)("Updated extensions [" + string + "]"));
    }

    public void setFilterMode(String string) {
        this.aj.createGlobalSettings().put(x, (Object)string);
        this.af.remove((Object)x);
        a.debug((Object)("Updated filter mode [" + string + "]"));
    }

    public void setFileTypeErrorMessage(String string) {
        this.aj.createGlobalSettings().put(B, (Object)string);
        this.af.remove((Object)B);
        a.debug((Object)("Updated file type error message [" + string + "]"));
    }

    public String getAllowProtected() {
        return (String)this.af.get((Object)y);
    }

    public void setAllowProtected(String string) {
        this.aj.createGlobalSettings().put(y, (Object)string);
        this.af.remove((Object)y);
        a.debug((Object)("Updated allow protected [" + string + "]"));
    }

    public String getAllowEncrypted() {
        return (String)this.af.get((Object)z);
    }

    public void setAllowEncrypted(String string) {
        this.aj.createGlobalSettings().put(z, (Object)string);
        this.af.remove((Object)z);
        a.debug((Object)("Updated allow encrypted [" + string + "]"));
    }

    public String getAllowTableSpreadsheetMacro() {
        return (String)this.af.get((Object)A);
    }

    public boolean a() {
        return "on".equalsIgnoreCase(this.getAllowTableSpreadsheetMacro());
    }

    public void setAllowTableSpreadsheetMacro(String string) {
        this.aj.createGlobalSettings().put(A, (Object)string);
        this.af.remove((Object)A);
        a.debug((Object)("Updated allow Table Spreadsheet Macro [" + string + "]"));
    }

    public String getFileSizeCheck() {
        return (String)this.af.get((Object)C);
    }

    public String getFileSizeErrMsg() {
        return (String)this.af.get((Object)D);
    }

    public boolean b() {
        return this.getFileSizeCheck().equalsIgnoreCase(d);
    }

    public void setFileSizeCheck(String string) {
        this.aj.createGlobalSettings().put(C, (Object)string);
        this.af.remove((Object)C);
        a.debug((Object)("Updated file size check [" + string + "]"));
    }

    public void setFileSizeErrMsg(String string) {
        this.aj.createGlobalSettings().put(D, (Object)string);
        this.af.remove((Object)D);
        a.debug((Object)("Updated file size error message [" + string + "]"));
    }

    public boolean c() {
        return this.getMissingFileCheck().equalsIgnoreCase("on");
    }

    public String getMissingFileCheck() {
        String string = (String)this.af.get((Object)E);
        if (Boolean.TRUE.toString().equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setMissingFileCheck(String string) {
        this.aj.createGlobalSettings().put(E, (Object)string);
        this.af.remove((Object)E);
        a.debug((Object)("Updated missing file check [" + string + "]"));
    }

    public boolean d() {
        return this.getVirusScanning().equalsIgnoreCase("on");
    }

    public String getVirusScanning() {
        String string = (String)this.af.get((Object)F);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setVirusScanning(String string) {
        this.aj.createGlobalSettings().put(F, (Object)string);
        this.af.remove((Object)F);
        a.debug((Object)("Updated virus scanning [" + string + "]"));
    }

    public boolean a(int n, @NotNull String string) {
        boolean bl = true;
        if (!this.getScannerDetected().equalsIgnoreCase("unknown")) {
            bl = n == 1 && (string.contains("clamscan") || string.contains("clamdscan") || string.contains("fpscan")) || n == 3 && string.contains("savscan") || n == 13 && (string.contains("uvscan") || string.contains("scan.exe")) || n == 50 && (string.contains("ecls.exe") || string.contains("eset")) || n == 72 && string.contains("kesl-control");
        }
        a.debug((Object)("Is infected? [" + bl + "]"));
        return bl;
    }

    public String getScannerDetected() {
        String string = this.getScannerPath().toLowerCase();
        String string2 = string.contains("clamscan") || string.contains("clamdscan") ? "ClamAV" : (string.contains("ecls.exe") || string.contains("eset") ? "ESET" : (string.contains("fpscan") ? "F-PROT Antivirus" : (string.contains("kesl-control") ? "Kaspersky Endpoint Security for Linux" : (string.contains("savscan") ? "Sophos Anti-Virus" : (string.contains("uvscan") || string.contains("scan.exe") ? "McAfee VirusScan" : "unknown")))));
        return string2;
    }

    public String getScannerPath() {
        return (String)this.af.get((Object)G);
    }

    public void setScannerPath(String string) {
        this.aj.createGlobalSettings().put(G, (Object)string);
        this.af.remove((Object)G);
        a.debug((Object)("Updated scanner path [" + string + "]"));
    }

    public String getScannerOption() {
        return (String)this.af.get((Object)H);
    }

    public void setScannerOption(String string) {
        this.aj.createGlobalSettings().put(H, (Object)string);
        this.af.remove((Object)H);
        a.debug((Object)("Updated scanner option [" + string + "]"));
    }

    public boolean e() {
        return this.getDeleteIfInfected().equalsIgnoreCase("on");
    }

    public String getDeleteIfInfected() {
        String string = (String)this.af.get((Object)I);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setDeleteIfInfected(String string) {
        this.aj.createGlobalSettings().put(I, (Object)string);
        this.af.remove((Object)I);
        a.debug((Object)("Updated delete if infected [" + string + "]"));
    }

    public boolean f() {
        return this.getEmailIfInfected().equalsIgnoreCase("on");
    }

    public String getEmailIfInfected() {
        return (String)this.af.get((Object)J);
    }

    public void setEmailIfInfected(String string) {
        this.aj.createGlobalSettings().put(J, (Object)string);
        this.af.remove((Object)J);
        a.debug((Object)("Updated email if infected [" + string + "]"));
    }

    public boolean g() {
        return this.getDeleteIfError().equalsIgnoreCase("on");
    }

    public String getDeleteIfError() {
        return (String)this.af.get((Object)K);
    }

    public void setDeleteIfError(String string) {
        this.aj.createGlobalSettings().put(K, (Object)string);
        this.af.remove((Object)K);
        a.debug((Object)("Updated delete if error [" + string + "]"));
    }

    public boolean h() {
        return this.getEmailIfError().equalsIgnoreCase("on");
    }

    public String getEmailIfError() {
        return (String)this.af.get((Object)L);
    }

    public void setEmailIfError(String string) {
        this.aj.createGlobalSettings().put(L, (Object)string);
        this.af.remove((Object)L);
        a.debug((Object)("Updated email if error [" + string + "]"));
    }

    public String getGroupToEmail() {
        return (String)this.af.get((Object)M);
    }

    public void setGroupToEmail(String string) {
        this.aj.createGlobalSettings().put(M, (Object)string);
        this.af.remove((Object)M);
        a.debug((Object)("Updated group to email (Confluence Sysadmin Group) [" + string + "]"));
    }

    private String getVirusAlertActor() {
        return (String)this.af.get((Object)N);
    }

    public void setVirusAlertActor(String string) {
        this.aj.createGlobalSettings().put(N, (Object)string);
        this.af.remove((Object)N);
        a.debug((Object)("Updated virus alert actor [" + string + "]"));
    }

    public ConfluenceUser getVirusAlertActorUser() {
        ConfluenceUser confluenceUser = null;
        String string = this.getVirusAlertActor();
        if (!string.isEmpty()) {
            confluenceUser = this.am.getUserByKey(new UserKey(string));
        }
        return confluenceUser;
    }

    public boolean getIsVirusScanRunning() {
        return Boolean.parseBoolean((String)this.af.get((Object)O));
    }

    public void setIsVirusScanRunning(boolean bl) {
        this.aj.createGlobalSettings().put(O, (Object)Boolean.toString(bl));
        this.af.remove((Object)O);
        a.debug((Object)("Updated is virus scan running? [" + bl + "]"));
    }

    public String getVirusScanNodeId() {
        return (String)this.af.get((Object)P);
    }

    public void setVirusScanNodeId(String string) {
        this.aj.createGlobalSettings().put(P, (Object)string);
        this.af.remove((Object)P);
        a.debug((Object)("Updated virus scan node id [" + string + "]"));
    }

    public String getQuotaCheck() {
        return (String)this.af.get((Object)Q);
    }

    public String getQuotaErrorMessage() {
        return (String)this.af.get((Object)R);
    }

    public String getUnit() {
        return (String)this.af.get((Object)S);
    }

    public long getDefaultStorageAllocated() {
        Long l = (Long)this.af.get((Object)T);
        return l == null ? 0L : l;
    }

    public boolean i() {
        return this.getQuotaCheck().equalsIgnoreCase(d);
    }

    public boolean j() {
        return this.getDefaultStorageAllocated() == 0L;
    }

    public void setQuotaCheck(String string) {
        this.aj.createGlobalSettings().put(Q, (Object)string);
        this.af.remove((Object)Q);
        a.debug((Object)("Updated quota check [" + string + "]"));
    }

    public void setQuotaErrorMessage(String string) {
        this.aj.createGlobalSettings().put(R, (Object)string);
        this.af.remove((Object)R);
        a.debug((Object)("Updated quota error message [" + string + "]"));
    }

    public void setDefaultStorageAllocated(String string) {
        this.aj.createGlobalSettings().put(T, (Object)string);
        this.af.remove((Object)T);
        a.debug((Object)("Updated default storage allocated [" + string + "] bytes"));
    }

    public void setUnit(String string) {
        this.aj.createGlobalSettings().put(S, (Object)string);
        this.af.remove((Object)S);
        a.debug((Object)("Updated unit [" + string + "]"));
    }

    public String getJobEndAmPm() {
        return (String)this.af.get((Object)U);
    }

    public String getJobEndHour() {
        return (String)this.af.get((Object)V);
    }

    public String getJobEndMinute() {
        return (String)this.af.get((Object)W);
    }

    public String getJobStartAmPm() {
        return (String)this.af.get((Object)X);
    }

    public String getJobStartHour() {
        return (String)this.af.get((Object)Y);
    }

    public String getJobStartMinute() {
        return (String)this.af.get((Object)Z);
    }

    private String getEnableQuotaCheckAfterSetup() {
        return (String)this.af.get((Object)ab);
    }

    private String getIsJobRunning() {
        return (String)this.af.get((Object)aa);
    }

    public boolean k() {
        return Boolean.parseBoolean(this.getEnableQuotaCheckAfterSetup());
    }

    public boolean l() {
        return Boolean.parseBoolean(this.getIsJobRunning());
    }

    public void setJobEndAmPm(String string) {
        this.aj.createGlobalSettings().put(U, (Object)string);
        this.af.remove((Object)U);
        a.debug((Object)("Updated job end am/pm [" + string + "]"));
    }

    public void setJobEndHour(String string) {
        this.aj.createGlobalSettings().put(V, (Object)string);
        this.af.remove((Object)V);
        a.debug((Object)("Updated job end hour [" + string + "]"));
    }

    public void setJobEndMinute(String string) {
        this.aj.createGlobalSettings().put(W, (Object)string);
        this.af.remove((Object)W);
        a.debug((Object)("Updated job end minute [" + string + "]"));
    }

    public void setJobStartAmPm(String string) {
        this.aj.createGlobalSettings().put(X, (Object)string);
        this.af.remove((Object)X);
        a.debug((Object)("Updated job start am/pm [" + string + "]"));
    }

    public void setJobStartHour(String string) {
        this.aj.createGlobalSettings().put(Y, (Object)string);
        this.af.remove((Object)Y);
        a.debug((Object)("Updated job start hour [" + string + "]"));
    }

    public void setJobStartMinute(String string) {
        this.aj.createGlobalSettings().put(Z, (Object)string);
        this.af.remove((Object)Z);
        a.debug((Object)("Updated job start minute [" + string + "]"));
    }

    public void m() {
        this.aj.createGlobalSettings().put(ab, (Object)String.valueOf(this.i()));
        this.af.remove((Object)ab);
        a.debug((Object)("Updated enable quota check after setup [" + this.i() + "]"));
    }

    public void setIsJobRunning(boolean bl) {
        this.aj.createGlobalSettings().put(aa, (Object)String.valueOf(bl));
        this.af.remove((Object)aa);
        a.debug((Object)("Updated is job running [" + bl + "]"));
    }

    public boolean n() {
        return "on".equalsIgnoreCase(this.getTrackLargeAttachment());
    }

    public String getTrackLargeAttachment() {
        return (String)this.af.get((Object)ac);
    }

    public void setTrackLargeAttachment(String string) {
        this.aj.createGlobalSettings().put(ac, (Object)string);
        this.af.remove((Object)ac);
        a.debug((Object)("Updated track large attachment [" + string + "]"));
    }

    public long getLargeAttachmentSize() {
        Long l = (Long)this.af.get((Object)ad);
        return l == null ? 0xFA00000L : l;
    }

    public void setLargeAttachmentSize(String string) {
        this.aj.createGlobalSettings().put(ad, (Object)string);
        this.af.remove((Object)ad);
        a.debug((Object)("Updated large attachment size [" + string + "]"));
    }

    public String b(@NotNull String string) {
        String string2;
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        if ((string2 = this.al.detect(string)).equalsIgnoreCase(f)) {
            if (string.equalsIgnoreCase(".dcm")) {
                string2 = "application/dicom";
            } else if (string.equalsIgnoreCase(".hwp")) {
                string2 = "application/x-hwp-v5";
            } else if (string.equalsIgnoreCase(".xd")) {
                string2 = "application/vnd.adobe.sparkler.project+dcxucf";
            }
        }
        return string2;
    }

    public boolean c(String string) {
        boolean bl;
        a.debug((Object)"*** Checking Extension ***");
        if (string != null) {
            boolean bl2 = bl = (string.equals(j) || string.equals(i)) && this.a();
            if (!bl) {
                String string2 = this.getFilterMode();
                boolean bl3 = string2.equalsIgnoreCase("whitelist");
                Set<String> set = this.getExtensionSet();
                bl = bl3 && set.contains(string) || !bl3 && !set.contains(string);
            }
        } else {
            bl = true;
        }
        a.debug((Object)("Is extension [" + string + "] valid? [" + bl + "]"));
        return bl;
    }

    public boolean a(String string, String string2, InputStream inputStream) {
        boolean bl;
        a.debug((Object)"*** Checking Mime Type ***");
        String string3 = this.getFilterMode();
        a.debug((Object)("Filter mode [" + string3 + "]"));
        a.debug((Object)("Mime type [" + string2 + "]"));
        String string4 = MediaType.parse((String)string2).getBaseType().toString();
        a.debug((Object)("Base mime type [" + string4 + "]"));
        boolean bl2 = string3.equalsIgnoreCase("whitelist");
        boolean bl3 = AttachmentCheckerHelper.a(string, string4, inputStream);
        if (string4.equals("application/x-tika-ooxml-protected")) {
            String string5 = this.getAllowProtected();
            a.debug((Object)("Allow protected [" + string5 + "]"));
            bl = string5.equals("on");
        } else if (bl3) {
            String string6 = this.getAllowEncrypted();
            a.debug((Object)("Allow encrypted [" + string6 + "]"));
            bl = string6.equals("on");
        } else if (string4.equals("application/vnd.apple.unknown.13")) {
            a.debug((Object)"Apple keynote/numbers/pages file detected");
            bl = this.a(bl2, string, ".key", ".numbers", ".pages");
        } else if (string4.equals("application/vnd.ms-spreadsheetml") || string4.equals("application/vnd.ms-wordml")) {
            a.debug((Object)"Office xml file detected");
            bl = this.a(bl2, string, ".xml");
        } else {
            boolean bl4 = bl = this.b(string, string4) && this.a() || this.b(string, string4, inputStream);
            if (!bl) {
                Set<String> set = this.getMimeTypeSet();
                bl = bl2 && set.contains(string4) || !bl2 && !set.contains(string4);
            }
        }
        a.debug((Object)("Is mime type [" + string4 + "] valid? [" + bl + "]"));
        return bl;
    }

    private boolean a(boolean bl, String string, String ... stringArray) {
        boolean bl2 = false;
        for (String string2 : stringArray) {
            boolean bl3 = bl2 = bl && string2.equals(string) || !bl && !this.getExtensionSet().contains(string2);
            if (bl2) break;
        }
        return bl2;
    }

    private boolean b(@NotNull String string, String string2, InputStream inputStream) {
        boolean bl = false;
        if (".ics".equals(string) && string2.equals("text/html")) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string3 = bufferedReader.readLine();
                a.debug((Object)("First line [" + string3 + "]"));
                bl = string3.equals("BEGIN:VCALENDAR");
            }
            catch (IOException iOException) {
                a.error((Object)"IOException while trying to read input stream", (Throwable)iOException);
            }
        }
        a.debug((Object)("Is calendar file with html? [" + bl + "]"));
        return bl;
    }

    private boolean b(String string, String string2) {
        boolean bl = false;
        if (string != null) {
            bl = (string.equals(j) || string.equals(i)) && string2.equals("text/plain") || string.equals(i) && string2.equals(f);
        }
        a.debug((Object)("Is Table Spreadsheet Macro attachments? [" + bl + "]"));
        return bl;
    }

    public boolean a(String string, long l, ConfluenceUser confluenceUser) {
        a.debug((Object)("User [" + confluenceUser + "]"));
        FileSizeLimit fileSizeLimit = null;
        if (confluenceUser != null) {
            List<FileSizeGroup> list = this.ag.getFileSizeGroups();
            for (FileSizeGroup fileSizeGroup : list) {
                try {
                    Group group = this.ah.getGroup(fileSizeGroup.getGroup());
                    if (!this.ah.hasMembership(group, (User)confluenceUser)) continue;
                    a.debug((Object)("Get file size limit for [" + fileSizeGroup.getGroup() + "]"));
                    fileSizeLimit = this.ag.b(fileSizeGroup.getID(), string);
                    break;
                }
                catch (EntityException entityException) {
                    a.error((Object)entityException.getMessage());
                }
            }
            if (fileSizeLimit == null) {
                a.debug((Object)"Get file size limit for any logged in user");
                fileSizeLimit = this.ag.b(0, string);
            }
        } else {
            a.debug((Object)"Get file size limit for anonymous ");
            fileSizeLimit = this.ag.b(-1, string);
        }
        if (fileSizeLimit != null) {
            long l2 = AttachmentCheckerHelper.a(fileSizeLimit.getSizeLimit(), fileSizeLimit.getSizeUnit());
            a.debug((Object)("Mime type [" + string + "] size limit [" + l2 + "] bytes"));
            a.debug((Object)("File size [" + l + "] bytes"));
            return l > l2;
        }
        return false;
    }

    public Map<String, String> a(String string, long l) {
        a.debug((Object)"*** Checking Storage ***");
        a.debug((Object)("Space key [" + string + "]"));
        a.debug((Object)("File size [" + l + "]"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SpaceInfo spaceInfo = this.ak.b(string);
        long l2 = spaceInfo.getStorageAllocated();
        if (l2 == -1L) {
            l2 = this.getDefaultStorageAllocated();
        }
        if (l2 == 0L) {
            a.debug((Object)"Storage allocated [Unlimited]");
            hashMap.put("storageInfo", "(Unlimited Storage)");
            hashMap.put("isSufficient", Boolean.toString(true));
        } else {
            long l3 = spaceInfo.getStorageUsed();
            long l4 = l2 - l3;
            a.debug((Object)("Storage allocated [" + l2 + "]"));
            a.debug((Object)("Storage available [" + l4 + "]"));
            hashMap.put("allocated", AttachmentCheckerHelper.a(l2, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("available", AttachmentCheckerHelper.a(l4, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("used", AttachmentCheckerHelper.a(l3, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("isSufficient", String.valueOf(l <= l4));
        }
        return hashMap;
    }

    private class AcConfigCacheLoader
    implements CacheLoader<String, Object> {
        private AcConfigCacheLoader() {
        }

        @Nonnull
        public Object a(@Nonnull String string) {
            Object object;
            String string2 = null;
            try {
                string2 = this.b(string);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            switch (string) {
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions": {
                    object = this.c(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map": {
                    object = this.d(AttachmentCheckerConfig.u);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set": {
                    object = this.d(AttachmentCheckerConfig.v);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set": {
                    object = this.d(AttachmentCheckerConfig.w);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.filterMode": {
                    object = this.e(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowEncrypted": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowProtected": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowTableSpreadsheetMacro": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.onAccessScanning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerMode": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.autoDeleteMode": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfInfected": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.deleteIfError": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfError": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.trackLargeAttachment": {
                    object = this.a(string2, "off");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.largeAttachmentSize": {
                    object = this.a(string2, 0xFA00000L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.message": {
                    object = this.f(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeCheck": {
                    object = this.g(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeError": {
                    object = this.h(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanRunning": {
                    object = this.a(string2, Boolean.FALSE.toString());
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.groupToEmail": {
                    object = this.a(string2, "confluence-administrators");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerPath": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerOption": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusAlertActor": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanNodeId": {
                    object = this.a(string2, "");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCheck": {
                    object = this.i(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaError": {
                    object = this.j(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultStorage": {
                    object = this.a(string2, 0L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unit": {
                    object = this.k(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndAmPm": {
                    object = this.l(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndHour": {
                    object = this.m(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndMinute": {
                    object = this.n(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartAmPm": {
                    object = this.o(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartHour": {
                    object = this.p(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartMinute": {
                    object = this.q(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isJobRunning": {
                    object = this.r(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.enableQuotaCheckAfterSetup": {
                    object = this.s(string2);
                    break;
                }
                default: {
                    object = "This should not happen";
                }
            }
            return object;
        }

        private String b(String string) {
            switch (string) {
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set": {
                    return null;
                }
            }
            return AttachmentCheckerConfig.this.aj.createGlobalSettings().get(string).toString();
        }

        @NotNull
        private String a(String string, String string2) {
            if (string == null || string.trim().isEmpty()) {
                string = string2;
            }
            return string;
        }

        private String c(String string) {
            if (string == null || string.trim().isEmpty()) {
                string = AttachmentCheckerConfig.k;
            }
            a.debug((Object)("Extensions [" + string + "]"));
            return string;
        }

        private Object d(String string) {
            String string2 = (String)AttachmentCheckerConfig.this.af.get((Object)AttachmentCheckerConfig.t);
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            if (string2 != null && string2.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                while (stringTokenizer.hasMoreElements()) {
                    List<String> list;
                    String string3 = (String)stringTokenizer.nextElement();
                    if (!string3.startsWith(".")) {
                        string3 = ".".concat(string3);
                    }
                    a.debug((Object)("Adding extension [" + string3 + "]"));
                    treeSet.add(string3);
                    String string4 = AttachmentCheckerConfig.this.b(string3);
                    if (string4.equalsIgnoreCase(AttachmentCheckerConfig.g) || string4.equalsIgnoreCase(AttachmentCheckerConfig.h)) {
                        treeSet2.add(AttachmentCheckerConfig.g);
                        treeSet2.add(AttachmentCheckerConfig.h);
                        a.debug((Object)("Adding mime type [application/x-msdownload] for [" + string3 + "]"));
                        a.debug((Object)("Adding mime type [application/x-dosexec] for [" + string3 + "]"));
                        list = this.b(string3, AttachmentCheckerConfig.h);
                        list.addAll(this.b(string3, AttachmentCheckerConfig.g));
                    } else {
                        treeSet2.add(string4);
                        a.debug((Object)("Adding mime type [" + string4 + "] for [" + string3 + "]"));
                        list = this.b(string3, string4);
                    }
                    treeSet.addAll(list);
                    hashMap.put(string3, list);
                }
            }
            if (string.equalsIgnoreCase(AttachmentCheckerConfig.u)) {
                return hashMap;
            }
            if (string.equalsIgnoreCase(AttachmentCheckerConfig.v)) {
                return treeSet;
            }
            return treeSet2;
        }

        private List<String> b(String string, String string2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                MimeType mimeType = AttachmentCheckerConfig.this.ai.forName(string2);
                List list = mimeType.getExtensions();
                for (String string3 : list) {
                    if (string3.equalsIgnoreCase(string)) continue;
                    arrayList.add(string3);
                }
            }
            catch (MimeTypeException mimeTypeException) {
                a.debug((Object)mimeTypeException.getMessage());
            }
            return arrayList;
        }

        private String e(String string) {
            if (string == null || !string.equalsIgnoreCase(AttachmentCheckerConfig.c) && !string.equalsIgnoreCase("whitelist")) {
                string = "whitelist";
            }
            a.debug((Object)("Filter mode [" + string + "]"));
            return string.toLowerCase();
        }

        private String f(String string) {
            if (string == null || string.isEmpty()) {
                string = AttachmentCheckerConfig.m;
            }
            a.debug((Object)("File type error message [" + string + "]"));
            return string;
        }

        private String g(String string) {
            if (string == null) {
                string = "disabled";
            }
            a.debug((Object)("File size check [" + string + "]"));
            return string.toLowerCase();
        }

        private String h(String string) {
            if (string == null) {
                string = AttachmentCheckerConfig.o;
            }
            a.debug((Object)("File size error message [" + string + "]"));
            return string;
        }

        private String i(String string) {
            if (string == null) {
                string = "disabled";
            }
            a.debug((Object)("Quota check [" + string + "]"));
            return string.toLowerCase();
        }

        private String j(String string) {
            if (string == null) {
                string = AttachmentCheckerConfig.q;
            }
            a.debug((Object)("Quota error message [" + string + "]"));
            return string;
        }

        private Long a(String string, long l) {
            long l2;
            if (string == null || string.isEmpty()) {
                string = String.valueOf(l);
            }
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = l;
            }
            a.debug((Object)("Long value [" + string + "]"));
            return l2;
        }

        private String k(String string) {
            if (string == null || string.isEmpty()) {
                string = AttachmentCheckerConfig.r;
            }
            a.debug((Object)("Unit [" + string + "]"));
            return string;
        }

        private String l(String string) {
            if (string == null) {
                string = "";
            }
            a.debug((Object)("Job end am/pm [" + string + "]"));
            return string;
        }

        private String m(String string) {
            if (string == null) {
                string = "";
            }
            a.debug((Object)("Job end hour [" + string + "]"));
            return string;
        }

        private String n(String string) {
            if (string == null) {
                string = "";
            }
            a.debug((Object)("Job end minute [" + string + "]"));
            return string;
        }

        private String o(String string) {
            if (string == null) {
                string = "";
            }
            a.debug((Object)("Job start am/pm [" + string + "]"));
            return string;
        }

        private String p(String string) {
            if (string == null) {
                string = "";
            }
            a.debug((Object)("Job start hour [" + string + "]"));
            return string;
        }

        private String q(String string) {
            if (string == null) {
                string = "";
            }
            a.debug((Object)("Job start minute [" + string + "]"));
            return string;
        }

        private String r(String string) {
            if (string == null) {
                string = String.valueOf(false);
            }
            a.debug((Object)("Is job running [" + string + "]"));
            return string;
        }

        private String s(String string) {
            if (string == null) {
                string = String.valueOf(false);
            }
            a.debug((Object)("Enable quota check after setup [" + string + "]"));
            return string;
        }

        @Nonnull
        public /* synthetic */ Object load(@Nonnull Object object) {
            return this.a((String)object);
        }
    }
}

