/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirusScanningJobHelper {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.utils.VirusScanningJobHelper");
    private final AttachmentManager b;
    private final CommentManager c;
    private final PageManager d;
    private final SpaceInfoService e;
    private final TransactionTemplate f;

    @Autowired
    public VirusScanningJobHelper(@ComponentImport AttachmentManager attachmentManager, @ComponentImport CommentManager commentManager, @ComponentImport PageManager pageManager, SpaceInfoService spaceInfoService, @ComponentImport TransactionTemplate transactionTemplate) {
        this.b = attachmentManager;
        this.c = commentManager;
        this.d = pageManager;
        this.e = spaceInfoService;
        this.f = transactionTemplate;
    }

    public Attachment a(long l, int n, Date date) {
        a.debug((Object)("Getting attachment id [" + l + "] v.[" + n + "] with creation date [" + date + "]"));
        Attachment attachment = this.b.getAttachment(l);
        if (attachment != null && (attachment.getVersion() != n || date != null && DateUtils.round((Date)attachment.getCreationDate(), (int)13).getTime() != date.getTime())) {
            a.debug((Object)("Attachment [" + attachment + "]"));
            a.debug((Object)"Version and/or creation date does not match, comparing previous versions...");
            List list = this.b.getAllVersions(attachment);
            attachment = null;
            a.debug((Object)("Finding v.[" + n + "] and creation date [" + (date == null ? "" : Long.valueOf(date.getTime())) + "]"));
            for (Attachment attachment2 : list) {
                int n2 = attachment2.getVersion();
                Date date2 = DateUtils.round((Date)attachment2.getCreationDate(), (int)13);
                a.debug((Object)("v.[" + n2 + "] id [" + attachment2.getId() + "] creation date [" + date2.getTime() + "]"));
                if (n2 != n || date != null && date2.getTime() != date.getTime()) continue;
                a.debug((Object)"Found matching attachment");
                attachment = attachment2;
                break;
            }
        }
        a.debug((Object)("Attachment [" + attachment + "]"));
        return attachment;
    }

    public File a(Attachment attachment) {
        File file = null;
        a.debug((Object)"Creating temp file...");
        try {
            file = File.createTempFile("AttachmentCheckerTempFile", ".tmp");
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            a.error((Object)"Error creating temp file", (Throwable)iOException);
        }
        if (file != null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                 InputStream inputStream = this.b.getAttachmentData(attachment);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            catch (IOException iOException) {
                a.error((Object)"Error copying content", (Throwable)iOException);
            }
        }
        return file;
    }

    public void a(boolean bl, long l, int n, Date date) {
        if (bl) {
            try {
                this.f.execute(() -> {
                    Attachment attachment = this.a(l, n, date);
                    if (attachment != null) {
                        long l2 = 136628L;
                        long l3 = attachment.getFileSize();
                        long l4 = Math.abs(l2 - l3);
                        String string = attachment.getSpaceKey();
                        a.debug((Object)"Saving placeholder... ");
                        attachment.setFileSize(l2);
                        attachment.setMediaType("image/png");
                        attachment.setVersionComment("This is a placeholder to replace the infected file");
                        AttachmentDao attachmentDao = this.b.getAttachmentDao();
                        InputStream inputStream = this.getClass().getResourceAsStream("/images/imageplaceholder.png");
                        attachmentDao.replaceAttachmentData(attachment, inputStream);
                        a.debug((Object)"Placeholder saved!");
                        a.debug((Object)("Placeholder file size [" + l2 + "]"));
                        a.debug((Object)("Original file size [" + l3 + "]"));
                        a.debug((Object)("Offset file size [" + l4 + "]"));
                        this.e.a(string, l4, l3 > l2);
                    }
                    return null;
                });
            }
            catch (Exception exception) {
                a.error((Object)"Exception while trying to replace infected attachment data with placeholder", (Throwable)exception);
            }
        }
    }

    @NotNull
    public static String a(String string, UserKey userKey, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string2 = "<p>Hi <ac:link><ri:user ri:userkey=\"" + userKey + "\"/></ac:link>, </p>";
        if (bl) {
            string2 = string2 + "<p>Attachment Checker has detected an infected file <strong>" + string + "</strong>.</p>";
            string2 = bl2 ? string2 + "<p>It has been deleted and replaced with a placeholder.</p><p>You may delete the placeholder version.</p>" : string2 + "<p>Please delete it. Thank you.</p>";
        } else {
            string2 = string2 + "<p>There is an issue with scanning the attachment <strong>" + string + "</strong>.</p>";
            string2 = bl3 ? string2 + "<p>It has been deleted and replaced with a placeholder.</p><p>You may delete the placeholder version.</p>" : (bl4 ? string2 + "<p>The admins have been alerted and it will be deleted if found to be infected.</p><p>Please be careful with the attachment in the meantime.</p>" : string2 + "<p>Please be careful with the attachment.</p>");
        }
        return string2;
    }

    public void a(String string, long l, ConfluenceUser confluenceUser) {
        this.f.execute(() -> {
            ContentEntityObject contentEntityObject = this.d.getById(l);
            if (contentEntityObject != null) {
                String string2 = contentEntityObject.getType();
                String string3 = contentEntityObject.getTitle();
                a.debug((Object)("Adding comment to [" + string2 + "] with title [" + string3 + "]"));
                ConfluenceUser confluenceUser2 = AuthenticatedUserThreadLocal.get();
                AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser);
                this.c.addCommentToObject(contentEntityObject, null, string);
                AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser2);
            } else {
                a.debug((Object)("ContentEntityObject with id [" + l + "] is null"));
            }
            return null;
        });
    }
}

