/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/config")
public class AttachmentCheckerConfigRestResource {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.rest.AttachmentCheckerConfigRestResource");
    private final AttachmentCheckerConfig b;
    private final PermissionManager c;

    public AttachmentCheckerConfigRestResource(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport PermissionManager permissionManager) {
        this.b = attachmentCheckerConfig;
        this.c = permissionManager;
    }

    @GET
    @Path(value="/extensions")
    @Produces(value={"application/json"})
    public Response getExtensionsMapJson() {
        a.debug((Object)"Get extensions map json...");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        a.debug((Object)("Logged in user [" + confluenceUser + "]"));
        if (this.c.isConfluenceAdministrator((User)confluenceUser)) {
            Map<String, List<String>> map = this.b.getExtensionsMap();
            JSONObject jSONObject = new JSONObject();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                try {
                    jSONObject.put(entry.getKey(), (Collection)entry.getValue());
                }
                catch (JSONException jSONException) {
                    a.error((Object)"JSONException while putting (extension, associated) into JSONObject", (Throwable)jSONException);
                }
            }
            return Response.ok((Object)jSONObject.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"You are not authorised to view this.").build();
    }

    @GET
    @Path(value="/scanner")
    @Produces(value={"text/plain"})
    public Response getScannerDetected() {
        String string = this.b.getScannerDetected();
        a.debug((Object)("Scanner detected [" + string + "]"));
        return Response.ok((Object)string).build();
    }
}

