/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.scheduler;

import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.scheduler.job.CalculateAttachmentJobRunner;
import com.akelesconsulting.confluence.plugins.scheduler.job.VirusScanningJobRunner;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class JobScheduler
implements LifecycleAware,
DisposableBean,
InitializingBean {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.scheduler.JobScheduler");
    private static final String b = "com.akelesconsulting.confluence.plugins.AttachmentChecker4CONF";
    private final AttachmentCheckerConfig c;
    private final EventPublisher d;
    private final SchedulerService e;
    private final CalculateAttachmentJobRunner f;
    private final VirusScanningJobRunner g;
    @GuardedBy(value="this")
    private final Set<LifecycleEvent> h = EnumSet.noneOf(LifecycleEvent.class);

    @Autowired
    public JobScheduler(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport EventPublisher eventPublisher, @ComponentImport SchedulerService schedulerService, CalculateAttachmentJobRunner calculateAttachmentJobRunner, VirusScanningJobRunner virusScanningJobRunner) {
        this.c = attachmentCheckerConfig;
        this.d = eventPublisher;
        this.e = schedulerService;
        this.f = calculateAttachmentJobRunner;
        this.g = virusScanningJobRunner;
    }

    public void afterPropertiesSet() {
        this.d.register((Object)this);
        this.a(LifecycleEvent.AFTER_PROPERTIES_SET);
    }

    @EventListener
    public void a(PluginEnabledEvent pluginEnabledEvent) {
        if (b.equals(pluginEnabledEvent.getPlugin().getKey())) {
            this.a(LifecycleEvent.PLUGIN_ENABLED);
        }
    }

    public void onStart() {
        this.a(LifecycleEvent.LIFECYCLE_AWARE_ON_START);
    }

    public void onStop() {
        a.debug((Object)"*** onStop ***");
    }

    public void destroy() {
        a.debug((Object)("Unschedule job [" + CalculateAttachmentJobRunner.b + "]"));
        this.e.unscheduleJob(CalculateAttachmentJobRunner.b);
        a.debug((Object)("Unschedule job [" + VirusScanningJobRunner.b + "]"));
        this.e.unscheduleJob(VirusScanningJobRunner.b);
        a.debug((Object)("Unregister job runner [" + CalculateAttachmentJobRunner.a + "]"));
        this.e.unregisterJobRunner(CalculateAttachmentJobRunner.a);
        a.debug((Object)("Unregister job runner [" + VirusScanningJobRunner.a + "]"));
        this.e.unregisterJobRunner(VirusScanningJobRunner.a);
        this.d.unregister((Object)this);
    }

    private void a(LifecycleEvent lifecycleEvent) {
        a.debug((Object)("onLifecycleEvent [" + (Object)((Object)lifecycleEvent) + "]"));
        if (this.b(lifecycleEvent)) {
            a.debug((Object)"Got the last lifecycle event... Time to get started!");
            this.d.unregister((Object)this);
            try {
                this.a();
            }
            catch (Exception exception) {
                a.error((Object)"Unexpected error during launch", (Throwable)exception);
            }
        }
    }

    private synchronized boolean b(LifecycleEvent lifecycleEvent) {
        return this.h.add(lifecycleEvent) && this.h.size() == LifecycleEvent.values().length;
    }

    private void a() {
        this.e.registerJobRunner(CalculateAttachmentJobRunner.a, (JobRunner)this.f);
        this.e.registerJobRunner(VirusScanningJobRunner.a, (JobRunner)this.g);
        String string = this.c.getJobStartHour();
        String string2 = this.c.getJobStartMinute();
        String string3 = this.c.getJobStartAmPm();
        if (!(string.isEmpty() || string2.isEmpty() || string3.isEmpty() || this.e.getJobDetails(CalculateAttachmentJobRunner.b) != null)) {
            this.a(AttachmentCheckerHelper.a(string, string2, string3));
        }
        if ((this.c.c() || this.c.d()) && this.e.getJobDetails(VirusScanningJobRunner.b) == null) {
            this.b();
        }
    }

    public void a(Date date) {
        a.debug((Object)"Scheduling CalculateAttachmentJob...");
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)CalculateAttachmentJobRunner.a).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)86400000L, (Date)date));
        try {
            this.e.scheduleJob(CalculateAttachmentJobRunner.b, jobConfig);
            a.debug((Object)"Scheduled CalculateAttachmentJob!");
        }
        catch (SchedulerServiceException schedulerServiceException) {
            a.error((Object)"Error scheduling CalculateAttachmentJob", (Throwable)schedulerServiceException);
        }
    }

    private void b() {
        a.debug((Object)"Scheduling VirusScanningJob...");
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)VirusScanningJobRunner.a).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)60000L, (Date)new Date(System.currentTimeMillis() + 15000L)));
        try {
            this.e.scheduleJob(VirusScanningJobRunner.b, jobConfig);
            a.debug((Object)"Scheduled VirusScanningJob!");
        }
        catch (SchedulerServiceException schedulerServiceException) {
            a.error((Object)"Error scheduling VirusScanningJob", (Throwable)schedulerServiceException);
        }
    }

    public String a(JobId jobId) {
        a.debug((Object)"Get upcoming job run...");
        String string = null;
        JobDetails jobDetails = this.e.getJobDetails(jobId);
        if (jobDetails != null) {
            a.debug((Object)("Upcoming run time [" + jobDetails.getNextRunTime() + "]"));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd yyyy h:mm a");
            string = simpleDateFormat.format(jobDetails.getNextRunTime());
        }
        a.debug((Object)("Upcoming job run for [" + jobId + "] at [" + string + "]"));
        return string;
    }

    static enum LifecycleEvent {
        AFTER_PROPERTIES_SET,
        PLUGIN_ENABLED,
        LIFECYCLE_AWARE_ON_START;

    }
}

