/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.filter;

import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.SmartRequestWrapper;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.tika.Tika;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Scanned
public class AttachmentCheckerFilter
implements Filter {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.filter.AttachmentCheckerFilter");
    private static final String b = "/pages/doattachfile.action";
    private static final String c = "/pages/plugins/attachments/doattachfile.action";
    private static final int d = 0;
    private static final int e = -1;
    private static final int f = -2;
    private static final int g = -3;
    private final AttachmentCheckerConfig h;
    private final Gson i;
    private final I18nResolver j;
    private final SpaceManager k;
    private final Tika l;

    public AttachmentCheckerFilter(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport I18nResolver i18nResolver, @ComponentImport SpaceManager spaceManager) {
        this.h = attachmentCheckerConfig;
        this.i = new Gson();
        this.j = i18nResolver;
        this.k = spaceManager;
        this.l = new Tika();
    }

    public void init(FilterConfig filterConfig) {
        a.debug((Object)"Initializing AttachmentCheckerFilter...");
    }

    public void destroy() {
        a.debug((Object)"Stopping AttachmentCheckerFilter...");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        a.debug((Object)"*** START OF REQUEST ***");
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            String string = httpServletRequest.getRequestURI();
            a.debug((Object)("Request uri [" + string + "]"));
            if (httpServletRequest.getMethod().equals("POST")) {
                this.a(httpServletRequest, httpServletResponse, filterChain);
            } else {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }
        a.debug((Object)"*** END OF REQUEST ***");
    }

    private void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        int n;
        SmartRequestWrapper smartRequestWrapper = new SmartRequestWrapper(httpServletRequest);
        String string = smartRequestWrapper.getRequestURL().toString().toLowerCase();
        a.debug((Object)("Request url [" + string + "]"));
        boolean bl = string.contains(b);
        boolean bl2 = string.contains("confiforms");
        String string2 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Map<String, String>> arrayList2 = new ArrayList<Map<String, String>>();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)httpServletRequest)) {
            n = this.a(smartRequestWrapper, bl, bl2, arrayList2, arrayList);
        } else {
            string2 = smartRequestWrapper.getParameter("filename");
            n = this.a(smartRequestWrapper, string2, arrayList);
        }
        if (n == 0) {
            a.debug((Object)"Continuing request...");
            filterChain.doFilter((ServletRequest)smartRequestWrapper, (ServletResponse)httpServletResponse);
            smartRequestWrapper.a();
        } else {
            a.debug((Object)"Intercepting request...");
            smartRequestWrapper.a();
            if (bl) {
                String string3 = httpServletRequest.getContextPath() + "/plugins/servlet/upload-failure";
                a.debug((Object)("Redirecting to [" + string3 + "]"));
                httpServletRequest.getSession().setAttribute("errorList", arrayList);
                httpServletRequest.getSession().setAttribute("attachmentList", (Object)this.i.toJson(arrayList2));
                httpServletResponse.sendRedirect(string3);
            } else if (string.contains(c)) {
                String string4 = "<html><body><div class=\"aui-message error\"><div><strong>" + string2 + "</strong></div><div>" + (String)arrayList.get(0) + "</div></div></body></html>";
                this.a(httpServletResponse, string4);
            } else {
                httpServletResponse.setStatus(bl2 ? 200 : 500);
                JSONObject jSONObject = this.a(arrayList, bl2);
                this.a(httpServletResponse, jSONObject);
            }
        }
    }

    private int a(@NotNull SmartRequestWrapper smartRequestWrapper, boolean bl, boolean bl2, List<Map<String, String>> list, List<String> list2) {
        int n = 0;
        String string = smartRequestWrapper.getParameter("pageId");
        long l = 0L;
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        List<FileItem> list3 = this.a(smartRequestWrapper);
        for (FileItem fileItem : list3) {
            String string2 = fileItem.getName();
            String string3 = fileItem.getFieldName();
            if (!fileItem.isFormField() && !string2.isEmpty()) {
                String string4 = FilenameUtils.getName((String)string2);
                String string5 = this.b(string4);
                a.debug((Object)("File name [" + string4 + "]"));
                a.debug((Object)("File ext. [" + string5 + "]"));
                boolean bl3 = this.h.c(string5);
                InputStream inputStream = this.a(fileItem);
                String string6 = this.a(inputStream, string4);
                a.debug((Object)("Mime type [" + string6 + "]"));
                boolean bl4 = this.h.a(string5, string6, (InputStream)smartRequestWrapper.getInputStream());
                if (!bl3 || !bl4) {
                    n = -1;
                    list2.add(this.a(n, string4, bl2));
                }
                long l2 = fileItem.getSize();
                a.debug((Object)("File size [" + l2 + "]"));
                if (this.h.b() && this.h.a(string6, l2, confluenceUser)) {
                    n = -3;
                    list2.add(this.a(n, string4, bl2));
                }
                l += l2;
                String string7 = this.a(fileItem.getSize());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("name", string4);
                hashMap.put("size", string7);
                hashMap.put("isValid", Boolean.toString(n == 0));
                list.add(hashMap);
                continue;
            }
            if (!string3.equalsIgnoreCase("contentId") && !string3.equalsIgnoreCase("pageId")) continue;
            string = fileItem.getString();
        }
        if (string == null) {
            string = this.b(smartRequestWrapper);
        }
        String string8 = this.a(string);
        a.debug((Object)("Space key [" + (String)string8 + "]"));
        n = this.a(n, string8, l, bl, list2);
        a.debug((Object)("Status code [" + n + "]"));
        return n;
    }

    private List<FileItem> a(SmartRequestWrapper smartRequestWrapper) {
        List<Object> list = new ArrayList<FileItem>();
        try {
            list = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest((HttpServletRequest)smartRequestWrapper);
        }
        catch (FileUploadException fileUploadException) {
            a.debug((Object)fileUploadException.getMessage());
        }
        return list;
    }

    private InputStream a(@NotNull FileItem fileItem) {
        InputStream inputStream = null;
        try {
            inputStream = fileItem.getInputStream();
        }
        catch (IOException iOException) {
            a.debug((Object)iOException.getMessage());
        }
        return inputStream;
    }

    private String b(@NotNull SmartRequestWrapper smartRequestWrapper) {
        String string = null;
        String string2 = smartRequestWrapper.getRequestURI();
        if (string2.startsWith("/rest/api/content/")) {
            string = string2.substring(18, string2.indexOf("/child/attachment"));
        }
        return string;
    }

    private String a(String string) {
        String string2 = null;
        if (string != null) {
            try {
                long l = Long.parseLong(string);
                string2 = this.k.getSpaceFromPageId(l);
            }
            catch (NumberFormatException numberFormatException) {
                a.debug((Object)numberFormatException.getMessage());
            }
        }
        return string2;
    }

    private int a(int n, String string, long l, boolean bl, List<String> list) {
        if (this.h.i() && string != null) {
            a.debug((Object)("Checking quota for space key [" + string + "]"));
            a.debug((Object)("Total file size [" + l + "]"));
            Map<String, String> map = this.h.a(string, l);
            if (!Boolean.parseBoolean(map.get("isSufficient"))) {
                n = -2;
                String string2 = this.a(map, bl, l);
                list.add(string2);
            }
        }
        return n;
    }

    private int a(@NotNull SmartRequestWrapper smartRequestWrapper, String string, List<String> list) {
        Object object;
        int n = 0;
        String string2 = smartRequestWrapper.getParameter("spaceKey");
        long l = Long.parseLong(smartRequestWrapper.getParameter("size"));
        String string3 = this.b(string);
        a.debug((Object)("File name [" + string + "]"));
        a.debug((Object)("File ext. [" + string3 + "]"));
        if (!this.h.c(string3)) {
            n = -1;
        } else {
            object = this.a((InputStream)smartRequestWrapper.getInputStream(), string);
            a.debug((Object)("Mime type [" + (String)object + "]"));
            if (!this.h.a(string3, (String)object, (InputStream)smartRequestWrapper.getInputStream())) {
                n = -1;
            } else if (this.h.b() && this.h.a((String)object, l, AuthenticatedUserThreadLocal.get())) {
                n = -3;
            }
        }
        if (n != 0) {
            list.add(this.a(n, string, false));
        } else if (this.h.i() && string2 != null) {
            a.debug((Object)("Space key [" + string2 + "]"));
            a.debug((Object)("File size [" + l + "]"));
            object = this.h.a(string2, l);
            if (!Boolean.parseBoolean((String)object.get("isSufficient"))) {
                n = -2;
                String string4 = this.a((Map<String, String>)object, false, l);
                list.add(string4);
            }
        }
        return n;
    }

    private String b(@NotNull String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n >= 0 && n < string.length() - 1) {
            string2 = string.substring(n).toLowerCase();
        }
        return string2;
    }

    private String a(InputStream inputStream, String string) {
        String string2 = null;
        TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)inputStream);
        Metadata metadata = new Metadata();
        metadata.add("resourceName", string);
        try {
            string2 = this.l.detect((InputStream)tikaInputStream, metadata);
            tikaInputStream.close();
        }
        catch (IOException iOException) {
            a.debug((Object)iOException.getMessage());
        }
        return string2;
    }

    private String a(int n, String string, boolean bl) {
        String string2;
        switch (n) {
            case -1: {
                string2 = this.h.getFileTypeErrorMessage();
                break;
            }
            case -2: {
                string2 = this.h.getQuotaErrorMessage();
                break;
            }
            case -3: {
                string2 = this.h.getFileSizeErrMsg();
                break;
            }
            default: {
                string2 = "";
            }
        }
        if (bl) {
            string2 = string2 + " (" + string + ")";
        }
        return string2;
    }

    @NotNull
    private String a(@NotNull Map<String, String> map, boolean bl, long l) {
        String string = this.a(-2, null, false);
        String string2 = this.j.getText("com.akeles.acc.quota.used");
        String string3 = this.j.getText("com.akeles.acc.quota.available");
        String[] stringArray = new String[]{map.get("used"), map.get("allocated")};
        String string4 = this.j.getText("com.akeles.acc.quota.usage", (Serializable[])stringArray);
        string = bl ? string + "<br><br><span style=\"display:inline-block;width:80px;\"><strong>" + string2 + "</strong></span>" + string4 + "<br><span style=\"display:inline-block;width:80px;\"><strong>" + string3 + "</strong></span>" + map.get("available") : string + "\n\n" + string2 + " \t " + string4 + "\n" + string3 + " \t " + map.get("available") + "\n" + this.j.getText("com.akeles.acc.quota.fileSize") + " \t " + this.a(l);
        return string;
    }

    @NotNull
    private String a(long l) {
        String string = this.h.getUnit();
        String string2 = AttachmentCheckerHelper.a(l, string, 2);
        string2 = string2.equals("0.00") ? AttachmentCheckerHelper.a(l, "KB", 2) + " " + "KB" : string2 + " " + string;
        return string2;
    }

    @NotNull
    private JSONObject a(@NotNull List<String> list, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        try {
            if (bl) {
                jSONObject.put("errors", (Object)list.toArray());
            } else {
                jSONObject.put("actionErrors", (Object)new String[]{list.get(0)});
            }
        }
        catch (JSONException jSONException) {
            a.debug((Object)jSONException);
        }
        return jSONObject;
    }

    private void a(@NotNull HttpServletResponse httpServletResponse, @NotNull JSONObject jSONObject) throws IOException {
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setCharacterEncoding("UTF-8");
        a.debug((Object)"Returning JSON response...");
        String string = jSONObject.toString();
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
        a.debug((Object)("Response [" + string + "]"));
    }

    private void a(@NotNull HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("text/html");
        a.debug((Object)"Returning HTML response...");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
    }
}

