/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.ao.service;

import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeGroup;
import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeLimit;
import com.akelesconsulting.confluence.plugins.rest.FileSizeLimitBean;
import com.akelesconsulting.confluence.plugins.rest.Result;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileSizeLimitService {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.service.FileSizeLimitService");
    private static final String b = "extension";
    private final ActiveObjects c;
    private final I18nResolver d;
    private final SettingsManager e;
    private final TransactionTemplate f;

    @Autowired
    public FileSizeLimitService(@ComponentImport ActiveObjects activeObjects, @ComponentImport I18nResolver i18nResolver, @ComponentImport SettingsManager settingsManager, @ComponentImport TransactionTemplate transactionTemplate) {
        this.c = (ActiveObjects)Preconditions.checkNotNull((Object)activeObjects);
        this.d = i18nResolver;
        this.e = settingsManager;
        this.f = transactionTemplate;
    }

    public List<FileSizeGroup> getFileSizeGroups() {
        a.debug((Object)"Getting all FileSizeGroup entities...");
        ArrayList<FileSizeGroup> arrayList = new ArrayList();
        FileSizeGroup[] fileSizeGroupArray = (FileSizeGroup[])this.c.find(FileSizeGroup.class, Query.select().order("ID ASC"));
        if (fileSizeGroupArray.length > 0) {
            arrayList = Arrays.asList(fileSizeGroupArray);
        } else {
            FileSizeGroup fileSizeGroup;
            try {
                fileSizeGroup = (FileSizeGroup)this.f.execute(() -> (FileSizeGroup)this.c.create(FileSizeGroup.class, new DBParam[]{new DBParam("GROUP", (Object)"confluence-administrators")}));
                arrayList.add(fileSizeGroup);
            }
            catch (Exception exception) {
                a.error((Object)"Error creating FileSizeGroup for default group 1 (confluence-administrators)", (Throwable)exception);
            }
            try {
                fileSizeGroup = (FileSizeGroup)this.f.execute(() -> (FileSizeGroup)this.c.create(FileSizeGroup.class, new DBParam[]{new DBParam("GROUP", (Object)"confluence-users")}));
                arrayList.add(fileSizeGroup);
            }
            catch (Exception exception) {
                a.error((Object)"Error creating FileSizeGroup for default group 2 (confluence-users)", (Throwable)exception);
            }
        }
        return arrayList;
    }

    public boolean a(int n, String string) {
        boolean bl;
        a.debug((Object)("Updating FileSizeGroup entity with id [" + n + "] group to [" + string + "]"));
        FileSizeGroup[] fileSizeGroupArray = (FileSizeGroup[])this.c.find(FileSizeGroup.class, Query.select().where("GROUP = ?", new Object[]{string}));
        boolean bl2 = bl = fileSizeGroupArray.length > 0 && fileSizeGroupArray[0].getID() != n;
        if (!bl) {
            FileSizeGroup fileSizeGroup = (FileSizeGroup)this.c.get(FileSizeGroup.class, (Object)n);
            if (fileSizeGroup != null) {
                try {
                    return (Boolean)this.f.execute(() -> {
                        fileSizeGroup.setGroup(string);
                        fileSizeGroup.save();
                        return true;
                    });
                }
                catch (Exception exception) {
                    a.error((Object)"Error updating FileSizeGroup entity", (Throwable)exception);
                }
            } else {
                a.debug((Object)("Unable to find FileSizeGroup entity with id [" + n + "]"));
            }
        } else {
            a.debug((Object)("FileSizeGroup entity with id [" + fileSizeGroupArray[0].getID() + "] is already set to [" + string + "]"));
        }
        return false;
    }

    public FileSizeLimit b(int n, String string) {
        a.debug((Object)("Calling getFileSizeLimit() with groupId = [" + n + "] and mimeType = [" + string + "]"));
        Query query = Query.select().where("GROUP_ID = ? AND MIME_TYPE = ?", new Object[]{n, string});
        FileSizeLimit[] fileSizeLimitArray = (FileSizeLimit[])this.c.find(FileSizeLimit.class, query);
        if (fileSizeLimitArray.length > 0) {
            if (fileSizeLimitArray.length != 1) {
                a.error((Object)"This should not happen!!! Returning the first result");
                for (FileSizeLimit fileSizeLimit : fileSizeLimitArray) {
                    a.debug((Object)("ID = [" + fileSizeLimit.getID() + "] groupId = [" + fileSizeLimit.getGroupId() + "] mimetype = [" + fileSizeLimit.getMimeType() + "]"));
                }
            }
            return fileSizeLimitArray[0];
        }
        query = Query.select().where("GROUP_ID = ? AND EXTENSION = 'Others'", new Object[]{n});
        fileSizeLimitArray = (FileSizeLimit[])this.c.find(FileSizeLimit.class, query);
        if (fileSizeLimitArray.length > 0) {
            return fileSizeLimitArray[0];
        }
        return null;
    }

    public List<FileSizeLimitBean> a(int n) {
        a.debug((Object)("calling getFileSizeLimitBeans with groupId = [" + n + "]"));
        ArrayList<FileSizeLimitBean> arrayList = new ArrayList<FileSizeLimitBean>();
        FileSizeLimitBean fileSizeLimitBean = null;
        FileSizeLimit[] fileSizeLimitArray = (FileSizeLimit[])this.c.find(FileSizeLimit.class, Query.select().where("GROUP_ID = ?", new Object[]{n}).order("EXTENSION ASC"));
        for (FileSizeLimit fileSizeLimit : fileSizeLimitArray) {
            FileSizeLimitBean fileSizeLimitBean2 = new FileSizeLimitBean(fileSizeLimit.getID(), fileSizeLimit.getExtension(), String.valueOf(fileSizeLimit.getSizeLimit()), fileSizeLimit.getSizeUnit());
            if (fileSizeLimit.getExtension().equalsIgnoreCase("Others")) {
                fileSizeLimitBean = fileSizeLimitBean2;
                continue;
            }
            arrayList.add(fileSizeLimitBean2);
        }
        if (fileSizeLimitBean == null) {
            FileSizeLimitBean fileSizeLimitBean3 = new FileSizeLimitBean();
            fileSizeLimitBean3.setExtension("Others");
            fileSizeLimitBean3.setSizeLimit(AttachmentCheckerHelper.a(this.e.getGlobalSettings().getAttachmentMaxSize(), "MB", 0));
            fileSizeLimitBean3.setSizeUnit("MB");
            Result<FileSizeLimitBean> result = this.a(n, fileSizeLimitBean3, null);
            arrayList.add(result.getResult());
        } else {
            arrayList.add(fileSizeLimitBean);
        }
        return arrayList;
    }

    public Result<FileSizeLimitBean> a(int n, FileSizeLimitBean fileSizeLimitBean, String string) {
        a.debug((Object)("Calling addFileSizeLimit() with groupId = [" + n + "] mimetype = [" + string + "]"));
        String string2 = fileSizeLimitBean.getExtension();
        String string3 = fileSizeLimitBean.getSizeLimit();
        String string4 = fileSizeLimitBean.getSizeUnit();
        Result<FileSizeLimitBean> result = this.c(n, fileSizeLimitBean, string);
        if (result.a()) {
            a.debug((Object)("Add file size limit for group id [" + n + "]"));
            FileSizeLimit fileSizeLimit = (FileSizeLimit)this.f.execute(() -> (FileSizeLimit)this.c.create(FileSizeLimit.class, new DBParam[]{new DBParam("GROUP_ID", (Object)n), new DBParam("EXTENSION", (Object)string2), new DBParam("MIME_TYPE", (Object)string), new DBParam("SIZE_LIMIT", (Object)Long.parseLong(string3)), new DBParam("SIZE_UNIT", (Object)string4)}));
            fileSizeLimitBean.setId(fileSizeLimit.getID());
            a.debug((Object)("Id [" + fileSizeLimitBean.getId() + "]"));
            a.debug((Object)("Extension [" + string2 + "] mime type [" + string + "] size limit [" + string3 + " " + string4 + "]"));
        }
        return result;
    }

    private Result<FileSizeLimitBean> c(int n, FileSizeLimitBean fileSizeLimitBean, String string) {
        Query query;
        FileSizeLimit[] fileSizeLimitArray;
        a.debug((Object)("Validate new file size limit for group id [" + n + "]"));
        a.debug((Object)("Bean = " + fileSizeLimitBean));
        Result.Builder<FileSizeLimitBean> builder = new Result.Builder<FileSizeLimitBean>();
        builder.setResult(fileSizeLimitBean);
        if (fileSizeLimitBean.getExtension() == null) {
            a.debug((Object)"Extension is null");
            builder.a(b, this.d.getText("com.akeles.acc.config.error.isRequired", (Serializable[])new String[]{this.d.getText("com.akeles.acc.fileSizeLimit.extension")}));
        }
        if (string != null && (fileSizeLimitArray = (FileSizeLimit[])this.c.find(FileSizeLimit.class, query = Query.select().where("GROUP_ID = ? AND MIME_TYPE = ?", new Object[]{n, string}))).length > 0 && fileSizeLimitBean.getId() != fileSizeLimitArray[0].getID()) {
            a.debug((Object)("Duplicate extension [" + fileSizeLimitBean.getExtension() + "]"));
            builder.a(b, this.d.getText("com.akeles.acc.fileSizeLimit.extension.error.duplicate"));
        }
        if (fileSizeLimitBean.getSizeLimit() == null) {
            a.debug((Object)"Size limit is null");
            builder.a("sizeLimit", this.d.getText("com.akeles.acc.config.error.isRequired", (Serializable[])new String[]{this.d.getText("com.akeles.acc.fileSizeLimit.maximumSize")}));
        } else {
            try {
                long l = Long.parseLong(fileSizeLimitBean.getSizeLimit());
                a.debug((Object)("Size limit [" + l + "] valid"));
            }
            catch (NumberFormatException numberFormatException) {
                a.debug((Object)("Invalid size limit [" + fileSizeLimitBean.getSizeLimit() + "]"));
                builder.a("sizeLimit", this.d.getText("com.akeles.acc.fileSizeLimit.maximumSize.error.invalid"));
            }
        }
        if (fileSizeLimitBean.getSizeUnit() == null) {
            a.error((Object)"Size unit is null");
            builder.a("sizeUnit", this.d.getText("com.akeles.acc.config.error.isRequired", (Serializable[])new String[]{this.d.getText("com.akeles.acc.fileSizeLimit.sizeUnit")}));
        } else if (!fileSizeLimitBean.getSizeUnit().equals("KB") && !fileSizeLimitBean.getSizeUnit().equals("MB")) {
            a.error((Object)("Size unit [" + fileSizeLimitBean.getSizeUnit() + "] is invalid"));
            builder.a("sizeUnit", this.d.getText("com.akeles.acc.fileSizeLimit.sizeUnit.error.invalid"));
        }
        return builder.a();
    }

    public Result<FileSizeLimitBean> b(int n, FileSizeLimitBean fileSizeLimitBean, String string) {
        Result<FileSizeLimitBean> result;
        a.debug((Object)("Calling updateFileSizeLimit with groupId [" + n + "] and modifiedMimeType = [" + string + "]"));
        FileSizeLimit fileSizeLimit = (FileSizeLimit)this.c.get(FileSizeLimit.class, (Object)fileSizeLimitBean.getId());
        a.debug((Object)("Trying to modify FileSizeLimit ID = [" + fileSizeLimitBean.getId() + "]"));
        if (fileSizeLimit != null) {
            if (fileSizeLimitBean.getExtension() == null) {
                fileSizeLimitBean.setExtension(fileSizeLimit.getExtension());
                string = fileSizeLimit.getMimeType();
            }
            if (fileSizeLimitBean.getSizeLimit() == null) {
                fileSizeLimitBean.setSizeLimit(Long.toString(fileSizeLimit.getSizeLimit()));
            }
            if (fileSizeLimitBean.getSizeUnit() == null) {
                fileSizeLimitBean.setSizeUnit(fileSizeLimit.getSizeUnit());
            }
            if ((result = this.c(n, fileSizeLimitBean, string)).a()) {
                String string2 = fileSizeLimitBean.getExtension();
                String string3 = string;
                long l = Long.parseLong(fileSizeLimitBean.getSizeLimit());
                String string4 = fileSizeLimitBean.getSizeUnit();
                a.debug((Object)("Update file size limit for group id [" + n + "]"));
                a.debug((Object)("-- Current extension [" + fileSizeLimit.getExtension() + "] new extension [" + fileSizeLimitBean.getExtension() + "]"));
                a.debug((Object)("-- Current mime type [" + fileSizeLimit.getMimeType() + "] new mime type [" + string + "]"));
                a.debug((Object)("-- Current size limit [" + fileSizeLimit.getSizeLimit() + "] new size limit [" + fileSizeLimitBean.getSizeLimit() + "]"));
                a.debug((Object)("-- Current size unit [" + fileSizeLimit.getSizeUnit() + "] new size unit [" + fileSizeLimitBean.getSizeUnit() + "]"));
                this.f.execute(() -> {
                    fileSizeLimit.setExtension(string2);
                    fileSizeLimit.setMimeType(string3);
                    fileSizeLimit.setSizeLimit(l);
                    fileSizeLimit.setSizeUnit(string4);
                    fileSizeLimit.save();
                    return null;
                });
            }
        } else {
            a.error((Object)("Cannot find FileSizeLimit record with id = " + fileSizeLimitBean.getId()));
            Result.Builder builder = new Result.Builder();
            builder.a(b, "Cannot find FileSizeLimit record with id = " + fileSizeLimitBean.getId());
            result = builder.a();
        }
        result.setResult(fileSizeLimitBean);
        return result;
    }

    public void a(int n, int n2) {
        a.debug((Object)("Delete file size limit id [" + n2 + "] for group id [" + n + "]"));
        FileSizeLimit fileSizeLimit = (FileSizeLimit)this.c.get(FileSizeLimit.class, (Object)n2);
        if (fileSizeLimit != null) {
            String string = fileSizeLimit.getExtension();
            int n3 = fileSizeLimit.getGroupId();
            long l = fileSizeLimit.getSizeLimit();
            String string2 = fileSizeLimit.getSizeUnit();
            this.f.execute(() -> {
                this.c.delete(new RawEntity[]{fileSizeLimit});
                return null;
            });
            a.debug((Object)("Extension [" + string + "] size limit [" + l + " " + string2 + "] deleted"));
            if (n != n3) {
                a.error((Object)("Groupid [" + n + "] does not match original group id [" + n3 + "]"));
            }
        } else {
            a.error((Object)("Cannot find an existing FileSizeLimit record with id [" + n2 + "]"));
        }
    }
}

