/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.config.xwork;

import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeGroup;
import com.akelesconsulting.confluence.plugins.ao.service.FileSizeLimitService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.utils.PluginValidator;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import java.util.List;
import org.apache.log4j.Logger;

@Scanned
public class FileSizeLimitManager
extends ConfluenceActionSupport {
    private static final Logger logger = Logger.getLogger((String)"com.akeles.plugins.acc.config.FileSizeLimitManager");
    private transient AccessModeCompatService accessModeCompatService;
    private transient AttachmentCheckerConfig attachmentCheckerConfig;
    private transient FileSizeLimitService fileSizeLimitService;
    private transient GroupManager groupManager;
    private transient PluginValidator pluginValidator;
    private transient TransactionTemplate transactionTemplate;
    private String fileSizeCheck;
    private String groupId;
    private String group;
    private transient List<FileSizeGroup> fileSizeGroups;

    public void setAccessModeCompatService(AccessModeCompatService accessModeCompatService) {
        this.accessModeCompatService = accessModeCompatService;
    }

    public void setAttachmentCheckerConfig(AttachmentCheckerConfig attachmentCheckerConfig) {
        this.attachmentCheckerConfig = attachmentCheckerConfig;
    }

    public void setFileSizeLimitService(FileSizeLimitService fileSizeLimitService) {
        this.fileSizeLimitService = fileSizeLimitService;
    }

    public void setGroupManager(@ComponentImport GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public void setPluginValidator(PluginValidator pluginValidator) {
        this.pluginValidator = pluginValidator;
    }

    public void setTransactionTemplate(@ComponentImport TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public String getFileSizeCheck() {
        return this.fileSizeCheck;
    }

    public void setFileSizeCheck(String string) {
        this.fileSizeCheck = string;
    }

    public void setGroupId(String string) {
        this.groupId = string;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public List<FileSizeGroup> getFileSizeGroups() {
        return this.fileSizeGroups;
    }

    public boolean getIsReadOnlyAccessModeEnabled() {
        return this.accessModeCompatService.isReadOnlyAccessModeEnabled();
    }

    public String execute() {
        logger.debug((Object)"Accessing file size limit...");
        logger.debug((Object)"Validating license...");
        if (this.pluginValidator.a()) {
            logger.debug((Object)"Valid!");
            this.loadSettings();
            return "success";
        }
        logger.debug((Object)"Invalid!");
        return "unlicensed";
    }

    private void loadSettings() {
        this.fileSizeCheck = this.attachmentCheckerConfig.getFileSizeCheck();
        logger.debug((Object)("File size check [" + this.fileSizeCheck + "]"));
        this.fileSizeGroups = this.fileSizeLimitService.getFileSizeGroups();
        logger.debug((Object)("Num of groups [" + this.fileSizeGroups.size() + "]"));
    }

    public void validate() {
        super.validate();
        if (this.group != null) {
            logger.debug((Object)"Validating file size group...");
            try {
                logger.debug((Object)("Group id [" + Integer.parseInt(this.groupId) + "]"));
                String string = "group" + this.groupId + "Error";
                if (this.group.isEmpty()) {
                    this.addFieldError(string, this.getText("com.akeles.acc.config.error.isRequired", new String[]{this.getText("group.name")}));
                } else if (this.groupManager.getGroup(this.group) == null) {
                    this.addFieldError(string, this.getText("com.akeles.acc.fileSizeLimit.group.error.notFound", new String[]{this.group}));
                }
            }
            catch (EntityException | NullPointerException | NumberFormatException throwable) {
                this.addActionError(this.getText("com.akeles.acc.config.error.update.failed"));
            }
        }
    }

    @ReadOnlyAccessBlocked
    public String doUpdate() {
        if (this.fileSizeCheck != null) {
            this.saveFileSizeCheck();
        } else if (this.groupId != null && this.group != null) {
            logger.debug((Object)("Group id [" + this.groupId + "] Group [" + this.group + "]"));
            logger.debug((Object)"Saving file size group...");
            if (!this.fileSizeLimitService.a(Integer.parseInt(this.groupId), this.group)) {
                this.addFieldError("group" + this.groupId + "Error", this.getText("com.akeles.acc.fileSizeLimit.group.error.duplicate"));
                return "error";
            }
        }
        return "success";
    }

    private void saveFileSizeCheck() {
        logger.debug((Object)("File size check [" + this.fileSizeCheck + "]"));
        logger.debug((Object)"Saving file size check...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.setFileSizeCheck(this.fileSizeCheck);
            return null;
        });
    }
}

