/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.service.FileSizeLimitService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.ErrorCollection;
import com.akelesconsulting.confluence.plugins.rest.FileSizeLimitBean;
import com.akelesconsulting.confluence.plugins.rest.Result;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.google.gson.Gson;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Scanned
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/config/file-size-limit")
public class FileSizeLimitResource {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.rest.FileSizeLimitResource");
    private final AttachmentCheckerConfig b;
    private final FileSizeLimitService c;
    private final PermissionManager d;
    private final CacheControl e;
    private final Gson f;

    public FileSizeLimitResource(AttachmentCheckerConfig attachmentCheckerConfig, FileSizeLimitService fileSizeLimitService, @ComponentImport PermissionManager permissionManager) {
        this.b = attachmentCheckerConfig;
        this.c = fileSizeLimitService;
        this.d = permissionManager;
        this.e = new CacheControl();
        this.e.setNoCache(true);
        this.f = new Gson();
    }

    @GET
    @Path(value="/{extension}/associated-extensions")
    @Produces(value={"application/json"})
    public Response a(@PathParam(value="extension") String string) {
        List<String> list = this.b.a(string);
        return Response.ok((Object)this.f.toJson(list)).build();
    }

    @GET
    @Path(value="/{groupId}")
    public Response a(@PathParam(value="groupId") int n) {
        a.debug((Object)("Get file size limit for group id [" + n + "]"));
        List<FileSizeLimitBean> list = this.c.a(n);
        return Response.ok(list).cacheControl(this.e).build();
    }

    @POST
    @Path(value="/{groupId}")
    public Response a(@PathParam(value="groupId") int n, @Context HttpServletRequest httpServletRequest, FileSizeLimitBean fileSizeLimitBean) {
        a.debug((Object)("Add file size limit for group id [" + n + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (this.d.isConfluenceAdministrator((User)confluenceUser)) {
            String string = fileSizeLimitBean.getExtension();
            String string2 = null;
            if (string != null) {
                if (!string.startsWith(".")) {
                    string = "." + string;
                }
                string2 = this.b.b(string);
            }
            a.debug((Object)("Extension [" + string + "] mime type [" + string2 + "]"));
            a.debug((Object)("Size limit [" + fileSizeLimitBean.getSizeLimit() + "]"));
            a.debug((Object)("Size unit [" + fileSizeLimitBean.getSizeUnit() + "]"));
            Result<FileSizeLimitBean> result = this.c.a(n, fileSizeLimitBean, string2);
            if (result.a()) {
                return Response.ok((Object)fileSizeLimitBean).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorCollection(result.getErrors())).cacheControl(this.e).build();
        }
        a.debug((Object)("An unauthorised user [" + confluenceUser + "] tried to add file size limit."));
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/{groupId}/{id}")
    public Response a(@PathParam(value="groupId") int n, @PathParam(value="id") int n2, @Context HttpServletRequest httpServletRequest, FileSizeLimitBean fileSizeLimitBean) {
        a.debug((Object)("Update file size limit id [" + n2 + "] for group id [" + n + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (this.d.isConfluenceAdministrator((User)confluenceUser)) {
            String string = fileSizeLimitBean.getExtension();
            String string2 = string == null ? null : this.b.b(string);
            a.debug((Object)("Extension [" + string + "] mime type [" + string2 + "]"));
            a.debug((Object)("Size limit [" + fileSizeLimitBean.getSizeLimit() + "]"));
            a.debug((Object)("Size unit [" + fileSizeLimitBean.getSizeUnit() + "]"));
            Result<FileSizeLimitBean> result = this.c.b(n, fileSizeLimitBean, string2);
            if (result.a()) {
                return Response.ok((Object)result.getResult()).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorCollection(result.getErrors())).cacheControl(this.e).build();
        }
        a.debug((Object)("An unauthorised user [" + confluenceUser + "] tried to update file size limit."));
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @DELETE
    @Path(value="/{groupId}/{id}")
    public Response a(@PathParam(value="groupId") int n, @PathParam(value="id") int n2, @Context HttpServletRequest httpServletRequest) {
        a.debug((Object)("Delete file size limit id [" + n2 + "] for group id [" + n + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (this.d.isConfluenceAdministrator((User)confluenceUser)) {
            this.c.a(n, n2);
            return Response.ok().build();
        }
        a.debug((Object)("An unauthorised user [" + confluenceUser + "] tried to delete file size limit."));
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }
}

