/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.config;

import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeGroup;
import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeLimit;
import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.akelesconsulting.confluence.plugins.ao.service.FileSizeLimitService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentCheckerConfig {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.config.AttachmentCheckerConfig");
    private static final String b = "whitelist";
    private static final String c = "blacklist";
    private static final String d = "enabled";
    private static final String e = "disabled";
    private static final String f = "application/x-msdownload";
    private static final String g = "application/x-dosexec";
    private static final String h = ".render";
    private static final String i = ".tfss";
    private static final String j = "jpg";
    private static final String k = "whitelist";
    private static final String l = "This file type is not allowed.";
    private static final String m = "disabled";
    private static final String n = "The file size has exceeded the maximum size limit set for the file type.";
    private static final String o = "disabled";
    private static final String p = "Insufficient storage available.";
    private static final String q = "MB";
    private static final String r = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.";
    private static final String s = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions";
    private static final String t = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map";
    private static final String u = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set";
    private static final String v = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set";
    private static final String w = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.filterMode";
    private static final String x = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowProtected";
    private static final String y = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowEncrypted";
    private static final String z = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowTableSpreadsheetMacro";
    private static final String A = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.message";
    private static final String B = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeCheck";
    private static final String C = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeError";
    private static final String D = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.onAccessScanning";
    private static final String E = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerMode";
    private static final String F = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerPath";
    private static final String G = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerOption";
    private static final String H = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.autoDeleteMode";
    private static final String I = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfInfected";
    private static final String J = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.deleteIfError";
    private static final String K = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfError";
    private static final String L = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.groupToEmail";
    private static final String M = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusAlertActor";
    private static final String N = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanRunning";
    private static final String O = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanNodeId";
    private static final String P = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCheck";
    private static final String Q = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaError";
    private static final String R = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unit";
    private static final String S = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultStorage";
    private static final String T = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndAmPm";
    private static final String U = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndHour";
    private static final String V = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndMinute";
    private static final String W = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartAmPm";
    private static final String X = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartHour";
    private static final String Y = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartMinute";
    private static final String Z = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isJobRunning";
    private static final String aa = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.enableQuotaCheckAfterSetup";
    private final Cache<String, Object> ab;
    private final FileSizeLimitService ac;
    private final GroupManager ad;
    private final MimeTypes ae;
    private final PluginSettingsFactory af;
    private final SpaceInfoService ag;
    private final Tika ah;
    private final UserAccessor ai;

    @Autowired
    public AttachmentCheckerConfig(FileSizeLimitService fileSizeLimitService, @ComponentImport GroupManager groupManager, @ComponentImport PluginSettingsFactory pluginSettingsFactory, SpaceInfoService spaceInfoService, @ComponentImport @NotNull CacheManager cacheManager, @ComponentImport UserAccessor userAccessor) {
        String string = AttachmentCheckerConfig.class.getName() + ".cache";
        CacheSettings cacheSettings = new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(1000).flushable().build();
        this.ab = cacheManager.getCache(string, (CacheLoader)new AcConfigCacheLoader(), cacheSettings);
        this.ad = groupManager;
        this.ac = fileSizeLimitService;
        this.ae = MimeTypes.getDefaultMimeTypes();
        this.af = pluginSettingsFactory;
        this.ag = (SpaceInfoService)Preconditions.checkNotNull((Object)spaceInfoService);
        this.ah = new Tika();
        this.ai = userAccessor;
    }

    public List<String> a(String string) {
        List<String> list;
        String string2;
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        if ((string2 = this.ah.detect(string)).equalsIgnoreCase(f) || string2.equalsIgnoreCase(g)) {
            list = this.a(string, f);
            list.addAll(this.a(string, g));
        } else {
            list = this.a(string, string2);
        }
        return list;
    }

    private List<String> a(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            MimeType mimeType = this.ae.forName(string2);
            List list = mimeType.getExtensions();
            for (String string3 : list) {
                if (string3.equalsIgnoreCase(string)) continue;
                arrayList.add(string3);
            }
        }
        catch (MimeTypeException mimeTypeException) {
            a.debug((Object)mimeTypeException.getMessage());
        }
        return arrayList;
    }

    public String getExtensions() {
        return (String)this.ab.get((Object)s);
    }

    public String getFilterMode() {
        return (String)this.ab.get((Object)w);
    }

    public String getFileTypeErrorMessage() {
        return (String)this.ab.get((Object)A);
    }

    public Map<String, List<String>> getExtensionsMap() {
        return (Map)this.ab.get((Object)t);
    }

    public Set<String> getExtensionSet() {
        TreeSet treeSet = (TreeSet)this.ab.get((Object)u);
        if (treeSet == null) {
            treeSet = new TreeSet();
        }
        return treeSet;
    }

    public Set<String> getMimeTypeSet() {
        TreeSet treeSet = (TreeSet)this.ab.get((Object)v);
        if (treeSet == null) {
            treeSet = new TreeSet();
        }
        return treeSet;
    }

    public void setExtensions(String string) {
        this.af.createGlobalSettings().put(s, (Object)string);
        this.ab.remove((Object)s);
        this.ab.remove((Object)t);
        this.ab.remove((Object)u);
        this.ab.remove((Object)v);
        a.debug((Object)("Updated extensions [" + string + "]"));
    }

    public void setFilterMode(String string) {
        this.af.createGlobalSettings().put(w, (Object)string);
        this.ab.remove((Object)w);
        a.debug((Object)("Updated filter mode [" + string + "]"));
    }

    public void setFileTypeErrorMessage(String string) {
        this.af.createGlobalSettings().put(A, (Object)string);
        this.ab.remove((Object)A);
        a.debug((Object)("Updated file type error message [" + string + "]"));
    }

    public String getAllowProtected() {
        return (String)this.ab.get((Object)x);
    }

    public void setAllowProtected(String string) {
        this.af.createGlobalSettings().put(x, (Object)string);
        this.ab.remove((Object)x);
        a.debug((Object)("Updated allow protected [" + string + "]"));
    }

    public String getAllowEncrypted() {
        return (String)this.ab.get((Object)y);
    }

    public void setAllowEncrypted(String string) {
        this.af.createGlobalSettings().put(y, (Object)string);
        this.ab.remove((Object)y);
        a.debug((Object)("Updated allow encrypted [" + string + "]"));
    }

    public String getAllowTableSpreadsheetMacro() {
        return (String)this.ab.get((Object)z);
    }

    public boolean a() {
        return "on".equalsIgnoreCase(this.getAllowTableSpreadsheetMacro());
    }

    public void setAllowTableSpreadsheetMacro(String string) {
        this.af.createGlobalSettings().put(z, (Object)string);
        this.ab.remove((Object)z);
        a.debug((Object)("Updated allow Table Spreadsheet Macro [" + string + "]"));
    }

    public String getFileSizeCheck() {
        return (String)this.ab.get((Object)B);
    }

    public String getFileSizeErrMsg() {
        return (String)this.ab.get((Object)C);
    }

    public boolean b() {
        return this.getFileSizeCheck().equalsIgnoreCase(d);
    }

    public void setFileSizeCheck(String string) {
        this.af.createGlobalSettings().put(B, (Object)string);
        this.ab.remove((Object)B);
        a.debug((Object)("Updated file size check [" + string + "]"));
    }

    public void setFileSizeErrMsg(String string) {
        this.af.createGlobalSettings().put(C, (Object)string);
        this.ab.remove((Object)C);
        a.debug((Object)("Updated file size error message [" + string + "]"));
    }

    public boolean c() {
        return this.getMissingFileCheck().equalsIgnoreCase("on");
    }

    public String getMissingFileCheck() {
        String string = (String)this.ab.get((Object)D);
        if (Boolean.TRUE.toString().equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setMissingFileCheck(String string) {
        this.af.createGlobalSettings().put(D, (Object)string);
        this.ab.remove((Object)D);
        a.debug((Object)("Updated missing file check [" + string + "]"));
    }

    public boolean d() {
        return this.getVirusScanning().equalsIgnoreCase("on");
    }

    public String getVirusScanning() {
        String string = (String)this.ab.get((Object)E);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setVirusScanning(String string) {
        this.af.createGlobalSettings().put(E, (Object)string);
        this.ab.remove((Object)E);
        a.debug((Object)("Updated virus scanning [" + string + "]"));
    }

    public boolean a(int n, @NotNull String string) {
        boolean bl = true;
        if (!this.getScannerDetected().equalsIgnoreCase("unknown")) {
            bl = n == 1 && (string.contains("clamscan") || string.contains("clamdscan") || string.contains("fpscan")) || n == 3 && string.contains("savscan") || n == 13 && (string.contains("uvscan") || string.contains("scan.exe")) || n == 50 && (string.contains("ecls.exe") || string.contains("eset")) || n == 72 && string.contains("kesl-control");
        }
        a.debug((Object)("Is infected? [" + bl + "]"));
        return bl;
    }

    public String getScannerDetected() {
        String string = this.getScannerPath().toLowerCase();
        String string2 = string.contains("clamscan") || string.contains("clamdscan") ? "ClamAV" : (string.contains("ecls.exe") || string.contains("eset") ? "ESET" : (string.contains("fpscan") ? "F-PROT Antivirus" : (string.contains("kesl-control") ? "Kaspersky Endpoint Security for Linux" : (string.contains("savscan") ? "Sophos Anti-Virus" : (string.contains("uvscan") || string.contains("scan.exe") ? "McAfee VirusScan" : "unknown")))));
        return string2;
    }

    public String getScannerPath() {
        return (String)this.ab.get((Object)F);
    }

    public void setScannerPath(String string) {
        this.af.createGlobalSettings().put(F, (Object)string);
        this.ab.remove((Object)F);
        a.debug((Object)("Updated scanner path [" + string + "]"));
    }

    public String getScannerOption() {
        return (String)this.ab.get((Object)G);
    }

    public void setScannerOption(String string) {
        this.af.createGlobalSettings().put(G, (Object)string);
        this.ab.remove((Object)G);
        a.debug((Object)("Updated scanner option [" + string + "]"));
    }

    public boolean e() {
        return this.getDeleteIfInfected().equalsIgnoreCase("on");
    }

    public String getDeleteIfInfected() {
        String string = (String)this.ab.get((Object)H);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setDeleteIfInfected(String string) {
        this.af.createGlobalSettings().put(H, (Object)string);
        this.ab.remove((Object)H);
        a.debug((Object)("Updated delete if infected [" + string + "]"));
    }

    public boolean f() {
        return this.getEmailIfInfected().equalsIgnoreCase("on");
    }

    public String getEmailIfInfected() {
        return (String)this.ab.get((Object)I);
    }

    public void setEmailIfInfected(String string) {
        this.af.createGlobalSettings().put(I, (Object)string);
        this.ab.remove((Object)I);
        a.debug((Object)("Updated email if infected [" + string + "]"));
    }

    public boolean g() {
        return this.getDeleteIfError().equalsIgnoreCase("on");
    }

    public String getDeleteIfError() {
        return (String)this.ab.get((Object)J);
    }

    public void setDeleteIfError(String string) {
        this.af.createGlobalSettings().put(J, (Object)string);
        this.ab.remove((Object)J);
        a.debug((Object)("Updated delete if error [" + string + "]"));
    }

    public boolean h() {
        return this.getEmailIfError().equalsIgnoreCase("on");
    }

    public String getEmailIfError() {
        return (String)this.ab.get((Object)K);
    }

    public void setEmailIfError(String string) {
        this.af.createGlobalSettings().put(K, (Object)string);
        this.ab.remove((Object)K);
        a.debug((Object)("Updated email if error [" + string + "]"));
    }

    public String getGroupToEmail() {
        return (String)this.ab.get((Object)L);
    }

    public void setGroupToEmail(String string) {
        this.af.createGlobalSettings().put(L, (Object)string);
        this.ab.remove((Object)L);
        a.debug((Object)("Updated group to email (Confluence Sysadmin Group) [" + string + "]"));
    }

    private String getVirusAlertActor() {
        return (String)this.ab.get((Object)M);
    }

    public void setVirusAlertActor(String string) {
        this.af.createGlobalSettings().put(M, (Object)string);
        this.ab.remove((Object)M);
        a.debug((Object)("Updated virus alert actor [" + string + "]"));
    }

    public ConfluenceUser getVirusAlertActorUser() {
        ConfluenceUser confluenceUser = null;
        String string = this.getVirusAlertActor();
        if (!string.isEmpty()) {
            confluenceUser = this.ai.getUserByKey(new UserKey(string));
        }
        return confluenceUser;
    }

    public boolean getIsVirusScanRunning() {
        return Boolean.parseBoolean((String)this.ab.get((Object)N));
    }

    public void setIsVirusScanRunning(boolean bl) {
        this.af.createGlobalSettings().put(N, (Object)Boolean.toString(bl));
        this.ab.remove((Object)N);
        a.debug((Object)("Updated is virus scan running? [" + bl + "]"));
    }

    public String getVirusScanNodeId() {
        return (String)this.ab.get((Object)O);
    }

    public void setVirusScanNodeId(String string) {
        this.af.createGlobalSettings().put(O, (Object)string);
        this.ab.remove((Object)O);
        a.debug((Object)("Updated virus scan node id [" + string + "]"));
    }

    public String getQuotaCheck() {
        return (String)this.ab.get((Object)P);
    }

    public String getQuotaErrorMessage() {
        return (String)this.ab.get((Object)Q);
    }

    public String getUnit() {
        return (String)this.ab.get((Object)R);
    }

    public long getDefaultStorageAllocated() {
        Long l = (Long)this.ab.get((Object)S);
        return l == null ? 0L : l;
    }

    public boolean i() {
        return this.getQuotaCheck().equalsIgnoreCase(d);
    }

    public boolean j() {
        return this.getDefaultStorageAllocated() == 0L;
    }

    public void setQuotaCheck(String string) {
        this.af.createGlobalSettings().put(P, (Object)string);
        this.ab.remove((Object)P);
        a.debug((Object)("Updated quota check [" + string + "]"));
    }

    public void setQuotaErrorMessage(String string) {
        this.af.createGlobalSettings().put(Q, (Object)string);
        this.ab.remove((Object)Q);
        a.debug((Object)("Updated quota error message [" + string + "]"));
    }

    public void setDefaultStorageAllocated(String string) {
        this.af.createGlobalSettings().put(S, (Object)string);
        this.ab.remove((Object)S);
        a.debug((Object)("Updated default storage allocated [" + string + "] bytes"));
    }

    public void setUnit(String string) {
        this.af.createGlobalSettings().put(R, (Object)string);
        this.ab.remove((Object)R);
        a.debug((Object)("Updated unit [" + string + "]"));
    }

    public String getJobEndAmPm() {
        return (String)this.ab.get((Object)T);
    }

    public String getJobEndHour() {
        return (String)this.ab.get((Object)U);
    }

    public String getJobEndMinute() {
        return (String)this.ab.get((Object)V);
    }

    public String getJobStartAmPm() {
        return (String)this.ab.get((Object)W);
    }

    public String getJobStartHour() {
        return (String)this.ab.get((Object)X);
    }

    public String getJobStartMinute() {
        return (String)this.ab.get((Object)Y);
    }

    private String getEnableQuotaCheckAfterSetup() {
        return (String)this.ab.get((Object)aa);
    }

    private String getIsJobRunning() {
        return (String)this.ab.get((Object)Z);
    }

    public boolean k() {
        return Boolean.parseBoolean(this.getEnableQuotaCheckAfterSetup());
    }

    public boolean l() {
        return Boolean.parseBoolean(this.getIsJobRunning());
    }

    public void setJobEndAmPm(String string) {
        this.af.createGlobalSettings().put(T, (Object)string);
        this.ab.remove((Object)T);
        a.debug((Object)("Updated job end am/pm [" + string + "]"));
    }

    public void setJobEndHour(String string) {
        this.af.createGlobalSettings().put(U, (Object)string);
        this.ab.remove((Object)U);
        a.debug((Object)("Updated job end hour [" + string + "]"));
    }

    public void setJobEndMinute(String string) {
        this.af.createGlobalSettings().put(V, (Object)string);
        this.ab.remove((Object)V);
        a.debug((Object)("Updated job end minute [" + string + "]"));
    }

    public void setJobStartAmPm(String string) {
        this.af.createGlobalSettings().put(W, (Object)string);
        this.ab.remove((Object)W);
        a.debug((Object)("Updated job start am/pm [" + string + "]"));
    }

    public void setJobStartHour(String string) {
        this.af.createGlobalSettings().put(X, (Object)string);
        this.ab.remove((Object)X);
        a.debug((Object)("Updated job start hour [" + string + "]"));
    }

    public void setJobStartMinute(String string) {
        this.af.createGlobalSettings().put(Y, (Object)string);
        this.ab.remove((Object)Y);
        a.debug((Object)("Updated job start minute [" + string + "]"));
    }

    public void m() {
        this.af.createGlobalSettings().put(aa, (Object)String.valueOf(this.i()));
        this.ab.remove((Object)aa);
        a.debug((Object)("Updated enable quota check after setup [" + this.i() + "]"));
    }

    public void setIsJobRunning(boolean bl) {
        this.af.createGlobalSettings().put(Z, (Object)String.valueOf(bl));
        this.ab.remove((Object)Z);
        a.debug((Object)("Updated is job running [" + bl + "]"));
    }

    public String b(String string) {
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        return this.ah.detect(string);
    }

    public boolean c(String string) {
        boolean bl;
        a.debug((Object)"*** Checking Extension ***");
        if (string != null) {
            boolean bl2 = bl = (string.equals(i) || string.equals(h)) && this.a();
            if (!bl) {
                String string2 = this.getFilterMode();
                boolean bl3 = string2.equalsIgnoreCase("whitelist");
                Set<String> set = this.getExtensionSet();
                bl = bl3 && set.contains(string) || !bl3 && !set.contains(string);
            }
        } else {
            bl = true;
        }
        a.debug((Object)("Is extension [" + string + "] valid? [" + bl + "]"));
        return bl;
    }

    public boolean a(String string, String string2, InputStream inputStream) {
        boolean bl;
        a.debug((Object)"*** Checking Mime Type ***");
        String string3 = this.getFilterMode();
        a.debug((Object)("Filter mode [" + string3 + "]"));
        a.debug((Object)("Mime type [" + string2 + "]"));
        String string4 = MediaType.parse((String)string2).getBaseType().toString();
        a.debug((Object)("Base mime type [" + string4 + "]"));
        boolean bl2 = string3.equalsIgnoreCase("whitelist");
        boolean bl3 = AttachmentCheckerHelper.a(inputStream, string4);
        if (string4.equals("application/x-tika-ooxml-protected")) {
            String string5 = this.getAllowProtected();
            a.debug((Object)("Allow protected [" + string5 + "]"));
            bl = string5.equals("on");
        } else if (string4.equals("application/x-tika-msoffice") && bl3) {
            String string6 = this.getAllowEncrypted();
            a.debug((Object)("Allow encrypted [" + string6 + "]"));
            bl = string6.equals("on");
        } else if (string4.equals("application/dicom")) {
            a.debug((Object)"DICOM file detected");
            bl = this.a(bl2, string, ".dcm");
        } else if (string4.equals("application/vnd.ms-spreadsheetml") || string4.equals("application/vnd.ms-wordml")) {
            a.debug((Object)"Office xml file detected");
            bl = this.a(bl2, string, ".xml");
        } else {
            boolean bl4 = bl = this.b(string, string4) && this.a() || this.b(string, string4, inputStream);
            if (!bl) {
                Set<String> set = this.getMimeTypeSet();
                bl = bl2 && set.contains(string4) || !bl2 && !set.contains(string4);
            }
        }
        a.debug((Object)("Is mime type [" + string4 + "] valid? [" + bl + "]"));
        return bl;
    }

    private boolean a(boolean bl, String string, String string2) {
        return bl && string2.equals(string) || !bl && !this.getExtensionSet().contains(string2);
    }

    private boolean b(@NotNull String string, String string2, InputStream inputStream) {
        boolean bl = false;
        if (".ics".equals(string) && string2.equals("text/html")) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string3 = bufferedReader.readLine();
                a.debug((Object)("First line [" + string3 + "]"));
                bl = string3.equals("BEGIN:VCALENDAR");
            }
            catch (IOException iOException) {
                a.error((Object)"IOException while trying to read input stream", (Throwable)iOException);
            }
        }
        a.debug((Object)("Is calendar file with html? [" + bl + "]"));
        return bl;
    }

    private boolean b(String string, String string2) {
        boolean bl = false;
        if (string != null) {
            bl = (string.equals(i) || string.equals(h)) && string2.equals("text/plain") || string.equals(h) && string2.equals("application/octet-stream");
        }
        a.debug((Object)("Is Table Spreadsheet Macro attachments? [" + bl + "]"));
        return bl;
    }

    public boolean a(String string, long l, ConfluenceUser confluenceUser) {
        a.debug((Object)("User [" + confluenceUser + "]"));
        FileSizeLimit fileSizeLimit = null;
        if (confluenceUser != null) {
            List<FileSizeGroup> list = this.ac.getFileSizeGroups();
            for (FileSizeGroup fileSizeGroup : list) {
                try {
                    Group group = this.ad.getGroup(fileSizeGroup.getGroup());
                    if (!this.ad.hasMembership(group, (User)confluenceUser)) continue;
                    a.debug((Object)("Get file size limit for [" + fileSizeGroup.getGroup() + "]"));
                    fileSizeLimit = this.ac.b(fileSizeGroup.getID(), string);
                    break;
                }
                catch (EntityException entityException) {
                    a.error((Object)entityException.getMessage());
                }
            }
            if (fileSizeLimit == null) {
                a.debug((Object)"Get file size limit for any logged in user");
                fileSizeLimit = this.ac.b(0, string);
            }
        } else {
            a.debug((Object)"Get file size limit for anonymous ");
            fileSizeLimit = this.ac.b(-1, string);
        }
        if (fileSizeLimit != null) {
            long l2 = AttachmentCheckerHelper.a(fileSizeLimit.getSizeLimit(), fileSizeLimit.getSizeUnit());
            a.debug((Object)("Mime type [" + string + "] size limit [" + l2 + "] bytes"));
            a.debug((Object)("File size [" + l + "] bytes"));
            return l > l2;
        }
        return false;
    }

    public Map<String, String> a(String string, long l) {
        a.debug((Object)"*** Checking Storage ***");
        a.debug((Object)("Space key [" + string + "]"));
        a.debug((Object)("File size [" + l + "]"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SpaceInfo spaceInfo = this.ag.b(string);
        long l2 = spaceInfo.getStorageAllocated();
        if (l2 == -1L) {
            l2 = this.getDefaultStorageAllocated();
        }
        if (l2 == 0L) {
            a.debug((Object)"Storage allocated [Unlimited]");
            hashMap.put("storageInfo", "(Unlimited Storage)");
            hashMap.put("isSufficient", Boolean.toString(true));
        } else {
            long l3 = spaceInfo.getStorageUsed();
            long l4 = l2 - l3;
            a.debug((Object)("Storage allocated [" + l2 + "]"));
            a.debug((Object)("Storage available [" + l4 + "]"));
            hashMap.put("allocated", AttachmentCheckerHelper.a(l2, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("available", AttachmentCheckerHelper.a(l4, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("used", AttachmentCheckerHelper.a(l3, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("isSufficient", String.valueOf(l <= l4));
        }
        return hashMap;
    }

    private class AcConfigCacheLoader
    implements CacheLoader<String, Object> {
        private AcConfigCacheLoader() {
        }

        @Nonnull
        public Object a(@Nonnull String string) {
            Object object;
            String string2 = null;
            try {
                string2 = this.b(string);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            switch (string) {
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions": {
                    object = this.c(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map": {
                    object = this.d(AttachmentCheckerConfig.t);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set": {
                    object = this.d(AttachmentCheckerConfig.u);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set": {
                    object = this.d(AttachmentCheckerConfig.v);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.filterMode": {
                    object = this.e(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowEncrypted": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowProtected": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowTableSpreadsheetMacro": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.onAccessScanning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerMode": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.autoDeleteMode": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfInfected": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.deleteIfError": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfError": {
                    object = this.a(string2, "off");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.message": {
                    object = this.f(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeCheck": {
                    object = this.g(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeError": {
                    object = this.h(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanRunning": {
                    object = this.a(string2, Boolean.FALSE.toString());
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.groupToEmail": {
                    object = this.a(string2, "confluence-administrators");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerPath": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerOption": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusAlertActor": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanNodeId": {
                    object = this.a(string2, "");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCheck": {
                    object = this.i(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaError": {
                    object = this.j(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultStorage": {
                    object = this.k(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unit": {
                    object = this.l(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndAmPm": {
                    object = this.m(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndHour": {
                    object = this.n(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndMinute": {
                    object = this.o(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartAmPm": {
                    object = this.p(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartHour": {
                    object = this.q(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartMinute": {
                    object = this.r(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isJobRunning": {
                    object = this.s(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.enableQuotaCheckAfterSetup": {
                    object = this.t(string2);
                    break;
                }
                default: {
                    object = "This should not happen";
                }
            }
            return object;
        }

        private String b(String string) {
            switch (string) {
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.map": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set": {
                    return null;
                }
            }
            return AttachmentCheckerConfig.this.af.createGlobalSettings().get(string).toString();
        }

        @NotNull
        private String a(String string, String string2) {
            if (string == null || string.trim().isEmpty()) {
                string = string2;
            }
            return string;
        }

        private String c(String string) {
            if (string == null || string.trim().isEmpty()) {
                string = AttachmentCheckerConfig.j;
            }
            a.debug((Object)("Extensions [" + string + "]"));
            return string;
        }

        private Object d(String string) {
            String string2 = (String)AttachmentCheckerConfig.this.ab.get((Object)AttachmentCheckerConfig.s);
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            if (string2 != null && string2.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                while (stringTokenizer.hasMoreElements()) {
                    List<String> list;
                    String string3 = (String)stringTokenizer.nextElement();
                    if (!string3.startsWith(".")) {
                        string3 = ".".concat(string3);
                    }
                    a.debug((Object)("Adding extension [" + string3 + "]"));
                    treeSet.add(string3);
                    String string4 = AttachmentCheckerConfig.this.ah.detect(string3);
                    if (string4.equalsIgnoreCase(AttachmentCheckerConfig.f) || string4.equalsIgnoreCase(AttachmentCheckerConfig.g)) {
                        treeSet2.add(AttachmentCheckerConfig.f);
                        treeSet2.add(AttachmentCheckerConfig.g);
                        a.debug((Object)("Adding mime type [application/x-msdownload] for [" + string3 + "]"));
                        a.debug((Object)("Adding mime type [application/x-dosexec] for [" + string3 + "]"));
                        list = this.b(string3, AttachmentCheckerConfig.g);
                        list.addAll(this.b(string3, AttachmentCheckerConfig.f));
                    } else {
                        treeSet2.add(string4);
                        a.debug((Object)("Adding mime type [" + string4 + "] for [" + string3 + "]"));
                        list = this.b(string3, string4);
                    }
                    treeSet.addAll(list);
                    hashMap.put(string3, list);
                }
            }
            if (string.equalsIgnoreCase(AttachmentCheckerConfig.t)) {
                return hashMap;
            }
            if (string.equalsIgnoreCase(AttachmentCheckerConfig.u)) {
                return treeSet;
            }
            return treeSet2;
        }

        private List<String> b(String string, String string2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                MimeType mimeType = AttachmentCheckerConfig.this.ae.forName(string2);
                List list = mimeType.getExtensions();
                for (String string3 : list) {
                    if (string3.equalsIgnoreCase(string)) continue;
                    arrayList.add(string3);
                }
            }
            catch (MimeTypeException mimeTypeException) {
                a.debug((Object)mimeTypeException.getMessage());
            }
            return arrayList;
        }

        private String e(String string) {
            if (string == null || !string.equalsIgnoreCase(AttachmentCheckerConfig.c) && !string.equalsIgnoreCase("whitelist")) {
                string = "whitelist";
            }
            a.debug((Object)("Filter mode [" + string + "]"));
            return string.toLowerCase();
        }

        private String f(String string) {
            if (string == null || string.isEmpty()) {
                string = AttachmentCheckerConfig.l;
            }
            a.debug((Object)("File type error message [" + string + "]"));
            return string;
        }

        private String g(String string) {
            if (string == null) {
                string = "disabled";
            }
            a.debug((Object)("File size check [" + string + "]"));
            return string.toLowerCase();
        }

        private String h(String string) {
            if (string == null) {
                string = AttachmentCheckerConfig.n;
            }
            a.debug((Object)("File size error message [" + string + "]"));
            return string;
        }

        private String i(String string) {
            if (string == null) {
                string = "disabled";
            }
            a.debug((Object)("Quota check [" + string + "]"));
            return string.toLowerCase();
        }

        private String j(String string) {
            if (string == null) {
                string = AttachmentCheckerConfig.p;
            }
            a.debug((Object)("Quota error message [" + string + "]"));
            return string;
        }

        private Long k(String string) {
            long l;
            if (string == null || string.isEmpty()) {
                string = String.valueOf(0L);
            }
            a.debug((Object)("Default storage [" + string + "] bytes"));
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                l = 0L;
            }
            return l;
        }

        private String l(String string) {
            if (string == null || string.isEmpty()) {
                string = AttachmentCheckerConfig.q;
            }
            a.debug((Object)("Unit [" + string + "]"));
            return string;
        }

        private String m(String string) {
            if (string == null) {
                string = "";
            }
            a.debug((Object)("Job end am/pm [" + string + "]"));
            return string;
        }

        private String n(String string) {
            if (string == null) {
                string = "";
            }
            a.debug((Object)("Job end hour [" + string + "]"));
            return string;
        }

        private String o(String string) {
            if (string == null) {
                string = "";
            }
            a.debug((Object)("Job end minute [" + string + "]"));
            return string;
        }

        private String p(String string) {
            if (string == null) {
                string = "";
            }
            a.debug((Object)("Job start am/pm [" + string + "]"));
            return string;
        }

        private String q(String string) {
            if (string == null) {
                string = "";
            }
            a.debug((Object)("Job start hour [" + string + "]"));
            return string;
        }

        private String r(String string) {
            if (string == null) {
                string = "";
            }
            a.debug((Object)("Job start minute [" + string + "]"));
            return string;
        }

        private String s(String string) {
            if (string == null) {
                string = String.valueOf(false);
            }
            a.debug((Object)("Is job running [" + string + "]"));
            return string;
        }

        private String t(String string) {
            if (string == null) {
                string = String.valueOf(false);
            }
            a.debug((Object)("Enable quota check after setup [" + string + "]"));
            return string;
        }

        @Nonnull
        public /* synthetic */ Object load(@Nonnull Object object) {
            return this.a((String)object);
        }
    }
}

