/*
 * Decompiled with CFR 0.152.
 */
package com.akeles.plugins.confluence.upgradetask;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.service.SpaceService;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={PluginUpgradeTask.class})
public class BandanaUpgradeTask
implements PluginUpgradeTask {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.cql.upgradetask.BandanaUpgradeTask");
    private final BandanaManager b;
    private final PluginSettings c;
    private final SpaceService d;

    @Inject
    public BandanaUpgradeTask(@ComponentImport BandanaManager bandanaManager, @ComponentImport @NotNull PluginSettingsFactory pluginSettingsFactory, @ComponentImport SpaceService spaceService) {
        a.debug("BandanaUpgradeTask constructed");
        this.b = bandanaManager;
        this.c = pluginSettingsFactory.createSettingsForKey("cqlTab");
        this.d = spaceService;
    }

    public int getBuildNumber() {
        return 1;
    }

    @NotNull
    public String getShortDescription() {
        return "Migrates CqlQuickSearchSpaceEntity from Bandana to PluginSettingsFactory";
    }

    @Nullable
    public Collection<Message> doUpgrade() {
        a.debug("Migrating CqlQuickSearchSpaceEntity from Bandana to PluginSettingsFactory");
        ConfluenceBandanaContext confluenceBandanaContext = new ConfluenceBandanaContext("cqlTab");
        Iterable iterable = this.b.getKeys((BandanaContext)confluenceBandanaContext);
        a.debug("Space count [" + ((Collection)iterable).size() + "]");
        iterable.forEach(string -> {
            a.debug("Space key [" + string + "]");
            Object object = this.c.get(string);
            if (this.d.getKeySpaceLocator(string).getSpace() == null) {
                a.debug("Space [" + string + "] not found");
                if (object != null) {
                    this.c.remove(string);
                    a.debug("Removed CqlQuickSearchSpaceEntity in PluginSettingsFactory for space [" + string + "]");
                }
            } else if (object == null) {
                a.debug("CqlQuickSearchSpaceEntity does not exists in PluginSettingsFactory for space [" + string + "]");
                a.debug("Get value from Bandana");
                Object object2 = this.b.getValue((BandanaContext)confluenceBandanaContext, string);
                a.debug(object2.toString());
                this.c.put(string, (Object)object2.toString());
                a.debug("Saved CqlQuickSearchSpaceEntity in PluginSettingsFactory");
            } else {
                a.debug("CqlQuickSearchSpaceEntity already exists in PluginSettingsFactory for space [" + string + "]");
                a.debug(object.toString());
            }
        });
        return List.of();
    }

    @NotNull
    public String getPluginKey() {
        return "com.akeles.plugins.confluence.cqlSearchUtilities";
    }
}

