/*
 * Decompiled with CFR 0.152.
 */
package com.akeles.plugins.confluence.helper;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.commons.lang.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Named(value="CqlCommonHelper")
public class CqlCommonHelper {
    private static final String a = "macroId";
    private static final String b = "id";
    private static final String c = "cql";
    private static final String d = "cqlQuery";
    private static final String e = "defaultTerm";
    private static final String f = "$self";
    private static final String g = "$$query$$";
    private static final String h = "hideFilePath";
    private static final String i = "hideInput";
    private static final String j = "num";
    private static final String k = "noResultsMsg";
    private static final String l = "searchType";
    private static final String m = "cqlNotRequired";
    private static final String n = "'$$query$$'";
    private static final String o = "\"$$query$$\"";
    private static final String p = "Exact Match";
    private static final String q = "Start With";
    private static final String r = "Contains";
    private final ContentEntityManager s;
    private final SettingsManager t;
    private final PluginLicenseManager u;
    private final VelocityHelperService v;
    private final Logger w = LoggerFactory.getLogger((String)"com.akeles.plugins.cql.CqlCommonHelper");

    @Inject
    public CqlCommonHelper(@ComponentImport SettingsManager settingsManager, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport VelocityHelperService velocityHelperService, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager) {
        this.w.debug("CqlCommonHelper initialised....");
        this.t = settingsManager;
        this.u = pluginLicenseManager;
        this.s = contentEntityManager;
        this.v = velocityHelperService;
    }

    public String a(String string, Map<String, Object> map) {
        return this.v.getRenderedTemplate(string, map);
    }

    public ContentEntityObject a(long l) {
        return this.s.getById(l);
    }

    public List<VersionHistorySummary> a(ContentEntityObject contentEntityObject) {
        return this.s.getVersionHistorySummaries(contentEntityObject);
    }

    public void a(Map<String, String> map, @NotNull Map<String, Object> map2, @NotNull ConversionContext conversionContext) throws MacroExecutionException {
        PageContext pageContext;
        this.w.debug("calling processCqlMacro()... ");
        PageContext pageContext2 = pageContext = conversionContext.getPageContext() != null ? conversionContext.getPageContext() : new PageContext();
        if (pageContext.getEntity() == null) {
            map2.put(b, RandomStringUtils.randomAlphanumeric((int)10));
        } else {
            map2.put(b, pageContext.getEntity().getIdAsString());
        }
        map2.put(a, this.a(conversionContext));
        map2.put(h, "");
        map2.put(j, 10);
        map2.put(l, p);
        map2.put(k, "");
        map2.put(i, "");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(h, j, k, l));
        for (String string : arrayList) {
            if (!map.containsKey(string)) continue;
            map2.put(string, map.get(string));
        }
        if (map.containsKey(i)) {
            map2.put(i, "hidden");
        }
        this.b(map, map2, conversionContext);
    }

    private void b(@NotNull Map<String, String> map, Map<String, Object> map2, ConversionContext conversionContext) throws MacroExecutionException {
        String string;
        this.w.debug("calling processDefaultTermAndCqlString()... ");
        String string2 = null;
        if (map.containsKey(c)) {
            string2 = map.get(c);
            this.w.debug("original CQL = [" + string2 + "]");
        } else {
            if (map.containsKey(m) && map.get(m).equals("true")) {
                this.w.debug("original CQL parameter is not required");
                return;
            }
            this.w.debug("original CQL parameter not found");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new MacroExecutionException("Please enter a CQL");
        }
        String string3 = this.b(map);
        if (!string3.isEmpty()) {
            if (string3.equals(f)) {
                ContentEntityObject contentEntityObject = conversionContext.getEntity();
                string3 = contentEntityObject.getTitle();
                this.w.debug("Setting defaultTerm to Page Title [" + string3 + "]");
            }
            string = this.a(string2, string3, map2.get(l).toString());
            this.w.debug("new cql after default term is replaced -- [" + string + "]");
        } else {
            string = string2.replace(g, "''");
            this.w.debug("no default term -- [" + string + "]");
        }
        map2.put(c, string2);
        map2.put(d, string);
        map2.put(e, string3);
    }

    private String b(@NotNull Map<String, String> map) {
        this.w.debug("calling getDefaultTerm()... ");
        String string = "";
        if (map.containsKey(e)) {
            string = map.get(e);
        } else {
            this.w.debug("No default term provided. Defaulting it to empty");
        }
        this.w.debug("returning defaultTerm = [" + string + "]");
        return string;
    }

    @NotNull
    private String a(String string, String string2, @NotNull String string3) {
        this.w.debug("calling getCqlByType() with searchType = [" + string3 + "]");
        if (string3.equals(q)) {
            string2 = this.a(string2, false);
        } else if (string3.equals(r)) {
            string2 = this.a(string2, true);
        }
        string2 = string2.replace("'", "\\'").replace("\"", "\\\"");
        string = string.contains(n) || string.contains(o) ? string.replace(g, string2) : string.replace(g, "\"" + string2 + "\"");
        this.w.debug("returning originalCql = [" + string + "]");
        return string;
    }

    public String a(@NotNull String string, boolean bl) {
        this.w.debug("calling appendWildcard() with query [" + string + "]");
        String[] stringArray = string.split(" ");
        string = "";
        for (String string2 : stringArray) {
            if (!string2.equals(stringArray[0])) {
                string = string.concat(" ");
            }
            string = bl ? this.a(string2.replaceAll("'", "").replaceAll("\"", ""), string) : this.b(string2.replaceAll("'", "").replaceAll("\"", ""), string);
        }
        this.w.debug("returning queryTerm = [" + string + "]");
        return string;
    }

    private String a(@NotNull String string, String string2) {
        this.w.debug("calling handleContainsSearch()...");
        string2 = string.startsWith("/.*") && string.endsWith(".*/") ? string.substring(0, string.indexOf(".*/")).concat("*.*/") : (string.startsWith("/.*") && !string.endsWith(".*/") ? string2.concat(string).concat("*.*/") : (!string.startsWith("/.*") && string.endsWith(".*/") ? string2.concat("/.*").concat(string.substring(0, string.indexOf(".*/"))).concat("*.*/") : string2.concat("/.*").concat(string).concat("*.*/")));
        this.w.debug("returning query = [" + string2 + "]");
        return string2;
    }

    @NotNull
    private String b(@NotNull String string, String string2) {
        this.w.debug("calling handleStartWithSearch()... ");
        string2 = !string.equals("") && string.lastIndexOf(42) != string.length() - 1 ? string2.concat(string).concat("*") : string2.concat(string);
        this.w.debug("returning query = [" + string2 + "]");
        return string2;
    }

    public String a(@NotNull ConversionContext conversionContext) throws MacroExecutionException {
        String string;
        this.w.debug("calling getMacroId()... ");
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        Optional optional = macroDefinition.getMacroIdentifier();
        if (optional.isPresent()) {
            try {
                string = ((MacroId)optional.get()).getId();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new MacroExecutionException((Throwable)noSuchElementException);
            }
        } else {
            string = "edit";
        }
        this.w.debug("returning macroId = [" + string + "]");
        return string;
    }

    public boolean a() {
        this.w.debug("calling isLicenseValid()");
        String string = this.t.getGlobalSettings().getBaseUrl();
        boolean bl = false;
        try {
            PluginLicense pluginLicense;
            if (string.contains("akeles")) {
                bl = true;
            } else if (this.u.getLicense().isDefined() && !(pluginLicense = (PluginLicense)this.u.getLicense().get()).getError().isDefined()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.w.debug("returning licenseValid = " + bl);
        return bl;
    }

    public void a(@NotNull Map<String, String> map) {
        this.w.debug("calling printHashMapContent()... ");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.w.debug("[" + entry.getKey() + "] ---> [" + entry.getValue() + "]");
        }
    }
}

