/*
 * Decompiled with CFR 0.152.
 */
package com.akeles.plugins.confluence.rest;

import com.akeles.plugins.confluence.ao.FilterService;
import com.akeles.plugins.confluence.ao.entity.CqlFilter;
import com.akeles.plugins.confluence.helper.CqlCommonHelper;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.pageproperties.api.model.PagePropertiesMacroInstance;
import com.atlassian.confluence.plugins.pageproperties.api.model.PagePropertiesMacroReport;
import com.atlassian.confluence.plugins.pageproperties.api.model.PageProperty;
import com.atlassian.confluence.plugins.pageproperties.api.service.PagePropertiesService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.user.UserKey;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Path(value="/")
@Named(value="CqlSearchRestResource")
public class CqlSearchRestResource {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.cql.CqlSearchRestResource");
    private static final String b = "'$$query$$'";
    private static final String c = "\"$$query$$\"";
    private static final String d = "$$query$$";
    private static final String e = "$$query*$$";
    private static final String f = "$$id$$";
    private static final String g = "$$parentid$$";
    private static final String h = "$$title$$";
    private static final String i = "$$created$$";
    private static final String j = "$$lastmodified$$";
    private static final String k = "$$space.key$$";
    private static final String l = "$$space.title$$";
    private static final String m = "All";
    private static final String n = "error";
    private final String o;
    private static final String p = "StartWith";
    private static final String q = "Contains";
    private static final String r = "creator";
    private static final String s = "modifier";
    private static final String t = "cqlsearch";
    private static final String u = "cqlsearchtable";
    private static final String v = "cqlsearchcounter";
    private static final String w = "cqlsearchcounterlink";
    private static final String x = "cqlnavigation";
    private static final String y = "cqlsummary";
    private static final String z = "cqlsummaryreport";
    private static final String A = "cqltab";
    private final java.time.format.DateTimeFormatter B = java.time.format.DateTimeFormatter.ofPattern("MMM dd, yyyy").withZone(ZoneId.systemDefault());
    private final java.time.format.DateTimeFormatter C = java.time.format.DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").withZone(ZoneId.systemDefault());
    private final CQLSearchService D;
    private final UserAccessor E;
    private final CqlCommonHelper F;
    private final PagePropertiesService G;
    private final XhtmlContent H;
    private final PageManager I;
    private final ContentService J;
    private final FilterService K;

    @Inject
    public CqlSearchRestResource(@ComponentImport CQLSearchService cQLSearchService, @ComponentImport @NotNull ContextPathHolder contextPathHolder, @ComponentImport UserAccessor userAccessor, @ComponentImport PagePropertiesService pagePropertiesService, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport PageManager pageManager, @ComponentImport ContentService contentService, CqlCommonHelper cqlCommonHelper, FilterService filterService) {
        a.debug((Object)"CqlSearchRestResource initialised....");
        this.D = cQLSearchService;
        this.o = contextPathHolder.getContextPath();
        this.E = userAccessor;
        this.G = pagePropertiesService;
        this.H = xhtmlContent;
        this.F = cqlCommonHelper;
        this.I = pageManager;
        this.K = filterService;
        this.J = contentService;
    }

    @GET
    @Path(value="/getFilters/{id}")
    @Produces(value={"application/json"})
    public Response a(@PathParam(value="id") int n) {
        a.debug((Object)("calling getFilter with id = [" + n + "]"));
        JsonObject jsonObject = new JsonObject();
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser != null) {
            String string = confluenceUser.getKey().toString();
            a.debug((Object)("UserKey: " + string));
            CqlFilter[] cqlFilterArray = this.K.a(string, n);
            if (cqlFilterArray.length == 0) {
                a.debug((Object)"Unable to find filter");
                return Response.serverError().entity((Object)"Unable to find filter").build();
            }
            a.debug((Object)("Found filter ] = [" + cqlFilterArray[0].getID()));
            CqlFilter cqlFilter = cqlFilterArray[0];
            jsonObject.addProperty("id", (Number)cqlFilter.getID());
            jsonObject.addProperty("name", cqlFilter.getName());
            jsonObject.addProperty("cql", cqlFilter.getCql());
        } else {
            a.error((Object)"No authenticated user found.");
        }
        return Response.ok((Object)jsonObject.toString()).build();
    }

    @DELETE
    @Path(value="/getFilters/{id}")
    @Produces(value={"application/json"})
    public Response b(@PathParam(value="id") int n) {
        a.debug((Object)("calling deleteFilter with id = [" + n + "]"));
        JsonObject jsonObject = new JsonObject();
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser != null) {
            String string = confluenceUser.getKey().toString();
            a.debug((Object)("UserKey: " + string));
            CqlFilter cqlFilter = this.K.b(string, n);
            if (cqlFilter == null) {
                return Response.serverError().entity((Object)"Unable to delete filter").build();
            }
            jsonObject.addProperty("id", (Number)cqlFilter.getID());
            jsonObject.addProperty("name", cqlFilter.getName());
            jsonObject.addProperty("cql", cqlFilter.getCql());
        } else {
            a.error((Object)"No authenticated user found.");
        }
        return Response.ok((Object)jsonObject.toString()).build();
    }

    @GET
    @Path(value="/getFilters")
    @Produces(value={"application/json"})
    public Response getFilters() {
        a.debug((Object)"calling getFilters...");
        JsonObject jsonObject = new JsonObject();
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser != null) {
            String string = confluenceUser.getKey().toString();
            a.debug((Object)("UserKey: " + string));
            CqlFilter[] cqlFilterArray = this.K.a(string);
            JsonArray jsonArray = new JsonArray();
            for (int i = 0; i < cqlFilterArray.length; ++i) {
                JsonObject jsonObject2 = new JsonObject();
                CqlFilter cqlFilter = cqlFilterArray[i];
                jsonObject2.addProperty("id", (Number)cqlFilter.getID());
                jsonObject2.addProperty("name", cqlFilter.getName());
                jsonObject2.addProperty("cql", cqlFilter.getCql());
                jsonArray.add((JsonElement)jsonObject2);
            }
            jsonObject.add("data", (JsonElement)jsonArray);
        } else {
            a.error((Object)"No authenticated user found.");
        }
        return Response.ok((Object)jsonObject.toString()).build();
    }

    @POST
    @Path(value="/saveFilter")
    @ReadOnlyAccessAllowed
    @AnonymousAllowed
    public Response a(@FormParam(value="id") String string, @FormParam(value="name") String string2, @FormParam(value="cql") String string3) {
        a.debug((Object)"calling saveCqlFilter: ");
        a.debug((Object)("    id = [" + string + "]"));
        a.debug((Object)("    name = [" + string2 + "]"));
        a.debug((Object)("    cql = [" + string3 + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        JsonObject jsonObject = new JsonObject();
        if (confluenceUser != null) {
            String string4 = confluenceUser.getKey().toString();
            a.debug((Object)("UserKey: " + string4));
            if (string.isEmpty()) {
                string = this.K.a(string4, string2, string3);
            } else {
                this.K.a(Long.parseLong(string), string4, string2, string3);
            }
        } else {
            a.error((Object)"No authenticated user found.");
        }
        jsonObject.addProperty("id", string);
        return Response.ok((Object)jsonObject.toString()).build();
    }

    @POST
    @Path(value="/bulkMovePages")
    @AnonymousAllowed
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response b(@FormParam(value="bulkMoveOptions") String string, @FormParam(value="cqlToValidate") @NotNull String string2, @FormParam(value="isValidate") String string3) {
        a.debug((Object)("calling bulkMovePages with bulkMoveOptions = [" + string + "]" + " cqlToValidate= [" + string2 + "] isValidate = [" + string3 + "]"));
        JsonObject jsonObject = JsonParser.parseString((String)string).getAsJsonObject();
        long l = jsonObject.get("oldParent").getAsLong();
        String string4 = jsonObject.get("newSpace").getAsString();
        long l2 = jsonObject.get("newParent").getAsLong();
        String string5 = jsonObject.get("excludePages").getAsString();
        a.debug((Object)("    oldParent = [" + l + "]"));
        a.debug((Object)("    newSpace = [" + string4 + "]"));
        a.debug((Object)("    newParent = [" + l2 + "]"));
        a.debug((Object)("    excludePages = [" + string5 + "]"));
        JsonObject jsonObject2 = new JsonObject();
        String string6 = "ancestor = " + l + " AND type = page";
        string6 = !string2.isEmpty() ? string6 + " AND " + string2 : string6 + " order by lastmodified desc";
        Page page = this.I.getPage(l);
        Page page2 = this.I.getPage(l2);
        if (page == null || page2 == null) {
            jsonObject2.addProperty(n, "Unable to find parent page [" + l2 + "]");
            return Response.ok((Object)jsonObject2.toString()).build();
        }
        try {
            int n = 0;
            int n2 = 200;
            a.debug((Object)("Bulk move executing CQL - [" + string6 + "]"));
            PageResponse pageResponse = this.D.searchContent(string6, (PageRequest)new SimplePageRequest(n, n2), new Expansion[]{Expansion.combine((Object[])new Object[0])});
            if (pageResponse.size() > 0) {
                List<Content> list = this.a(string6, n, n2, (PageResponse<Content>)pageResponse);
                jsonObject2.addProperty("isValidate", string3);
                if (Boolean.parseBoolean(string3)) {
                    JsonArray jsonArray = this.a(list, page);
                    jsonObject2.add("results", (JsonElement)jsonArray);
                    jsonObject2.addProperty("size", (Number)jsonArray.size());
                } else {
                    this.a(string5, jsonObject2, page, page2, list);
                }
            } else {
                jsonObject2.addProperty(n, "No search results found");
                jsonObject2.addProperty("size", (Number)0);
            }
        }
        catch (Exception exception) {
            this.a(exception, string6, jsonObject2);
        }
        return Response.ok((Object)jsonObject2.toString()).build();
    }

    private void a(Exception exception, String string, JsonObject jsonObject) {
        if (exception instanceof NotFoundException) {
            a.error((Object)"No results found", (Throwable)exception);
            jsonObject.addProperty(n, "No search results found -- " + exception);
        } else if (exception instanceof BadRequestException) {
            a.error((Object)("Syntax error in CQL:" + exception));
            jsonObject.addProperty(n, "Syntax error in CQL : " + string);
        } else if (exception instanceof UnsupportedOperationException) {
            a.error((Object)"Syntax error in CQL", (Throwable)exception);
            jsonObject.addProperty(n, "Syntax error in CQL : " + exception.getMessage());
        } else if (exception instanceof IllegalArgumentException) {
            a.error((Object)("Error executing CQL - " + string), (Throwable)exception);
            String string2 = exception.toString();
            if (string2.equals("java.lang.IllegalArgumentException: query parameter is required.") || string2.equals("java.lang.IllegalArgumentException: Raw query is required.")) {
                jsonObject.addProperty(n, "A search keyword is required");
            } else if (string2.contains("java.lang.IllegalArgumentException: Illegal move of parent") || string2.equals("java.lang.IllegalArgumentException: Can not set page as its own parent.")) {
                jsonObject.addProperty(n, string2.replace("java.lang.IllegalArgumentException: ", ""));
            } else {
                jsonObject.addProperty(n, "Unable to execute the CQL [" + string + "]");
            }
        } else {
            a.error((Object)"Other errors", (Throwable)exception);
            jsonObject.addProperty(n, "Unable to execute the CQL [" + string + "]");
        }
    }

    private void a(@NotNull String string, JsonObject jsonObject, Page page, Page page2, @NotNull List<Content> list) {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(string.split(",")));
        int n = 0;
        for (Content content : list) {
            ContentEntityObject contentEntityObject;
            Page page3;
            a.debug((Object)("content id " + content.getId().toString() + " Title =>" + content.getTitle()));
            if (content.getId() == null || (page3 = (Page)(contentEntityObject = this.I.getById(content.getId().asLong()))) == null) continue;
            if (!hashSet.contains(page3.getIdAsString())) {
                a.debug((Object)("Moving " + page3.getIdAsString() + " to " + page2.getIdAsString()));
                this.I.movePageAsChild(page3, page2);
                ++n;
                continue;
            }
            arrayList.add(content);
        }
        JsonArray jsonArray = this.a(arrayList, page);
        jsonObject.add("results", (JsonElement)jsonArray);
        jsonObject.addProperty("size", (Number)jsonArray.size());
        jsonObject.addProperty("movedPageCount", (Number)n);
    }

    @NotNull
    private JsonArray a(@NotNull List<Content> list, @NotNull Page page) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", page.getIdAsString());
        jsonObject.addProperty("text", page.getTitle());
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.addProperty("opened", "true");
        jsonObject2.addProperty("checked", "true");
        jsonObject.add("state", (JsonElement)jsonObject2);
        JsonObject jsonObject3 = new JsonObject();
        jsonObject3.addProperty("class", "no_checkbox notSelected");
        jsonObject.add("a_attr", (JsonElement)jsonObject3);
        jsonObject.addProperty("parent", "#");
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((JsonElement)jsonObject);
        HashSet<String> hashSet = new HashSet<String>();
        HashSet hashSet2 = list.stream().map(content -> {
            Content content2 = (Content)this.J.find(new Expansion[0]).withType(new ContentType[]{ContentType.PAGE}).withId(content.getId(), new ContentId[0]).fetchOrNull();
            return content2.getId().asLong();
        }).collect(Collectors.toCollection(HashSet::new));
        for (Content content2 : list) {
            ContentEntityObject contentEntityObject;
            a.debug((Object)("validate content id " + content2.getId().toString() + " TITLE => " + content2.getTitle()));
            if (content2.getId() == null || !((contentEntityObject = this.F.a(content2.getId().asLong())) instanceof Page)) continue;
            Page page2 = (Page)contentEntityObject;
            this.a(jsonArray, page2, hashSet, (HashSet<Long>)hashSet2);
            this.a(jsonArray, page2, page, hashSet, hashSet2);
        }
        return jsonArray;
    }

    private void a(JsonArray jsonArray, @NotNull Page page, @NotNull Page page2, HashSet<String> hashSet, HashSet<Long> hashSet2) {
        if (page.getParent() == null) {
            a.debug((Object)"Stop because the parent id is null");
            return;
        }
        if (hashSet.contains(page.getIdAsString())) {
            a.debug((Object)("This id has been processed and is found in the unique id list: " + page.getIdAsString() + " TITLE => " + page.getTitle()));
            return;
        }
        hashSet.add(page.getIdAsString());
        if (!page.getParent().getIdAsString().equalsIgnoreCase(page2.getIdAsString())) {
            a.debug((Object)("Checking parent for..." + page.getIdAsString() + " TITLE => " + page.getTitle()));
            Page page3 = page.getParent();
            this.a(jsonArray, page, page3, hashSet2);
            this.a(jsonArray, page3, page2, hashSet, hashSet2);
        } else {
            a.debug((Object)("Found the root parent page: " + page.getIdAsString() + " TITLE => " + page.getTitle()));
            this.a(jsonArray, page, page2, hashSet2);
        }
    }

    private void a(JsonArray jsonArray, @NotNull Page page, @NotNull Page page2, HashSet<Long> hashSet) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", page.getIdAsString());
        jsonObject.addProperty("text", page.getTitle());
        jsonObject.addProperty("parent", page2.getIdAsString());
        this.a(jsonObject, page.getIdAsString(), hashSet);
        jsonArray.add((JsonElement)jsonObject);
    }

    private void a(JsonObject jsonObject, String string, HashSet<Long> hashSet) {
        JsonObject jsonObject2 = new JsonObject();
        JsonObject jsonObject3 = new JsonObject();
        jsonObject2.addProperty("opened", "true");
        if (!hashSet.contains(Long.valueOf(string))) {
            jsonObject3.addProperty("class", "no_checkbox notSelected");
            jsonObject2.addProperty("checked", "true");
        } else {
            jsonObject2.addProperty("selected", "false");
            jsonObject2.addProperty("checked", "false");
        }
        jsonObject.add("a_attr", (JsonElement)jsonObject3);
        jsonObject.add("state", (JsonElement)jsonObject2);
    }

    private void a(JsonArray jsonArray, @NotNull Page page, HashSet<String> hashSet, HashSet<Long> hashSet2) {
        if (page.hasChildren()) {
            List list = page.getSortedChildren();
            list.forEach(page2 -> {
                a.debug((Object)("Checking grandchildren..." + page2.getIdAsString() + " TITLE => " + page2.getTitle()));
                if (hashSet.contains(page2.getIdAsString())) {
                    a.debug((Object)("This id" + page2.getIdAsString() + " has been processed and is found in the unique id list..." + page2.getIdAsString() + " TITLE => " + page2.getTitle()));
                } else {
                    this.a(jsonArray, (Page)page2, page, hashSet2);
                    hashSet.add(page2.getIdAsString());
                    this.a(jsonArray, (Page)page2, hashSet, hashSet2);
                }
            });
        } else {
            a.debug((Object)("No more children for ..." + page.getIdAsString() + " TITLE => " + page.getTitle()));
        }
    }

    @POST
    @Path(value="/search")
    @ReadOnlyAccessAllowed
    @AnonymousAllowed
    public Response a(@FormParam(value="query") String string, @FormParam(value="originalCql") String string2, @FormParam(value="num") String string3, @FormParam(value="searchType") String string4, @FormParam(value="hideFilePath") boolean bl, @FormParam(value="macroName") String string5, @FormParam(value="id") String string6, @FormParam(value="otherInfo") String string7) {
        a.debug((Object)("calling searchQuery with query = [" + string + "]"));
        a.debug((Object)("    originalCql = [" + string2 + "]"));
        a.debug((Object)("    num = [" + string3 + "]"));
        a.debug((Object)("    searchType = [" + string4 + "]"));
        a.debug((Object)("    hideFilePath = [" + bl + "]"));
        a.debug((Object)("    macroName = [" + string5 + "]"));
        a.debug((Object)("    id = [" + string6 + "]"));
        a.debug((Object)("    otherInfo = [" + string7 + "]"));
        JsonObject jsonObject = new JsonObject();
        if (string5.equalsIgnoreCase("enhancecql")) {
            this.a(jsonObject, bl, string5, string2, string7, null);
        } else {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Long l = null;
            if (CqlSearchRestResource.b(string6)) {
                l = Long.parseLong(string6);
                hashMap = this.a(l);
            }
            if (CqlSearchRestResource.a(string3) || string3.equalsIgnoreCase(m)) {
                String string8 = this.a(string, string2, hashMap, string4);
                this.a(jsonObject, bl, string5, string8, string7, l);
            } else {
                jsonObject.addProperty(n, "Error processing limit per page");
            }
        }
        return Response.ok((Object)jsonObject.toString()).build();
    }

    @NotNull
    private HashMap<String, String> a(Long l) {
        a.debug((Object)("calling populateReplaceableToken with postId = [" + l + "]"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ContentEntityObject contentEntityObject = this.F.a(l);
        BlogPost blogPost = null;
        Space space = null;
        if (contentEntityObject instanceof BlogPost) {
            blogPost = (BlogPost)contentEntityObject;
        } else if (contentEntityObject instanceof Page) {
            blogPost = ((Page)contentEntityObject).getLatestVersion();
            hashMap.put(g, ((Page)blogPost).getParent() == null ? "" : ((Page)blogPost).getParent().getIdAsString());
            a.debug((Object)("Parent ID = " + hashMap.get(g)));
        }
        if (blogPost != null) {
            space = blogPost.getSpace();
            hashMap.put(f, l.toString());
            hashMap.put(h, "\"" + blogPost.getDisplayTitle() + "\"");
            hashMap.put(i, "\"" + this.C.format(blogPost.getCreationDate().toInstant()) + "\"");
            hashMap.put(j, "\"" + this.C.format(blogPost.getLastModificationDate().toInstant()) + "\"");
        }
        if (space != null) {
            hashMap.put(k, space.getKey());
            hashMap.put(l, "\"" + space.getDisplayTitle() + "\"");
        }
        return hashMap;
    }

    private static boolean a(String string) {
        a.debug((Object)("calling isInteger with parameter = [" + string + "]"));
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean b(String string) {
        a.debug((Object)("calling isLong with parameter = [" + string + "]"));
        try {
            Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @NotNull
    private String a(String string, String string2, HashMap<String, String> hashMap, String string3) {
        String string4;
        a.debug((Object)"calling processQueryAndCql() with query and originalCql... ");
        if (string != null) {
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                String string5 = entry.getKey();
                String string6 = entry.getValue();
                while (string2.contains(string5)) {
                    string2 = string2.replace(string5, string6);
                }
            }
            if (string2.contains(e)) {
                string2 = string2.replace(e, d);
                string3 = p;
            }
            string = this.a(string3, string);
            string4 = string2.contains(b) || string2.contains(c) ? string2.replace(d, string) : string2.replace(d, "\"" + string + "\"");
        } else {
            string4 = string2.replace(d, "");
        }
        a.debug((Object)("returning cqlQuery = [" + string4 + "]"));
        return string4;
    }

    @NotNull
    private String a(@NotNull String string, @NotNull String string2) {
        a.debug((Object)("calling updateQueryBySearchType() with searchType = [" + string + "] and query = [" + string2 + "]"));
        if (string.equals(p)) {
            string2 = this.F.a(string2, false);
        } else if (string.equals(q)) {
            string2 = this.F.a(string2, true);
        }
        return string2.replace("'", "\\'").replace("\"", "\\\"");
    }

    private void a(JsonObject jsonObject, boolean bl, @NotNull String string, String string2, String string3, Long l) {
        block28: {
            a.debug((Object)("calling queryCqlSearchService() for [" + string + "] on page " + l + "... "));
            try {
                int n = 0;
                int n2 = 200;
                if (string.equals(A) && (string2.contains("ancestor =") || string2.contains("parent ="))) {
                    this.a(string2, bl, n, n2, jsonObject);
                    return;
                }
                a.debug((Object)("Executing CQL - [" + string2 + "]"));
                PageResponse pageResponse = this.D.searchContent(string2, (PageRequest)new SimplePageRequest(n, n2), new Expansion[]{Expansion.combine((Object[])new Object[0])});
                if (pageResponse.size() > 0) {
                    JsonArray jsonArray;
                    List<Content> list = this.a(string2, n, n2, (PageResponse<Content>)pageResponse);
                    switch (string) {
                        case "cqlsummary": {
                            jsonArray = this.a(jsonObject, string3, list);
                            break;
                        }
                        case "cqlsummaryreport": {
                            jsonArray = this.b(jsonObject, string3, list);
                            break;
                        }
                        case "cqlnavigation": {
                            this.a(jsonObject, l, list);
                            return;
                        }
                        case "cqlsearchtable": {
                            jsonArray = this.a(jsonObject, bl, list);
                            break;
                        }
                        case "cqlsearchcounter": 
                        case "cqlsearchcounterlink": {
                            jsonObject.addProperty("cql", string2);
                            jsonObject.addProperty("size", (Number)list.size());
                            return;
                        }
                        default: {
                            jsonArray = this.a(bl, list);
                        }
                    }
                    jsonObject.addProperty("size", (Number)jsonArray.size());
                    jsonObject.addProperty("results", jsonArray.toString());
                } else {
                    a.debug((Object)("No results found --- cql: [" + string2 + "]"));
                    jsonObject.addProperty("size", (Number)0);
                }
                jsonObject.addProperty("cql", string2);
            }
            catch (NotFoundException notFoundException) {
                a.error((Object)"No results found", (Throwable)notFoundException);
                jsonObject.addProperty(n, "No search results found -- " + (Object)((Object)notFoundException));
            }
            catch (BadRequestException badRequestException) {
                a.error((Object)("Syntax error in CQL:" + (Object)((Object)badRequestException)));
                jsonObject.addProperty(n, "Syntax error in CQL : " + string2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                a.error((Object)"Syntax error in CQL", (Throwable)unsupportedOperationException);
                jsonObject.addProperty(n, "Syntax error in CQL : " + unsupportedOperationException.getMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                a.error((Object)("Error executing CQL - " + string2), (Throwable)illegalArgumentException);
                String string4 = illegalArgumentException.toString();
                if (string4.equals("java.lang.IllegalArgumentException: query parameter is required.") || string4.equals("java.lang.IllegalArgumentException: Raw query is required.")) {
                    jsonObject.addProperty(n, "A search keyword is required");
                } else {
                    jsonObject.addProperty(n, "Unable to execute the CQL");
                    jsonObject.addProperty("size", (Number)0);
                    jsonObject.addProperty("cql", string2);
                }
            }
            catch (PermissionException permissionException) {
                a.error((Object)("User does not have permission - " + string2), (Throwable)permissionException);
                String string5 = permissionException.toString();
                if (!string5.equals("com.atlassian.confluence.api.service.exceptions.PermissionException: Not permitted to use confluence : null")) break block28;
                jsonObject.addProperty(n, "You are not permitted to use confluence");
            }
        }
    }

    private void a(String string, boolean bl, int n, int n2, JsonObject jsonObject) {
        int n3 = string.indexOf(" AND ");
        String string2 = string.substring(0, n3);
        int n4 = 0;
        boolean bl2 = true;
        if (string.contains("parent =")) {
            n4 = string.indexOf("parent = ") + 9;
        } else if (string.contains("ancestor =")) {
            n4 = string.indexOf("ancestor = ") + 11;
            bl2 = false;
        }
        int n5 = string.indexOf(" AND ", n4);
        String string3 = string.substring(n4, n5).trim();
        HashSet<Long> hashSet = this.a(bl2, string3);
        string = string2 + string.substring(n5);
        a.debug((Object)("Executing CQL - [" + string + "]"));
        PageResponse pageResponse = this.D.searchContent(string, (PageRequest)new SimplePageRequest(n, n2), new Expansion[]{Expansion.combine((Object[])new Object[0])});
        if (pageResponse.size() > 0) {
            List<Content> list = this.a(string, n, n2, (PageResponse<Content>)pageResponse);
            JsonArray jsonArray = this.a(bl, list, hashSet);
            jsonObject.addProperty("size", (Number)jsonArray.size());
            jsonObject.addProperty("results", jsonArray.toString());
        } else {
            a.debug((Object)("No results found --- cql: [" + string + "]"));
            jsonObject.addProperty("size", (Number)0);
        }
        jsonObject.addProperty("cql", string);
    }

    private HashSet<Long> a(boolean bl, String string) {
        HashSet hashSet = new HashSet();
        Page page = (Page)this.F.a(Long.parseLong(string));
        if (page != null) {
            List list = bl ? page.getChildren() : page.getDescendants();
            hashSet = (HashSet)list.stream().map(EntityObject::getId).collect(Collectors.toSet());
        }
        return hashSet;
    }

    @NotNull
    private JsonArray a(boolean bl, @NotNull List<Content> list, HashSet<Long> hashSet) {
        a.debug((Object)"calling buildResultsForSearchChildrenOrDescendant()... ");
        JsonArray jsonArray = new JsonArray();
        for (Content content : list) {
            ContentEntityObject contentEntityObject;
            if (content.getId() == null || (contentEntityObject = this.F.a(content.getId().asLong())) == null || !this.a(hashSet, contentEntityObject)) continue;
            jsonArray.add((JsonElement)this.a(contentEntityObject, bl));
        }
        return jsonArray;
    }

    private boolean a(HashSet<Long> hashSet, ContentEntityObject contentEntityObject) {
        boolean bl = false;
        if (contentEntityObject != null) {
            if (contentEntityObject instanceof Page) {
                if (hashSet.contains(contentEntityObject.getId())) {
                    bl = true;
                }
            } else if (contentEntityObject instanceof Comment) {
                Comment comment = (Comment)contentEntityObject;
                if (hashSet.contains(Objects.requireNonNull(comment.getContainer()).getId())) {
                    bl = true;
                }
            } else if (contentEntityObject instanceof Attachment) {
                Attachment attachment = (Attachment)contentEntityObject;
                if (hashSet.contains(Objects.requireNonNull(attachment.getContainer()).getId())) {
                    bl = true;
                }
            } else {
                a.debug((Object)"No space info as this macro only supports page/comment/attachment");
            }
        }
        return bl;
    }

    @NotNull
    private List<Content> a(String string, int n, int n2, @NotNull PageResponse<Content> pageResponse) {
        a.debug((Object)"calling combineSearchResults()... ");
        ArrayList<Content> arrayList = new ArrayList<Content>(pageResponse.getResults());
        int n3 = 200;
        while (pageResponse.hasMore()) {
            pageResponse = this.D.searchContent(string, (PageRequest)new SimplePageRequest(n += n3, n2 += n3), new Expansion[]{Expansion.combine((Object[])new Object[0])});
            arrayList.addAll(pageResponse.getResults());
        }
        a.debug((Object)("Results found (" + arrayList.size() + "), updating... "));
        return arrayList;
    }

    private void a(JsonObject jsonObject, long l, @NotNull List<Content> list) {
        a.debug((Object)"calling buildResultsForCqlNavigationMacro()... ");
        ContentEntityObject contentEntityObject = this.F.a(l);
        if (contentEntityObject instanceof Page || contentEntityObject instanceof BlogPost) {
            Content content = null;
            Content content2 = null;
            for (Content content3 : list) {
                if (content2 != null) {
                    this.a(content3, "next", jsonObject);
                    break;
                }
                if (content3.getId().asLong() == l) {
                    content2 = content3;
                    if (content != null) {
                        this.a(content, "previous", jsonObject);
                    }
                }
                content = content3;
            }
        } else {
            a.error((Object)"This is not supposed to happen since the cql type field only support page/blogpost for navigation macro");
        }
    }

    private void a(@NotNull Content content, String string, JsonObject jsonObject) {
        ContentEntityObject contentEntityObject = this.F.a(content.getId().asLong());
        String string2 = "";
        String string3 = "";
        if (contentEntityObject != null) {
            string2 = this.o + contentEntityObject.getUrlPath();
            string3 = contentEntityObject.getTitle();
        }
        if (string.equalsIgnoreCase("next")) {
            jsonObject.addProperty("next", string2);
            jsonObject.addProperty("nextTitle", string3);
        } else {
            jsonObject.addProperty("previous", string2);
            jsonObject.addProperty("previousTitle", string3);
        }
    }

    @NotNull
    private JsonArray a(boolean bl, @NotNull List<Content> list) {
        a.debug((Object)"calling buildResultsForCqlMacro()... ");
        JsonArray jsonArray = new JsonArray();
        for (Content content : list) {
            ContentEntityObject contentEntityObject;
            if (content.getId() == null || (contentEntityObject = this.F.a(content.getId().asLong())) == null) continue;
            jsonArray.add((JsonElement)this.a(contentEntityObject, bl));
        }
        return jsonArray;
    }

    @NotNull
    private JsonObject a(@NotNull ContentEntityObject contentEntityObject, boolean bl) {
        Comment comment;
        JsonObject jsonObject = new JsonObject();
        String string = "";
        String string2 = "";
        String string3 = contentEntityObject.getTitle();
        Space space = null;
        if (Boolean.TRUE.equals(bl)) {
            jsonObject.addProperty("excerpt", this.a(contentEntityObject));
        } else {
            jsonObject.addProperty("excerpt", contentEntityObject.getExcerpt());
        }
        if (contentEntityObject instanceof BlogPost) {
            space = ((BlogPost)contentEntityObject).getSpace();
        } else if (contentEntityObject instanceof Page) {
            space = ((Page)contentEntityObject).getSpace();
        } else if (contentEntityObject instanceof Comment) {
            space = ((Comment)contentEntityObject).getSpace();
            comment = (Comment)contentEntityObject;
            string3 = comment.getDisplayTitle();
        } else if (contentEntityObject instanceof Attachment) {
            space = ((Attachment)contentEntityObject).getSpace();
            comment = (Attachment)contentEntityObject;
            jsonObject.addProperty("dLink", this.o + comment.getDownloadPath());
            jsonObject.addProperty("ext", comment.getFileExtension());
            ContentEntityObject contentEntityObject2 = comment.getContainer();
            if (contentEntityObject2 != null) {
                jsonObject.addProperty("ptitle", contentEntityObject2.getTitle());
                jsonObject.addProperty("purl", this.o + contentEntityObject2.getUrlPath());
            }
        } else {
            a.debug((Object)"No space info as this macro only supports page/blogpost/comment/attachment");
        }
        if (space != null) {
            string = space.getName();
            string2 = space.getKey();
        }
        jsonObject.addProperty("version", (Number)contentEntityObject.getLatestVersion().getVersion());
        if (!contentEntityObject.getLabels().isEmpty()) {
            jsonObject.addProperty("labels", contentEntityObject.getLabels().toString());
        }
        if ((comment = contentEntityObject.getCreator()) != null) {
            jsonObject.addProperty("creatorName", contentEntityObject.getCreator().getName());
            jsonObject.addProperty("creatorFullName", contentEntityObject.getCreator().getFullName());
        } else {
            a.debug((Object)"Anonymous Users ");
            jsonObject.addProperty("creatorName", "Anonymous");
            jsonObject.addProperty("creatorFullName", "Anonymous");
        }
        jsonObject.addProperty("comments", (Number)contentEntityObject.getComments().size());
        jsonObject.addProperty("title", string3);
        jsonObject.addProperty("space", string);
        jsonObject.addProperty("key", string2);
        jsonObject.addProperty("type", contentEntityObject.getType());
        jsonObject.addProperty("createdDate", contentEntityObject.getCreationDate() == null ? "" : this.B.format(contentEntityObject.getCreationDate().toInstant()));
        jsonObject.addProperty("date", contentEntityObject.getLastModificationDate() == null ? "" : this.B.format(contentEntityObject.getLastModificationDate().toInstant()));
        jsonObject.addProperty("url", this.o + contentEntityObject.getUrlPath());
        return jsonObject;
    }

    private String a(@NotNull ContentEntityObject contentEntityObject) {
        String string = contentEntityObject.getBodyAsString();
        int n = string.indexOf("<ac:image");
        int n2 = string.indexOf("</ac:image>", n);
        String string2 = contentEntityObject.getExcerpt();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n != -1) {
            int n3;
            int n4 = string.indexOf("filename=", n) + 10;
            if (n4 > n2) {
                a.debug((Object)("Filename not found. " + n4 + " not in range " + n + " to " + n2));
                n = string.indexOf("<ac:image", n2 + 11);
                n2 = string.indexOf("</ac:image>", n);
                continue;
            }
            int n5 = string.indexOf("</ac:image>", n4);
            if ((string2 = this.a(string, string2, arrayList, n4, n5, n3 = string.indexOf("<ri:page", n4))) == null) break;
            int n6 = n5 + 11;
            n = string.indexOf("<ac:image", n6);
            n2 = string.indexOf("</ac:image>", n);
        }
        return string2;
    }

    @Nullable
    private String a(String string, String string2, List<String> list, int n, int n2, int n3) {
        int n4 = n2 - 4;
        if (n2 > n3 && n3 > n) {
            n4 = n3 - 2;
        }
        String string3 = string.substring(n, n4);
        int n5 = string2.indexOf(string3);
        if (!list.contains(string3)) {
            list.add(string3);
            if (n5 != -1) {
                string2 = string2.replace(string3, "");
            } else {
                return null;
            }
        }
        return string2;
    }

    @NotNull
    private JsonArray a(JsonObject jsonObject, boolean bl, @NotNull List<Content> list) {
        JsonObject jsonObject2;
        a.debug((Object)"calling buildResultsForCqlTableMacro()... ");
        JsonArray jsonArray = new JsonArray();
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        for (Content object : list) {
            ContentEntityObject contentEntityObject;
            if (object.getId() == null || (contentEntityObject = this.F.a(object.getId().asLong())) == null) continue;
            jsonObject2 = this.a(contentEntityObject, bl);
            this.a(contentEntityObject, jsonObject2);
            this.a(contentEntityObject.getCreator(), jsonObject2, r, hashMap);
            this.a(contentEntityObject.getLastModifier(), jsonObject2, s, hashMap);
            jsonArray.add((JsonElement)jsonObject2);
        }
        JsonObject jsonObject3 = new JsonObject();
        for (Map.Entry entry : hashMap.entrySet()) {
            jsonObject2 = new JsonObject();
            jsonObject2.addProperty("userName", ((String[])entry.getValue())[0]);
            jsonObject2.addProperty("userFullName", ((String[])entry.getValue())[1]);
            jsonObject3.add((String)entry.getKey(), (JsonElement)jsonObject2);
        }
        jsonObject.addProperty("userInfoMap", String.valueOf(jsonObject3));
        return jsonArray;
    }

    private void a(@NotNull ContentEntityObject contentEntityObject, JsonObject jsonObject) {
        a.debug((Object)("Calling getPageProperties() for id = [" + contentEntityObject.getId() + "]"));
        if (contentEntityObject instanceof Page) {
            PageContext pageContext = contentEntityObject.toPageContext();
            DefaultConversionContext defaultConversionContext = new DefaultConversionContext((RenderContext)pageContext);
            PagePropertiesMacroReport pagePropertiesMacroReport = this.G.getReportFromContent(contentEntityObject);
            List list = pagePropertiesMacroReport.getAllMacroInstances();
            for (PagePropertiesMacroInstance pagePropertiesMacroInstance : list) {
                Map map = pagePropertiesMacroInstance.getPagePropertyReportRow();
                for (Map.Entry entry : map.entrySet()) {
                    String string = ((PageProperty)entry.getValue()).getHeadingStorageFormat();
                    String string2 = ((PageProperty)entry.getValue()).getDetailStorageFormat();
                    a.debug((Object)("Key = [" + string + "] and value = [" + string2 + "]"));
                    String string3 = "";
                    try {
                        string3 = this.H.convertStorageToView(string2, (ConversionContext)defaultConversionContext);
                    }
                    catch (XhtmlException | XMLStreamException throwable) {
                        a.error((Object)("Cannot render xhtml content for page properties macro:" + string2), throwable);
                    }
                    jsonObject.addProperty("pp:" + (String)entry.getKey(), string3);
                }
            }
        }
    }

    private void a(ConfluenceUser confluenceUser, JsonObject jsonObject, String string2, HashMap<String, String[]> hashMap) {
        a.debug((Object)"calling updateResultWithUserInfoForTableMacro()... ");
        if (confluenceUser == null) {
            jsonObject.addProperty(string2, "");
        } else if (this.E.exists(confluenceUser.getName())) {
            String string3 = confluenceUser.getKey().toString();
            String[] stringArray = hashMap.computeIfAbsent(string3, string -> new String[2]);
            stringArray[0] = confluenceUser.getName();
            stringArray[1] = confluenceUser.getFullName();
            jsonObject.addProperty(string2, string3);
        }
    }

    @NotNull
    private JsonArray a(JsonObject jsonObject, @NotNull String string, List<Content> list) {
        a.debug((Object)"calling buildResultForContributorSummaryMacro()... ");
        JsonArray jsonArray = new JsonArray();
        String[] stringArray = string.split("((?i)and)");
        String string2 = this.a(stringArray);
        if (!string2.isEmpty()) {
            a.debug((Object)string2);
            jsonObject.addProperty(n, "Error : " + string2);
            return jsonArray;
        }
        boolean bl = true;
        String string3 = stringArray[0];
        String string4 = stringArray[0];
        if (stringArray.length != 1) {
            string3 = stringArray[0];
            string4 = stringArray[1];
            bl = false;
        }
        String string5 = this.c(string3);
        String string6 = this.c(string4);
        String string7 = this.d(string5);
        string5 = string5.trim().replace(string7, "");
        String string8 = this.d(string6);
        string6 = string6.trim().replace(string8, "");
        DateTime dateTime = this.e(string5);
        DateTime dateTime2 = this.e(string6);
        if (dateTime == null || dateTime2 == null || string7.isEmpty() || string8.isEmpty()) {
            string2 = "Invalid syntax for custom duration";
            a.debug((Object)string2);
            jsonObject.addProperty(n, "Error : " + string2);
            return jsonArray;
        }
        if (dateTime.compareTo((ReadableInstant)dateTime2) >= 0) {
            DateTime dateTime3 = dateTime;
            dateTime = dateTime2;
            dateTime2 = dateTime3;
            String string9 = string7;
            string7 = string8;
            string8 = string9;
        }
        jsonArray = this.a(list, bl, string7, string8, dateTime, dateTime2);
        return jsonArray;
    }

    @NotNull
    private JsonArray b(JsonObject jsonObject, @NotNull String string, List<Content> list) {
        a.debug((Object)"calling buildResultForTwoDimensionalContributorSummaryMacro()... ");
        JsonArray jsonArray = this.a(jsonObject, string, list);
        JsonArray jsonArray2 = new JsonArray();
        JsonObject jsonObject2 = new JsonObject();
        JsonObject jsonObject3 = new JsonObject();
        JsonObject jsonObject4 = new JsonObject();
        for (JsonElement jsonElement : jsonArray) {
            JsonObject jsonObject5;
            JsonObject jsonObject6 = jsonElement.getAsJsonObject();
            String string2 = jsonObject6.get("contributor").getAsString();
            String string3 = jsonObject6.get("contributorKey").getAsString();
            if (jsonObject2.get(string2) == null) {
                jsonObject2.addProperty(string3, string2);
            }
            String string4 = jsonObject6.get("space").getAsString();
            String string5 = jsonObject6.get("key").getAsString();
            if (jsonObject3.get(string4) == null) {
                jsonObject3.addProperty(string5, string4);
            }
            if ((jsonObject5 = jsonObject4.getAsJsonObject(string3)) == null) {
                jsonObject5 = new JsonObject();
            }
            JsonObject jsonObject7 = jsonObject5.get(string5) == null ? new JsonObject() : jsonObject5.get(string5).getAsJsonObject();
            jsonObject7.add(jsonObject6.get("id").getAsString(), jsonElement);
            jsonObject5.add(string5, (JsonElement)jsonObject7);
            jsonObject4.add(string3, (JsonElement)jsonObject5);
        }
        jsonArray2.add((JsonElement)jsonObject2);
        jsonArray2.add((JsonElement)jsonObject3);
        jsonArray2.add((JsonElement)jsonObject4);
        return jsonArray2;
    }

    @NotNull
    private JsonArray a(@NotNull List<Content> list, boolean bl, String string, String string2, DateTime dateTime, DateTime dateTime2) {
        a.debug((Object)"calling processContentsForSummaryMacro()... ");
        JsonArray jsonArray = new JsonArray();
        for (Content content : list) {
            ContentEntityObject contentEntityObject = this.F.a(content.getId().asLong());
            if (contentEntityObject instanceof BlogPost || contentEntityObject instanceof Page) {
                if (string.contains("<") && string2.contains("<") || bl) {
                    dateTime = new DateTime((Object)contentEntityObject.getCreationDate());
                }
                a.debug((Object)("From: lastmodified " + string + " " + dateTime));
                a.debug((Object)("To: lastmodified " + string2 + " " + dateTime2));
                HashMap<String, Integer> hashMap = this.a(contentEntityObject, dateTime, string, dateTime2, string2);
                this.a(contentEntityObject, hashMap, jsonArray);
                continue;
            }
            a.debug((Object)"Skipping content since it is null or not Page/Blog Post/Attachment/Comment");
        }
        return jsonArray;
    }

    @NotNull
    private String a(@NotNull String[] stringArray) {
        String string;
        String string2;
        a.debug((Object)("validating Duration with " + String.join((CharSequence)",", stringArray)));
        if (stringArray.length == 1) {
            a.debug((Object)("    durations[0] = [" + stringArray[0] + "]"));
            string2 = "lastmodified >= 1900-01-01";
            string = stringArray[0];
        } else if (stringArray.length == 2) {
            a.debug((Object)("    durations[0] = [" + stringArray[0] + "]"));
            a.debug((Object)("    durations[1] = [" + stringArray[1] + "]"));
            string2 = stringArray[0];
            string = stringArray[1];
        } else {
            return "Only 2 durations are allowed. Eg lastmodified > startOfWeek() and lastmodified < endOfWeek().";
        }
        if (!string2.toLowerCase().contains("lastmodified") || !string.toLowerCase().contains("lastmodified")) {
            return "Must contain the keyword lastmodified";
        }
        return "";
    }

    @NotNull
    private String c(@NotNull String string) {
        a.debug((Object)("calling removeLastmodifiedFromQueryForSummaryMacro() with queryClause = [" + string + "]"));
        int n = string.toLowerCase().indexOf("lastmodified");
        String string2 = string.substring(n);
        String[] stringArray = string2.split("((?i)and|or)");
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        return string2.substring("lastmodified".length());
    }

    private String d(String string) {
        String[] stringArray;
        a.debug((Object)("calling getOperatorFromQueryForSummaryMacro() with text = [" + string + "]"));
        for (String string2 : stringArray = new String[]{"<=", ">=", "!=", "<", ">", "="}) {
            if (!string.contains(string2)) continue;
            return string2;
        }
        return "";
    }

    private DateTime e(String string) {
        DateTimeFormatter dateTimeFormatter;
        a.debug((Object)("calling getDateFromQueryForSummaryMacro() with query = [" + string + "]"));
        for (String string2 : dateTimeFormatter = new DateTimeFormatter[]{"endOfDay", "endOfMonth", "endOfWeek", "endOfYear", "startOfDay", "startOfMonth", "startOfWeek", "startOfYear"}) {
            if (!string.contains(string2)) continue;
            String string3 = this.c(string, string2);
            return this.b(string3, string2);
        }
        DateTimeFormatter dateTimeFormatter2 = (string = string.trim().replaceAll("\"", "")).contains(":") ? (string.contains("/") ? DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm") : DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm")) : (string.contains("/") ? DateTimeFormat.forPattern((String)"yyyy/MM/dd") : DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
        return dateTimeFormatter2.parseDateTime(string);
    }

    private boolean a(@NotNull String string, DateTime dateTime, DateTime dateTime2) {
        a.debug((Object)"calling verifyPeriod()... ");
        switch (string) {
            case "<=": {
                return dateTime2.compareTo((ReadableInstant)dateTime) <= 0;
            }
            case "<": {
                return dateTime2.compareTo((ReadableInstant)dateTime) < 0;
            }
            case ">=": {
                return dateTime2.compareTo((ReadableInstant)dateTime) >= 0;
            }
            case ">": {
                return dateTime2.compareTo((ReadableInstant)dateTime) > 0;
            }
            case "!=": {
                return dateTime2.compareTo((ReadableInstant)dateTime) != 0;
            }
            case "=": {
                return dateTime2.compareTo((ReadableInstant)dateTime) == 0;
            }
        }
        return false;
    }

    private DateTime b(String string, @NotNull String string2) {
        DateTime dateTime;
        a.debug((Object)("calling resolveDateFunction() with dateFunction = [" + string2 + "]"));
        DateTime dateTime2 = new DateTime().withTimeAtStartOfDay();
        DateTime dateTime3 = new DateTime().withTimeAtStartOfDay().plusDays(1).minusMillis(1);
        switch (string2) {
            case "endOfDay": {
                dateTime = dateTime3;
                break;
            }
            case "endOfMonth": {
                dateTime = dateTime3.dayOfMonth().withMaximumValue();
                break;
            }
            case "endOfWeek": {
                dateTime = dateTime3.dayOfWeek().withMaximumValue();
                break;
            }
            case "endOfYear": {
                dateTime = dateTime3.dayOfYear().withMaximumValue();
                break;
            }
            case "startOfDay": {
                dateTime = dateTime2;
                break;
            }
            case "startOfMonth": {
                dateTime = dateTime2.dayOfMonth().withMinimumValue();
                break;
            }
            case "startOfWeek": {
                dateTime = dateTime2.dayOfWeek().withMinimumValue();
                break;
            }
            case "startOfYear": {
                dateTime = dateTime2.dayOfYear().withMinimumValue();
                break;
            }
            default: {
                dateTime = null;
            }
        }
        if (string.isEmpty()) {
            return dateTime;
        }
        char c = string.charAt(0);
        String string3 = string.substring(0, string.length() - 1);
        char c2 = string.charAt(string.length() - 1);
        if (c == '-') {
            string3 = string3.substring(1);
            return this.a(dateTime, c2, Integer.parseInt(string3));
        }
        if (c == '+') {
            string3 = string3.substring(1);
            return this.b(dateTime, c2, Integer.parseInt(string3));
        }
        return this.b(dateTime, c2, Integer.parseInt(string3));
    }

    private DateTime a(DateTime dateTime, char c, int n) {
        a.debug((Object)"calling computeMinusPeriod()... ");
        DateTime dateTime2 = c == 'y' ? dateTime.minusYears(n) : (c == 'M' ? dateTime.minusMonths(n) : (c == 'w' ? dateTime.minusWeeks(n) : (c == 'd' ? dateTime.minusDays(n) : (c == 'h' ? dateTime.minusHours(n) : (c == 'm' ? dateTime.minusMinutes(n) : dateTime)))));
        return dateTime2;
    }

    private DateTime b(DateTime dateTime, char c, int n) {
        a.debug((Object)"calling computePlusPeriod()... ");
        DateTime dateTime2 = c == 'y' ? dateTime.plusYears(n) : (c == 'M' ? dateTime.plusMonths(n) : (c == 'w' ? dateTime.plusWeeks(n) : (c == 'd' ? dateTime.plusDays(n) : (c == 'h' ? dateTime.plusHours(n) : (c == 'm' ? dateTime.plusMinutes(n) : dateTime)))));
        return dateTime2;
    }

    @NotNull
    private String c(@NotNull String string, String string2) {
        a.debug((Object)"calling extractValueFromDateFunction()... ");
        a.debug((Object)("lastModified = [" + string + "]"));
        a.debug((Object)("dateFunction = [" + string2 + "]"));
        String string3 = string.replace(string2, "").replaceAll("[()\"]", "").trim();
        a.debug((Object)(" returning [" + string3 + "]"));
        return string3;
    }

    @NotNull
    private HashMap<String, Integer> a(@NotNull ContentEntityObject contentEntityObject, @NotNull DateTime dateTime, String string2, DateTime dateTime2, String string3) {
        VersionHistorySummary versionHistorySummary;
        DateTime dateTime3;
        a.debug((Object)"calling getVersionCountByUsers()... ");
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Iterator<VersionHistorySummary> iterator = this.F.a(contentEntityObject).iterator();
        while (iterator.hasNext() && this.a(string2, dateTime, dateTime3 = new DateTime((Object)(versionHistorySummary = iterator.next()).getLastModificationDate())) && this.a(string3, dateTime2, dateTime3)) {
            for (ConfluenceUser confluenceUser : versionHistorySummary.getContributorSet()) {
                Integer n;
                String string4 = null;
                if (confluenceUser != null) {
                    string4 = confluenceUser.getKey().toString();
                }
                Integer n2 = n = hashMap.computeIfAbsent(string4, string -> 0);
                Integer n3 = n = Integer.valueOf(n + 1);
                hashMap.put(string4, n);
            }
        }
        return hashMap;
    }

    private void a(ContentEntityObject contentEntityObject, @NotNull Map<String, Integer> map, JsonArray jsonArray) {
        a.debug((Object)"calling updateVersionCount()... ");
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            UserKey userKey = null;
            if (entry.getKey() != null) {
                userKey = new UserKey(entry.getKey());
            }
            JsonObject jsonObject = this.a(contentEntityObject, this.E.getExistingUserByKey(userKey), (int)entry.getValue());
            jsonArray.add((JsonElement)jsonObject);
        }
    }

    @NotNull
    private JsonObject a(ContentEntityObject contentEntityObject, ConfluenceUser confluenceUser, int n) {
        a.debug((Object)"calling addSummaryInfo()... ");
        JsonObject jsonObject = new JsonObject();
        Space space = null;
        if (contentEntityObject instanceof BlogPost) {
            space = ((BlogPost)contentEntityObject).getSpace();
        } else if (contentEntityObject instanceof Page) {
            space = ((Page)contentEntityObject).getSpace();
        } else {
            a.debug((Object)"No space info as this macro only supports page/blogpost");
        }
        if (space != null) {
            jsonObject.addProperty("space", space.getName());
            jsonObject.addProperty("key", space.getKey());
        } else {
            a.debug((Object)"This is not a Confluence page or blog post");
            jsonObject.addProperty("space", "");
            jsonObject.addProperty("key", "");
        }
        jsonObject.addProperty("id", contentEntityObject.getIdAsString());
        jsonObject.addProperty("contributor", confluenceUser == null ? "Anonymous" : confluenceUser.getFullName());
        jsonObject.addProperty("contributorKey", confluenceUser == null ? "-1" : confluenceUser.getKey().toString());
        jsonObject.addProperty("type", contentEntityObject.getType());
        jsonObject.addProperty("title", contentEntityObject.getTitle());
        jsonObject.addProperty("url", this.o + contentEntityObject.getUrlPath());
        jsonObject.addProperty("versionCount", (Number)n);
        return jsonObject;
    }
}

