/*
 * Decompiled with CFR 0.152.
 */
package com.akeles.plugins.confluence.macro;

import com.akeles.plugins.confluence.helper.CqlCommonHelper;
import com.akeles.plugins.confluence.rest.CqlQuickSearchManager;
import com.akeles.plugins.confluence.rest.CqlQuickSearchSpaceEntity;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.ia.service.SidebarLinkService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.lang.reflect.Method;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Named(value="CqlQuickSearch")
public class CqlQuickSearch
implements Macro {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.cql.CqlQuickSearch");
    private static final String b = "license";
    private static final String c = "templates/cql-tab-utilities.vm";
    private static final String d = "macroName";
    private static final String e = "cql";
    private static final String f = "showSearchOptions";
    private static final String g = "searchType";
    private static final String h = "searchBy";
    private static final String i = "filterBy";
    private static final String[] j = new String[]{"searchBy", "filterBy", "showSearchOptions"};
    private final SidebarLinkService k;
    private final CqlCommonHelper l;
    private final PageManager m;
    private final CqlQuickSearchManager n;

    @Inject
    public CqlQuickSearch(@ComponentImport SidebarLinkService sidebarLinkService, @ComponentImport PageManager pageManager, CqlCommonHelper cqlCommonHelper, CqlQuickSearchManager cqlQuickSearchManager) {
        a.debug((Object)"CQL quick search initialised...");
        this.n = cqlQuickSearchManager;
        this.k = sidebarLinkService;
        this.m = pageManager;
        this.l = cqlCommonHelper;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private void a(@NotNull Map<String, String> map, @NotNull Map<String, Object> map2) {
        a.debug((Object)"calling populateContextForQuickSearchMacro()... ");
        map2.put(d, "cqltab");
        map2.put(f, true);
        map2.put(g, "ExactMatch");
        map2.put(h, "title");
        map2.put(i, "page, blogpost ");
        map.put(e, "space.key = $$space.key$$ AND title ~ $$query$$");
        for (String string : j) {
            String string2 = map.get(string);
            if (string2 == null) continue;
            map2.put(string, string2);
        }
    }

    public String execute(Map<String, String> map, String string, ConversionContext conversionContext) throws MacroExecutionException {
        a.debug((Object)"calling execute() with parameters... ");
        this.l.a(map);
        Map map2 = MacroUtils.defaultVelocityContext();
        if (this.l.a()) {
            map2.put(b, true);
            this.a(map, map2);
            this.l.a(map, map2, conversionContext);
            this.a(conversionContext.getEntity());
            map2.put("pageToDisplay", "Search in Space");
        } else {
            map2.put(b, false);
        }
        return this.l.a(c, map2);
    }

    private void a(ContentEntityObject contentEntityObject) {
        a.debug((Object)"calling createSpaceSideBarLinkIfNotFound()... ");
        if (contentEntityObject instanceof Page) {
            Page page = (Page)contentEntityObject;
            CqlQuickSearchSpaceEntity cqlQuickSearchSpaceEntity = this.n.a(page.getSpaceKey());
            try {
                this.a(page, cqlQuickSearchSpaceEntity);
            }
            catch (NotPermittedException notPermittedException) {
                a.error((Object)"No permission to create quick link in the space sidebar", (Throwable)notPermittedException);
            }
        }
    }

    private void a(Page page, CqlQuickSearchSpaceEntity cqlQuickSearchSpaceEntity) throws NotPermittedException {
        a.debug((Object)"calling createQuickLink()... ");
        if (cqlQuickSearchSpaceEntity == null) {
            a.debug((Object)"No existing sidebar link");
            this.a(page);
        } else {
            Page page2 = this.m.getPage(cqlQuickSearchSpaceEntity.getPageId().longValue());
            if (page2 == null) {
                a.debug((Object)("Unable to find previous quickLinkPage with id: " + cqlQuickSearchSpaceEntity.getPageId()));
                this.a(page);
            } else if (this.m.getPage(page.getSpaceKey(), page2.getTitle()) == null) {
                a.debug((Object)("The page [" + page2.getTitle() + "] cannot be found in the current space"));
                this.a(page);
            } else if (!this.k.hasQuickLink(page.getSpaceKey(), Long.valueOf(page2.getId()))) {
                a.debug((Object)"The sidebar link has been removed. Adding it back");
                this.a(page);
            }
        }
    }

    private void a(@NotNull Page page) throws NotPermittedException {
        a.debug((Object)"calling addSidebarLink()... ");
        if (!this.k.hasQuickLink(page.getSpaceKey(), Long.valueOf(page.getId()))) {
            try {
                Method method = this.k.getClass().getDeclaredMethod("create", String.class, Long.class, String.class, String.class);
                method.invoke((Object)this.k, page.getSpaceKey(), page.getId(), null, null);
                CqlQuickSearchSpaceEntity cqlQuickSearchSpaceEntity = new CqlQuickSearchSpaceEntity(page.getSpaceKey(), page.getId());
                this.n.a(cqlQuickSearchSpaceEntity);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                a.error((Object)"No such method!");
            }
            catch (Exception exception) {
                a.error((Object)"Error invoking method!");
            }
        }
    }
}

