window.onload = function() {
    //reset form
    document.getElementById("DateTimeForm").reset();

    //toggler event logic added
    var toggle = document.getElementById('toggle-listener');
    toggle.addEventListener('click', function(e) {
        var isChecked = toggle.checked;
        toggle.busy = true;
        var linkEnable = document.getElementById("link-confluence-listener-rest").getAttribute("link-confluence-listener-rest-enable");
        var linkDisable = document.getElementById("link-confluence-listener-rest").getAttribute("link-confluence-listener-rest-disable");
        if(isChecked) {
            if (!window.confirm(document.getElementById("i18n").getAttribute("badges-events-logging-really-enable"))) {
                toggle.checked = !isChecked;
                toggle.busy = false;
                return;
            }
            $.get(linkEnable)
                .done(function () {
                    AJS.messages.success({
                        body: document.getElementById("i18n").getAttribute("badges-events-logging-has-been-enabled")
                    });
                })
                .fail(function () {
                    toggle.checked = !isChecked;
                    AJS.messages.success({
                        body: "Could not enable event logging."
                    });
                })
                .always(function () {
                    toggle.busy = false;
                });
        } else {
            if (!window.confirm(document.getElementById("i18n").getAttribute("badges-events-logging-really-disable"))) {
                toggle.checked = !isChecked;
                toggle.busy = false;
                return;
            }
            $.get(linkDisable)
                .done(function () {
                    AJS.messages.success({
                        body: document.getElementById("i18n").getAttribute("badges-events-logging-has-been-disabled")
                    });
                })
                .fail(function () {
                    toggle.checked = !isChecked;
                    AJS.messages.success({
                        body: "Could not disable event logging."
                    });
                })
                .always(function () {
                    toggle.busy = false;
                });
        }
    });
}

function deleteAll() {
        if (window.confirm(document.getElementById("i18n").getAttribute("badges-events-logging-really-delete-data"))) {
        AJS.$.ajax({
            url: document.getElementById("link-confluence-listener-rest").getAttribute("link-confluence-listener-rest-delete-all"),
            type: "GET",
            dataType: "json",
            contentType: "application/json",
            success: function(result){
                AJS.messages.success({
                            body: document.getElementById("i18n").getAttribute("badges-events-logging-has-been-deleted")
                        });
                $("#event-table tbody tr").remove();
            }
        });
    }
}

AJS.$(document).ready(function() {
    AJS.$('#date-from').datePicker({'overrideBrowserDefault': true});
    AJS.$('#date-to').datePicker({'overrideBrowserDefault': true});
});

function applyDates() {
    var from = $("#date-from").datePicker("getDate");
    var to = $("#date-to").datePicker("getDate");

    AJS.$.ajax({
        url: document.getElementById("link-confluence-listener-rest").getAttribute("link-confluence-listener-rest-events-table-by-time"),
        type: "GET",
        dataType: "json",
        data: {
            "from": from.getDate().getTime(),
            "to": to.getDate().getTime()
        },
        contentType: "application/json",
        success: function(result){
            $("#event-table tbody tr").remove();

            $(function() {
                $.each(result, function(i, eventRow) {
                    var $tr = $('<tr>').append(
                        $('<td>').text(eventRow.className),
                        $('<td>').text(eventRow.count)
                    ).appendTo('#event-table');
                });
            });
        }
    });
}


function sendForm(form, e) {
    e.preventDefault();

    $("#event-table tbody tr").remove();
    var spinner = document.getElementById("loading-spinner");
    spinner.style.display = "flex";

    var formData = new FormData(form);
    var from = 0;
    var to = 0;
    var dateFrom = parseInt($("#date-from").datePicker("getDate").getDate().getTime()); //in ms
    var hourFrom = parseInt(formData.get('hour-from')); //as string
    var minFrom = parseInt(formData.get('min-from')); //as string
    var dateTo = parseInt($("#date-to").datePicker("getDate").getDate().getTime()); //in ms
    var hourTo = parseInt(formData.get('hour-to')); //as string
    var minTo = parseInt(formData.get('min-to')); //as string
    var limit = formData.get('entries'); //as string

    //eliminate empty values
    if(!dateFrom) {
        dateFrom = 0;
    }
    if(!hourFrom) {
        hourFrom = 0;
    }
    if(!minFrom) {
        minFrom = 0;
    }
    if(!dateTo) {
        dateTo = 0;
    }
    if(!hourTo) {
        hourTo = 0;
    }
    if(!minTo) {
        minTo = 0;
    }
    //eliminate All
    if(limit == "All" || limit == "Alle") {
        limit = -1;
    }

    //add hour and min to the dates
    from = dateFrom + (60000 * (minFrom + (60 * hourFrom)));
    var one = 60 * hourFrom;
    var two = minFrom + (60 * hourFrom);
    var three = 60000 * (minFrom + (60 * hourFrom));

    to = dateTo + (60000 * (minTo + (60 * hourTo)));

    AJS.$.ajax({
        url: document.getElementById("link-confluence-listener-rest").getAttribute("link-confluence-listener-rest-events-table-by-time"),
        type: "GET",
        dataType: "json",
        data: {
            "from": from,
            "to": to,
            "limit": limit
        },
        contentType: "application/json",
        success: function(result){
            spinner.style.display = "none";

            $(function() {
                $.each(result, function(i, eventRow) {
                    var $tr = $('<tr>').append(
                        $('<td>').text(eventRow.className),
                        $('<td>').text(eventRow.count)
                    ).appendTo('#event-table');
                });
            });
        },
        error: function (result) {
            spinner.style.display = "none";
        }
    });
}

$(document).ready(function()
{
    $('#DateTimeForm').submit(function (e)
    {
        sendForm(this, event);
    });
});
