function loadDefaultBadge() {
    document.getElementById("cancel").click();
    AJS.$("#dropdown-button").hide();
    AJS.$("#new-badge").hide();
    AJS.$("#badge-id").hide();
    AJS.$("#reset-badge").hide();
    AJS.$("#cancel").hide();
    AJS.$("#save").hide();
    AJS.$("#no-badge-selected").hide()
    AJS.$("#delete-badge").hide()
    AJS.$("#give-badge").hide();

    AJS.$("#badge-id-editable").show();
    AJS.$("#badge-id-editable").removeAttr("disabled");
    AJS.$("#cancel-new-badge").show();
    AJS.$("#save-new-badge").show();

    var id = "default";
    AJS.$.ajax({
        url: document.getElementById("context-path").value + "/rest/badge/1.0/badges/" + id,
        type: "GET",
        dataType: "json",
        contentType: "application/json",
        success: function(result){
            AJS.$("#no-badge-selected").hide()
            document.getElementById("BadgeForm").setAttribute("badge-id", result.id);
            document.getElementById("badgesLegend").innerHTML = "Badge - " + result.name;

            if(result.enabled) {
                document.getElementById("radioButtonTrue").setAttribute("checked", "");
                document.getElementById("radioButtonFalse").removeAttribute("checked");
            } else {
                document.getElementById("radioButtonTrue").removeAttribute("checked");
                document.getElementById("radioButtonFalse").setAttribute("checked", "");
            }

            document.getElementById("badge-id-editable").setAttribute("value", result.id);
            document.getElementById("name").setAttribute("value", result.name);
            document.getElementById("description").innerHTML = result.description;
            document.getElementById("thresholdBronze").setAttribute("value", result.thresholdBronze);
            document.getElementById("thresholdSilver").setAttribute("value", result.thresholdSilver);
            document.getElementById("thresholdGold").setAttribute("value", result.thresholdGold);
            document.getElementById("currentBronzeImage").setAttribute("src", result.bronzeImage);
            document.getElementById("currentSilverImage").setAttribute("src", result.silverImage);
            document.getElementById("currentGoldImage").setAttribute("src", result.goldImage);
            document.getElementById("currentNeutralImage").setAttribute("src", result.neutralImage);

        }
    });

    AJS.$("#BadgeForm").show();
}

function cancelNewBadge() {
    AJS.$("#dropdown-button").show();
    AJS.$("#new-badge").show();
    AJS.$("#badge-id").show();
    AJS.$("#reset-badge").show();
    AJS.$("#cancel").show();
    AJS.$("#save").show();
    AJS.$("#no-badge-selected").show();
    AJS.$("#delete-badge").show();
    AJS.$("#give-badge").show();

    AJS.$("#BadgeForm").hide();
    AJS.$("#badge-id-editable").hide();
    AJS.$("#badge-id-editable").attr("disabled", true);
    AJS.$("#cancel-new-badge").hide();
    AJS.$("#save-new-badge").hide();
    document.getElementById("dropdown-button").innerHTML = "Badge auswählen";
    document.getElementById("badgesLegend").innerHTML = "Badge";
}

function deleteBadge() {
    var id = document.getElementById("BadgeForm").getAttribute("badge-id");
    var name = document.getElementById("name").getAttribute("value");
    var message = document.getElementById("i18n").getAttribute("i18n-badges-really-delete-badge").replaceAll("{0}", name);
    if (window.confirm(message)) {
    AJS.$.ajax({
        url: document.getElementById("context-path").value + "/rest/badge/1.0/badges/"+id,
        type: "DELETE",
        dataType: "json",
        contentType: "application/json",
        success: function(result){
            sessionStorage.setItem("badgeDeleted", "true");
            sessionStorage.setItem("badgeDeletedName", name);
            location.href = document.getElementById("context-path").value + "/admin/plugins/badge/configurePlugin.action";
        }
    });
}
}