function previousPage() {
    var previousPage = getCurrentPage() - 1;
    if(previousPage >= 1) {
        goToPage(previousPage);
    }
}

function nextPage() {
    var nextPage = getCurrentPage() + 1;
    if(nextPage <= getLastPage()) {
        goToPage(nextPage);
    }
}

function firstPage() {
    goToPage(1);
}

function lastPage() {
    goToPage(getLastPage());
}

function markUserRow(rowId) {
    try{
        document.getElementById(rowId).classList.add("marked-row");
    } catch (e) {
        //thrown when user is not on the current ranking page
    }
}

function goToPage(page) {
    var queryString = window.location.search;
    var urlParams = new URLSearchParams(queryString);
    var username = urlParams.get('username')
    if(username) {
        location.href = document.getElementById("context-path").value
            + "/plugins/badge/viewUserRanking.action?"
            + "username=" + username
            + "&page=" + page;
    } else {
        location.href = document.getElementById("context-path").value
            + "/plugins/badge/viewUserRanking.action?page=" + page;
    }
}

function getCurrentPage() {
    return Number(document.getElementById("currentPage").innerHTML);
}

function getLastPage() {
    return Number(document.getElementById("lastPage").innerHTML);
}